/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import com.facebook.FacebookException;
import com.facebook.FacebookGraphObjectException;
import com.facebook.NativeAppCallAttachmentStore;
import com.facebook.NativeAppCallContentProvider;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.model.OpenGraphAction;
import com.facebook.model.OpenGraphObject;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FacebookDialog {
    public static final String COMPLETION_GESTURE_CANCEL = "cancel";
    private static final String EXTRA_DIALOG_COMPLETE_KEY = "com.facebook.platform.extra.DID_COMPLETE";
    private static final String EXTRA_DIALOG_COMPLETION_GESTURE_KEY = "com.facebook.platform.extra.COMPLETION_GESTURE";
    private static final String EXTRA_DIALOG_COMPLETION_ID_KEY = "com.facebook.platform.extra.POST_ID";
    private static final int MIN_NATIVE_SHARE_PROTOCOL_VERSION = 20130618;
    private static NativeAppCallAttachmentStore attachmentStore;
    private Activity activity;
    private PendingCall appCall;
    private Fragment fragment;
    private OnPresentCallback onPresentCallback;

    private FacebookDialog(Activity activity, Fragment fragment, PendingCall pendingCall, OnPresentCallback onPresentCallback) {
        this.activity = activity;
        this.fragment = fragment;
        this.appCall = pendingCall;
        this.onPresentCallback = onPresentCallback;
    }

    public static boolean canPresentOpenGraphActionDialog(Context context, OpenGraphActionDialogFeature ... openGraphActionDialogFeatureArray) {
        return FacebookDialog.handleCanPresent(context, EnumSet.of(OpenGraphActionDialogFeature.OG_ACTION_DIALOG, openGraphActionDialogFeatureArray));
    }

    public static boolean canPresentShareDialog(Context context, ShareDialogFeature ... shareDialogFeatureArray) {
        return FacebookDialog.handleCanPresent(context, EnumSet.of(ShareDialogFeature.SHARE_DIALOG, shareDialogFeatureArray));
    }

    private static NativeAppCallAttachmentStore getAttachmentStore() {
        if (attachmentStore == null) {
            attachmentStore = new NativeAppCallAttachmentStore();
        }
        return attachmentStore;
    }

    private static int getMinVersionForFeatures(Iterable<? extends DialogFeature> iterable) {
        int n2 = Integer.MIN_VALUE;
        Iterator<? extends DialogFeature> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            n2 = Math.max(n2, iterator.next().getMinVersion());
        }
        return n2;
    }

    public static String getNativeDialogCompletionGesture(Bundle bundle) {
        return bundle.getString(EXTRA_DIALOG_COMPLETION_GESTURE_KEY);
    }

    public static boolean getNativeDialogDidComplete(Bundle bundle) {
        return bundle.getBoolean(EXTRA_DIALOG_COMPLETE_KEY, false);
    }

    public static String getNativeDialogPostId(Bundle bundle) {
        return bundle.getString(EXTRA_DIALOG_COMPLETION_ID_KEY);
    }

    private static int getProtocolVersionForNativeDialog(Context context, Integer n2) {
        return NativeProtocol.getLatestAvailableProtocolVersion(context, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean handleActivityResult(Context context, PendingCall pendingCall, int n2, Intent intent, Callback callback) {
        block7: {
            block6: {
                if (n2 != pendingCall.getRequestCode()) {
                    return false;
                }
                if (attachmentStore != null) {
                    attachmentStore.cleanupAttachmentsForCall(context, pendingCall.getCallId());
                }
                if (callback == null) break block6;
                if (!NativeProtocol.isErrorResult(intent)) break block7;
                callback.onError(pendingCall, NativeProtocol.getErrorFromResult(intent), intent.getExtras());
            }
            return true;
        }
        callback.onComplete(pendingCall, intent.getExtras());
        return true;
    }

    private static boolean handleCanPresent(Context context, Iterable<? extends DialogFeature> iterable) {
        return FacebookDialog.getProtocolVersionForNativeDialog(context, FacebookDialog.getMinVersionForFeatures(iterable)) != -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PendingCall present() {
        if (this.onPresentCallback != null) {
            try {
                this.onPresentCallback.onPresent((Context)this.activity);
            }
            catch (Exception exception) {
                throw new FacebookException(exception);
            }
        }
        if (this.fragment != null) {
            this.fragment.startActivityForResult(this.appCall.getRequestIntent(), this.appCall.getRequestCode());
            return this.appCall;
        }
        this.activity.startActivityForResult(this.appCall.getRequestIntent(), this.appCall.getRequestCode());
        return this.appCall;
    }

    private static abstract class Builder<CONCRETE extends Builder<?>> {
        protected final Activity activity;
        protected final PendingCall appCall;
        protected final String applicationId;
        protected String applicationName;
        protected Fragment fragment;

        Builder(Activity activity) {
            Validate.notNull(activity, "activity");
            this.activity = activity;
            this.applicationId = Utility.getMetadataApplicationId((Context)activity);
            this.appCall = new PendingCall(64207);
        }

        public FacebookDialog build() {
            this.validate();
            Bundle bundle = new Bundle();
            this.putExtra(bundle, "com.facebook.platform.extra.APPLICATION_ID", this.applicationId);
            this.putExtra(bundle, "com.facebook.platform.extra.APPLICATION_NAME", this.applicationName);
            Intent intent = this.handleBuild(bundle);
            if (intent == null) {
                throw new FacebookException("Unable to create Intent; this likely means the Facebook app is not installed.");
            }
            this.appCall.setRequestIntent(intent);
            return new FacebookDialog(this.activity, this.fragment, this.appCall, this.getOnPresentCallback());
        }

        public boolean canPresent() {
            return this.handleCanPresent();
        }

        OnPresentCallback getOnPresentCallback() {
            return null;
        }

        abstract Intent handleBuild(Bundle var1);

        boolean handleCanPresent() {
            return FacebookDialog.getProtocolVersionForNativeDialog((Context)this.activity, 20130618) != -1;
        }

        void putExtra(Bundle bundle, String string2, String string3) {
            if (string3 != null) {
                bundle.putString(string2, string3);
            }
        }

        public CONCRETE setApplicationName(String string2) {
            this.applicationName = string2;
            return (CONCRETE)this;
        }

        public CONCRETE setFragment(Fragment fragment) {
            this.fragment = fragment;
            return (CONCRETE)this;
        }

        public CONCRETE setRequestCode(int n2) {
            this.appCall.setRequestCode(n2);
            return (CONCRETE)this;
        }

        void validate() {
        }
    }

    public static interface Callback {
        public void onComplete(PendingCall var1, Bundle var2);

        public void onError(PendingCall var1, Exception var2, Bundle var3);
    }

    private static interface DialogFeature {
        public int getMinVersion();
    }

    static interface OnPresentCallback {
        public void onPresent(Context var1) throws Exception;
    }

    public static class OpenGraphActionDialogBuilder
    extends Builder<OpenGraphActionDialogBuilder> {
        private OpenGraphAction action;
        private String actionType;
        private boolean dataErrorsFatal;
        private HashMap<String, File> imageAttachmentFiles;
        private HashMap<String, Bitmap> imageAttachments;
        private String previewPropertyName;

        public OpenGraphActionDialogBuilder(Activity activity, OpenGraphAction openGraphAction, String string2) {
            super(activity);
            Validate.notNull(openGraphAction, "action");
            Validate.notNullOrEmpty(openGraphAction.getType(), "action.getType()");
            Validate.notNullOrEmpty(string2, "previewPropertyName");
            if (openGraphAction.getProperty(string2) == null) {
                throw new IllegalArgumentException("A property named \"" + string2 + "\" was not found on the action.  The name of " + "the preview property must match the name of an action property.");
            }
            this.action = openGraphAction;
            this.actionType = openGraphAction.getType();
            this.previewPropertyName = string2;
        }

        @Deprecated
        public OpenGraphActionDialogBuilder(Activity activity, OpenGraphAction openGraphAction, String string2, String string3) {
            super(activity);
            Validate.notNull(openGraphAction, "action");
            Validate.notNullOrEmpty(string2, "actionType");
            Validate.notNullOrEmpty(string3, "previewPropertyName");
            if (openGraphAction.getProperty(string3) == null) {
                throw new IllegalArgumentException("A property named \"" + string3 + "\" was not found on the action.  The name of " + "the preview property must match the name of an action property.");
            }
            String string4 = openGraphAction.getType();
            if (!Utility.isNullOrEmpty(string4) && !string4.equals(string2)) {
                throw new IllegalArgumentException("'actionType' must match the type of 'action' if it is specified. Consider using OpenGraphActionDialogBuilder(Activity activity, OpenGraphAction action, String previewPropertyName) instead.");
            }
            this.action = openGraphAction;
            this.actionType = string2;
            this.previewPropertyName = string3;
        }

        private OpenGraphActionDialogBuilder addImageAttachment(String string2, Bitmap bitmap) {
            if (this.imageAttachments == null) {
                this.imageAttachments = new HashMap();
            }
            this.imageAttachments.put(string2, bitmap);
            return this;
        }

        private OpenGraphActionDialogBuilder addImageAttachment(String string2, File file) {
            if (this.imageAttachmentFiles == null) {
                this.imageAttachmentFiles = new HashMap();
            }
            this.imageAttachmentFiles.put(string2, file);
            return this;
        }

        private List<String> addImageAttachmentFiles(List<File> list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (File file : list) {
                String string2 = UUID.randomUUID().toString();
                this.addImageAttachment(string2, file);
                arrayList.add(NativeAppCallContentProvider.getAttachmentUrl(this.applicationId, this.appCall.getCallId(), string2));
            }
            return arrayList;
        }

        private List<String> addImageAttachments(List<Bitmap> list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Bitmap bitmap : list) {
                String string2 = UUID.randomUUID().toString();
                this.addImageAttachment(string2, bitmap);
                arrayList.add(NativeAppCallContentProvider.getAttachmentUrl(this.applicationId, this.appCall.getCallId(), string2));
            }
            return arrayList;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private JSONObject flattenChildrenOfGraphObject(JSONObject jSONObject) {
            void var3_6;
            JSONObject jSONObject2;
            try {
                jSONObject2 = new JSONObject(jSONObject.toString());
            }
            catch (JSONException jSONException) {
                throw new FacebookException((Throwable)var3_6);
            }
            try {
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string2.equalsIgnoreCase("image")) continue;
                    jSONObject2.put(string2, this.flattenObject(jSONObject2.get(string2)));
                }
                return jSONObject2;
            }
            catch (JSONException jSONException) {
                throw new FacebookException((Throwable)var3_6);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Object flattenObject(Object object) throws JSONException {
            if (object == null) {
                return null;
            }
            if (object instanceof JSONObject) {
                JSONObject jSONObject = (JSONObject)object;
                if (jSONObject.optBoolean("fbsdk:create_object")) return object;
                if (jSONObject.has("id")) {
                    return jSONObject.getString("id");
                }
                if (!jSONObject.has("url")) return object;
                return jSONObject.getString("url");
            }
            if (!(object instanceof JSONArray)) return object;
            JSONArray jSONArray = (JSONArray)object;
            JSONArray jSONArray2 = new JSONArray();
            int n2 = jSONArray.length();
            int n3 = 0;
            while (n3 < n2) {
                jSONArray2.put(this.flattenObject(jSONArray.get(n3)));
                ++n3;
            }
            return jSONArray2;
        }

        private void updateActionAttachmentUrls(List<String> list, boolean bl2) {
            List<JSONObject> list2 = this.action.getImage();
            if (list2 == null) {
                list2 = new ArrayList<JSONObject>(list.size());
            }
            for (String string2 : list) {
                JSONObject jSONObject;
                block5: {
                    jSONObject = new JSONObject();
                    try {
                        jSONObject.put("url", (Object)string2);
                        if (!bl2) break block5;
                    }
                    catch (JSONException jSONException) {
                        throw new FacebookException("Unable to attach images", jSONException);
                    }
                    jSONObject.put("user_generated", true);
                }
                list2.add(jSONObject);
            }
            this.action.setImage(list2);
        }

        List<String> getImageAttachmentNames() {
            return new ArrayList<String>(this.imageAttachments.keySet());
        }

        @Override
        OnPresentCallback getOnPresentCallback() {
            return new OnPresentCallback(){

                @Override
                public void onPresent(Context context) throws Exception {
                    if (OpenGraphActionDialogBuilder.this.imageAttachments != null && OpenGraphActionDialogBuilder.this.imageAttachments.size() > 0) {
                        FacebookDialog.getAttachmentStore().addAttachmentsForCall(context, OpenGraphActionDialogBuilder.this.appCall.getCallId(), OpenGraphActionDialogBuilder.this.imageAttachments);
                    }
                    if (OpenGraphActionDialogBuilder.this.imageAttachmentFiles != null && OpenGraphActionDialogBuilder.this.imageAttachmentFiles.size() > 0) {
                        FacebookDialog.getAttachmentStore().addAttachmentFilesForCall(context, OpenGraphActionDialogBuilder.this.appCall.getCallId(), OpenGraphActionDialogBuilder.this.imageAttachmentFiles);
                    }
                }
            };
        }

        @Override
        Intent handleBuild(Bundle bundle) {
            this.putExtra(bundle, "com.facebook.platform.extra.PREVIEW_PROPERTY_NAME", this.previewPropertyName);
            this.putExtra(bundle, "com.facebook.platform.extra.ACTION_TYPE", this.actionType);
            bundle.putBoolean("com.facebook.platform.extra.DATA_FAILURES_FATAL", this.dataErrorsFatal);
            this.putExtra(bundle, "com.facebook.platform.extra.ACTION", this.flattenChildrenOfGraphObject(this.action.getInnerJSONObject()).toString());
            int n2 = FacebookDialog.getProtocolVersionForNativeDialog((Context)this.activity, 20130618);
            return NativeProtocol.createPlatformActivityIntent((Context)this.activity, "com.facebook.platform.action.request.OGACTIONPUBLISH_DIALOG", n2, bundle);
        }

        @Override
        boolean handleCanPresent() {
            Activity activity = this.activity;
            OpenGraphActionDialogFeature[] openGraphActionDialogFeatureArray = new OpenGraphActionDialogFeature[]{OpenGraphActionDialogFeature.OG_ACTION_DIALOG};
            return FacebookDialog.canPresentOpenGraphActionDialog((Context)activity, openGraphActionDialogFeatureArray);
        }

        public OpenGraphActionDialogBuilder setDataErrorsFatal(boolean bl2) {
            this.dataErrorsFatal = bl2;
            return this;
        }

        public OpenGraphActionDialogBuilder setImageAttachmentFilesForAction(List<File> list) {
            return this.setImageAttachmentFilesForAction(list, false);
        }

        public OpenGraphActionDialogBuilder setImageAttachmentFilesForAction(List<File> list, boolean bl2) {
            Validate.containsNoNulls(list, "bitmapFiles");
            if (this.action == null) {
                throw new FacebookException("Can not set attachments prior to setting action.");
            }
            this.updateActionAttachmentUrls(this.addImageAttachmentFiles(list), bl2);
            return this;
        }

        public OpenGraphActionDialogBuilder setImageAttachmentFilesForObject(String string2, List<File> list) {
            return this.setImageAttachmentFilesForObject(string2, list, false);
        }

        public OpenGraphActionDialogBuilder setImageAttachmentFilesForObject(String string2, List<File> list, boolean bl2) {
            Validate.notNull(string2, "objectProperty");
            Validate.containsNoNulls(list, "bitmapFiles");
            if (this.action == null) {
                throw new FacebookException("Can not set attachments prior to setting action.");
            }
            this.updateObjectAttachmentUrls(string2, this.addImageAttachmentFiles(list), bl2);
            return this;
        }

        public OpenGraphActionDialogBuilder setImageAttachmentsForAction(List<Bitmap> list) {
            return this.setImageAttachmentsForAction(list, false);
        }

        public OpenGraphActionDialogBuilder setImageAttachmentsForAction(List<Bitmap> list, boolean bl2) {
            Validate.containsNoNulls(list, "bitmaps");
            if (this.action == null) {
                throw new FacebookException("Can not set attachments prior to setting action.");
            }
            this.updateActionAttachmentUrls(this.addImageAttachments(list), bl2);
            return this;
        }

        public OpenGraphActionDialogBuilder setImageAttachmentsForObject(String string2, List<Bitmap> list) {
            return this.setImageAttachmentsForObject(string2, list, false);
        }

        public OpenGraphActionDialogBuilder setImageAttachmentsForObject(String string2, List<Bitmap> list, boolean bl2) {
            Validate.notNull(string2, "objectProperty");
            Validate.containsNoNulls(list, "bitmaps");
            if (this.action == null) {
                throw new FacebookException("Can not set attachments prior to setting action.");
            }
            this.updateObjectAttachmentUrls(string2, this.addImageAttachments(list), bl2);
            return this;
        }

        void updateObjectAttachmentUrls(String string2, List<String> list, boolean bl2) {
            OpenGraphObject openGraphObject;
            block7: {
                try {
                    openGraphObject = this.action.getPropertyAs(string2, OpenGraphObject.class);
                    if (openGraphObject != null) break block7;
                }
                catch (FacebookGraphObjectException facebookGraphObjectException) {
                    throw new IllegalArgumentException("Property '" + string2 + "' is not a graph object");
                }
                throw new IllegalArgumentException("Action does not contain a property '" + string2 + "'");
            }
            if (!openGraphObject.getCreateObject()) {
                throw new IllegalArgumentException("The Open Graph object in '" + string2 + "' is not marked for creation");
            }
            GraphObjectList<GraphObject> graphObjectList = openGraphObject.getImage();
            if (graphObjectList == null) {
                graphObjectList = GraphObject.Factory.createList(GraphObject.class);
            }
            for (String string3 : list) {
                GraphObject graphObject = GraphObject.Factory.create();
                graphObject.setProperty("url", string3);
                if (bl2) {
                    graphObject.setProperty("user_generated", true);
                }
                graphObjectList.add(graphObject);
            }
            openGraphObject.setImage(graphObjectList);
        }
    }

    public static final class OpenGraphActionDialogFeature
    extends Enum<OpenGraphActionDialogFeature>
    implements DialogFeature {
        private static final /* synthetic */ OpenGraphActionDialogFeature[] $VALUES;
        public static final /* enum */ OpenGraphActionDialogFeature OG_ACTION_DIALOG = new OpenGraphActionDialogFeature(20130618);
        private int minVersion;

        static {
            OpenGraphActionDialogFeature[] openGraphActionDialogFeatureArray = new OpenGraphActionDialogFeature[]{OG_ACTION_DIALOG};
            $VALUES = openGraphActionDialogFeatureArray;
        }

        private OpenGraphActionDialogFeature(int n3) {
            this.minVersion = n3;
        }

        public static OpenGraphActionDialogFeature valueOf(String string2) {
            return Enum.valueOf(OpenGraphActionDialogFeature.class, string2);
        }

        public static OpenGraphActionDialogFeature[] values() {
            return (OpenGraphActionDialogFeature[])$VALUES.clone();
        }

        @Override
        public int getMinVersion() {
            return this.minVersion;
        }
    }

    public static class PendingCall
    implements Parcelable {
        public static final Parcelable.Creator<PendingCall> CREATOR = new Parcelable.Creator<PendingCall>(){

            public PendingCall createFromParcel(Parcel parcel) {
                return new PendingCall(parcel);
            }

            public PendingCall[] newArray(int n2) {
                return new PendingCall[n2];
            }
        };
        private UUID callId;
        private int requestCode;
        private Intent requestIntent;

        public PendingCall(int n2) {
            this.callId = UUID.randomUUID();
            this.requestCode = n2;
        }

        private PendingCall(Parcel parcel) {
            this.callId = UUID.fromString(parcel.readString());
            this.requestIntent = (Intent)parcel.readParcelable(null);
            this.requestCode = parcel.readInt();
        }

        private void setRequestCode(int n2) {
            this.requestCode = n2;
        }

        private void setRequestIntent(Intent intent) {
            this.requestIntent = intent;
            this.requestIntent.putExtra("com.facebook.platform.protocol.CALL_ID", this.callId.toString());
        }

        public int describeContents() {
            return 0;
        }

        public UUID getCallId() {
            return this.callId;
        }

        public int getRequestCode() {
            return this.requestCode;
        }

        public Intent getRequestIntent() {
            return this.requestIntent;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeString(this.callId.toString());
            parcel.writeParcelable((Parcelable)this.requestIntent, 0);
            parcel.writeInt(this.requestCode);
        }
    }

    public static class ShareDialogBuilder
    extends Builder<ShareDialogBuilder> {
        private String caption;
        private boolean dataErrorsFatal;
        private String description;
        private ArrayList<String> friends;
        private String link;
        private String name;
        private String picture;
        private String place;
        private String ref;

        public ShareDialogBuilder(Activity activity) {
            super(activity);
        }

        @Override
        Intent handleBuild(Bundle bundle) {
            this.putExtra(bundle, "com.facebook.platform.extra.APPLICATION_ID", this.applicationId);
            this.putExtra(bundle, "com.facebook.platform.extra.APPLICATION_NAME", this.applicationName);
            this.putExtra(bundle, "com.facebook.platform.extra.TITLE", this.name);
            this.putExtra(bundle, "com.facebook.platform.extra.SUBTITLE", this.caption);
            this.putExtra(bundle, "com.facebook.platform.extra.DESCRIPTION", this.description);
            this.putExtra(bundle, "com.facebook.platform.extra.LINK", this.link);
            this.putExtra(bundle, "com.facebook.platform.extra.IMAGE", this.picture);
            this.putExtra(bundle, "com.facebook.platform.extra.PLACE", this.place);
            this.putExtra(bundle, "com.facebook.platform.extra.TITLE", this.name);
            this.putExtra(bundle, "com.facebook.platform.extra.REF", this.ref);
            bundle.putBoolean("com.facebook.platform.extra.DATA_FAILURES_FATAL", this.dataErrorsFatal);
            if (!Utility.isNullOrEmpty(this.friends)) {
                bundle.putStringArrayList("com.facebook.platform.extra.FRIENDS", this.friends);
            }
            int n2 = FacebookDialog.getProtocolVersionForNativeDialog((Context)this.activity, 20130618);
            return NativeProtocol.createPlatformActivityIntent((Context)this.activity, "com.facebook.platform.action.request.FEED_DIALOG", n2, bundle);
        }

        @Override
        boolean handleCanPresent() {
            Activity activity = this.activity;
            ShareDialogFeature[] shareDialogFeatureArray = new ShareDialogFeature[]{ShareDialogFeature.SHARE_DIALOG};
            return FacebookDialog.canPresentShareDialog((Context)activity, shareDialogFeatureArray);
        }

        public ShareDialogBuilder setCaption(String string2) {
            this.caption = string2;
            return this;
        }

        public ShareDialogBuilder setDataErrorsFatal(boolean bl2) {
            this.dataErrorsFatal = bl2;
            return this;
        }

        public ShareDialogBuilder setDescription(String string2) {
            this.description = string2;
            return this;
        }

        public ShareDialogBuilder setFriends(List<String> list) {
            this.friends = new ArrayList<String>(list);
            return this;
        }

        public ShareDialogBuilder setLink(String string2) {
            this.link = string2;
            return this;
        }

        public ShareDialogBuilder setName(String string2) {
            this.name = string2;
            return this;
        }

        public ShareDialogBuilder setPicture(String string2) {
            this.picture = string2;
            return this;
        }

        public ShareDialogBuilder setPlace(String string2) {
            this.place = string2;
            return this;
        }

        public ShareDialogBuilder setRef(String string2) {
            this.ref = string2;
            return this;
        }
    }

    public static final class ShareDialogFeature
    extends Enum<ShareDialogFeature>
    implements DialogFeature {
        private static final /* synthetic */ ShareDialogFeature[] $VALUES;
        public static final /* enum */ ShareDialogFeature SHARE_DIALOG = new ShareDialogFeature(20130618);
        private int minVersion;

        static {
            ShareDialogFeature[] shareDialogFeatureArray = new ShareDialogFeature[]{SHARE_DIALOG};
            $VALUES = shareDialogFeatureArray;
        }

        private ShareDialogFeature(int n3) {
            this.minVersion = n3;
        }

        public static ShareDialogFeature valueOf(String string2) {
            return Enum.valueOf(ShareDialogFeature.class, string2);
        }

        public static ShareDialogFeature[] values() {
            return (ShareDialogFeature[])$VALUES.clone();
        }

        @Override
        public int getMinVersion() {
            return this.minVersion;
        }
    }
}

