/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.model;

import android.annotation.SuppressLint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

class JsonUtil {
    JsonUtil() {
    }

    static void jsonObjectClear(JSONObject jSONObject) {
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    static boolean jsonObjectContainsValue(JSONObject jSONObject, Object object) {
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            Object object2 = jSONObject.opt((String)iterator.next());
            if (object2 == null || !object2.equals(object)) continue;
            return true;
        }
        return false;
    }

    static Set<Map.Entry<String, Object>> jsonObjectEntrySet(JSONObject jSONObject) {
        HashSet<Map.Entry<String, Object>> hashSet = new HashSet<Map.Entry<String, Object>>();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            hashSet.add(new JSONObjectEntry(string2, jSONObject.opt(string2)));
        }
        return hashSet;
    }

    static Set<String> jsonObjectKeySet(JSONObject jSONObject) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            hashSet.add((String)iterator.next());
        }
        return hashSet;
    }

    static void jsonObjectPutAll(JSONObject jSONObject, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                jSONObject.putOpt(entry.getKey(), entry.getValue());
            }
            catch (JSONException jSONException) {
                throw new IllegalArgumentException(jSONException);
            }
        }
    }

    static Collection<Object> jsonObjectValues(JSONObject jSONObject) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            arrayList.add(jSONObject.opt((String)iterator.next()));
        }
        return arrayList;
    }

    private static final class JSONObjectEntry
    implements Map.Entry<String, Object> {
        private final String key;
        private final Object value;

        JSONObjectEntry(String string2, Object object) {
            this.key = string2;
            this.value = object;
        }

        @Override
        @SuppressLint(value={"FieldGetter"})
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object object) {
            throw new UnsupportedOperationException("JSONObjectEntry is immutable");
        }
    }
}

