/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.model;

import com.facebook.FacebookGraphObjectException;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.CreateGraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.model.JsonUtil;
import com.facebook.model.PropertyName;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public interface GraphObject {
    public Map<String, Object> asMap();

    public <T extends GraphObject> T cast(Class<T> var1);

    public JSONObject getInnerJSONObject();

    public Object getProperty(String var1);

    public <T extends GraphObject> T getPropertyAs(String var1, Class<T> var2);

    public <T extends GraphObject> GraphObjectList<T> getPropertyAsList(String var1, Class<T> var2);

    public void removeProperty(String var1);

    public void setProperty(String var1, Object var2);

    public static final class Factory {
        private static final SimpleDateFormat[] dateFormats;
        private static final HashSet<Class<?>> verifiedGraphObjectClasses;

        static {
            verifiedGraphObjectClasses = new HashSet();
            SimpleDateFormat[] simpleDateFormatArray = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US), new SimpleDateFormat("yyyy-MM-dd", Locale.US)};
            dateFormats = simpleDateFormatArray;
        }

        private Factory() {
        }

        static <U> U coerceValueToExpectedType(Object object, Class<U> clazz, ParameterizedType parameterizedType) {
            if (object == null) {
                if (Boolean.TYPE.equals(clazz)) {
                    return (U)Boolean.valueOf(false);
                }
                if (Character.TYPE.equals(clazz)) {
                    return (U)Character.valueOf('\u0000');
                }
                if (clazz.isPrimitive()) {
                    return (U)Integer.valueOf(0);
                }
                return null;
            }
            Class<?> clazz2 = object.getClass();
            if (clazz.isAssignableFrom(clazz2)) {
                return (U)object;
            }
            if (clazz.isPrimitive()) {
                return (U)object;
            }
            if (GraphObject.class.isAssignableFrom(clazz)) {
                if (JSONObject.class.isAssignableFrom(clazz2)) {
                    return Factory.createGraphObjectProxy(clazz, (JSONObject)object);
                }
                if (GraphObject.class.isAssignableFrom(clazz2)) {
                    return ((GraphObject)object).cast(clazz);
                }
                throw new FacebookGraphObjectException("Can't create GraphObject from " + clazz2.getName());
            }
            if (Iterable.class.equals(clazz) || Collection.class.equals(clazz) || List.class.equals(clazz) || GraphObjectList.class.equals(clazz)) {
                if (parameterizedType == null) {
                    throw new FacebookGraphObjectException("can't infer generic type of: " + clazz.toString());
                }
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                if (typeArray == null || typeArray.length != 1 || !(typeArray[0] instanceof Class)) {
                    throw new FacebookGraphObjectException("Expect collection properties to be of a type with exactly one generic parameter.");
                }
                Class clazz3 = (Class)typeArray[0];
                if (JSONArray.class.isAssignableFrom(clazz2)) {
                    return (U)Factory.createList((JSONArray)object, clazz3);
                }
                throw new FacebookGraphObjectException("Can't create Collection from " + clazz2.getName());
            }
            if (String.class.equals(clazz)) {
                if (Double.class.isAssignableFrom(clazz2) || Float.class.isAssignableFrom(clazz2)) {
                    return (U)String.format("%f", object);
                }
                if (Number.class.isAssignableFrom(clazz2)) {
                    return (U)String.format("%d", object);
                }
            } else if (Date.class.equals(clazz) && String.class.isAssignableFrom(clazz2)) {
                for (SimpleDateFormat simpleDateFormat : dateFormats) {
                    Date date;
                    try {
                        date = simpleDateFormat.parse((String)object);
                        if (date == null) continue;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    return (U)date;
                }
            }
            throw new FacebookGraphObjectException("Can't convert type" + clazz2.getName() + " to " + clazz.getName());
        }

        static String convertCamelCaseToLowercaseWithUnderscores(String string2) {
            return string2.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US);
        }

        public static GraphObject create() {
            return Factory.create(GraphObject.class);
        }

        public static <T extends GraphObject> T create(Class<T> clazz) {
            return Factory.createGraphObjectProxy(clazz, new JSONObject());
        }

        public static GraphObject create(JSONObject jSONObject) {
            return Factory.create(jSONObject, GraphObject.class);
        }

        public static <T extends GraphObject> T create(JSONObject jSONObject, Class<T> clazz) {
            return Factory.createGraphObjectProxy(clazz, jSONObject);
        }

        private static <T extends GraphObject> T createGraphObjectProxy(Class<T> clazz, JSONObject jSONObject) {
            Factory.verifyCanProxyClass(clazz);
            Class[] classArray = new Class[]{clazz};
            GraphObjectProxy graphObjectProxy = new GraphObjectProxy(jSONObject, clazz);
            return (T)((GraphObject)Proxy.newProxyInstance(GraphObject.class.getClassLoader(), classArray, (InvocationHandler)graphObjectProxy));
        }

        private static Map<String, Object> createGraphObjectProxyForMap(JSONObject jSONObject) {
            Class[] classArray = new Class[]{Map.class};
            GraphObjectProxy graphObjectProxy = new GraphObjectProxy(jSONObject, Map.class);
            return (Map)Proxy.newProxyInstance(GraphObject.class.getClassLoader(), classArray, (InvocationHandler)graphObjectProxy);
        }

        public static <T> GraphObjectList<T> createList(Class<T> clazz) {
            return Factory.createList(new JSONArray(), clazz);
        }

        public static <T> GraphObjectList<T> createList(JSONArray jSONArray, Class<T> clazz) {
            return new GraphObjectListImpl(jSONArray, clazz);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Object getUnderlyingJSONObject(Object object) {
            if (object == null) {
                return null;
            }
            Class<?> clazz = object.getClass();
            if (GraphObject.class.isAssignableFrom(clazz)) {
                return ((GraphObject)object).getInnerJSONObject();
            }
            if (GraphObjectList.class.isAssignableFrom(clazz)) {
                return ((GraphObjectList)object).getInnerJSONArray();
            }
            if (!Iterable.class.isAssignableFrom(clazz)) return object;
            JSONArray jSONArray = new JSONArray();
            Iterator iterator = ((Iterable)object).iterator();
            while (iterator.hasNext()) {
                Object t2 = iterator.next();
                if (GraphObject.class.isAssignableFrom(t2.getClass())) {
                    jSONArray.put((Object)((GraphObject)t2).getInnerJSONObject());
                    continue;
                }
                jSONArray.put(t2);
            }
            return jSONArray;
        }

        private static <T extends GraphObject> boolean hasClassBeenVerified(Class<T> clazz) {
            synchronized (Factory.class) {
                boolean bl2 = verifiedGraphObjectClasses.contains(clazz);
                return bl2;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public static boolean hasSameId(GraphObject graphObject, GraphObject graphObject2) {
            Object object;
            Object object2;
            block5: {
                block4: {
                    if (graphObject == null || graphObject2 == null || !graphObject.asMap().containsKey("id") || !graphObject2.asMap().containsKey("id")) break block4;
                    if (graphObject.equals(graphObject2)) {
                        return true;
                    }
                    object2 = graphObject.getProperty("id");
                    object = graphObject2.getProperty("id");
                    if (object2 != null && object != null && object2 instanceof String && object instanceof String) break block5;
                }
                return false;
            }
            return object2.equals(object);
        }

        private static <T extends GraphObject> void recordClassHasBeenVerified(Class<T> clazz) {
            synchronized (Factory.class) {
                verifiedGraphObjectClasses.add(clazz);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private static <T extends GraphObject> void verifyCanProxyClass(Class<T> clazz) {
            if (Factory.hasClassBeenVerified(clazz)) {
                return;
            }
            if (!clazz.isInterface()) {
                throw new FacebookGraphObjectException("Factory can only wrap interfaces, not class: " + clazz.getName());
            }
            Method[] methodArray = clazz.getMethods();
            int n2 = methodArray.length;
            int n3 = 0;
            while (true) {
                block10: {
                    boolean bl2;
                    Class<?> clazz2;
                    int n4;
                    String string2;
                    Method method;
                    block11: {
                        if (n3 >= n2) {
                            Factory.recordClassHasBeenVerified(clazz);
                            return;
                        }
                        method = methodArray[n3];
                        string2 = method.getName();
                        n4 = method.getParameterTypes().length;
                        clazz2 = method.getReturnType();
                        bl2 = method.isAnnotationPresent(PropertyName.class);
                        if (method.getDeclaringClass().isAssignableFrom(GraphObject.class)) break block10;
                        if (n4 != 1 || clazz2 != Void.TYPE) break block11;
                        if (bl2) {
                            if (Utility.isNullOrEmpty(method.getAnnotation(PropertyName.class).value())) {
                                throw new FacebookGraphObjectException("Factory can't proxy method: " + method.toString());
                            }
                            break block10;
                        } else if (!string2.startsWith("set") || string2.length() <= 3) throw new FacebookGraphObjectException("Factory can't proxy method: " + method.toString());
                        break block10;
                    }
                    if (n4 != 0 || clazz2 == Void.TYPE || !(!bl2 ? string2.startsWith("get") && string2.length() > 3 : !Utility.isNullOrEmpty(method.getAnnotation(PropertyName.class).value()))) {
                        throw new FacebookGraphObjectException("Factory can't proxy method: " + method.toString());
                    }
                }
                ++n3;
            }
        }

        private static final class GraphObjectListImpl<T>
        extends AbstractList<T>
        implements GraphObjectList<T> {
            private final Class<?> itemType;
            private final JSONArray state;

            public GraphObjectListImpl(JSONArray jSONArray, Class<?> clazz) {
                Validate.notNull(jSONArray, "state");
                Validate.notNull(clazz, "itemType");
                this.state = jSONArray;
                this.itemType = clazz;
            }

            private void checkIndex(int n2) {
                if (n2 < 0 || n2 >= this.state.length()) {
                    throw new IndexOutOfBoundsException();
                }
            }

            private void put(int n2, T t2) {
                Object object = Factory.getUnderlyingJSONObject(t2);
                try {
                    this.state.put(n2, object);
                    return;
                }
                catch (JSONException jSONException) {
                    throw new IllegalArgumentException(jSONException);
                }
            }

            @Override
            public void add(int n2, T t2) {
                if (n2 < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (n2 < this.size()) {
                    throw new UnsupportedOperationException("Only adding items at the end of the list is supported.");
                }
                this.put(n2, t2);
            }

            @Override
            public final <U extends GraphObject> GraphObjectList<U> castToListOf(Class<U> clazz) {
                if (GraphObject.class.isAssignableFrom(this.itemType)) {
                    if (clazz.isAssignableFrom(this.itemType)) {
                        return this;
                    }
                    return Factory.createList(this.state, clazz);
                }
                throw new FacebookGraphObjectException("Can't cast GraphObjectCollection of non-GraphObject type " + this.itemType);
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean equals(Object object) {
                block5: {
                    block4: {
                        if (object == null) break block4;
                        if (this == object) {
                            return true;
                        }
                        if (this.getClass() == object.getClass()) break block5;
                    }
                    return false;
                }
                GraphObjectListImpl graphObjectListImpl = (GraphObjectListImpl)object;
                return this.state.equals((Object)graphObjectListImpl.state);
            }

            @Override
            public T get(int n2) {
                this.checkIndex(n2);
                return (T)Factory.coerceValueToExpectedType(this.state.opt(n2), this.itemType, null);
            }

            @Override
            public final JSONArray getInnerJSONArray() {
                return this.state;
            }

            @Override
            public int hashCode() {
                return this.state.hashCode();
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public T set(int n2, T t2) {
                this.checkIndex(n2);
                T t3 = this.get(n2);
                this.put(n2, t2);
                return t3;
            }

            @Override
            public int size() {
                return this.state.length();
            }

            @Override
            public String toString() {
                Object[] objectArray = new Object[]{this.itemType.getSimpleName(), this.state};
                return String.format("GraphObjectList{itemType=%s, state=%s}", objectArray);
            }
        }

        private static final class GraphObjectProxy
        extends ProxyBase<JSONObject> {
            private static final String CASTTOMAP_METHOD = "asMap";
            private static final String CAST_METHOD = "cast";
            private static final String CLEAR_METHOD = "clear";
            private static final String CONTAINSKEY_METHOD = "containsKey";
            private static final String CONTAINSVALUE_METHOD = "containsValue";
            private static final String ENTRYSET_METHOD = "entrySet";
            private static final String GETINNERJSONOBJECT_METHOD = "getInnerJSONObject";
            private static final String GETPROPERTYASLIST_METHOD = "getPropertyAsList";
            private static final String GETPROPERTYAS_METHOD = "getPropertyAs";
            private static final String GETPROPERTY_METHOD = "getProperty";
            private static final String GET_METHOD = "get";
            private static final String ISEMPTY_METHOD = "isEmpty";
            private static final String KEYSET_METHOD = "keySet";
            private static final String PUTALL_METHOD = "putAll";
            private static final String PUT_METHOD = "put";
            private static final String REMOVEPROPERTY_METHOD = "removeProperty";
            private static final String REMOVE_METHOD = "remove";
            private static final String SETPROPERTY_METHOD = "setProperty";
            private static final String SIZE_METHOD = "size";
            private static final String VALUES_METHOD = "values";
            private final Class<?> graphObjectClass;

            public GraphObjectProxy(JSONObject jSONObject, Class<?> clazz) {
                super(jSONObject);
                this.graphObjectClass = clazz;
            }

            private Object createGraphObjectsFromParameters(CreateGraphObject createGraphObject, Object graphObjectList) {
                String string2;
                block4: {
                    block3: {
                        if (createGraphObject == null || Utility.isNullOrEmpty(createGraphObject.value())) break block3;
                        string2 = createGraphObject.value();
                        if (!List.class.isAssignableFrom(graphObjectList.getClass())) break block4;
                        GraphObjectList<GraphObject> graphObjectList2 = Factory.createList(GraphObject.class);
                        for (Object e2 : (List)graphObjectList) {
                            GraphObject graphObject = Factory.create();
                            graphObject.setProperty(string2, e2);
                            graphObjectList2.add(graphObject);
                        }
                        graphObjectList = graphObjectList2;
                    }
                    return graphObjectList;
                }
                GraphObject graphObject = Factory.create();
                graphObject.setProperty(string2, graphObjectList);
                return graphObject;
            }

            /*
             * Enabled aggressive block sorting
             */
            private final Object proxyGraphObjectGettersAndSetters(Method method, Object[] objectArray) throws JSONException {
                String string2 = method.getName();
                int n2 = method.getParameterTypes().length;
                PropertyName propertyName = method.getAnnotation(PropertyName.class);
                String string3 = propertyName != null ? propertyName.value() : Factory.convertCamelCaseToLowercaseWithUnderscores(string2.substring(3));
                if (n2 == 0) {
                    Object object = ((JSONObject)this.state).opt(string3);
                    Class<?> clazz = method.getReturnType();
                    Type type = method.getGenericReturnType();
                    boolean bl2 = type instanceof ParameterizedType;
                    ParameterizedType parameterizedType = null;
                    if (bl2) {
                        parameterizedType = (ParameterizedType)type;
                    }
                    return Factory.coerceValueToExpectedType(object, clazz, parameterizedType);
                }
                if (n2 == 1) {
                    Object object = Factory.getUnderlyingJSONObject(this.createGraphObjectsFromParameters(method.getAnnotation(CreateGraphObject.class), objectArray[0]));
                    ((JSONObject)this.state).putOpt(string3, object);
                    return null;
                }
                return this.throwUnexpectedMethodSignature(method);
            }

            private final Object proxyGraphObjectMethods(Object object, Method method, Object[] objectArray) {
                String string2 = method.getName();
                if (string2.equals(CAST_METHOD)) {
                    Class clazz = (Class)objectArray[0];
                    if (clazz != null && clazz.isAssignableFrom(this.graphObjectClass)) {
                        return object;
                    }
                    return Factory.createGraphObjectProxy(clazz, (JSONObject)this.state);
                }
                if (string2.equals(GETINNERJSONOBJECT_METHOD)) {
                    return ((GraphObjectProxy)Proxy.getInvocationHandler((Object)object)).state;
                }
                if (string2.equals(CASTTOMAP_METHOD)) {
                    return Factory.createGraphObjectProxyForMap((JSONObject)this.state);
                }
                if (string2.equals(GETPROPERTY_METHOD)) {
                    return ((JSONObject)this.state).opt((String)objectArray[0]);
                }
                if (string2.equals(GETPROPERTYAS_METHOD)) {
                    return Factory.coerceValueToExpectedType(((JSONObject)this.state).opt((String)objectArray[0]), (Class)objectArray[1], null);
                }
                if (string2.equals(GETPROPERTYASLIST_METHOD)) {
                    return Factory.coerceValueToExpectedType(((JSONObject)this.state).opt((String)objectArray[0]), GraphObjectList.class, new ParameterizedType((Class)objectArray[1]){
                        final /* synthetic */ Class val$expectedType;
                        {
                            this.val$expectedType = clazz;
                        }

                        @Override
                        public Type[] getActualTypeArguments() {
                            Type[] typeArray = new Type[]{this.val$expectedType};
                            return typeArray;
                        }

                        @Override
                        public Type getOwnerType() {
                            return null;
                        }

                        @Override
                        public Type getRawType() {
                            return GraphObjectList.class;
                        }
                    });
                }
                if (string2.equals(SETPROPERTY_METHOD)) {
                    return this.setJSONProperty(objectArray);
                }
                if (string2.equals(REMOVEPROPERTY_METHOD)) {
                    ((JSONObject)this.state).remove((String)objectArray[0]);
                    return null;
                }
                return this.throwUnexpectedMethodSignature(method);
            }

            /*
             * Enabled aggressive block sorting
             */
            private final Object proxyMapMethods(Method method, Object[] objectArray) {
                String string2 = method.getName();
                if (string2.equals(CLEAR_METHOD)) {
                    JsonUtil.jsonObjectClear((JSONObject)this.state);
                    return null;
                }
                if (string2.equals(CONTAINSKEY_METHOD)) {
                    return ((JSONObject)this.state).has((String)objectArray[0]);
                }
                if (string2.equals(CONTAINSVALUE_METHOD)) {
                    return JsonUtil.jsonObjectContainsValue((JSONObject)this.state, objectArray[0]);
                }
                if (string2.equals(ENTRYSET_METHOD)) {
                    return JsonUtil.jsonObjectEntrySet((JSONObject)this.state);
                }
                if (string2.equals(GET_METHOD)) {
                    return ((JSONObject)this.state).opt((String)objectArray[0]);
                }
                if (string2.equals(ISEMPTY_METHOD)) {
                    boolean bl2;
                    if (((JSONObject)this.state).length() == 0) {
                        bl2 = true;
                        return bl2;
                    }
                    bl2 = false;
                    return bl2;
                }
                if (string2.equals(KEYSET_METHOD)) {
                    return JsonUtil.jsonObjectKeySet((JSONObject)this.state);
                }
                if (string2.equals(PUT_METHOD)) {
                    return this.setJSONProperty(objectArray);
                }
                if (string2.equals(PUTALL_METHOD)) {
                    Map<String, Object> map;
                    if (objectArray[0] instanceof Map) {
                        map = (Map<String, Object>)objectArray[0];
                    } else {
                        if (!(objectArray[0] instanceof GraphObject)) return null;
                        map = ((GraphObject)objectArray[0]).asMap();
                    }
                    JsonUtil.jsonObjectPutAll((JSONObject)this.state, map);
                    return null;
                }
                if (string2.equals(REMOVE_METHOD)) {
                    ((JSONObject)this.state).remove((String)objectArray[0]);
                    return null;
                }
                if (string2.equals(SIZE_METHOD)) {
                    return ((JSONObject)this.state).length();
                }
                if (!string2.equals(VALUES_METHOD)) return this.throwUnexpectedMethodSignature(method);
                return JsonUtil.jsonObjectValues((JSONObject)this.state);
            }

            private Object setJSONProperty(Object[] objectArray) {
                String string2 = (String)objectArray[0];
                Object object = Factory.getUnderlyingJSONObject(objectArray[1]);
                try {
                    ((JSONObject)this.state).putOpt(string2, object);
                    return null;
                }
                catch (JSONException jSONException) {
                    throw new IllegalArgumentException(jSONException);
                }
            }

            @Override
            public final Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                Class<?> clazz = method.getDeclaringClass();
                if (clazz == Object.class) {
                    return this.proxyObjectMethods(object, method, objectArray);
                }
                if (clazz == Map.class) {
                    return this.proxyMapMethods(method, objectArray);
                }
                if (clazz == GraphObject.class) {
                    return this.proxyGraphObjectMethods(object, method, objectArray);
                }
                if (GraphObject.class.isAssignableFrom(clazz)) {
                    return this.proxyGraphObjectGettersAndSetters(method, objectArray);
                }
                return this.throwUnexpectedMethodSignature(method);
            }

            public String toString() {
                Object[] objectArray = new Object[]{this.graphObjectClass.getSimpleName(), this.state};
                return String.format("GraphObject{graphObjectClass=%s, state=%s}", objectArray);
            }
        }

        private static abstract class ProxyBase<STATE>
        implements InvocationHandler {
            private static final String EQUALS_METHOD = "equals";
            private static final String TOSTRING_METHOD = "toString";
            protected final STATE state;

            protected ProxyBase(STATE STATE) {
                this.state = STATE;
            }

            protected final Object proxyObjectMethods(Object object, Method method, Object[] objectArray) throws Throwable {
                String string2 = method.getName();
                if (string2.equals(EQUALS_METHOD)) {
                    Object object2 = objectArray[0];
                    if (object2 == null) {
                        return false;
                    }
                    InvocationHandler invocationHandler = Proxy.getInvocationHandler(object2);
                    if (!(invocationHandler instanceof GraphObjectProxy)) {
                        return false;
                    }
                    GraphObjectProxy graphObjectProxy = (GraphObjectProxy)invocationHandler;
                    return this.state.equals(graphObjectProxy.state);
                }
                if (string2.equals(TOSTRING_METHOD)) {
                    return this.toString();
                }
                return method.invoke(this.state, objectArray);
            }

            protected final Object throwUnexpectedMethodSignature(Method method) {
                throw new FacebookGraphObjectException(this.getClass().getName() + " got an unexpected method signature: " + method.toString());
            }
        }
    }
}

