/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import com.facebook.Settings;
import java.util.concurrent.Executor;

class WorkQueue {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final int DEFAULT_MAX_CONCURRENT = 8;
    private final Executor executor;
    private final int maxConcurrent;
    private WorkNode pendingJobs;
    private int runningCount = 0;
    private WorkNode runningJobs = null;
    private final Object workLock = new Object();

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2 = !WorkQueue.class.desiredAssertionStatus();
        $assertionsDisabled = bl2;
    }

    WorkQueue() {
        this(8);
    }

    WorkQueue(int n2) {
        this(n2, Settings.getExecutor());
    }

    WorkQueue(int n2, Executor executor) {
        this.maxConcurrent = n2;
        this.executor = executor;
    }

    static /* synthetic */ WorkNode access$202(WorkQueue workQueue, WorkNode workNode) {
        workQueue.pendingJobs = workNode;
        return workNode;
    }

    private void execute(final WorkNode workNode) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    workNode.getCallback().run();
                    return;
                }
                finally {
                    WorkQueue.this.finishItemAndStartNew(workNode);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void finishItemAndStartNew(WorkNode workNode) {
        Object object = this.workLock;
        // MONITORENTER : object
        if (workNode != null) {
            this.runningJobs = workNode.removeFromList(this.runningJobs);
            this.runningCount = -1 + this.runningCount;
        }
        int n2 = this.runningCount;
        int n3 = this.maxConcurrent;
        WorkNode workNode2 = null;
        if (n2 < n3 && (workNode2 = this.pendingJobs) != null) {
            this.pendingJobs = workNode2.removeFromList(this.pendingJobs);
            this.runningJobs = workNode2.addToList(this.runningJobs, false);
            this.runningCount = 1 + this.runningCount;
            workNode2.setIsRunning(true);
        }
        // MONITOREXIT : object
        if (workNode2 == null) return;
        this.execute(workNode2);
    }

    private void startItem() {
        this.finishItemAndStartNew(null);
    }

    WorkItem addActiveWorkItem(Runnable runnable) {
        return this.addActiveWorkItem(runnable, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    WorkItem addActiveWorkItem(Runnable runnable, boolean bl2) {
        WorkNode workNode = new WorkNode(runnable);
        Object object = this.workLock;
        synchronized (object) {
            this.pendingJobs = workNode.addToList(this.pendingJobs, bl2);
        }
        this.startItem();
        return workNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void validate() {
        Object object = this.workLock;
        synchronized (object) {
            WorkNode workNode = this.runningJobs;
            int n2 = 0;
            if (workNode != null) {
                WorkNode workNode2 = this.runningJobs;
                do {
                    workNode2.verify(true);
                    ++n2;
                } while ((workNode2 = workNode2.getNext()) != this.runningJobs);
            }
            if (!$assertionsDisabled && this.runningCount != n2) {
                throw new AssertionError();
            }
            return;
        }
    }

    static interface WorkItem {
        public boolean cancel();

        public boolean isRunning();

        public void moveToFront();
    }

    private class WorkNode
    implements WorkItem {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final Runnable callback;
        private boolean isRunning;
        private WorkNode next;
        private WorkNode prev;

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl2 = !WorkQueue.class.desiredAssertionStatus();
            $assertionsDisabled = bl2;
        }

        WorkNode(Runnable runnable) {
            this.callback = runnable;
        }

        /*
         * Enabled aggressive block sorting
         */
        WorkNode addToList(WorkNode workNode, boolean bl2) {
            if (!$assertionsDisabled && this.next != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.prev != null) {
                throw new AssertionError();
            }
            if (workNode == null) {
                this.prev = this;
                this.next = this;
                workNode = this;
            } else {
                this.next = workNode;
                this.prev = workNode.prev;
                WorkNode workNode2 = this.next;
                this.prev.next = this;
                workNode2.prev = this;
            }
            if (bl2) {
                return this;
            }
            return workNode;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean cancel() {
            Object object = WorkQueue.this.workLock;
            synchronized (object) {
                if (!this.isRunning()) {
                    WorkQueue.access$202(WorkQueue.this, this.removeFromList(WorkQueue.this.pendingJobs));
                    return true;
                }
                return false;
            }
        }

        Runnable getCallback() {
            return this.callback;
        }

        WorkNode getNext() {
            return this.next;
        }

        @Override
        public boolean isRunning() {
            return this.isRunning;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void moveToFront() {
            Object object = WorkQueue.this.workLock;
            synchronized (object) {
                if (!this.isRunning()) {
                    WorkQueue.access$202(WorkQueue.this, this.removeFromList(WorkQueue.this.pendingJobs));
                    WorkQueue.access$202(WorkQueue.this, this.addToList(WorkQueue.this.pendingJobs, true));
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        WorkNode removeFromList(WorkNode workNode) {
            if (!$assertionsDisabled && this.next == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.prev == null) {
                throw new AssertionError();
            }
            if (workNode == this) {
                workNode = this.next == this ? null : this.next;
            }
            this.next.prev = this.prev;
            this.prev.next = this.next;
            this.prev = null;
            this.next = null;
            return workNode;
        }

        void setIsRunning(boolean bl2) {
            this.isRunning = bl2;
        }

        void verify(boolean bl2) {
            if (!$assertionsDisabled && this.prev.next != this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.next.prev != this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.isRunning() != bl2) {
                throw new AssertionError();
            }
        }
    }
}

