/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import com.facebook.internal.Utility;
import java.util.Collection;
import java.util.Iterator;

public final class Validate {
    public static void containsNoNullOrEmpty(Collection<String> collection, String string2) {
        Validate.notNull(collection, string2);
        for (String string3 : collection) {
            if (string3 == null) {
                throw new NullPointerException("Container '" + string2 + "' cannot contain null values");
            }
            if (string3.length() != 0) continue;
            throw new IllegalArgumentException("Container '" + string2 + "' cannot contain empty values");
        }
    }

    public static <T> void containsNoNulls(Collection<T> collection, String string2) {
        Validate.notNull(collection, string2);
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            throw new NullPointerException("Container '" + string2 + "' cannot contain null values");
        }
    }

    public static <T> void notEmpty(Collection<T> collection, String string2) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Container '" + string2 + "' cannot be empty");
        }
    }

    public static <T> void notEmptyAndContainsNoNulls(Collection<T> collection, String string2) {
        Validate.containsNoNulls(collection, string2);
        Validate.notEmpty(collection, string2);
    }

    public static void notNull(Object object, String string2) {
        if (object == null) {
            throw new NullPointerException("Argument '" + string2 + "' cannot be null");
        }
    }

    public static void notNullOrEmpty(String string2, String string3) {
        if (Utility.isNullOrEmpty(string2)) {
            throw new IllegalArgumentException("Argument '" + string3 + "' cannot be null or empty");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void oneOf(Object object, String string2, Object ... objectArray) {
        int n2 = objectArray.length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                throw new IllegalArgumentException("Argument '" + string2 + "' was not one of the allowed values");
            }
            Object object2 = objectArray[n3];
            if (object2 != null ? object2.equals(object) : object == null) {
                return;
            }
            ++n3;
        }
    }
}

