/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.Settings;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.facebook.FacebookException;
import com.facebook.Request;
import com.facebook.internal.ImageDownloader;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class Utility {
    private static final String APPLICATION_FIELDS = "fields";
    private static final String[] APP_SETTING_FIELDS = new String[]{"supports_attribution", "supports_implicit_sdk_logging"};
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 8192;
    private static final String HASH_ALGORITHM_MD5 = "MD5";
    private static final String HASH_ALGORITHM_SHA1 = "SHA-1";
    static final String LOG_TAG = "FacebookSDK";
    private static final String SUPPORTS_ATTRIBUTION = "supports_attribution";
    private static final String SUPPORTS_IMPLICIT_SDK_LOGGING = "supports_implicit_sdk_logging";
    private static final String URL_SCHEME = "https";
    private static Map<String, FetchedAppSettings> fetchedAppSettings = new ConcurrentHashMap<String, FetchedAppSettings>();

    public static <T> boolean areObjectsEqual(T t2, T t3) {
        if (t2 == null) {
            return t3 == null;
        }
        return t2.equals(t3);
    }

    public static <T> ArrayList<T> arrayList(T ... TArray) {
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        int n2 = TArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(TArray[i2]);
        }
        return arrayList;
    }

    public static <T> List<T> asListNoNulls(T ... TArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t2 : TArray) {
            if (t2 == null) continue;
            arrayList.add(t2);
        }
        return arrayList;
    }

    public static Uri buildUri(String string2, String string3, Bundle bundle) {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(URL_SCHEME);
        builder.authority(string2);
        builder.path(string3);
        for (String string4 : bundle.keySet()) {
            Object object = bundle.get(string4);
            if (!(object instanceof String)) continue;
            builder.appendQueryParameter(string4, (String)object);
        }
        return builder.build();
    }

    public static void clearCaches(Context context) {
        ImageDownloader.clearCache(context);
    }

    private static void clearCookiesForDomain(Context context, String string2) {
        CookieSyncManager.createInstance((Context)context).sync();
        CookieManager cookieManager = CookieManager.getInstance();
        String string3 = cookieManager.getCookie(string2);
        if (string3 == null) {
            return;
        }
        String[] stringArray = string3.split(";");
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String[] stringArray2 = stringArray[i2].split("=");
            if (stringArray2.length <= 0) continue;
            cookieManager.setCookie(string2, stringArray2[0].trim() + "=;expires=Sat, 1 Jan 2000 00:00:01 UTC;");
        }
        cookieManager.removeExpiredCookie();
    }

    public static void clearFacebookCookies(Context context) {
        Utility.clearCookiesForDomain(context, "facebook.com");
        Utility.clearCookiesForDomain(context, ".facebook.com");
        Utility.clearCookiesForDomain(context, "https://facebook.com");
        Utility.clearCookiesForDomain(context, "https://.facebook.com");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map<String, Object> convertJSONObjectToHashMap(JSONObject jSONObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        JSONArray jSONArray = jSONObject.names();
        int n2 = 0;
        while (n2 < jSONArray.length()) {
            try {
                String string2 = jSONArray.getString(n2);
                Map<String, Object> map = jSONObject.get(string2);
                if (map instanceof JSONObject) {
                    map = Utility.convertJSONObjectToHashMap((JSONObject)map);
                }
                hashMap.put(string2, map);
            }
            catch (JSONException jSONException) {}
            ++n2;
        }
        return hashMap;
    }

    public static void deleteDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Utility.deleteDirectory(fileArray[i2]);
            }
        }
        file.delete();
    }

    public static void disconnectQuietly(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    public static String getHashedDeviceAndAppID(Context context, String string2) {
        String string3 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (string3 == null) {
            return null;
        }
        return Utility.sha1hash(string3 + string2);
    }

    public static String getMetadataApplicationId(Context context) {
        Validate.notNull(context, "context");
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                String string2 = applicationInfo.metaData.getString("com.facebook.sdk.ApplicationId");
                return string2;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static Object getStringPropertyAsJSON(JSONObject jSONObject, String string2, String string3) throws JSONException {
        Object object = jSONObject.opt(string2);
        if (object != null && object instanceof String) {
            object = new JSONTokener((String)object).nextValue();
        }
        if (object != null && !(object instanceof JSONObject) && !(object instanceof JSONArray)) {
            if (string3 != null) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.putOpt(string3, object);
                return jSONObject2;
            }
            throw new FacebookException("Got an unexpected non-JSON object.");
        }
        return object;
    }

    private static String hashWithAlgorithm(String string2, String string3) {
        StringBuilder stringBuilder;
        byte[] byArray;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string2);
            messageDigest.update(string3.getBytes());
            byArray = messageDigest.digest();
            stringBuilder = new StringBuilder();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        for (byte by2 : byArray) {
            stringBuilder.append(Integer.toHexString(0xF & by2 >> 4));
            stringBuilder.append(Integer.toHexString(0xF & by2 >> 0));
        }
        return stringBuilder.toString();
    }

    public static boolean isNullOrEmpty(String string2) {
        return string2 == null || string2.length() == 0;
    }

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.size() == 0;
    }

    public static <T> boolean isSubset(Collection<T> collection, Collection<T> collection2) {
        block3: {
            boolean bl2;
            block5: {
                block4: {
                    if (collection2 != null && collection2.size() != 0) break block3;
                    if (collection == null) break block4;
                    int n2 = collection.size();
                    bl2 = false;
                    if (n2 != 0) break block5;
                }
                bl2 = true;
            }
            return bl2;
        }
        HashSet<T> hashSet = new HashSet<T>(collection2);
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (hashSet.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static void logd(String string2, Exception exception) {
    }

    public static void logd(String string2, String string3) {
    }

    static String md5hash(String string2) {
        return Utility.hashWithAlgorithm(HASH_ALGORITHM_MD5, string2);
    }

    public static void putObjectInBundle(Bundle bundle, String string2, Object object) {
        if (object instanceof String) {
            bundle.putString(string2, (String)object);
            return;
        }
        if (object instanceof Parcelable) {
            bundle.putParcelable(string2, (Parcelable)object);
            return;
        }
        if (object instanceof byte[]) {
            bundle.putByteArray(string2, (byte[])object);
            return;
        }
        throw new FacebookException("attempted to add unsupported type to Bundle");
    }

    public static FetchedAppSettings queryAppSettings(String string2, boolean bl2) {
        if (!bl2 && fetchedAppSettings.containsKey(string2)) {
            return fetchedAppSettings.get(string2);
        }
        Bundle bundle = new Bundle();
        bundle.putString(APPLICATION_FIELDS, TextUtils.join((CharSequence)",", (Object[])APP_SETTING_FIELDS));
        Request request = Request.newGraphPathRequest(null, string2, null);
        request.setParameters(bundle);
        GraphObject graphObject = request.executeAndWait().getGraphObject();
        FetchedAppSettings fetchedAppSettings = new FetchedAppSettings(Utility.safeGetBooleanFromResponse(graphObject, SUPPORTS_ATTRIBUTION), Utility.safeGetBooleanFromResponse(graphObject, SUPPORTS_IMPLICIT_SDK_LOGGING));
        Utility.fetchedAppSettings.put(string2, fetchedAppSettings);
        return fetchedAppSettings;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readStreamToString(InputStream var0) throws IOException {
        var1_1 = new BufferedInputStream(var0);
        var2_2 = new InputStreamReader(var1_1);
        try {
            var3_3 = new StringBuilder();
            var7_4 = new char[2048];
            while ((var8_5 = var2_2.read(var7_4)) != -1) {
                var3_3.append(var7_4, 0, var8_5);
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var4_6) {
            var5_10 = var2_2;
            var6_11 = var1_1;
lbl16:
            // 3 sources

            while (true) {
                Utility.closeQuietly(var6_11);
                Utility.closeQuietly(var5_10);
                throw var4_7;
            }
        }
        catch (Throwable var4_9) {
            var6_11 = var1_1;
            var5_10 = null;
            ** GOTO lbl16
        }
        catch (Throwable var4_8) {
            var6_11 = null;
            var5_10 = null;
            ** continue;
        }
lbl-1000:
        // 1 sources

        {
            var10_12 = var3_3.toString();
        }
        Utility.closeQuietly(var1_1);
        Utility.closeQuietly(var2_2);
        return var10_12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean safeGetBooleanFromResponse(GraphObject graphObject, String string2) {
        Object object;
        Object object2 = false;
        if (graphObject != null) {
            object2 = graphObject.getProperty(string2);
        }
        if (!(object2 instanceof Boolean)) {
            object = false;
            return (Boolean)object;
        }
        object = object2;
        return (Boolean)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setAppEventAttributionParameters(GraphObject graphObject, String string2, String string3, boolean bl2) {
        if (string2 != null) {
            graphObject.setProperty("attribution", string2);
        } else if (string3 != null) {
            graphObject.setProperty("advertiser_id", string3);
        }
        boolean bl3 = !bl2;
        graphObject.setProperty("application_tracking_enabled", bl3);
    }

    private static String sha1hash(String string2) {
        return Utility.hashWithAlgorithm(HASH_ALGORITHM_SHA1, string2);
    }

    public static boolean stringsEqualOrEmpty(String string2, String string3) {
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        boolean bl3 = TextUtils.isEmpty((CharSequence)string3);
        if (bl2 && bl3) {
            return true;
        }
        if (!bl2 && !bl3) {
            return string2.equals(string3);
        }
        return false;
    }

    public static <T> Collection<T> unmodifiableCollection(T ... TArray) {
        return Collections.unmodifiableCollection(Arrays.asList(TArray));
    }

    public static class FetchedAppSettings {
        private boolean supportsAttribution;
        private boolean supportsImplicitLogging;

        private FetchedAppSettings(boolean bl2, boolean bl3) {
            this.supportsAttribution = bl2;
            this.supportsImplicitLogging = bl3;
        }

        public boolean supportsAttribution() {
            return this.supportsAttribution;
        }

        public boolean supportsImplicitLogging() {
            return this.supportsImplicitLogging;
        }
    }
}

