/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import com.facebook.LoggingBehavior;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;

class UrlRedirectCache {
    private static final String REDIRECT_CONTENT_TAG;
    static final String TAG;
    private static volatile FileLruCache urlRedirectCache;

    static {
        TAG = UrlRedirectCache.class.getSimpleName();
        REDIRECT_CONTENT_TAG = TAG + "_Redirect";
    }

    UrlRedirectCache() {
    }

    static void cacheUriRedirect(Context context, URI uRI, URI uRI2) {
        if (uRI == null || uRI2 == null) {
            return;
        }
        OutputStream outputStream = null;
        try {
            outputStream = UrlRedirectCache.getCache(context).openPutStream(uRI.toString(), REDIRECT_CONTENT_TAG);
            outputStream.write(uRI2.toString().getBytes());
        }
        catch (IOException iOException) {
            Utility.closeQuietly(outputStream);
            return;
        }
        catch (Throwable throwable) {
            Utility.closeQuietly(outputStream);
            throw throwable;
        }
        Utility.closeQuietly(outputStream);
        return;
    }

    static void clearCache(Context context) {
        try {
            UrlRedirectCache.getCache(context).clearCache();
            return;
        }
        catch (IOException iOException) {
            Logger.log(LoggingBehavior.CACHE, 5, TAG, "clearCache failed " + iOException.getMessage());
            return;
        }
    }

    static FileLruCache getCache(Context context) throws IOException {
        synchronized (UrlRedirectCache.class) {
            if (urlRedirectCache == null) {
                urlRedirectCache = new FileLruCache(context.getApplicationContext(), TAG, new FileLruCache.Limits());
            }
            FileLruCache fileLruCache = urlRedirectCache;
            return fileLruCache;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static URI getRedirectedUri(Context var0, URI var1_1) {
        if (var1_1 == null) {
            return null;
        }
        var2_2 = var1_1.toString();
        var3_3 = null;
        try {
            var7_4 = UrlRedirectCache.getCache(var0);
            var8_5 = false;
            var9_6 = null;
        }
        catch (IOException var5_14) lbl-1000:
        // 2 sources

        {
            Utility.closeQuietly(var3_3);
            return null;
        }
        catch (Throwable var4_15) lbl-1000:
        // 2 sources

        {
            Utility.closeQuietly(var3_3);
            throw var4_16;
        }
        while (true) {
            block15: {
                var12_10 = var7_4.get(var2_2, UrlRedirectCache.REDIRECT_CONTENT_TAG);
                if (var12_10 == null) break;
                var8_5 = true;
                var3_3 = new InputStreamReader(var12_10);
                try {
                    var15_11 = new char[128];
                    var16_7 = new StringBuilder();
                    while ((var17_8 = var3_3.read(var15_11, 0, var15_11.length)) > 0) {
                        var16_7.append(var15_11, 0, var17_8);
                    }
                    break block15;
                }
                catch (URISyntaxException var6_12) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        Utility.closeQuietly(var3_3);
                        return null;
                    }
                }
                catch (Throwable var4_17) {
                    var3_3 = var9_6;
                    ** GOTO lbl-1000
                }
                catch (IOException var11_18) {
                    var3_3 = var9_6;
                    ** GOTO lbl-1000
                }
                catch (URISyntaxException var10_19) {
                    var3_3 = var9_6;
                    ** continue;
                }
            }
            Utility.closeQuietly(var3_3);
            var2_2 = var19_9 = var16_7.toString();
            var9_6 = var3_3;
            continue;
            break;
        }
        if (var8_5) ** GOTO lbl-1000
        Utility.closeQuietly(var9_6);
        return null;
lbl-1000:
        // 1 sources

        {
            var14_13 = new URI(var2_2);
        }
        Utility.closeQuietly(var9_6);
        return var14_13;
    }
}

