/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import com.facebook.Session;
import com.facebook.SessionState;

public class SessionTracker {
    private final LocalBroadcastManager broadcastManager;
    private final Session.StatusCallback callback;
    private boolean isTracking = false;
    private final BroadcastReceiver receiver;
    private Session session;

    public SessionTracker(Context context, Session.StatusCallback statusCallback) {
        this(context, statusCallback, null);
    }

    SessionTracker(Context context, Session.StatusCallback statusCallback, Session session) {
        this(context, statusCallback, session, true);
    }

    public SessionTracker(Context context, Session.StatusCallback statusCallback, Session session, boolean bl2) {
        this.callback = new CallbackWrapper(statusCallback);
        this.session = session;
        this.receiver = new ActiveSessionBroadcastReceiver();
        this.broadcastManager = LocalBroadcastManager.getInstance(context);
        if (bl2) {
            this.startTracking();
        }
    }

    private void addBroadcastReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.facebook.sdk.ACTIVE_SESSION_SET");
        intentFilter.addAction("com.facebook.sdk.ACTIVE_SESSION_UNSET");
        this.broadcastManager.registerReceiver(this.receiver, intentFilter);
    }

    public Session getOpenSession() {
        Session session = this.getSession();
        if (session != null && session.isOpened()) {
            return session;
        }
        return null;
    }

    public Session getSession() {
        if (this.session == null) {
            return Session.getActiveSession();
        }
        return this.session;
    }

    public boolean isTracking() {
        return this.isTracking;
    }

    public boolean isTrackingActiveSession() {
        return this.session == null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSession(Session session) {
        if (session == null) {
            if (this.session != null) {
                this.session.removeCallback(this.callback);
                this.session = null;
                this.addBroadcastReceiver();
                if (this.getSession() != null) {
                    this.getSession().addCallback(this.callback);
                }
            }
            return;
        }
        if (this.session == null) {
            Session session2 = Session.getActiveSession();
            if (session2 != null) {
                session2.removeCallback(this.callback);
            }
            this.broadcastManager.unregisterReceiver(this.receiver);
        } else {
            this.session.removeCallback(this.callback);
        }
        this.session = session;
        this.session.addCallback(this.callback);
    }

    public void startTracking() {
        if (this.isTracking) {
            return;
        }
        if (this.session == null) {
            this.addBroadcastReceiver();
        }
        if (this.getSession() != null) {
            this.getSession().addCallback(this.callback);
        }
        this.isTracking = true;
    }

    public void stopTracking() {
        if (!this.isTracking) {
            return;
        }
        Session session = this.getSession();
        if (session != null) {
            session.removeCallback(this.callback);
        }
        this.broadcastManager.unregisterReceiver(this.receiver);
        this.isTracking = false;
    }

    private class ActiveSessionBroadcastReceiver
    extends BroadcastReceiver {
        private ActiveSessionBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Session session;
            if ("com.facebook.sdk.ACTIVE_SESSION_SET".equals(intent.getAction()) && (session = Session.getActiveSession()) != null) {
                session.addCallback(SessionTracker.this.callback);
            }
        }
    }

    private class CallbackWrapper
    implements Session.StatusCallback {
        private final Session.StatusCallback wrapped;

        public CallbackWrapper(Session.StatusCallback statusCallback) {
            this.wrapped = statusCallback;
        }

        @Override
        public void call(Session session, SessionState sessionState, Exception exception) {
            if (this.wrapped != null && SessionTracker.this.isTracking()) {
                this.wrapped.call(session, sessionState, exception);
            }
            if (session == SessionTracker.this.session && sessionState.isClosed()) {
                SessionTracker.this.setSession(null);
            }
        }
    }
}

