/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.facebook.internal.NativeProtocol;

public abstract class PlatformServiceClient
implements ServiceConnection {
    private final String applicationId;
    private final Context context;
    private final Handler handler;
    private CompletedListener listener;
    private final int protocolVersion;
    private int replyMessage;
    private int requestMessage;
    private boolean running;
    private Messenger sender;

    /*
     * Enabled aggressive block sorting
     */
    public PlatformServiceClient(Context context, int n2, int n3, int n4, String string2) {
        Context context2 = context.getApplicationContext();
        if (context2 == null) {
            context2 = context;
        }
        this.context = context2;
        this.requestMessage = n2;
        this.replyMessage = n3;
        this.applicationId = string2;
        this.protocolVersion = n4;
        this.handler = new Handler(){

            public void handleMessage(Message message) {
                PlatformServiceClient.this.handleMessage(message);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private void callback(Bundle bundle) {
        CompletedListener completedListener;
        block3: {
            block2: {
                if (!this.running) break block2;
                this.running = false;
                completedListener = this.listener;
                if (completedListener != null) break block3;
            }
            return;
        }
        completedListener.completed(bundle);
    }

    private void sendMessage() {
        Bundle bundle = new Bundle();
        bundle.putString("com.facebook.platform.extra.APPLICATION_ID", this.applicationId);
        this.populateRequestBundle(bundle);
        Message message = Message.obtain(null, (int)this.requestMessage);
        message.arg1 = this.protocolVersion;
        message.setData(bundle);
        message.replyTo = new Messenger(this.handler);
        try {
            this.sender.send(message);
            return;
        }
        catch (RemoteException remoteException) {
            this.callback(null);
            return;
        }
    }

    public void cancel() {
        this.running = false;
    }

    protected Context getContext() {
        return this.context;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void handleMessage(Message message) {
        if (message.what == this.replyMessage) {
            Bundle bundle = message.getData();
            if (bundle.getString("com.facebook.platform.status.ERROR_TYPE") != null) {
                this.callback(null);
            } else {
                this.callback(bundle);
            }
            this.context.unbindService((ServiceConnection)this);
        }
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        this.sender = new Messenger(iBinder);
        this.sendMessage();
    }

    public void onServiceDisconnected(ComponentName componentName) {
        this.sender = null;
        this.context.unbindService((ServiceConnection)this);
        this.callback(null);
    }

    protected abstract void populateRequestBundle(Bundle var1);

    public void setCompletedListener(CompletedListener completedListener) {
        this.listener = completedListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean start() {
        Intent intent;
        if (this.running || NativeProtocol.getLatestAvailableProtocolVersion(this.context, this.protocolVersion) == -1 || (intent = NativeProtocol.createPlatformServiceIntent(this.context)) == null) {
            return false;
        }
        this.running = true;
        this.context.bindService(intent, (ServiceConnection)this, 1);
        return true;
    }

    public static interface CompletedListener {
        public void completed(Bundle var1);
    }
}

