/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import com.facebook.LoggingBehavior;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

class ImageResponseCache {
    static final String TAG = ImageResponseCache.class.getSimpleName();
    private static volatile FileLruCache imageCache;

    ImageResponseCache() {
    }

    static void clearCache(Context context) {
        try {
            ImageResponseCache.getCache(context).clearCache();
            return;
        }
        catch (IOException iOException) {
            Logger.log(LoggingBehavior.CACHE, 5, TAG, "clearCache failed " + iOException.getMessage());
            return;
        }
    }

    static FileLruCache getCache(Context context) throws IOException {
        synchronized (ImageResponseCache.class) {
            if (imageCache == null) {
                imageCache = new FileLruCache(context.getApplicationContext(), TAG, new FileLruCache.Limits());
            }
            FileLruCache fileLruCache = imageCache;
            return fileLruCache;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static InputStream getCachedImageStream(URI uRI, Context context) {
        InputStream inputStream = null;
        if (uRI == null) return inputStream;
        boolean bl2 = ImageResponseCache.isCDNURL(uRI);
        inputStream = null;
        if (!bl2) return inputStream;
        try {
            InputStream inputStream2 = ImageResponseCache.getCache(context).get(uRI.toString());
            return inputStream2;
        }
        catch (IOException iOException) {
            Logger.log(LoggingBehavior.CACHE, 5, TAG, iOException.toString());
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static InputStream interceptAndCacheImageStream(Context context, HttpURLConnection httpURLConnection) throws IOException {
        int n2 = httpURLConnection.getResponseCode();
        InputStream inputStream = null;
        if (n2 != 200) return inputStream;
        URL uRL = httpURLConnection.getURL();
        inputStream = httpURLConnection.getInputStream();
        try {
            if (!ImageResponseCache.isCDNURL(uRL.toURI())) return inputStream;
            InputStream inputStream2 = ImageResponseCache.getCache(context).interceptAndPut(uRL.toString(), new BufferedHttpInputStream(inputStream, httpURLConnection));
            return inputStream2;
        }
        catch (URISyntaxException uRISyntaxException) {
            return inputStream;
        }
        catch (IOException iOException) {
            return inputStream;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isCDNURL(URI uRI) {
        String string2;
        return uRI != null && ((string2 = uRI.getHost()).endsWith("fbcdn.net") || string2.startsWith("fbcdn") && string2.endsWith("akamaihd.net"));
    }

    private static class BufferedHttpInputStream
    extends BufferedInputStream {
        HttpURLConnection connection;

        BufferedHttpInputStream(InputStream inputStream, HttpURLConnection httpURLConnection) {
            super(inputStream, 8192);
            this.connection = httpURLConnection;
        }

        @Override
        public void close() throws IOException {
            super.close();
            Utility.disconnectQuietly(this.connection);
        }
    }
}

