/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.net.Uri;
import com.facebook.internal.ImageResponse;
import com.facebook.internal.Validate;
import java.net.URI;
import java.net.URISyntaxException;

public class ImageRequest {
    private static final String HEIGHT_PARAM = "height";
    private static final String MIGRATION_PARAM = "migration_overrides";
    private static final String MIGRATION_VALUE = "{october_2012:true}";
    private static final String PROFILEPIC_URL_FORMAT = "https://graph.facebook.com/%s/picture";
    public static final int UNSPECIFIED_DIMENSION = 0;
    private static final String WIDTH_PARAM = "width";
    private boolean allowCachedRedirects;
    private Callback callback;
    private Object callerTag;
    private Context context;
    private URI imageUri;

    /*
     * Enabled aggressive block sorting
     */
    private ImageRequest(Builder builder) {
        this.context = builder.context;
        this.imageUri = builder.imageUrl;
        this.callback = builder.callback;
        this.allowCachedRedirects = builder.allowCachedRedirects;
        Object object = builder.callerTag == null ? new Object() : builder.callerTag;
        this.callerTag = object;
    }

    public static URI getProfilePictureUrl(String string2, int n2, int n3) throws URISyntaxException {
        Validate.notNullOrEmpty(string2, "userId");
        int n4 = Math.max(n2, 0);
        int n5 = Math.max(n3, 0);
        if (n4 == 0 && n5 == 0) {
            throw new IllegalArgumentException("Either width or height must be greater than 0");
        }
        Uri.Builder builder = new Uri.Builder().encodedPath(String.format(PROFILEPIC_URL_FORMAT, string2));
        if (n5 != 0) {
            builder.appendQueryParameter(HEIGHT_PARAM, String.valueOf(n5));
        }
        if (n4 != 0) {
            builder.appendQueryParameter(WIDTH_PARAM, String.valueOf(n4));
        }
        builder.appendQueryParameter(MIGRATION_PARAM, MIGRATION_VALUE);
        return new URI(builder.toString());
    }

    public Callback getCallback() {
        return this.callback;
    }

    public Object getCallerTag() {
        return this.callerTag;
    }

    public Context getContext() {
        return this.context;
    }

    public URI getImageUri() {
        return this.imageUri;
    }

    public boolean isCachedRedirectAllowed() {
        return this.allowCachedRedirects;
    }

    public static class Builder {
        private boolean allowCachedRedirects;
        private Callback callback;
        private Object callerTag;
        private Context context;
        private URI imageUrl;

        public Builder(Context context, URI uRI) {
            Validate.notNull(uRI, "imageUrl");
            this.context = context;
            this.imageUrl = uRI;
        }

        public ImageRequest build() {
            return new ImageRequest(this);
        }

        public Builder setAllowCachedRedirects(boolean bl2) {
            this.allowCachedRedirects = bl2;
            return this;
        }

        public Builder setCallback(Callback callback) {
            this.callback = callback;
            return this;
        }

        public Builder setCallerTag(Object object) {
            this.callerTag = object;
            return this;
        }
    }

    public static interface Callback {
        public void onCompleted(ImageResponse var1);
    }
}

