/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Looper;
import com.facebook.internal.ImageRequest;
import com.facebook.internal.ImageResponse;
import com.facebook.internal.ImageResponseCache;
import com.facebook.internal.UrlRedirectCache;
import com.facebook.internal.Utility;
import com.facebook.internal.WorkQueue;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class ImageDownloader {
    private static final int CACHE_READ_QUEUE_MAX_CONCURRENT = 2;
    private static final int DOWNLOAD_QUEUE_MAX_CONCURRENT = 8;
    private static WorkQueue cacheReadQueue;
    private static WorkQueue downloadQueue;
    private static Handler handler;
    private static final Map<RequestKey, DownloaderContext> pendingRequests;

    static {
        downloadQueue = new WorkQueue(8);
        cacheReadQueue = new WorkQueue(2);
        pendingRequests = new HashMap<RequestKey, DownloaderContext>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean cancelRequest(ImageRequest imageRequest) {
        RequestKey requestKey = new RequestKey(imageRequest.getImageUri(), imageRequest.getCallerTag());
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            DownloaderContext downloaderContext = pendingRequests.get(requestKey);
            boolean bl2 = false;
            if (downloaderContext != null) {
                bl2 = true;
                if (downloaderContext.workItem.cancel()) {
                    pendingRequests.remove(requestKey);
                } else {
                    downloaderContext.isCancelled = true;
                }
            }
            return bl2;
        }
    }

    public static void clearCache(Context context) {
        ImageResponseCache.clearCache(context);
        UrlRedirectCache.clearCache(context);
    }

    /*
     * Exception decompiling
     */
    private static void download(RequestKey var0, Context var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [12, 13, 14 : 171->186)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void downloadAsync(ImageRequest imageRequest) {
        if (imageRequest == null) {
            return;
        }
        RequestKey requestKey = new RequestKey(imageRequest.getImageUri(), imageRequest.getCallerTag());
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            DownloaderContext downloaderContext = pendingRequests.get(requestKey);
            if (downloaderContext != null) {
                downloaderContext.request = imageRequest;
                downloaderContext.isCancelled = false;
                downloaderContext.workItem.moveToFront();
            } else {
                ImageDownloader.enqueueCacheRead(imageRequest, requestKey, imageRequest.isCachedRedirectAllowed());
            }
            return;
        }
    }

    private static void enqueueCacheRead(ImageRequest imageRequest, RequestKey requestKey, boolean bl2) {
        ImageDownloader.enqueueRequest(imageRequest, requestKey, cacheReadQueue, new CacheReadWorkItem(imageRequest.getContext(), requestKey, bl2));
    }

    private static void enqueueDownload(ImageRequest imageRequest, RequestKey requestKey) {
        ImageDownloader.enqueueRequest(imageRequest, requestKey, downloadQueue, new DownloadImageWorkItem(imageRequest.getContext(), requestKey));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void enqueueRequest(ImageRequest imageRequest, RequestKey requestKey, WorkQueue workQueue, Runnable runnable) {
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            DownloaderContext downloaderContext = new DownloaderContext();
            downloaderContext.request = imageRequest;
            pendingRequests.put(requestKey, downloaderContext);
            downloaderContext.workItem = workQueue.addActiveWorkItem(runnable);
            return;
        }
    }

    private static Handler getHandler() {
        synchronized (ImageDownloader.class) {
            if (handler == null) {
                handler = new Handler(Looper.getMainLooper());
            }
            Handler handler = ImageDownloader.handler;
            return handler;
        }
    }

    private static void issueResponse(RequestKey requestKey, final Exception exception, final Bitmap bitmap, final boolean bl2) {
        ImageRequest imageRequest;
        ImageRequest.Callback callback;
        DownloaderContext downloaderContext = ImageDownloader.removePendingRequest(requestKey);
        if (downloaderContext != null && !downloaderContext.isCancelled && (callback = (imageRequest = downloaderContext.request).getCallback()) != null) {
            ImageDownloader.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    ImageResponse imageResponse = new ImageResponse(imageRequest, exception, bl2, bitmap);
                    callback.onCompleted(imageResponse);
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prioritizeRequest(ImageRequest imageRequest) {
        RequestKey requestKey = new RequestKey(imageRequest.getImageUri(), imageRequest.getCallerTag());
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            DownloaderContext downloaderContext = pendingRequests.get(requestKey);
            if (downloaderContext != null) {
                downloaderContext.workItem.moveToFront();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void readFromCache(RequestKey requestKey, Context context, boolean bl2) {
        InputStream inputStream = null;
        boolean bl3 = false;
        if (bl2) {
            URI uRI = UrlRedirectCache.getRedirectedUri(context, requestKey.uri);
            inputStream = null;
            bl3 = false;
            if (uRI != null) {
                inputStream = ImageResponseCache.getCachedImageStream(uRI, context);
                bl3 = inputStream != null;
            }
        }
        if (!bl3) {
            inputStream = ImageResponseCache.getCachedImageStream(requestKey.uri, context);
        }
        if (inputStream != null) {
            Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
            Utility.closeQuietly(inputStream);
            ImageDownloader.issueResponse(requestKey, null, bitmap, bl3);
            return;
        } else {
            DownloaderContext downloaderContext = ImageDownloader.removePendingRequest(requestKey);
            if (downloaderContext == null || downloaderContext.isCancelled) return;
            ImageDownloader.enqueueDownload(downloaderContext.request, requestKey);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DownloaderContext removePendingRequest(RequestKey requestKey) {
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            return pendingRequests.remove(requestKey);
        }
    }

    private static class CacheReadWorkItem
    implements Runnable {
        private boolean allowCachedRedirects;
        private Context context;
        private RequestKey key;

        CacheReadWorkItem(Context context, RequestKey requestKey, boolean bl2) {
            this.context = context;
            this.key = requestKey;
            this.allowCachedRedirects = bl2;
        }

        @Override
        public void run() {
            ImageDownloader.readFromCache(this.key, this.context, this.allowCachedRedirects);
        }
    }

    private static class DownloadImageWorkItem
    implements Runnable {
        private Context context;
        private RequestKey key;

        DownloadImageWorkItem(Context context, RequestKey requestKey) {
            this.context = context;
            this.key = requestKey;
        }

        @Override
        public void run() {
            ImageDownloader.download(this.key, this.context);
        }
    }

    private static class DownloaderContext {
        boolean isCancelled;
        ImageRequest request;
        WorkQueue.WorkItem workItem;

        private DownloaderContext() {
        }
    }

    private static class RequestKey {
        private static final int HASH_MULTIPLIER = 37;
        private static final int HASH_SEED = 29;
        Object tag;
        URI uri;

        RequestKey(URI uRI, Object object) {
            this.uri = uRI;
            this.tag = object;
        }

        public boolean equals(Object object) {
            block3: {
                boolean bl2;
                block2: {
                    bl2 = false;
                    if (object == null) break block2;
                    boolean bl3 = object instanceof RequestKey;
                    bl2 = false;
                    if (!bl3) break block2;
                    RequestKey requestKey = (RequestKey)object;
                    if (requestKey.uri != this.uri || requestKey.tag != this.tag) break block3;
                    bl2 = true;
                }
                return bl2;
            }
            return false;
        }

        public int hashCode() {
            return 37 * (1073 + this.uri.hashCode()) + this.tag.hashCode();
        }
    }
}

