/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import com.facebook.LoggingBehavior;
import com.facebook.Settings;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.Date;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class FileLruCache {
    private static final String HEADER_CACHEKEY_KEY = "key";
    private static final String HEADER_CACHE_CONTENT_TAG_KEY = "tag";
    static final String TAG = FileLruCache.class.getSimpleName();
    private static final AtomicLong bufferIndex = new AtomicLong();
    private final File directory;
    private boolean isTrimPending;
    private AtomicLong lastClearCacheTime = new AtomicLong(0L);
    private final Limits limits;
    private final Object lock;
    private final String tag;

    public FileLruCache(Context context, String string2, Limits limits) {
        this.tag = string2;
        this.limits = limits;
        this.directory = new File(context.getCacheDir(), string2);
        this.lock = new Object();
        if (this.directory.mkdirs() || this.directory.isDirectory()) {
            BufferFile.deleteAll(this.directory);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postTrim() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isTrimPending) {
                this.isTrimPending = true;
                Settings.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        FileLruCache.this.trim();
                    }
                });
            }
            return;
        }
    }

    private void renameToTargetAndTrim(String string2, File file) {
        if (!file.renameTo(new File(this.directory, Utility.md5hash(string2)))) {
            file.delete();
        }
        this.postTrim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void trim() {
        Logger.log(LoggingBehavior.CACHE, TAG, "trim started");
        PriorityQueue<ModifiedFile> priorityQueue = new PriorityQueue<ModifiedFile>();
        long l2 = 0L;
        long l3 = 0L;
        File[] fileArray = this.directory.listFiles(BufferFile.excludeBufferFiles());
        if (fileArray != null) {
            File file;
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; l2 += file.length(), ++l3, ++i2) {
                file = fileArray[i2];
                ModifiedFile modifiedFile = new ModifiedFile(file);
                priorityQueue.add(modifiedFile);
                Logger.log(LoggingBehavior.CACHE, TAG, "  trim considering time=" + Long.valueOf(modifiedFile.getModified()) + " name=" + modifiedFile.getFile().getName());
            }
        }
        while (true) {
            if (l2 <= (long)this.limits.getByteCount()) {
                if (l3 <= (long)this.limits.getFileCount()) return;
            }
            File file = ((ModifiedFile)priorityQueue.remove()).getFile();
            Logger.log(LoggingBehavior.CACHE, TAG, "  trim removing " + file.getName());
            l2 -= file.length();
            --l3;
            file.delete();
        }
    }

    public void clearCache() {
        final File[] fileArray = this.directory.listFiles(BufferFile.excludeBufferFiles());
        this.lastClearCacheTime.set(System.currentTimeMillis());
        if (fileArray != null) {
            Settings.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    File[] fileArray2 = fileArray;
                    int n2 = fileArray2.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        fileArray2[i2].delete();
                    }
                }
            });
        }
    }

    public InputStream get(String string2) throws IOException {
        return this.get(string2, null);
    }

    /*
     * Loose catch block
     */
    public InputStream get(String string2, String string3) throws IOException {
        BufferedInputStream bufferedInputStream;
        File file;
        block18: {
            block17: {
                JSONObject jSONObject;
                block16: {
                    block15: {
                        block13: {
                            block14: {
                                file = new File(this.directory, Utility.md5hash(string2));
                                FileInputStream fileInputStream = new FileInputStream(file);
                                bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
                                jSONObject = StreamHeader.readHeader(bufferedInputStream);
                                if (jSONObject != null) break block13;
                                if (false) break block14;
                                bufferedInputStream.close();
                            }
                            return null;
                            catch (IOException iOException) {
                                return null;
                            }
                        }
                        String string4 = jSONObject.optString(HEADER_CACHEKEY_KEY);
                        if (string4 == null) break block15;
                        boolean bl2 = string4.equals(string2);
                        if (bl2) break block16;
                    }
                    if (!false) {
                        bufferedInputStream.close();
                    }
                    return null;
                }
                String string5 = jSONObject.optString(HEADER_CACHE_CONTENT_TAG_KEY, null);
                if (string3 == null && string5 != null) break block17;
                if (string3 == null) break block18;
                boolean bl3 = string3.equals(string5);
                if (bl3) break block18;
            }
            if (!false) {
                bufferedInputStream.close();
            }
            return null;
        }
        try {
            long l2 = new Date().getTime();
            Logger.log(LoggingBehavior.CACHE, TAG, "Setting lastModified to " + Long.valueOf(l2) + " for " + file.getName());
            file.setLastModified(l2);
            return bufferedInputStream;
        }
        finally {
            if (!true) {
                bufferedInputStream.close();
            }
        }
    }

    public InputStream interceptAndPut(String string2, InputStream inputStream) throws IOException {
        return new CopyingInputStream(inputStream, this.openPutStream(string2));
    }

    OutputStream openPutStream(String string2) throws IOException {
        return this.openPutStream(string2, null);
    }

    public OutputStream openPutStream(String string2, String string3) throws IOException {
        BufferedOutputStream bufferedOutputStream;
        File file = BufferFile.newFile(this.directory);
        file.delete();
        if (!file.createNewFile()) {
            throw new IOException("Could not create file at " + file.getAbsolutePath());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(new CloseCallbackOutputStream(fileOutputStream, new StreamCloseCallback(System.currentTimeMillis(), file, string2){
                final /* synthetic */ File val$buffer;
                final /* synthetic */ long val$bufferFileCreateTime;
                final /* synthetic */ String val$key;
                {
                    this.val$bufferFileCreateTime = l2;
                    this.val$buffer = file;
                    this.val$key = string2;
                }

                @Override
                public void onClose() {
                    if (this.val$bufferFileCreateTime < FileLruCache.this.lastClearCacheTime.get()) {
                        this.val$buffer.delete();
                        return;
                    }
                    FileLruCache.this.renameToTargetAndTrim(this.val$key, this.val$buffer);
                }
            }), 8192);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.log(LoggingBehavior.CACHE, 5, TAG, "Error creating buffer output stream: " + fileNotFoundException);
            throw new IOException(fileNotFoundException.getMessage());
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(HEADER_CACHEKEY_KEY, (Object)string2);
            if (!Utility.isNullOrEmpty(string3)) {
                jSONObject.put(HEADER_CACHE_CONTENT_TAG_KEY, (Object)string3);
            }
            StreamHeader.writeHeader(bufferedOutputStream, jSONObject);
            return bufferedOutputStream;
        }
        catch (JSONException jSONException) {
            Logger.log(LoggingBehavior.CACHE, 5, TAG, "Error creating JSON header for cache file: " + (Object)((Object)jSONException));
            throw new IOException(jSONException.getMessage());
        }
        finally {
            if (!false) {
                bufferedOutputStream.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long sizeInBytesForTest() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            while (bl2 = this.isTrimPending) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        File[] fileArray = this.directory.listFiles();
        long l2 = 0L;
        if (fileArray != null) {
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; l2 += fileArray[i2].length(), ++i2) {
            }
        }
        return l2;
    }

    public String toString() {
        return "{FileLruCache: tag:" + this.tag + " file:" + this.directory.getName() + "}";
    }

    private static class BufferFile {
        private static final String FILE_NAME_PREFIX = "buffer";
        private static final FilenameFilter filterExcludeBufferFiles = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return !string2.startsWith(BufferFile.FILE_NAME_PREFIX);
            }
        };
        private static final FilenameFilter filterExcludeNonBufferFiles = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return string2.startsWith(BufferFile.FILE_NAME_PREFIX);
            }
        };

        private BufferFile() {
        }

        static void deleteAll(File file) {
            File[] fileArray = file.listFiles(BufferFile.excludeNonBufferFiles());
            if (fileArray != null) {
                int n2 = fileArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    fileArray[i2].delete();
                }
            }
        }

        static FilenameFilter excludeBufferFiles() {
            return filterExcludeBufferFiles;
        }

        static FilenameFilter excludeNonBufferFiles() {
            return filterExcludeNonBufferFiles;
        }

        static File newFile(File file) {
            return new File(file, FILE_NAME_PREFIX + Long.valueOf(bufferIndex.incrementAndGet()).toString());
        }
    }

    private static class CloseCallbackOutputStream
    extends OutputStream {
        final StreamCloseCallback callback;
        final OutputStream innerStream;

        CloseCallbackOutputStream(OutputStream outputStream, StreamCloseCallback streamCloseCallback) {
            this.innerStream = outputStream;
            this.callback = streamCloseCallback;
        }

        @Override
        public void close() throws IOException {
            try {
                this.innerStream.close();
                return;
            }
            finally {
                this.callback.onClose();
            }
        }

        @Override
        public void flush() throws IOException {
            this.innerStream.flush();
        }

        @Override
        public void write(int n2) throws IOException {
            this.innerStream.write(n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.innerStream.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.innerStream.write(byArray, n2, n3);
        }
    }

    private static final class CopyingInputStream
    extends InputStream {
        final InputStream input;
        final OutputStream output;

        CopyingInputStream(InputStream inputStream, OutputStream outputStream) {
            this.input = inputStream;
            this.output = outputStream;
        }

        @Override
        public int available() throws IOException {
            return this.input.available();
        }

        @Override
        public void close() throws IOException {
            try {
                this.input.close();
                return;
            }
            finally {
                this.output.close();
            }
        }

        @Override
        public void mark(int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            int n2 = this.input.read();
            if (n2 >= 0) {
                this.output.write(n2);
            }
            return n2;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            int n2 = this.input.read(byArray);
            if (n2 > 0) {
                this.output.write(byArray, 0, n2);
            }
            return n2;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = this.input.read(byArray, n2, n3);
            if (n4 > 0) {
                this.output.write(byArray, n2, n4);
            }
            return n4;
        }

        @Override
        public void reset() {
            synchronized (this) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public long skip(long l2) throws IOException {
            byte[] byArray = new byte[1024];
            long l3 = 0L;
            int n2;
            while (l3 < l2 && (n2 = this.read(byArray, 0, (int)Math.min(l2 - l3, (long)byArray.length))) >= 0) {
                l3 += (long)n2;
            }
            return l3;
        }
    }

    public static final class Limits {
        private int byteCount = 0x100000;
        private int fileCount = 1024;

        int getByteCount() {
            return this.byteCount;
        }

        int getFileCount() {
            return this.fileCount;
        }

        void setByteCount(int n2) {
            if (n2 < 0) {
                throw new InvalidParameterException("Cache byte-count limit must be >= 0");
            }
            this.byteCount = n2;
        }

        void setFileCount(int n2) {
            if (n2 < 0) {
                throw new InvalidParameterException("Cache file count limit must be >= 0");
            }
            this.fileCount = n2;
        }
    }

    private static final class ModifiedFile
    implements Comparable<ModifiedFile> {
        private static final int HASH_MULTIPLIER = 37;
        private static final int HASH_SEED = 29;
        private final File file;
        private final long modified;

        ModifiedFile(File file) {
            this.file = file;
            this.modified = file.lastModified();
        }

        @Override
        public int compareTo(ModifiedFile modifiedFile) {
            if (this.getModified() < modifiedFile.getModified()) {
                return -1;
            }
            if (this.getModified() > modifiedFile.getModified()) {
                return 1;
            }
            return this.getFile().compareTo(modifiedFile.getFile());
        }

        public boolean equals(Object object) {
            return object instanceof ModifiedFile && this.compareTo((ModifiedFile)object) == 0;
        }

        File getFile() {
            return this.file;
        }

        long getModified() {
            return this.modified;
        }

        public int hashCode() {
            return 37 * (1073 + this.file.hashCode()) + (int)(this.modified % Integer.MAX_VALUE);
        }
    }

    private static interface StreamCloseCallback {
        public void onClose();
    }

    private static final class StreamHeader {
        private static final int HEADER_VERSION;

        private StreamHeader() {
        }

        static JSONObject readHeader(InputStream inputStream) throws IOException {
            Object object;
            block7: {
                int n2;
                if (inputStream.read() != 0) {
                    return null;
                }
                int n3 = 0;
                for (int i2 = 0; i2 < 3; ++i2) {
                    int n4 = inputStream.read();
                    if (n4 == -1) {
                        Logger.log(LoggingBehavior.CACHE, TAG, "readHeader: stream.read returned -1 while reading header size");
                        return null;
                    }
                    n3 = (n3 << 8) + (n4 & 0xFF);
                }
                byte[] byArray = new byte[n3];
                for (int i3 = 0; i3 < byArray.length; i3 += n2) {
                    n2 = inputStream.read(byArray, i3, byArray.length - i3);
                    if (n2 >= 1) continue;
                    Logger.log(LoggingBehavior.CACHE, TAG, "readHeader: stream.read stopped at " + Integer.valueOf(i3) + " when expected " + byArray.length);
                    return null;
                }
                JSONTokener jSONTokener = new JSONTokener(new String(byArray));
                try {
                    object = jSONTokener.nextValue();
                    if (object instanceof JSONObject) break block7;
                    Logger.log(LoggingBehavior.CACHE, TAG, "readHeader: expected JSONObject, got " + object.getClass().getCanonicalName());
                    return null;
                }
                catch (JSONException jSONException) {
                    throw new IOException(jSONException.getMessage());
                }
            }
            JSONObject jSONObject = (JSONObject)object;
            return jSONObject;
        }

        static void writeHeader(OutputStream outputStream, JSONObject jSONObject) throws IOException {
            byte[] byArray = jSONObject.toString().getBytes();
            outputStream.write(0);
            outputStream.write(0xFF & byArray.length >> 16);
            outputStream.write(0xFF & byArray.length >> 8);
            outputStream.write(0xFF & byArray.length >> 0);
            outputStream.write(byArray);
        }
    }
}

