/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.facebook.AppEventsLogger;
import com.facebook.Session;
import com.facebook.SessionState;
import com.facebook.widget.FacebookDialog;
import java.util.UUID;

public class UiLifecycleHelper {
    private static final String ACTIVITY_NULL_MESSAGE = "activity cannot be null";
    private static final String DIALOG_CALL_BUNDLE_SAVE_KEY = "com.facebook.UiLifecycleHelper.pendingFacebookDialogCallKey";
    private final Activity activity;
    private AppEventsLogger appEventsLogger;
    private final LocalBroadcastManager broadcastManager;
    private final Session.StatusCallback callback;
    private FacebookDialog.PendingCall pendingFacebookDialogCall;
    private final BroadcastReceiver receiver;

    public UiLifecycleHelper(Activity activity, Session.StatusCallback statusCallback) {
        if (activity == null) {
            throw new IllegalArgumentException(ACTIVITY_NULL_MESSAGE);
        }
        this.activity = activity;
        this.callback = statusCallback;
        this.receiver = new ActiveSessionBroadcastReceiver();
        this.broadcastManager = LocalBroadcastManager.getInstance((Context)activity);
    }

    private void cancelPendingAppCall(FacebookDialog.Callback callback) {
        if (callback != null) {
            Intent intent = this.pendingFacebookDialogCall.getRequestIntent();
            Intent intent2 = new Intent();
            intent2.putExtra("com.facebook.platform.protocol.CALL_ID", intent.getStringExtra("com.facebook.platform.protocol.CALL_ID"));
            intent2.putExtra("com.facebook.platform.protocol.PROTOCOL_ACTION", intent.getStringExtra("com.facebook.platform.protocol.PROTOCOL_ACTION"));
            intent2.putExtra("com.facebook.platform.protocol.PROTOCOL_VERSION", intent.getIntExtra("com.facebook.platform.protocol.PROTOCOL_VERSION", 0));
            intent2.putExtra("com.facebook.platform.status.ERROR_TYPE", "UnknownError");
            FacebookDialog.handleActivityResult((Context)this.activity, this.pendingFacebookDialogCall, this.pendingFacebookDialogCall.getRequestCode(), intent2, callback);
        }
        this.pendingFacebookDialogCall = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleFacebookDialogActivityResult(int n2, int n3, Intent intent, FacebookDialog.Callback callback) {
        if (this.pendingFacebookDialogCall == null || this.pendingFacebookDialogCall.getRequestCode() != n2) {
            return false;
        }
        if (intent == null) {
            this.cancelPendingAppCall(callback);
            return true;
        }
        String string2 = intent.getStringExtra("com.facebook.platform.protocol.CALL_ID");
        UUID uUID = null;
        if (string2 != null) {
            try {
                UUID uUID2;
                uUID = uUID2 = UUID.fromString(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                uUID = null;
            }
        }
        if (uUID != null && this.pendingFacebookDialogCall.getCallId().equals(uUID)) {
            FacebookDialog.handleActivityResult((Context)this.activity, this.pendingFacebookDialogCall, n2, intent, callback);
        } else {
            this.cancelPendingAppCall(callback);
        }
        this.pendingFacebookDialogCall = null;
        return true;
    }

    public AppEventsLogger getAppEventsLogger() {
        Session session = Session.getActiveSession();
        if (session == null) {
            return null;
        }
        if (this.appEventsLogger == null || !this.appEventsLogger.isValidForSession(session)) {
            if (this.appEventsLogger != null) {
                AppEventsLogger.onContextStop();
            }
            this.appEventsLogger = AppEventsLogger.newLogger((Context)this.activity, session);
        }
        return this.appEventsLogger;
    }

    public void onActivityResult(int n2, int n3, Intent intent) {
        this.onActivityResult(n2, n3, intent, null);
    }

    public void onActivityResult(int n2, int n3, Intent intent, FacebookDialog.Callback callback) {
        Session session = Session.getActiveSession();
        if (session != null) {
            session.onActivityResult(this.activity, n2, n3, intent);
        }
        this.handleFacebookDialogActivityResult(n2, n3, intent, callback);
    }

    public void onCreate(Bundle bundle) {
        Session session = Session.getActiveSession();
        if (session == null) {
            if (bundle != null) {
                session = Session.restoreSession((Context)this.activity, null, this.callback, bundle);
            }
            if (session == null) {
                session = new Session((Context)this.activity);
            }
            Session.setActiveSession(session);
        }
        if (bundle != null) {
            this.pendingFacebookDialogCall = (FacebookDialog.PendingCall)bundle.getParcelable(DIALOG_CALL_BUNDLE_SAVE_KEY);
        }
    }

    public void onDestroy() {
    }

    public void onPause() {
        Session session;
        this.broadcastManager.unregisterReceiver(this.receiver);
        if (this.callback != null && (session = Session.getActiveSession()) != null) {
            session.removeCallback(this.callback);
        }
    }

    public void onResume() {
        Session session = Session.getActiveSession();
        if (session != null) {
            if (this.callback != null) {
                session.addCallback(this.callback);
            }
            if (SessionState.CREATED_TOKEN_LOADED.equals((Object)session.getState())) {
                session.openForRead(null);
            }
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.facebook.sdk.ACTIVE_SESSION_SET");
        intentFilter.addAction("com.facebook.sdk.ACTIVE_SESSION_UNSET");
        this.broadcastManager.registerReceiver(this.receiver, intentFilter);
    }

    public void onSaveInstanceState(Bundle bundle) {
        Session.saveSession(Session.getActiveSession(), bundle);
        bundle.putParcelable(DIALOG_CALL_BUNDLE_SAVE_KEY, (Parcelable)this.pendingFacebookDialogCall);
    }

    public void onStop() {
        AppEventsLogger.onContextStop();
    }

    public void trackPendingDialogCall(FacebookDialog.PendingCall pendingCall) {
        if (this.pendingFacebookDialogCall != null) {
            Log.i((String)"Facebook", (String)"Tracking new app call while one is still pending; canceling pending call.");
            this.cancelPendingAppCall(null);
        }
        this.pendingFacebookDialogCall = pendingCall;
    }

    private class ActiveSessionBroadcastReceiver
    extends BroadcastReceiver {
        private ActiveSessionBroadcastReceiver() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onReceive(Context context, Intent intent) {
            Session session;
            if ("com.facebook.sdk.ACTIVE_SESSION_SET".equals(intent.getAction())) {
                Session session2 = Session.getActiveSession();
                if (session2 == null || UiLifecycleHelper.this.callback == null) return;
                session2.addCallback(UiLifecycleHelper.this.callback);
                return;
            }
            if (!"com.facebook.sdk.ACTIVE_SESSION_UNSET".equals(intent.getAction()) || (session = Session.getActiveSession()) == null || UiLifecycleHelper.this.callback == null) return;
            session.removeCallback(UiLifecycleHelper.this.callback);
        }
    }
}

