/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Bundle;
import com.facebook.AccessTokenSource;
import com.facebook.internal.Validate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class TokenCachingStrategy {
    public static final String EXPIRATION_DATE_KEY = "com.facebook.TokenCachingStrategy.ExpirationDate";
    private static final long INVALID_BUNDLE_MILLISECONDS = Long.MIN_VALUE;
    private static final String IS_SSO_KEY = "com.facebook.TokenCachingStrategy.IsSSO";
    public static final String LAST_REFRESH_DATE_KEY = "com.facebook.TokenCachingStrategy.LastRefreshDate";
    public static final String PERMISSIONS_KEY = "com.facebook.TokenCachingStrategy.Permissions";
    public static final String TOKEN_KEY = "com.facebook.TokenCachingStrategy.Token";
    public static final String TOKEN_SOURCE_KEY = "com.facebook.TokenCachingStrategy.AccessTokenSource";
    public static final String USER_FBID_KEY = "com.facebook.TokenCachingStrategy.UserFBID";

    /*
     * Enabled aggressive block sorting
     */
    static Date getDate(Bundle bundle, String string2) {
        long l2;
        if (bundle == null || (l2 = bundle.getLong(string2, Long.MIN_VALUE)) == Long.MIN_VALUE) {
            return null;
        }
        return new Date(l2);
    }

    public static Date getExpirationDate(Bundle bundle) {
        Validate.notNull(bundle, "bundle");
        return TokenCachingStrategy.getDate(bundle, EXPIRATION_DATE_KEY);
    }

    public static long getExpirationMilliseconds(Bundle bundle) {
        Validate.notNull(bundle, "bundle");
        return bundle.getLong(EXPIRATION_DATE_KEY);
    }

    public static Date getLastRefreshDate(Bundle bundle) {
        Validate.notNull(bundle, "bundle");
        return TokenCachingStrategy.getDate(bundle, LAST_REFRESH_DATE_KEY);
    }

    public static long getLastRefreshMilliseconds(Bundle bundle) {
        Validate.notNull(bundle, "bundle");
        return bundle.getLong(LAST_REFRESH_DATE_KEY);
    }

    public static List<String> getPermissions(Bundle bundle) {
        Validate.notNull(bundle, "bundle");
        return bundle.getStringArrayList(PERMISSIONS_KEY);
    }

    public static AccessTokenSource getSource(Bundle bundle) {
        Validate.notNull(bundle, "bundle");
        if (bundle.containsKey(TOKEN_SOURCE_KEY)) {
            return (AccessTokenSource)((Object)bundle.getSerializable(TOKEN_SOURCE_KEY));
        }
        if (bundle.getBoolean(IS_SSO_KEY)) {
            return AccessTokenSource.FACEBOOK_APPLICATION_WEB;
        }
        return AccessTokenSource.WEB_VIEW;
    }

    public static String getToken(Bundle bundle) {
        Validate.notNull(bundle, "bundle");
        return bundle.getString(TOKEN_KEY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean hasTokenInformation(Bundle bundle) {
        String string2;
        return bundle != null && (string2 = bundle.getString(TOKEN_KEY)) != null && string2.length() != 0 && bundle.getLong(EXPIRATION_DATE_KEY, 0L) != 0L;
    }

    static void putDate(Bundle bundle, String string2, Date date) {
        bundle.putLong(string2, date.getTime());
    }

    public static void putExpirationDate(Bundle bundle, Date date) {
        Validate.notNull(bundle, "bundle");
        Validate.notNull(date, "value");
        TokenCachingStrategy.putDate(bundle, EXPIRATION_DATE_KEY, date);
    }

    public static void putExpirationMilliseconds(Bundle bundle, long l2) {
        Validate.notNull(bundle, "bundle");
        bundle.putLong(EXPIRATION_DATE_KEY, l2);
    }

    public static void putLastRefreshDate(Bundle bundle, Date date) {
        Validate.notNull(bundle, "bundle");
        Validate.notNull(date, "value");
        TokenCachingStrategy.putDate(bundle, LAST_REFRESH_DATE_KEY, date);
    }

    public static void putLastRefreshMilliseconds(Bundle bundle, long l2) {
        Validate.notNull(bundle, "bundle");
        bundle.putLong(LAST_REFRESH_DATE_KEY, l2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void putPermissions(Bundle bundle, List<String> list) {
        Validate.notNull(bundle, "bundle");
        Validate.notNull(list, "value");
        ArrayList<String> arrayList = list instanceof ArrayList ? (ArrayList<String>)list : new ArrayList<String>(list);
        bundle.putStringArrayList(PERMISSIONS_KEY, arrayList);
    }

    public static void putSource(Bundle bundle, AccessTokenSource accessTokenSource) {
        Validate.notNull(bundle, "bundle");
        bundle.putSerializable(TOKEN_SOURCE_KEY, (Serializable)((Object)accessTokenSource));
    }

    public static void putToken(Bundle bundle, String string2) {
        Validate.notNull(bundle, "bundle");
        Validate.notNull(string2, "value");
        bundle.putString(TOKEN_KEY, string2);
    }

    public abstract void clear();

    public abstract Bundle load();

    public abstract void save(Bundle var1);
}

