/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.HttpMethod;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.SessionState;
import com.facebook.TokenCachingStrategy;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class TestSession
extends Session {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final String LOG_TAG = "FacebookSDK.TestSession";
    private static Map<String, TestAccount> appTestAccounts;
    private static final long serialVersionUID = 1L;
    private static String testApplicationId;
    private static String testApplicationSecret;
    private final Mode mode;
    private final List<String> requestedPermissions;
    private final String sessionUniqueUserTag;
    private String testAccountId;
    private boolean wasAskedToExtendAccessToken;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2 = !TestSession.class.desiredAssertionStatus();
        $assertionsDisabled = bl2;
    }

    TestSession(Activity activity, List<String> list, TokenCachingStrategy tokenCachingStrategy, String string2, Mode mode) {
        super((Context)activity, testApplicationId, tokenCachingStrategy);
        Validate.notNull(list, "permissions");
        Validate.notNullOrEmpty(testApplicationId, "testApplicationId");
        Validate.notNullOrEmpty(testApplicationSecret, "testApplicationSecret");
        this.sessionUniqueUserTag = string2;
        this.mode = mode;
        this.requestedPermissions = list;
    }

    public static TestSession createSessionWithPrivateUser(Activity activity, List<String> list) {
        return TestSession.createTestSession(activity, list, Mode.PRIVATE, null);
    }

    public static TestSession createSessionWithSharedUser(Activity activity, List<String> list) {
        return TestSession.createSessionWithSharedUser(activity, list, null);
    }

    public static TestSession createSessionWithSharedUser(Activity activity, List<String> list, String string2) {
        return TestSession.createTestSession(activity, list, Mode.SHARED, string2);
    }

    private TestAccount createTestAccountAndFinishAuth() {
        Bundle bundle = new Bundle();
        bundle.putString("installed", "true");
        bundle.putString("permissions", this.getPermissionsString());
        bundle.putString("access_token", TestSession.getAppAccessToken());
        if (this.mode == Mode.SHARED) {
            Object[] objectArray = new Object[]{this.getSharedTestAccountIdentifier()};
            bundle.putString("name", String.format("Shared %s Testuser", objectArray));
        }
        Object[] objectArray = new Object[]{testApplicationId};
        Response response = new Request(null, String.format("%s/accounts/test-users", objectArray), bundle, HttpMethod.POST).executeAndWait();
        FacebookRequestError facebookRequestError = response.getError();
        TestAccount testAccount = response.getGraphObjectAs(TestAccount.class);
        if (facebookRequestError != null) {
            this.finishAuthOrReauth(null, facebookRequestError.getException());
            return null;
        }
        if (!$assertionsDisabled && testAccount == null) {
            throw new AssertionError();
        }
        if (this.mode == Mode.SHARED) {
            testAccount.setName(bundle.getString("name"));
            TestSession.storeTestAccount(testAccount);
        }
        this.finishAuthWithTestAccount(testAccount);
        return testAccount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TestSession createTestSession(Activity activity, List<String> list, Mode mode, String string2) {
        synchronized (TestSession.class) {
            if (Utility.isNullOrEmpty(testApplicationId)) throw new FacebookException("Must provide app ID and secret");
            if (Utility.isNullOrEmpty(testApplicationSecret)) {
                throw new FacebookException("Must provide app ID and secret");
            }
            if (Utility.isNullOrEmpty(list)) {
                list = Arrays.asList("email", "publish_actions");
            }
            TestTokenCachingStrategy testTokenCachingStrategy = new TestTokenCachingStrategy();
            return new TestSession(activity, list, testTokenCachingStrategy, string2, mode);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void deleteTestAccount(String string2, String string3) {
        Bundle bundle = new Bundle();
        bundle.putString("access_token", string3);
        Response response = new Request(null, string2, bundle, HttpMethod.DELETE).executeAndWait();
        FacebookRequestError facebookRequestError = response.getError();
        GraphObject graphObject = response.getGraphObject();
        if (facebookRequestError != null) {
            Object[] objectArray = new Object[]{string2, facebookRequestError.getException().toString()};
            Log.w((String)LOG_TAG, (String)String.format("Could not delete test account %s: %s", objectArray));
            return;
        } else {
            if (graphObject.getProperty("FACEBOOK_NON_JSON_RESULT") != Boolean.valueOf(false)) return;
            Log.w((String)LOG_TAG, (String)String.format("Could not delete test account %s: unknown reason", string2));
            return;
        }
    }

    private void findOrCreateSharedTestAccount() {
        TestAccount testAccount = TestSession.findTestAccountMatchingIdentifier(this.getSharedTestAccountIdentifier());
        if (testAccount != null) {
            this.finishAuthWithTestAccount(testAccount);
            return;
        }
        this.createTestAccountAndFinishAuth();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TestAccount findTestAccountMatchingIdentifier(String string2) {
        synchronized (TestSession.class) {
            TestAccount testAccount;
            boolean bl2;
            TestSession.retrieveTestAccountsForAppIfNeeded();
            Iterator<TestAccount> iterator = appTestAccounts.values().iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while (!(bl2 = (testAccount = iterator.next()).getName().contains(string2)));
            return testAccount;
        }
    }

    private void finishAuthWithTestAccount(TestAccount testAccount) {
        this.testAccountId = testAccount.getId();
        this.finishAuthOrReauth(AccessToken.createFromString(testAccount.getAccessToken(), this.requestedPermissions, AccessTokenSource.TEST_USER), null);
    }

    static final String getAppAccessToken() {
        return testApplicationId + "|" + testApplicationSecret;
    }

    private String getPermissionsString() {
        return TextUtils.join((CharSequence)",", this.requestedPermissions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSharedTestAccountIdentifier() {
        long l2;
        long l3 = 0xFFFFFFFFL & (long)this.getPermissionsString().hashCode();
        if (this.sessionUniqueUserTag != null) {
            l2 = 0xFFFFFFFFL & (long)this.sessionUniqueUserTag.hashCode();
            return this.validNameStringFromInteger(l3 ^ l2);
        }
        l2 = 0L;
        return this.validNameStringFromInteger(l3 ^ l2);
    }

    public static String getTestApplicationId() {
        synchronized (TestSession.class) {
            String string2 = testApplicationId;
            return string2;
        }
    }

    public static String getTestApplicationSecret() {
        synchronized (TestSession.class) {
            String string2 = testApplicationSecret;
            return string2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void populateTestAccounts(Collection<TestAccount> collection, Collection<UserAccount> collection2) {
        synchronized (TestSession.class) {
            Iterator<TestAccount> iterator = collection.iterator();
            while (iterator.hasNext()) {
                TestSession.storeTestAccount(iterator.next());
            }
            Iterator<UserAccount> iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                UserAccount userAccount = iterator2.next();
                TestAccount testAccount = appTestAccounts.get(userAccount.getUid());
                if (testAccount == null) continue;
                testAccount.setName(userAccount.getName());
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void retrieveTestAccountsForAppIfNeeded() {
        synchronized (TestSession.class) {
            Map<String, TestAccount> map = appTestAccounts;
            if (map == null) {
                JSONObject jSONObject;
                appTestAccounts = new HashMap<String, TestAccount>();
                Object[] objectArray = new Object[]{testApplicationId};
                String string2 = String.format("SELECT id,access_token FROM test_account WHERE app_id = %s", objectArray);
                Bundle bundle = new Bundle();
                try {
                    jSONObject = new JSONObject();
                    jSONObject.put("test_accounts", (Object)string2);
                    jSONObject.put("users", (Object)"SELECT uid,name FROM user WHERE uid IN (SELECT id FROM #test_accounts)");
                }
                catch (JSONException jSONException) {
                    throw new FacebookException(jSONException);
                }
                bundle.putString("q", jSONObject.toString());
                bundle.putString("access_token", TestSession.getAppAccessToken());
                Response response = new Request(null, "fql", bundle, null).executeAndWait();
                if (response.getError() != null) {
                    throw response.getError().getException();
                }
                GraphObjectList<FqlResult> graphObjectList = response.getGraphObjectAs(FqlResponse.class).getData();
                if (graphObjectList == null || graphObjectList.size() != 2) {
                    throw new FacebookException("Unexpected number of results from FQL query");
                }
                TestSession.populateTestAccounts(((FqlResult)graphObjectList.get(0)).getFqlResultSet().castToListOf(TestAccount.class), ((FqlResult)graphObjectList.get(1)).getFqlResultSet().castToListOf(UserAccount.class));
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setTestApplicationId(String string2) {
        synchronized (TestSession.class) {
            if (testApplicationId != null && !testApplicationId.equals(string2)) {
                throw new FacebookException("Can't have more than one test application ID");
            }
            testApplicationId = string2;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setTestApplicationSecret(String string2) {
        synchronized (TestSession.class) {
            if (testApplicationSecret != null && !testApplicationSecret.equals(string2)) {
                throw new FacebookException("Can't have more than one test application secret");
            }
            testApplicationSecret = string2;
            return;
        }
    }

    private static void storeTestAccount(TestAccount testAccount) {
        synchronized (TestSession.class) {
            appTestAccounts.put(testAccount.getId(), testAccount);
            return;
        }
    }

    private String validNameStringFromInteger(long l2) {
        String string2 = Long.toString(l2);
        StringBuilder stringBuilder = new StringBuilder("Perm");
        char c2 = '\u0000';
        for (char c3 : string2.toCharArray()) {
            if (c3 == c2) {
                c3 = (char)(c3 + 10);
            }
            stringBuilder.append((char)(-48 + (c3 + 97)));
            c2 = c3;
        }
        return stringBuilder.toString();
    }

    @Override
    void authorize(Session.AuthorizationRequest authorizationRequest) {
        if (this.mode == Mode.PRIVATE) {
            this.createTestAccountAndFinishAuth();
            return;
        }
        this.findOrCreateSharedTestAccount();
    }

    @Override
    void extendAccessToken() {
        this.wasAskedToExtendAccessToken = true;
        super.extendAccessToken();
    }

    void fakeTokenRefreshAttempt() {
        this.setCurrentTokenRefreshRequest(new Session.TokenRefreshRequest());
    }

    void forceExtendAccessToken(boolean bl2) {
        AccessToken accessToken = this.getTokenInfo();
        this.setTokenInfo(new AccessToken(accessToken.getToken(), new Date(), accessToken.getPermissions(), AccessTokenSource.TEST_USER, new Date(0L)));
        this.setLastAttemptedTokenExtendDate(new Date(0L));
    }

    public final String getTestUserId() {
        return this.testAccountId;
    }

    boolean getWasAskedToExtendAccessToken() {
        return this.wasAskedToExtendAccessToken;
    }

    @Override
    void postStateChange(SessionState sessionState, SessionState sessionState2, Exception exception) {
        String string2 = this.testAccountId;
        super.postStateChange(sessionState, sessionState2, exception);
        if (sessionState2.isClosed() && string2 != null && this.mode == Mode.PRIVATE) {
            this.deleteTestAccount(string2, TestSession.getAppAccessToken());
        }
    }

    @Override
    boolean shouldExtendAccessToken() {
        boolean bl2 = super.shouldExtendAccessToken();
        this.wasAskedToExtendAccessToken = false;
        return bl2;
    }

    @Override
    public final String toString() {
        String string2 = super.toString();
        return "{TestSession" + " testUserId:" + this.testAccountId + " " + string2 + "}";
    }

    private static interface FqlResponse
    extends GraphObject {
        public GraphObjectList<FqlResult> getData();
    }

    private static interface FqlResult
    extends GraphObject {
        public GraphObjectList<GraphObject> getFqlResultSet();
    }

    private static final class Mode
    extends Enum<Mode> {
        private static final /* synthetic */ Mode[] $VALUES;
        public static final /* enum */ Mode PRIVATE = new Mode();
        public static final /* enum */ Mode SHARED = new Mode();

        static {
            Mode[] modeArray = new Mode[]{PRIVATE, SHARED};
            $VALUES = modeArray;
        }

        public static Mode valueOf(String string2) {
            return Enum.valueOf(Mode.class, string2);
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }
    }

    private static interface TestAccount
    extends GraphObject {
        public String getAccessToken();

        public String getId();

        public String getName();

        public void setName(String var1);
    }

    private static final class TestTokenCachingStrategy
    extends TokenCachingStrategy {
        private Bundle bundle;

        private TestTokenCachingStrategy() {
        }

        @Override
        public void clear() {
            this.bundle = null;
        }

        @Override
        public Bundle load() {
            return this.bundle;
        }

        @Override
        public void save(Bundle bundle) {
            this.bundle = bundle;
        }
    }

    private static interface UserAccount
    extends GraphObject {
        public String getName();

        public String getUid();

        public void setName(String var1);
    }
}

