/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import com.facebook.LoggingBehavior;
import com.facebook.TokenCachingStrategy;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SharedPreferencesTokenCachingStrategy
extends TokenCachingStrategy {
    private static final String DEFAULT_CACHE_KEY = "com.facebook.SharedPreferencesTokenCachingStrategy.DEFAULT_KEY";
    private static final String JSON_VALUE = "value";
    private static final String JSON_VALUE_ENUM_TYPE = "enumType";
    private static final String JSON_VALUE_TYPE = "valueType";
    private static final String TAG = SharedPreferencesTokenCachingStrategy.class.getSimpleName();
    private static final String TYPE_BOOLEAN = "bool";
    private static final String TYPE_BOOLEAN_ARRAY = "bool[]";
    private static final String TYPE_BYTE = "byte";
    private static final String TYPE_BYTE_ARRAY = "byte[]";
    private static final String TYPE_CHAR = "char";
    private static final String TYPE_CHAR_ARRAY = "char[]";
    private static final String TYPE_DOUBLE = "double";
    private static final String TYPE_DOUBLE_ARRAY = "double[]";
    private static final String TYPE_ENUM = "enum";
    private static final String TYPE_FLOAT = "float";
    private static final String TYPE_FLOAT_ARRAY = "float[]";
    private static final String TYPE_INTEGER = "int";
    private static final String TYPE_INTEGER_ARRAY = "int[]";
    private static final String TYPE_LONG = "long";
    private static final String TYPE_LONG_ARRAY = "long[]";
    private static final String TYPE_SHORT = "short";
    private static final String TYPE_SHORT_ARRAY = "short[]";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_STRING_LIST = "stringList";
    private SharedPreferences cache;
    private String cacheKey;

    public SharedPreferencesTokenCachingStrategy(Context context) {
        this(context, null);
    }

    public SharedPreferencesTokenCachingStrategy(Context context, String string2) {
        Validate.notNull(context, "context");
        if (Utility.isNullOrEmpty(string2)) {
            string2 = DEFAULT_CACHE_KEY;
        }
        this.cacheKey = string2;
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            context = context2;
        }
        this.cache = context.getSharedPreferences(this.cacheKey, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deserializeKey(String string2, Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject(this.cache.getString(string2, "{}"));
        String string3 = jSONObject.getString(JSON_VALUE_TYPE);
        if (string3.equals(TYPE_BOOLEAN)) {
            bundle.putBoolean(string2, jSONObject.getBoolean(JSON_VALUE));
            return;
        } else {
            if (string3.equals(TYPE_BOOLEAN_ARRAY)) {
                JSONArray jSONArray = jSONObject.getJSONArray(JSON_VALUE);
                boolean[] blArray = new boolean[jSONArray.length()];
                int n2 = 0;
                while (true) {
                    if (n2 >= blArray.length) {
                        bundle.putBooleanArray(string2, blArray);
                        return;
                    }
                    blArray[n2] = jSONArray.getBoolean(n2);
                    ++n2;
                }
            }
            if (string3.equals(TYPE_BYTE)) {
                bundle.putByte(string2, (byte)jSONObject.getInt(JSON_VALUE));
                return;
            }
            if (string3.equals(TYPE_BYTE_ARRAY)) {
                JSONArray jSONArray = jSONObject.getJSONArray(JSON_VALUE);
                byte[] byArray = new byte[jSONArray.length()];
                int n3 = 0;
                while (true) {
                    if (n3 >= byArray.length) {
                        bundle.putByteArray(string2, byArray);
                        return;
                    }
                    byArray[n3] = (byte)jSONArray.getInt(n3);
                    ++n3;
                }
            }
            if (string3.equals(TYPE_SHORT)) {
                bundle.putShort(string2, (short)jSONObject.getInt(JSON_VALUE));
                return;
            }
            if (string3.equals(TYPE_SHORT_ARRAY)) {
                JSONArray jSONArray = jSONObject.getJSONArray(JSON_VALUE);
                short[] sArray = new short[jSONArray.length()];
                int n4 = 0;
                while (true) {
                    if (n4 >= sArray.length) {
                        bundle.putShortArray(string2, sArray);
                        return;
                    }
                    sArray[n4] = (short)jSONArray.getInt(n4);
                    ++n4;
                }
            }
            if (string3.equals(TYPE_INTEGER)) {
                bundle.putInt(string2, jSONObject.getInt(JSON_VALUE));
                return;
            }
            if (string3.equals(TYPE_INTEGER_ARRAY)) {
                JSONArray jSONArray = jSONObject.getJSONArray(JSON_VALUE);
                int[] nArray = new int[jSONArray.length()];
                int n5 = 0;
                while (true) {
                    if (n5 >= nArray.length) {
                        bundle.putIntArray(string2, nArray);
                        return;
                    }
                    nArray[n5] = jSONArray.getInt(n5);
                    ++n5;
                }
            }
            if (string3.equals(TYPE_LONG)) {
                bundle.putLong(string2, jSONObject.getLong(JSON_VALUE));
                return;
            }
            if (string3.equals(TYPE_LONG_ARRAY)) {
                JSONArray jSONArray = jSONObject.getJSONArray(JSON_VALUE);
                long[] lArray = new long[jSONArray.length()];
                int n6 = 0;
                while (true) {
                    if (n6 >= lArray.length) {
                        bundle.putLongArray(string2, lArray);
                        return;
                    }
                    lArray[n6] = jSONArray.getLong(n6);
                    ++n6;
                }
            }
            if (string3.equals(TYPE_FLOAT)) {
                bundle.putFloat(string2, (float)jSONObject.getDouble(JSON_VALUE));
                return;
            }
            if (string3.equals(TYPE_FLOAT_ARRAY)) {
                JSONArray jSONArray = jSONObject.getJSONArray(JSON_VALUE);
                float[] fArray = new float[jSONArray.length()];
                int n7 = 0;
                while (true) {
                    if (n7 >= fArray.length) {
                        bundle.putFloatArray(string2, fArray);
                        return;
                    }
                    fArray[n7] = (float)jSONArray.getDouble(n7);
                    ++n7;
                }
            }
            if (string3.equals(TYPE_DOUBLE)) {
                bundle.putDouble(string2, jSONObject.getDouble(JSON_VALUE));
                return;
            }
            if (string3.equals(TYPE_DOUBLE_ARRAY)) {
                JSONArray jSONArray = jSONObject.getJSONArray(JSON_VALUE);
                double[] dArray = new double[jSONArray.length()];
                int n8 = 0;
                while (true) {
                    if (n8 >= dArray.length) {
                        bundle.putDoubleArray(string2, dArray);
                        return;
                    }
                    dArray[n8] = jSONArray.getDouble(n8);
                    ++n8;
                }
            }
            if (string3.equals(TYPE_CHAR)) {
                String string4 = jSONObject.getString(JSON_VALUE);
                if (string4 == null || string4.length() != 1) return;
                bundle.putChar(string2, string4.charAt(0));
                return;
            } else {
                if (string3.equals(TYPE_CHAR_ARRAY)) {
                    JSONArray jSONArray = jSONObject.getJSONArray(JSON_VALUE);
                    char[] cArray = new char[jSONArray.length()];
                    int n9 = 0;
                    while (true) {
                        if (n9 >= cArray.length) {
                            bundle.putCharArray(string2, cArray);
                            return;
                        }
                        String string5 = jSONArray.getString(n9);
                        if (string5 != null && string5.length() == 1) {
                            cArray[n9] = string5.charAt(0);
                        }
                        ++n9;
                    }
                }
                if (string3.equals(TYPE_STRING)) {
                    bundle.putString(string2, jSONObject.getString(JSON_VALUE));
                    return;
                }
                if (string3.equals(TYPE_STRING_LIST)) {
                    JSONArray jSONArray = jSONObject.getJSONArray(JSON_VALUE);
                    int n10 = jSONArray.length();
                    ArrayList<String> arrayList = new ArrayList<String>(n10);
                    int n11 = 0;
                    while (true) {
                        if (n11 >= n10) {
                            bundle.putStringArrayList(string2, arrayList);
                            return;
                        }
                        Object object = jSONArray.get(n11);
                        String string6 = object == JSONObject.NULL ? null : (String)object;
                        arrayList.add(n11, string6);
                        ++n11;
                    }
                }
                if (!string3.equals(TYPE_ENUM)) return;
                try {
                    bundle.putSerializable(string2, Enum.valueOf(Class.forName(jSONObject.getString(JSON_VALUE_ENUM_TYPE)), jSONObject.getString(JSON_VALUE)));
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void serializeKey(String string2, Bundle bundle, SharedPreferences.Editor editor) throws JSONException {
        String string3;
        Object object = bundle.get(string2);
        if (object == null) return;
        JSONArray jSONArray = null;
        JSONObject jSONObject = new JSONObject();
        if (object instanceof Byte) {
            string3 = TYPE_BYTE;
            jSONObject.put(JSON_VALUE, ((Byte)object).intValue());
        } else if (object instanceof Short) {
            string3 = TYPE_SHORT;
            jSONObject.put(JSON_VALUE, ((Short)object).intValue());
            jSONArray = null;
        } else if (object instanceof Integer) {
            string3 = TYPE_INTEGER;
            jSONObject.put(JSON_VALUE, ((Integer)object).intValue());
            jSONArray = null;
        } else if (object instanceof Long) {
            string3 = TYPE_LONG;
            jSONObject.put(JSON_VALUE, ((Long)object).longValue());
            jSONArray = null;
        } else if (object instanceof Float) {
            string3 = TYPE_FLOAT;
            jSONObject.put(JSON_VALUE, ((Float)object).doubleValue());
            jSONArray = null;
        } else if (object instanceof Double) {
            string3 = TYPE_DOUBLE;
            jSONObject.put(JSON_VALUE, ((Double)object).doubleValue());
            jSONArray = null;
        } else if (object instanceof Boolean) {
            string3 = TYPE_BOOLEAN;
            jSONObject.put(JSON_VALUE, ((Boolean)object).booleanValue());
            jSONArray = null;
        } else if (object instanceof Character) {
            string3 = TYPE_CHAR;
            jSONObject.put(JSON_VALUE, (Object)object.toString());
            jSONArray = null;
        } else if (object instanceof String) {
            string3 = TYPE_STRING;
            jSONObject.put(JSON_VALUE, (Object)((String)object));
            jSONArray = null;
        } else if (object instanceof Enum) {
            string3 = TYPE_ENUM;
            jSONObject.put(JSON_VALUE, (Object)object.toString());
            jSONObject.put(JSON_VALUE_ENUM_TYPE, (Object)object.getClass().getName());
            jSONArray = null;
        } else {
            jSONArray = new JSONArray();
            if (object instanceof byte[]) {
                string3 = TYPE_BYTE_ARRAY;
                byte[] byArray = (byte[])object;
                int n2 = byArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    jSONArray.put((int)byArray[i2]);
                }
            } else if (object instanceof short[]) {
                string3 = TYPE_SHORT_ARRAY;
                short[] sArray = (short[])object;
                int n3 = sArray.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    jSONArray.put((int)sArray[i3]);
                }
            } else if (object instanceof int[]) {
                string3 = TYPE_INTEGER_ARRAY;
                int[] nArray = (int[])object;
                int n4 = nArray.length;
                for (int i4 = 0; i4 < n4; ++i4) {
                    jSONArray.put(nArray[i4]);
                }
            } else if (object instanceof long[]) {
                string3 = TYPE_LONG_ARRAY;
                long[] lArray = (long[])object;
                int n5 = lArray.length;
                for (int i5 = 0; i5 < n5; ++i5) {
                    jSONArray.put(lArray[i5]);
                }
            } else if (object instanceof float[]) {
                string3 = TYPE_FLOAT_ARRAY;
                float[] fArray = (float[])object;
                int n6 = fArray.length;
                for (int i6 = 0; i6 < n6; ++i6) {
                    jSONArray.put((double)fArray[i6]);
                }
            } else if (object instanceof double[]) {
                string3 = TYPE_DOUBLE_ARRAY;
                double[] dArray = (double[])object;
                int n7 = dArray.length;
                for (int i7 = 0; i7 < n7; ++i7) {
                    jSONArray.put(dArray[i7]);
                }
            } else if (object instanceof boolean[]) {
                string3 = TYPE_BOOLEAN_ARRAY;
                boolean[] blArray = (boolean[])object;
                int n8 = blArray.length;
                for (int i8 = 0; i8 < n8; ++i8) {
                    jSONArray.put(blArray[i8]);
                }
            } else if (object instanceof char[]) {
                string3 = TYPE_CHAR_ARRAY;
                char[] cArray = (char[])object;
                int n9 = cArray.length;
                for (int i9 = 0; i9 < n9; ++i9) {
                    jSONArray.put((Object)String.valueOf(cArray[i9]));
                }
            } else {
                if (!(object instanceof List)) return;
                string3 = TYPE_STRING_LIST;
                for (Object object2 : (List)object) {
                    if (object2 == null) {
                        object2 = JSONObject.NULL;
                    }
                    jSONArray.put(object2);
                }
            }
        }
        if (string3 == null) {
            return;
        }
        jSONObject.put(JSON_VALUE_TYPE, (Object)string3);
        if (jSONArray != null) {
            jSONObject.putOpt(JSON_VALUE, jSONArray);
        }
        editor.putString(string2, jSONObject.toString());
    }

    @Override
    public void clear() {
        this.cache.edit().clear().commit();
    }

    @Override
    public Bundle load() {
        Bundle bundle = new Bundle();
        for (String string2 : this.cache.getAll().keySet()) {
            try {
                this.deserializeKey(string2, bundle);
            }
            catch (JSONException jSONException) {
                Logger.log(LoggingBehavior.CACHE, 5, TAG, "Error reading cached value for key: '" + string2 + "' -- " + (Object)((Object)jSONException));
                bundle = null;
                break;
            }
        }
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public void save(Bundle bundle) {
        Validate.notNull(bundle, "bundle");
        SharedPreferences.Editor editor = this.cache.edit();
        Iterator iterator = bundle.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (editor.commit()) return;
                Logger.log(LoggingBehavior.CACHE, 5, TAG, "SharedPreferences.Editor.commit() was not successful");
                return;
            }
            String string2 = (String)iterator.next();
            try {
                this.serializeKey(string2, bundle, editor);
            }
            catch (JSONException jSONException) {
                Logger.log(LoggingBehavior.CACHE, 5, TAG, "Error processing value for key: '" + string2 + "' -- " + (Object)((Object)jSONException));
                return;
            }
        }
    }
}

