/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.LoggingBehavior;
import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Response;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public final class Settings {
    private static final String ANALYTICS_EVENT = "event";
    private static final String APP_EVENT_PREFERENCES = "com.facebook.sdk.appEventPreferences";
    private static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    private static final Uri ATTRIBUTION_ID_CONTENT_URI;
    private static final String ATTRIBUTION_PREFERENCES = "com.facebook.sdk.attributionTracking";
    private static final String AUTO_PUBLISH = "auto_publish";
    private static final int DEFAULT_CORE_POOL_SIZE = 5;
    private static final int DEFAULT_KEEP_ALIVE = 1;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = 128;
    private static final ThreadFactory DEFAULT_THREAD_FACTORY;
    private static final BlockingQueue<Runnable> DEFAULT_WORK_QUEUE;
    private static final String FACEBOOK_COM = "facebook.com";
    private static final Object LOCK;
    private static final String MOBILE_INSTALL_EVENT = "MOBILE_APP_INSTALL";
    private static final String PUBLISH_ACTIVITY_PATH = "%s/activities";
    private static final String TAG;
    private static volatile String appVersion;
    private static volatile Executor executor;
    private static volatile String facebookDomain;
    private static final HashSet<LoggingBehavior> loggingBehaviors;
    private static volatile boolean shouldAutoPublishInstall;

    static {
        TAG = Settings.class.getCanonicalName();
        LoggingBehavior[] loggingBehaviorArray = new LoggingBehavior[]{LoggingBehavior.DEVELOPER_ERRORS};
        loggingBehaviors = new HashSet<LoggingBehavior>(Arrays.asList(loggingBehaviorArray));
        facebookDomain = FACEBOOK_COM;
        LOCK = new Object();
        ATTRIBUTION_ID_CONTENT_URI = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
        DEFAULT_WORK_QUEUE = new LinkedBlockingQueue<Runnable>(10);
        DEFAULT_THREAD_FACTORY = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "FacebookSdk #" + this.counter.incrementAndGet());
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void addLoggingBehavior(LoggingBehavior loggingBehavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.add(loggingBehavior);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void clearLoggingBehaviors() {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.clear();
            return;
        }
    }

    public static String getAppVersion() {
        return appVersion;
    }

    private static Executor getAsyncTaskExecutor() {
        Object object;
        Field field;
        try {
            field = AsyncTask.class.getField("THREAD_POOL_EXECUTOR");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        try {
            object = field.get(null);
            if (object == null) {
                return null;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        if (!(object instanceof Executor)) {
            return null;
        }
        return (Executor)object;
    }

    public static String getAttributionId(ContentResolver contentResolver) {
        block4: {
            Cursor cursor;
            try {
                String[] stringArray = new String[]{ATTRIBUTION_ID_COLUMN_NAME};
                cursor = contentResolver.query(ATTRIBUTION_ID_CONTENT_URI, stringArray, null, null, null);
                if (cursor == null) break block4;
            }
            catch (Exception exception) {
                Log.d((String)TAG, (String)("Caught unexpected exception in getAttributionId(): " + exception.toString()));
                return null;
            }
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(cursor.getColumnIndex(ATTRIBUTION_ID_COLUMN_NAME));
                cursor.close();
                return string2;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Executor getExecutor() {
        Object object = LOCK;
        synchronized (object) {
            if (executor == null) {
                Executor executor = Settings.getAsyncTaskExecutor();
                if (executor == null) {
                    executor = new ThreadPoolExecutor(5, 128, 1L, TimeUnit.SECONDS, DEFAULT_WORK_QUEUE, DEFAULT_THREAD_FACTORY);
                }
                Settings.executor = executor;
            }
            return executor;
        }
    }

    public static String getFacebookDomain() {
        return facebookDomain;
    }

    public static boolean getLimitEventAndDataUsage(Context context) {
        return context.getSharedPreferences(APP_EVENT_PREFERENCES, 0).getBoolean("limitEventUsage", false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Set<LoggingBehavior> getLoggingBehaviors() {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            return Collections.unmodifiableSet(new HashSet<LoggingBehavior>(loggingBehaviors));
        }
    }

    public static String getMigrationBundle() {
        return "fbsdk:20131203";
    }

    public static String getSdkVersion() {
        return "3.6.0";
    }

    @Deprecated
    public static boolean getShouldAutoPublishInstall() {
        return shouldAutoPublishInstall;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static final boolean isLoggingBehaviorEnabled(LoggingBehavior loggingBehavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        // MONITORENTER : hashSet
        // MONITOREXIT : hashSet
        return false;
    }

    @Deprecated
    public static boolean publishInstallAndWait(Context context, String string2) {
        Response response = Settings.publishInstallAndWaitForResponse(context, string2);
        return response != null && response.getError() == null;
    }

    @Deprecated
    public static Response publishInstallAndWaitForResponse(Context context, String string2) {
        return Settings.publishInstallAndWaitForResponse(context, string2, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Response publishInstallAndWaitForResponse(Context var0, String var1_1, boolean var2_2) {
        block13: {
            if (var0 != null && var1_1 != null) ** GOTO lbl-1000
            try {
                throw new IllegalArgumentException("Both context and applicationId must be non-null");
            }
            catch (Exception var3_3) {
                Utility.logd("Facebook-publish", var3_3);
                var4_4 = new FacebookRequestError(null, var3_3);
                return new Response(null, null, var4_4);
            }
lbl-1000:
            // 1 sources

            {
                var5_5 = Settings.getAttributionId(var0.getContentResolver());
                var6_6 = var0.getSharedPreferences("com.facebook.sdk.attributionTracking", 0);
                var7_7 = var1_1 + "ping";
                var8_8 = var1_1 + "json";
                var9_9 = var6_6.getLong(var7_7, 0L);
                var11_10 = var6_6.getString(var8_8, null);
                if (!var2_2) {
                    Settings.setShouldAutoPublishInstall(false);
                }
                var12_11 = GraphObject.Factory.create();
                var12_11.setProperty("event", "MOBILE_APP_INSTALL");
                var13_12 = Utility.getHashedDeviceAndAppID(var0, var1_1);
                if (Settings.getLimitEventAndDataUsage(var0)) break block13;
                var14_13 = true;
lbl21:
                // 2 sources

                while (true) {
                    Utility.setAppEventAttributionParameters(var12_11, var5_5, var13_12, var14_13);
                    var12_11.setProperty("auto_publish", var2_2);
                    var12_11.setProperty("application_package_name", var0.getPackageName());
                    var15_14 = Request.newPostRequest(null, String.format("%s/activities", new Object[]{var1_1}), var12_11, null);
                    if (var9_9 != 0L) {
                        var16_15 = null;
                        if (var11_10 != null) {
                            var18_16 = new JSONObject(var11_10);
                            var16_15 = var20_17 = GraphObject.Factory.create(var18_16);
                        }
lbl32:
                        // 4 sources

                        while (true) {
                            if (var16_15 != null) return new Response(null, null, var16_15, true);
                            return Response.createResponsesFromString("true", null, new RequestBatch(new Request[]{var15_14}), true).get(0);
                        }
                        catch (JSONException var19_21) {
                            var16_15 = null;
                            ** continue;
                        }
                    }
                    if (var5_5 == null) {
                        throw new FacebookException("No attribution id returned from the Facebook application");
                    }
                    if (!Utility.queryAppSettings(var1_1, false).supportsAttribution()) {
                        throw new FacebookException("Install attribution has been disabled on the server.");
                    }
                    var21_19 = var15_14.executeAndWait();
                    var22_20 = var6_6.edit();
                    var22_20.putLong(var7_7, System.currentTimeMillis());
                    if (var21_19.getGraphObject() != null && var21_19.getGraphObject().getInnerJSONObject() != null) {
                        var22_20.putString(var8_8, var21_19.getGraphObject().getInnerJSONObject().toString());
                    }
                    var22_20.commit();
                    return var21_19;
                }
            }
        }
        var14_13 = false;
        ** while (true)
    }

    @Deprecated
    public static void publishInstallAsync(Context context, String string2) {
        Settings.publishInstallAsync(context, string2, null);
    }

    @Deprecated
    public static void publishInstallAsync(Context context, final String string2, final Request.Callback callback) {
        final Context context2 = context.getApplicationContext();
        Settings.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final Response response = Settings.publishInstallAndWaitForResponse(context2, string2);
                if (callback != null) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onCompleted(response);
                        }
                    });
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void removeLoggingBehavior(LoggingBehavior loggingBehavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.remove((Object)loggingBehavior);
            return;
        }
    }

    public static void setAppVersion(String string2) {
        appVersion = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setExecutor(Executor executor) {
        Validate.notNull(executor, "executor");
        Object object = LOCK;
        synchronized (object) {
            Settings.executor = executor;
            return;
        }
    }

    public static void setFacebookDomain(String string2) {
        Log.w((String)TAG, (String)"WARNING: Calling setFacebookDomain from non-DEBUG code.");
        facebookDomain = string2;
    }

    public static void setLimitEventAndDataUsage(Context context, boolean bl2) {
        SharedPreferences.Editor editor = context.getSharedPreferences(APP_EVENT_PREFERENCES, 0).edit();
        editor.putBoolean("limitEventUsage", bl2);
        editor.commit();
    }

    @Deprecated
    public static void setShouldAutoPublishInstall(boolean bl2) {
        shouldAutoPublishInstall = bl2;
    }
}

