/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.AppEventsLogger;
import com.facebook.AuthorizationClient;
import com.facebook.FacebookAuthorizationException;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.LoginActivity;
import com.facebook.SessionDefaultAudience;
import com.facebook.SessionLoginBehavior;
import com.facebook.SessionState;
import com.facebook.Settings;
import com.facebook.SharedPreferencesTokenCachingStrategy;
import com.facebook.TokenCachingStrategy;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.SessionAuthorizationType;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class Session
implements Serializable {
    public static final String ACTION_ACTIVE_SESSION_CLOSED = "com.facebook.sdk.ACTIVE_SESSION_CLOSED";
    public static final String ACTION_ACTIVE_SESSION_OPENED = "com.facebook.sdk.ACTIVE_SESSION_OPENED";
    public static final String ACTION_ACTIVE_SESSION_SET = "com.facebook.sdk.ACTIVE_SESSION_SET";
    public static final String ACTION_ACTIVE_SESSION_UNSET = "com.facebook.sdk.ACTIVE_SESSION_UNSET";
    public static final String APPLICATION_ID_PROPERTY = "com.facebook.sdk.ApplicationId";
    private static final String AUTH_BUNDLE_SAVE_KEY = "com.facebook.sdk.Session.authBundleKey";
    public static final int DEFAULT_AUTHORIZE_ACTIVITY_CODE = 64206;
    private static final String MANAGE_PERMISSION_PREFIX = "manage";
    private static final Set<String> OTHER_PUBLISH_PERMISSIONS;
    private static final String PUBLISH_PERMISSION_PREFIX = "publish";
    private static final String SESSION_BUNDLE_SAVE_KEY = "com.facebook.sdk.Session.saveSessionKey";
    private static final Object STATIC_LOCK;
    public static final String TAG;
    private static final int TOKEN_EXTEND_RETRY_SECONDS = 3600;
    private static final int TOKEN_EXTEND_THRESHOLD_SECONDS = 86400;
    public static final String WEB_VIEW_ERROR_CODE_KEY = "com.facebook.sdk.WebViewErrorCode";
    public static final String WEB_VIEW_FAILING_URL_KEY = "com.facebook.sdk.FailingUrl";
    private static Session activeSession;
    private static final long serialVersionUID = 1L;
    private static volatile Context staticContext;
    private AppEventsLogger appEventsLogger;
    private String applicationId;
    private volatile Bundle authorizationBundle;
    private AuthorizationClient authorizationClient;
    private AutoPublishAsyncTask autoPublishAsyncTask;
    private final List<StatusCallback> callbacks;
    private volatile TokenRefreshRequest currentTokenRefreshRequest;
    private Handler handler;
    private Date lastAttemptedTokenExtendDate = new Date(0L);
    private final Object lock = new Object();
    private AuthorizationRequest pendingAuthorizationRequest;
    private SessionState state;
    private TokenCachingStrategy tokenCachingStrategy;
    private AccessToken tokenInfo;

    static {
        TAG = Session.class.getCanonicalName();
        STATIC_LOCK = new Object();
        OTHER_PUBLISH_PERMISSIONS = new HashSet<String>(){
            {
                this.add("ads_management");
                this.add("create_event");
                this.add("rsvp_event");
            }
        };
    }

    public Session(Context context) {
        this(context, null, null, true);
    }

    Session(Context context, String string2, TokenCachingStrategy tokenCachingStrategy) {
        this(context, string2, tokenCachingStrategy, true);
    }

    Session(Context context, String string2, TokenCachingStrategy tokenCachingStrategy, boolean bl2) {
        if (context != null && string2 == null) {
            string2 = Utility.getMetadataApplicationId(context);
        }
        Validate.notNull(string2, "applicationId");
        Session.initializeStaticContext(context);
        if (tokenCachingStrategy == null) {
            tokenCachingStrategy = new SharedPreferencesTokenCachingStrategy(staticContext);
        }
        this.applicationId = string2;
        this.tokenCachingStrategy = tokenCachingStrategy;
        this.state = SessionState.CREATED;
        this.pendingAuthorizationRequest = null;
        this.callbacks = new ArrayList<StatusCallback>();
        this.handler = new Handler(Looper.getMainLooper());
        Bundle bundle = null;
        if (bl2) {
            bundle = tokenCachingStrategy.load();
        }
        if (TokenCachingStrategy.hasTokenInformation(bundle)) {
            Date date = TokenCachingStrategy.getDate(bundle, "com.facebook.TokenCachingStrategy.ExpirationDate");
            Date date2 = new Date();
            if (date == null || date.before(date2)) {
                tokenCachingStrategy.clear();
                this.tokenInfo = AccessToken.createEmptyToken(Collections.<String>emptyList());
                return;
            }
            this.tokenInfo = AccessToken.createFromCache(bundle);
            this.state = SessionState.CREATED_TOKEN_LOADED;
            return;
        }
        this.tokenInfo = AccessToken.createEmptyToken(Collections.<String>emptyList());
    }

    private Session(String string2, SessionState sessionState, AccessToken accessToken, Date date, boolean bl2, AuthorizationRequest authorizationRequest) {
        this.applicationId = string2;
        this.state = sessionState;
        this.tokenInfo = accessToken;
        this.lastAttemptedTokenExtendDate = date;
        this.pendingAuthorizationRequest = authorizationRequest;
        this.handler = new Handler(Looper.getMainLooper());
        this.currentTokenRefreshRequest = null;
        this.tokenCachingStrategy = null;
        this.callbacks = new ArrayList<StatusCallback>();
    }

    static /* synthetic */ TokenRefreshRequest access$1202(Session session, TokenRefreshRequest tokenRefreshRequest) {
        session.currentTokenRefreshRequest = tokenRefreshRequest;
        return tokenRefreshRequest;
    }

    static /* synthetic */ AutoPublishAsyncTask access$1402(Session session, AutoPublishAsyncTask autoPublishAsyncTask) {
        session.autoPublishAsyncTask = autoPublishAsyncTask;
        return autoPublishAsyncTask;
    }

    private static boolean areEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void autoPublishAsync() {
        // MONITORENTER : this
        AutoPublishAsyncTask autoPublishAsyncTask = this.autoPublishAsyncTask;
        AutoPublishAsyncTask autoPublishAsyncTask2 = null;
        if (autoPublishAsyncTask == null) {
            boolean bl2 = Settings.getShouldAutoPublishInstall();
            autoPublishAsyncTask2 = null;
            if (bl2) {
                String string2 = this.applicationId;
                autoPublishAsyncTask2 = null;
                if (string2 != null) {
                    AutoPublishAsyncTask autoPublishAsyncTask3;
                    this.autoPublishAsyncTask = autoPublishAsyncTask3 = new AutoPublishAsyncTask(string2, staticContext);
                    autoPublishAsyncTask2 = autoPublishAsyncTask3;
                }
            }
        }
        // MONITOREXIT : this
        if (autoPublishAsyncTask2 == null) return;
        autoPublishAsyncTask2.execute(new Void[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void finishAuthorization(AccessToken accessToken, Exception exception) {
        SessionState sessionState = this.state;
        if (accessToken != null) {
            this.tokenInfo = accessToken;
            this.saveTokenToCache(accessToken);
            this.state = SessionState.OPENED;
        } else if (exception != null) {
            this.state = SessionState.CLOSED_LOGIN_FAILED;
        }
        this.pendingAuthorizationRequest = null;
        this.postStateChange(sessionState, this.state, exception);
    }

    private void finishReauthorization(AccessToken accessToken, Exception exception) {
        SessionState sessionState = this.state;
        if (accessToken != null) {
            this.tokenInfo = accessToken;
            this.saveTokenToCache(accessToken);
            this.state = SessionState.OPENED_TOKEN_UPDATED;
        }
        this.pendingAuthorizationRequest = null;
        this.postStateChange(sessionState, this.state, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Session getActiveSession() {
        Object object = STATIC_LOCK;
        synchronized (object) {
            return activeSession;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AppEventsLogger getAppEventsLogger() {
        Object object = this.lock;
        synchronized (object) {
            if (this.appEventsLogger != null) return this.appEventsLogger;
            this.appEventsLogger = AppEventsLogger.newLogger(staticContext, this.applicationId);
            return this.appEventsLogger;
        }
    }

    private Intent getLoginActivityIntent(AuthorizationRequest authorizationRequest) {
        Intent intent = new Intent();
        intent.setClass(Session.getStaticContext(), LoginActivity.class);
        intent.setAction(authorizationRequest.getLoginBehavior().toString());
        intent.putExtras(LoginActivity.populateIntentExtras(authorizationRequest.getAuthorizationClientRequest()));
        return intent;
    }

    static Context getStaticContext() {
        return staticContext;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void handleAuthorizationResult(int n2, AuthorizationClient.Result result) {
        void var3_4;
        AccessToken accessToken;
        Object var3_3 = null;
        if (n2 == -1) {
            if (result.code == AuthorizationClient.Result.Code.SUCCESS) {
                accessToken = result.token;
            } else {
                FacebookAuthorizationException facebookAuthorizationException = new FacebookAuthorizationException(result.errorMessage);
                accessToken = null;
            }
        } else {
            Object var3_6 = null;
            accessToken = null;
            if (n2 == 0) {
                FacebookOperationCanceledException facebookOperationCanceledException = new FacebookOperationCanceledException(result.errorMessage);
                accessToken = null;
            }
        }
        this.logAuthorizationComplete(result.code, result.loggingExtras, (Exception)var3_4);
        this.authorizationClient = null;
        this.finishAuthOrReauth(accessToken, (Exception)var3_4);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void initializeStaticContext(Context context) {
        if (context != null && staticContext == null) {
            Context context2 = context.getApplicationContext();
            if (context2 == null) {
                context2 = context;
            }
            staticContext = context2;
        }
    }

    public static boolean isPublishPermission(String string2) {
        return string2 != null && (string2.startsWith(PUBLISH_PERMISSION_PREFIX) || string2.startsWith(MANAGE_PERMISSION_PREFIX) || OTHER_PUBLISH_PERMISSIONS.contains(string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logAuthorizationComplete(AuthorizationClient.Result.Code code, Map<String, String> map, Exception exception) {
        Bundle bundle;
        if (this.pendingAuthorizationRequest == null) {
            bundle = AuthorizationClient.newAuthorizationLoggingBundle("");
            bundle.putString("2_result", AuthorizationClient.Result.Code.ERROR.getLoggingValue());
            bundle.putString("5_error_message", "Unexpected call to logAuthorizationComplete with null pendingAuthorizationRequest.");
        } else {
            bundle = AuthorizationClient.newAuthorizationLoggingBundle(this.pendingAuthorizationRequest.getAuthId());
            if (code != null) {
                bundle.putString("2_result", code.getLoggingValue());
            }
            if (exception != null && exception.getMessage() != null) {
                bundle.putString("5_error_message", exception.getMessage());
            }
            boolean bl2 = this.pendingAuthorizationRequest.loggingExtras.isEmpty();
            JSONObject jSONObject = null;
            if (!bl2) {
                jSONObject = new JSONObject(this.pendingAuthorizationRequest.loggingExtras);
            }
            if (map != null) {
                if (jSONObject == null) {
                    jSONObject = new JSONObject();
                }
                try {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        jSONObject.put(entry.getKey(), (Object)entry.getValue());
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            if (jSONObject != null) {
                bundle.putString("6_extras", jSONObject.toString());
            }
        }
        bundle.putLong("1_timestamp_ms", System.currentTimeMillis());
        this.getAppEventsLogger().logSdkEvent("fb_mobile_login_complete", null, bundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logAuthorizationStart() {
        Bundle bundle = AuthorizationClient.newAuthorizationLoggingBundle(this.pendingAuthorizationRequest.getAuthId());
        bundle.putLong("1_timestamp_ms", System.currentTimeMillis());
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("login_behavior", (Object)this.pendingAuthorizationRequest.loginBehavior.toString());
            jSONObject.put("request_code", this.pendingAuthorizationRequest.requestCode);
            jSONObject.put("is_legacy", this.pendingAuthorizationRequest.isLegacy);
            jSONObject.put("permissions", (Object)TextUtils.join((CharSequence)",", (Iterable)this.pendingAuthorizationRequest.permissions));
            jSONObject.put("default_audience", (Object)this.pendingAuthorizationRequest.defaultAudience.toString());
            bundle.putString("6_extras", jSONObject.toString());
        }
        catch (JSONException jSONException) {}
        this.getAppEventsLogger().logSdkEvent("fb_mobile_login_start", null, bundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void open(OpenRequest openRequest, SessionAuthorizationType sessionAuthorizationType) {
        SessionState sessionState;
        this.validatePermissions(openRequest, sessionAuthorizationType);
        this.validateLoginBehavior(openRequest);
        Object object = this.lock;
        // MONITORENTER : object
        if (this.pendingAuthorizationRequest != null) {
            this.postStateChange(this.state, this.state, new UnsupportedOperationException("Session: an attempt was made to open a session that has a pending request."));
            // MONITOREXIT : object
            return;
        }
        SessionState sessionState2 = this.state;
        switch (this.state) {
            default: {
                throw new UnsupportedOperationException("Session: an attempt was made to open an already opened session.");
            }
            case CREATED: {
                this.state = sessionState = SessionState.OPENING;
                if (openRequest == null) {
                    throw new IllegalArgumentException("openRequest cannot be null when opening a new Session");
                }
                this.pendingAuthorizationRequest = openRequest;
                break;
            }
            case CREATED_TOKEN_LOADED: {
                if (openRequest != null && !Utility.isNullOrEmpty(openRequest.getPermissions()) && !Utility.isSubset(openRequest.getPermissions(), this.getPermissions())) {
                    this.pendingAuthorizationRequest = openRequest;
                }
                this.state = this.pendingAuthorizationRequest == null ? (sessionState = SessionState.OPENED) : (sessionState = SessionState.OPENING);
            }
        }
        if (openRequest != null) {
            this.addCallback(openRequest.getCallback());
        }
        this.postStateChange(sessionState2, sessionState, null);
        // MONITOREXIT : object
        if (sessionState != SessionState.OPENING) return;
        this.authorize(openRequest);
    }

    public static Session openActiveSession(Activity activity, boolean bl2, StatusCallback statusCallback) {
        return Session.openActiveSession((Context)activity, bl2, (OpenRequest)new OpenRequest(activity).setCallback(statusCallback));
    }

    public static Session openActiveSession(Context context, Fragment fragment, boolean bl2, StatusCallback statusCallback) {
        return Session.openActiveSession(context, bl2, (OpenRequest)new OpenRequest(fragment).setCallback(statusCallback));
    }

    private static Session openActiveSession(Context context, boolean bl2, OpenRequest openRequest) {
        Session session = new Builder(context).build();
        if (SessionState.CREATED_TOKEN_LOADED.equals((Object)session.getState()) || bl2) {
            Session.setActiveSession(session);
            session.openForRead(openRequest);
            return session;
        }
        return null;
    }

    public static Session openActiveSessionFromCache(Context context) {
        return Session.openActiveSession(context, false, null);
    }

    public static Session openActiveSessionWithAccessToken(Context context, AccessToken accessToken, StatusCallback statusCallback) {
        Session session = new Session(context, null, null, false);
        Session.setActiveSession(session);
        session.open(accessToken, statusCallback);
        return session;
    }

    static void postActiveSessionAction(String string2) {
        Intent intent = new Intent(string2);
        LocalBroadcastManager.getInstance(Session.getStaticContext()).sendBroadcast(intent);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Cannot readObject, serialization proxy required");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void requestNewPermissions(NewPermissionsRequest newPermissionsRequest, SessionAuthorizationType sessionAuthorizationType) {
        this.validatePermissions(newPermissionsRequest, sessionAuthorizationType);
        this.validateLoginBehavior(newPermissionsRequest);
        if (newPermissionsRequest == null) return;
        Object object = this.lock;
        // MONITORENTER : object
        if (this.pendingAuthorizationRequest != null) {
            throw new UnsupportedOperationException("Session: an attempt was made to request new permissions for a session that has a pending request.");
        }
        if (this.state.isOpened()) {
            this.pendingAuthorizationRequest = newPermissionsRequest;
            // MONITOREXIT : object
            newPermissionsRequest.setValidateSameFbidAsToken(this.getAccessToken());
            this.addCallback(newPermissionsRequest.getCallback());
            this.authorize(newPermissionsRequest);
            return;
        }
        if (!this.state.isClosed()) throw new UnsupportedOperationException("Session: an attempt was made to request new permissions for a session that is not currently open.");
        throw new UnsupportedOperationException("Session: an attempt was made to request new permissions for a session that has been closed.");
    }

    private boolean resolveIntent(Intent intent) {
        return Session.getStaticContext().getPackageManager().resolveActivity(intent, 0) != null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Session restoreSession(Context context, TokenCachingStrategy tokenCachingStrategy, StatusCallback statusCallback, Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        byte[] byArray = bundle.getByteArray(SESSION_BUNDLE_SAVE_KEY);
        if (byArray == null) return null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            Session session = (Session)new ObjectInputStream(byteArrayInputStream).readObject();
            Session.initializeStaticContext(context);
            session.tokenCachingStrategy = tokenCachingStrategy != null ? tokenCachingStrategy : new SharedPreferencesTokenCachingStrategy(context);
            if (statusCallback != null) {
                session.addCallback(statusCallback);
            }
            session.authorizationBundle = bundle.getBundle(AUTH_BUNDLE_SAVE_KEY);
            return session;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)TAG, (String)"Unable to restore session", (Throwable)classNotFoundException);
        }
        return null;
        catch (IOException iOException) {
            Log.w((String)TAG, (String)"Unable to restore session.", (Throwable)iOException);
            return null;
        }
    }

    private static void runWithHandlerOrExecutor(Handler handler, Runnable runnable) {
        if (handler != null) {
            handler.post(runnable);
            return;
        }
        Settings.getExecutor().execute(runnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void saveSession(Session session, Bundle bundle) {
        if (bundle == null || session == null || bundle.containsKey(SESSION_BUNDLE_SAVE_KEY)) return;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(byteArrayOutputStream).writeObject(session);
        }
        catch (IOException iOException) {
            throw new FacebookException("Unable to save session.", iOException);
        }
        bundle.putByteArray(SESSION_BUNDLE_SAVE_KEY, byteArrayOutputStream.toByteArray());
        bundle.putBundle(AUTH_BUNDLE_SAVE_KEY, session.authorizationBundle);
    }

    private void saveTokenToCache(AccessToken accessToken) {
        if (accessToken != null && this.tokenCachingStrategy != null) {
            this.tokenCachingStrategy.save(accessToken.toCacheBundle());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void setActiveSession(Session session) {
        Object object = STATIC_LOCK;
        synchronized (object) {
            if (session != activeSession) {
                Session session2 = activeSession;
                if (session2 != null) {
                    session2.close();
                }
                activeSession = session;
                if (session2 != null) {
                    Session.postActiveSessionAction(ACTION_ACTIVE_SESSION_UNSET);
                }
                if (session != null) {
                    Session.postActiveSessionAction(ACTION_ACTIVE_SESSION_SET);
                    if (session.isOpened()) {
                        Session.postActiveSessionAction(ACTION_ACTIVE_SESSION_OPENED);
                    }
                }
            }
            return;
        }
    }

    private void tryLegacyAuth(AuthorizationRequest authorizationRequest) {
        this.authorizationClient = new AuthorizationClient();
        this.authorizationClient.setOnCompletedListener(new AuthorizationClient.OnCompletedListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onCompleted(AuthorizationClient.Result result) {
                int n2 = result.code == AuthorizationClient.Result.Code.CANCEL ? 0 : -1;
                Session.this.handleAuthorizationResult(n2, result);
            }
        });
        this.authorizationClient.setContext(Session.getStaticContext());
        this.authorizationClient.startOrContinueAuth(authorizationRequest.getAuthorizationClientRequest());
    }

    private boolean tryLoginActivity(AuthorizationRequest authorizationRequest) {
        Intent intent = this.getLoginActivityIntent(authorizationRequest);
        if (!this.resolveIntent(intent)) {
            return false;
        }
        try {
            authorizationRequest.getStartActivityDelegate().startActivityForResult(intent, authorizationRequest.getRequestCode());
            return true;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            return false;
        }
    }

    private void validateLoginBehavior(AuthorizationRequest authorizationRequest) {
        if (authorizationRequest != null && !authorizationRequest.isLegacy) {
            Intent intent = new Intent();
            intent.setClass(Session.getStaticContext(), LoginActivity.class);
            if (!this.resolveIntent(intent)) {
                Object[] objectArray = new Object[]{authorizationRequest.getLoginBehavior(), LoginActivity.class.getName()};
                throw new FacebookException(String.format("Cannot use SessionLoginBehavior %s when %s is not declared as an activity in AndroidManifest.xml", objectArray));
            }
        }
    }

    private void validatePermissions(AuthorizationRequest authorizationRequest, SessionAuthorizationType sessionAuthorizationType) {
        if (authorizationRequest == null || Utility.isNullOrEmpty(authorizationRequest.getPermissions())) {
            if (SessionAuthorizationType.PUBLISH.equals((Object)sessionAuthorizationType)) {
                throw new FacebookException("Cannot request publish or manage authorization with no permissions.");
            }
        } else {
            for (String string2 : authorizationRequest.getPermissions()) {
                if (Session.isPublishPermission(string2)) {
                    if (!SessionAuthorizationType.READ.equals((Object)sessionAuthorizationType)) continue;
                    throw new FacebookException(String.format("Cannot pass a publish or manage permission (%s) to a request for read authorization", string2));
                }
                if (!SessionAuthorizationType.PUBLISH.equals((Object)sessionAuthorizationType)) continue;
                Log.w((String)TAG, (String)String.format("Should not pass a read permission (%s) to a request for publish or manage authorization", string2));
            }
        }
    }

    private Object writeReplace() {
        return new SerializationProxyV1(this.applicationId, this.state, this.tokenInfo, this.lastAttemptedTokenExtendDate, false, this.pendingAuthorizationRequest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void addCallback(StatusCallback statusCallback) {
        List<StatusCallback> list = this.callbacks;
        synchronized (list) {
            if (statusCallback != null && !this.callbacks.contains(statusCallback)) {
                this.callbacks.add(statusCallback);
            }
            return;
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void authorize(AuthorizationRequest authorizationRequest) {
        authorizationRequest.setApplicationId(this.applicationId);
        this.autoPublishAsync();
        this.logAuthorizationStart();
        boolean bl2 = this.tryLoginActivity(authorizationRequest);
        Map map = this.pendingAuthorizationRequest.loggingExtras;
        String string2 = bl2 ? "1" : "0";
        map.put("try_login_activity", string2);
        if (!bl2 && authorizationRequest.isLegacy) {
            this.pendingAuthorizationRequest.loggingExtras.put("try_legacy", "1");
            this.tryLegacyAuth(authorizationRequest);
            return;
        }
        if (bl2) return;
        Object object = this.lock;
        synchronized (object) {
            SessionState sessionState = this.state;
            switch (4.$SwitchMap$com$facebook$SessionState[this.state.ordinal()]) {
                default: {
                    this.state = SessionState.CLOSED_LOGIN_FAILED;
                    FacebookException facebookException = new FacebookException("Log in attempt failed: LoginActivity could not be started, and not legacy request");
                    this.logAuthorizationComplete(AuthorizationClient.Result.Code.ERROR, null, facebookException);
                    this.postStateChange(sessionState, this.state, facebookException);
                    return;
                }
                case 6: 
                case 7: 
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void close() {
        Object object = this.lock;
        synchronized (object) {
            SessionState sessionState = this.state;
            switch (this.state) {
                case CREATED: 
                case OPENING: {
                    this.state = SessionState.CLOSED_LOGIN_FAILED;
                    this.postStateChange(sessionState, this.state, new FacebookException("Log in attempt aborted."));
                }
                default: {
                    break;
                }
                case CREATED_TOKEN_LOADED: 
                case OPENED: 
                case OPENED_TOKEN_UPDATED: {
                    this.state = SessionState.CLOSED;
                    this.postStateChange(sessionState, this.state, null);
                }
            }
            return;
        }
    }

    public final void closeAndClearTokenInformation() {
        if (this.tokenCachingStrategy != null) {
            this.tokenCachingStrategy.clear();
        }
        Utility.clearFacebookCookies(staticContext);
        Utility.clearCaches(staticContext);
        this.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof Session)) break block2;
                Session session = (Session)object;
                if (Session.areEqual(session.applicationId, this.applicationId) && Session.areEqual(session.authorizationBundle, this.authorizationBundle) && Session.areEqual((Object)session.state, (Object)this.state) && Session.areEqual(session.getExpirationDate(), this.getExpirationDate())) break block3;
            }
            return false;
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void extendAccessToken() {
        Object object = this.lock;
        // MONITORENTER : object
        TokenRefreshRequest tokenRefreshRequest = this.currentTokenRefreshRequest;
        TokenRefreshRequest tokenRefreshRequest2 = null;
        if (tokenRefreshRequest == null) {
            TokenRefreshRequest tokenRefreshRequest3 = new TokenRefreshRequest();
            this.currentTokenRefreshRequest = tokenRefreshRequest3;
            tokenRefreshRequest2 = tokenRefreshRequest3;
        }
        // MONITOREXIT : object
        if (tokenRefreshRequest2 == null) return;
        tokenRefreshRequest2.bind();
        return;
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    void extendAccessTokenIfNeeded() {
        if (this.shouldExtendAccessToken()) {
            this.extendAccessToken();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void extendTokenCompleted(Bundle bundle) {
        Object object = this.lock;
        synchronized (object) {
            SessionState sessionState = this.state;
            switch (this.state) {
                default: {
                    Log.d((String)TAG, (String)("refreshToken ignored in state " + (Object)((Object)this.state)));
                    return;
                }
                case OPENED: {
                    this.state = SessionState.OPENED_TOKEN_UPDATED;
                    this.postStateChange(sessionState, this.state, null);
                    break;
                }
                case OPENED_TOKEN_UPDATED: 
            }
            this.tokenInfo = AccessToken.createFromRefresh(this.tokenInfo, bundle);
            if (this.tokenCachingStrategy != null) {
                this.tokenCachingStrategy.save(this.tokenInfo.toCacheBundle());
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void finishAuthOrReauth(AccessToken accessToken, Exception exception) {
        if (accessToken != null && accessToken.isInvalid()) {
            accessToken = null;
            exception = new FacebookException("Invalid access token.");
        }
        Object object = this.lock;
        synchronized (object) {
            switch (4.$SwitchMap$com$facebook$SessionState[this.state.ordinal()]) {
                case 2: {
                    this.finishAuthorization(accessToken, exception);
                    break;
                }
                case 4: 
                case 5: {
                    this.finishReauthorization(accessToken, exception);
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: {
                    Log.d((String)TAG, (String)("Unexpected call to finishAuthOrReauth in state " + (Object)((Object)this.state)));
                    break;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getAccessToken() {
        Object object = this.lock;
        synchronized (object) {
            if (this.tokenInfo != null) return this.tokenInfo.getToken();
            return null;
        }
    }

    public final String getApplicationId() {
        return this.applicationId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Bundle getAuthorizationBundle() {
        Object object = this.lock;
        synchronized (object) {
            return this.authorizationBundle;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Date getExpirationDate() {
        Object object = this.lock;
        synchronized (object) {
            if (this.tokenInfo != null) return this.tokenInfo.getExpires();
            return null;
        }
    }

    Date getLastAttemptedTokenExtendDate() {
        return this.lastAttemptedTokenExtendDate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final List<String> getPermissions() {
        Object object = this.lock;
        synchronized (object) {
            if (this.tokenInfo != null) return this.tokenInfo.getPermissions();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SessionState getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    AccessToken getTokenInfo() {
        return this.tokenInfo;
    }

    public int hashCode() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.state.isClosed();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isOpened() {
        Object object = this.lock;
        synchronized (object) {
            return this.state.isOpened();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean onActivityResult(Activity activity, int n2, int n3, Intent intent) {
        FacebookException facebookException;
        Validate.notNull(activity, "currentActivity");
        Session.initializeStaticContext((Context)activity);
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingAuthorizationRequest == null || n2 != this.pendingAuthorizationRequest.getRequestCode()) {
                return false;
            }
        }
        AuthorizationClient.Result.Code code = AuthorizationClient.Result.Code.ERROR;
        if (intent != null) {
            AuthorizationClient.Result result = (AuthorizationClient.Result)intent.getSerializableExtra("com.facebook.LoginActivity:Result");
            if (result != null) {
                this.handleAuthorizationResult(n3, result);
                return true;
            }
            AuthorizationClient authorizationClient = this.authorizationClient;
            facebookException = null;
            if (authorizationClient != null) {
                this.authorizationClient.onActivityResult(n2, n3, intent);
                return true;
            }
        } else {
            facebookException = null;
            if (n3 == 0) {
                facebookException = new FacebookOperationCanceledException("User canceled operation.");
                code = AuthorizationClient.Result.Code.CANCEL;
            }
        }
        if (facebookException == null) {
            facebookException = new FacebookException("Unexpected call to Session.onActivityResult");
        }
        this.logAuthorizationComplete(code, null, facebookException);
        this.finishAuthOrReauth(null, facebookException);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void open(AccessToken accessToken, StatusCallback statusCallback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingAuthorizationRequest != null) {
                throw new UnsupportedOperationException("Session: an attempt was made to open a session that has a pending request.");
            }
            if (this.state.isClosed()) {
                throw new UnsupportedOperationException("Session: an attempt was made to open a previously-closed session.");
            }
            if (this.state != SessionState.CREATED && this.state != SessionState.CREATED_TOKEN_LOADED) {
                throw new UnsupportedOperationException("Session: an attempt was made to open an already opened session.");
            }
            if (statusCallback != null) {
                this.addCallback(statusCallback);
            }
            this.tokenInfo = accessToken;
            if (this.tokenCachingStrategy != null) {
                this.tokenCachingStrategy.save(accessToken.toCacheBundle());
            }
            SessionState sessionState = this.state;
            this.state = SessionState.OPENED;
            this.postStateChange(sessionState, this.state, null);
        }
        this.autoPublishAsync();
    }

    public final void openForPublish(OpenRequest openRequest) {
        this.open(openRequest, SessionAuthorizationType.PUBLISH);
    }

    public final void openForRead(OpenRequest openRequest) {
        this.open(openRequest, SessionAuthorizationType.READ);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void postStateChange(SessionState sessionState, final SessionState sessionState2, final Exception exception) {
        block9: {
            block8: {
                if (sessionState == sessionState2 && sessionState != SessionState.OPENED_TOKEN_UPDATED && exception == null) break block8;
                if (sessionState2.isClosed()) {
                    this.tokenInfo = AccessToken.createEmptyToken(Collections.<String>emptyList());
                }
                List<StatusCallback> list = this.callbacks;
                synchronized (list) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Iterator iterator = Session.this.callbacks.iterator();
                            while (iterator.hasNext()) {
                                Runnable runnable = new Runnable((StatusCallback)iterator.next()){
                                    final /* synthetic */ StatusCallback val$callback;
                                    {
                                        this.val$callback = statusCallback;
                                    }

                                    @Override
                                    public void run() {
                                        this.val$callback.call(Session.this, sessionState2, exception);
                                    }
                                };
                                Session.runWithHandlerOrExecutor(Session.this.handler, runnable);
                            }
                        }
                    };
                    Session.runWithHandlerOrExecutor(this.handler, runnable);
                    if (this == activeSession && sessionState.isOpened() != sessionState2.isOpened()) break block9;
                }
            }
            return;
        }
        if (sessionState2.isOpened()) {
            Session.postActiveSessionAction(ACTION_ACTIVE_SESSION_OPENED);
            return;
        }
        Session.postActiveSessionAction(ACTION_ACTIVE_SESSION_CLOSED);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void removeCallback(StatusCallback statusCallback) {
        List<StatusCallback> list = this.callbacks;
        synchronized (list) {
            this.callbacks.remove(statusCallback);
            return;
        }
    }

    public final void requestNewPublishPermissions(NewPermissionsRequest newPermissionsRequest) {
        this.requestNewPermissions(newPermissionsRequest, SessionAuthorizationType.PUBLISH);
    }

    public final void requestNewReadPermissions(NewPermissionsRequest newPermissionsRequest) {
        this.requestNewPermissions(newPermissionsRequest, SessionAuthorizationType.READ);
    }

    void setCurrentTokenRefreshRequest(TokenRefreshRequest tokenRefreshRequest) {
        this.currentTokenRefreshRequest = tokenRefreshRequest;
    }

    void setLastAttemptedTokenExtendDate(Date date) {
        this.lastAttemptedTokenExtendDate = date;
    }

    void setTokenInfo(AccessToken accessToken) {
        this.tokenInfo = accessToken;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean shouldExtendAccessToken() {
        block3: {
            block2: {
                if (this.currentTokenRefreshRequest != null) break block2;
                Date date = new Date();
                if (this.state.isOpened() && this.tokenInfo.getSource().canExtendToken() && date.getTime() - this.lastAttemptedTokenExtendDate.getTime() > 3600000L && date.getTime() - this.tokenInfo.getLastRefresh().getTime() > 86400000L) break block3;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("{Session").append(" state:").append((Object)this.state).append(", token:");
        Object object = this.tokenInfo == null ? "null" : this.tokenInfo;
        StringBuilder stringBuilder2 = stringBuilder.append(object).append(", appId:");
        if (this.applicationId == null) {
            string2 = "null";
            return stringBuilder2.append(string2).append("}").toString();
        }
        string2 = this.applicationId;
        return stringBuilder2.append(string2).append("}").toString();
    }

    public static class AuthorizationRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String applicationId;
        private final String authId;
        private SessionDefaultAudience defaultAudience;
        private boolean isLegacy = false;
        private final Map<String, String> loggingExtras;
        private SessionLoginBehavior loginBehavior = SessionLoginBehavior.SSO_WITH_FALLBACK;
        private List<String> permissions = Collections.emptyList();
        private int requestCode = 64206;
        private final StartActivityDelegate startActivityDelegate;
        private StatusCallback statusCallback;
        private String validateSameFbidAsToken;

        AuthorizationRequest(final Activity activity) {
            this.defaultAudience = SessionDefaultAudience.FRIENDS;
            this.authId = UUID.randomUUID().toString();
            this.loggingExtras = new HashMap<String, String>();
            this.startActivityDelegate = new StartActivityDelegate(){

                @Override
                public Activity getActivityContext() {
                    return activity;
                }

                @Override
                public void startActivityForResult(Intent intent, int n2) {
                    activity.startActivityForResult(intent, n2);
                }
            };
        }

        AuthorizationRequest(final Fragment fragment) {
            this.defaultAudience = SessionDefaultAudience.FRIENDS;
            this.authId = UUID.randomUUID().toString();
            this.loggingExtras = new HashMap<String, String>();
            this.startActivityDelegate = new StartActivityDelegate(){

                @Override
                public Activity getActivityContext() {
                    return fragment.getActivity();
                }

                @Override
                public void startActivityForResult(Intent intent, int n2) {
                    fragment.startActivityForResult(intent, n2);
                }
            };
        }

        private AuthorizationRequest(SessionLoginBehavior sessionLoginBehavior, int n2, List<String> list, String string2, boolean bl2, String string3, String string4) {
            this.defaultAudience = SessionDefaultAudience.FRIENDS;
            this.authId = UUID.randomUUID().toString();
            this.loggingExtras = new HashMap<String, String>();
            this.startActivityDelegate = new StartActivityDelegate(){

                @Override
                public Activity getActivityContext() {
                    throw new UnsupportedOperationException("Cannot create an AuthorizationRequest without a valid Activity or Fragment");
                }

                @Override
                public void startActivityForResult(Intent intent, int n2) {
                    throw new UnsupportedOperationException("Cannot create an AuthorizationRequest without a valid Activity or Fragment");
                }
            };
            this.loginBehavior = sessionLoginBehavior;
            this.requestCode = n2;
            this.permissions = list;
            this.defaultAudience = SessionDefaultAudience.valueOf(string2);
            this.isLegacy = bl2;
            this.applicationId = string3;
            this.validateSameFbidAsToken = string4;
        }

        private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
            throw new InvalidObjectException("Cannot readObject, serialization proxy required");
        }

        String getApplicationId() {
            return this.applicationId;
        }

        String getAuthId() {
            return this.authId;
        }

        AuthorizationClient.AuthorizationRequest getAuthorizationClientRequest() {
            AuthorizationClient.StartActivityDelegate startActivityDelegate = new AuthorizationClient.StartActivityDelegate(){

                @Override
                public Activity getActivityContext() {
                    return AuthorizationRequest.this.startActivityDelegate.getActivityContext();
                }

                @Override
                public void startActivityForResult(Intent intent, int n2) {
                    AuthorizationRequest.this.startActivityDelegate.startActivityForResult(intent, n2);
                }
            };
            return new AuthorizationClient.AuthorizationRequest(this.loginBehavior, this.requestCode, this.isLegacy, this.permissions, this.defaultAudience, this.applicationId, this.validateSameFbidAsToken, startActivityDelegate, this.authId);
        }

        StatusCallback getCallback() {
            return this.statusCallback;
        }

        SessionDefaultAudience getDefaultAudience() {
            return this.defaultAudience;
        }

        SessionLoginBehavior getLoginBehavior() {
            return this.loginBehavior;
        }

        List<String> getPermissions() {
            return this.permissions;
        }

        int getRequestCode() {
            return this.requestCode;
        }

        StartActivityDelegate getStartActivityDelegate() {
            return this.startActivityDelegate;
        }

        String getValidateSameFbidAsToken() {
            return this.validateSameFbidAsToken;
        }

        boolean isLegacy() {
            return this.isLegacy;
        }

        void setApplicationId(String string2) {
            this.applicationId = string2;
        }

        AuthorizationRequest setCallback(StatusCallback statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        AuthorizationRequest setDefaultAudience(SessionDefaultAudience sessionDefaultAudience) {
            if (sessionDefaultAudience != null) {
                this.defaultAudience = sessionDefaultAudience;
            }
            return this;
        }

        public void setIsLegacy(boolean bl2) {
            this.isLegacy = bl2;
        }

        AuthorizationRequest setLoginBehavior(SessionLoginBehavior sessionLoginBehavior) {
            if (sessionLoginBehavior != null) {
                this.loginBehavior = sessionLoginBehavior;
            }
            return this;
        }

        AuthorizationRequest setPermissions(List<String> list) {
            if (list != null) {
                this.permissions = list;
            }
            return this;
        }

        AuthorizationRequest setPermissions(String ... stringArray) {
            return this.setPermissions(Arrays.asList(stringArray));
        }

        AuthorizationRequest setRequestCode(int n2) {
            if (n2 >= 0) {
                this.requestCode = n2;
            }
            return this;
        }

        void setValidateSameFbidAsToken(String string2) {
            this.validateSameFbidAsToken = string2;
        }

        Object writeReplace() {
            return new AuthRequestSerializationProxyV1(this.loginBehavior, this.requestCode, this.permissions, this.defaultAudience.name(), this.isLegacy, this.applicationId, this.validateSameFbidAsToken);
        }

        private static class AuthRequestSerializationProxyV1
        implements Serializable {
            private static final long serialVersionUID = -8748347685113614927L;
            private final String applicationId;
            private final String defaultAudience;
            private boolean isLegacy;
            private final SessionLoginBehavior loginBehavior;
            private final List<String> permissions;
            private final int requestCode;
            private final String validateSameFbidAsToken;

            private AuthRequestSerializationProxyV1(SessionLoginBehavior sessionLoginBehavior, int n2, List<String> list, String string2, boolean bl2, String string3, String string4) {
                this.loginBehavior = sessionLoginBehavior;
                this.requestCode = n2;
                this.permissions = list;
                this.defaultAudience = string2;
                this.isLegacy = bl2;
                this.applicationId = string3;
                this.validateSameFbidAsToken = string4;
            }

            private Object readResolve() {
                return new AuthorizationRequest(this.loginBehavior, this.requestCode, this.permissions, this.defaultAudience, this.isLegacy, this.applicationId, this.validateSameFbidAsToken);
            }
        }
    }

    private class AutoPublishAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private final Context mApplicationContext;
        private final String mApplicationId;

        public AutoPublishAsyncTask(String string2, Context context) {
            this.mApplicationId = string2;
            this.mApplicationContext = context.getApplicationContext();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Void doInBackground(Void ... voidArray) {
            try {
                Settings.publishInstallAndWaitForResponse(this.mApplicationContext, this.mApplicationId, true);
                return null;
            }
            catch (Exception exception) {
                Utility.logd("Facebook-publish", exception);
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void onPostExecute(Void void_) {
            Session session = Session.this;
            synchronized (session) {
                Session.access$1402(Session.this, null);
                return;
            }
        }
    }

    public static final class Builder {
        private String applicationId;
        private final Context context;
        private TokenCachingStrategy tokenCachingStrategy;

        public Builder(Context context) {
            this.context = context;
        }

        public Session build() {
            return new Session(this.context, this.applicationId, this.tokenCachingStrategy);
        }

        public Builder setApplicationId(String string2) {
            this.applicationId = string2;
            return this;
        }

        public Builder setTokenCachingStrategy(TokenCachingStrategy tokenCachingStrategy) {
            this.tokenCachingStrategy = tokenCachingStrategy;
            return this;
        }
    }

    public static final class NewPermissionsRequest
    extends AuthorizationRequest {
        private static final long serialVersionUID = 1L;

        public NewPermissionsRequest(Activity activity, List<String> list) {
            super(activity);
            this.setPermissions(list);
        }

        public NewPermissionsRequest(Activity activity, String ... stringArray) {
            super(activity);
            this.setPermissions(stringArray);
        }

        public NewPermissionsRequest(Fragment fragment, List<String> list) {
            super(fragment);
            this.setPermissions(list);
        }

        public NewPermissionsRequest(Fragment fragment, String ... stringArray) {
            super(fragment);
            this.setPermissions(stringArray);
        }

        @Override
        public final NewPermissionsRequest setCallback(StatusCallback statusCallback) {
            super.setCallback(statusCallback);
            return this;
        }

        @Override
        public final NewPermissionsRequest setDefaultAudience(SessionDefaultAudience sessionDefaultAudience) {
            super.setDefaultAudience(sessionDefaultAudience);
            return this;
        }

        @Override
        public final NewPermissionsRequest setLoginBehavior(SessionLoginBehavior sessionLoginBehavior) {
            super.setLoginBehavior(sessionLoginBehavior);
            return this;
        }

        @Override
        public final NewPermissionsRequest setRequestCode(int n2) {
            super.setRequestCode(n2);
            return this;
        }
    }

    public static final class OpenRequest
    extends AuthorizationRequest {
        private static final long serialVersionUID = 1L;

        public OpenRequest(Activity activity) {
            super(activity);
        }

        public OpenRequest(Fragment fragment) {
            super(fragment);
        }

        @Override
        public final OpenRequest setCallback(StatusCallback statusCallback) {
            super.setCallback(statusCallback);
            return this;
        }

        @Override
        public final OpenRequest setDefaultAudience(SessionDefaultAudience sessionDefaultAudience) {
            super.setDefaultAudience(sessionDefaultAudience);
            return this;
        }

        @Override
        public final OpenRequest setLoginBehavior(SessionLoginBehavior sessionLoginBehavior) {
            super.setLoginBehavior(sessionLoginBehavior);
            return this;
        }

        @Override
        public final OpenRequest setPermissions(List<String> list) {
            super.setPermissions(list);
            return this;
        }

        @Override
        public final OpenRequest setPermissions(String ... stringArray) {
            super.setPermissions(stringArray);
            return this;
        }

        @Override
        public final OpenRequest setRequestCode(int n2) {
            super.setRequestCode(n2);
            return this;
        }
    }

    private static class SerializationProxyV1
    implements Serializable {
        private static final long serialVersionUID = 7663436173185080063L;
        private final String applicationId;
        private final Date lastAttemptedTokenExtendDate;
        private final AuthorizationRequest pendingAuthorizationRequest;
        private final boolean shouldAutoPublish;
        private final SessionState state;
        private final AccessToken tokenInfo;

        SerializationProxyV1(String string2, SessionState sessionState, AccessToken accessToken, Date date, boolean bl2, AuthorizationRequest authorizationRequest) {
            this.applicationId = string2;
            this.state = sessionState;
            this.tokenInfo = accessToken;
            this.lastAttemptedTokenExtendDate = date;
            this.shouldAutoPublish = bl2;
            this.pendingAuthorizationRequest = authorizationRequest;
        }

        private Object readResolve() {
            return new Session(this.applicationId, this.state, this.tokenInfo, this.lastAttemptedTokenExtendDate, this.shouldAutoPublish, this.pendingAuthorizationRequest);
        }
    }

    static interface StartActivityDelegate {
        public Activity getActivityContext();

        public void startActivityForResult(Intent var1, int var2);
    }

    public static interface StatusCallback {
        public void call(Session var1, SessionState var2, Exception var3);
    }

    class TokenRefreshRequest
    implements ServiceConnection {
        final Messenger messageReceiver;
        Messenger messageSender;

        TokenRefreshRequest() {
            this.messageReceiver = new Messenger((Handler)new TokenRefreshRequestHandler(Session.this, this));
            this.messageSender = null;
        }

        private void cleanup() {
            if (Session.this.currentTokenRefreshRequest == this) {
                Session.access$1202(Session.this, null);
            }
        }

        private void refreshToken() {
            Bundle bundle = new Bundle();
            bundle.putString("access_token", Session.this.getTokenInfo().getToken());
            Message message = Message.obtain();
            message.setData(bundle);
            message.replyTo = this.messageReceiver;
            try {
                this.messageSender.send(message);
                return;
            }
            catch (RemoteException remoteException) {
                this.cleanup();
                return;
            }
        }

        public void bind() {
            Intent intent = NativeProtocol.createTokenRefreshIntent(Session.getStaticContext());
            if (intent != null && staticContext.bindService(intent, (ServiceConnection)this, 1)) {
                Session.this.setLastAttemptedTokenExtendDate(new Date());
                return;
            }
            this.cleanup();
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            this.messageSender = new Messenger(iBinder);
            this.refreshToken();
        }

        public void onServiceDisconnected(ComponentName componentName) {
            this.cleanup();
            staticContext.unbindService((ServiceConnection)this);
        }
    }

    static class TokenRefreshRequestHandler
    extends Handler {
        private WeakReference<TokenRefreshRequest> refreshRequestWeakReference;
        private WeakReference<Session> sessionWeakReference;

        TokenRefreshRequestHandler(Session session, TokenRefreshRequest tokenRefreshRequest) {
            super(Looper.getMainLooper());
            this.sessionWeakReference = new WeakReference<Session>(session);
            this.refreshRequestWeakReference = new WeakReference<TokenRefreshRequest>(tokenRefreshRequest);
        }

        public void handleMessage(Message message) {
            TokenRefreshRequest tokenRefreshRequest;
            String string2 = message.getData().getString("access_token");
            Session session = (Session)this.sessionWeakReference.get();
            if (session != null && string2 != null) {
                session.extendTokenCompleted(message.getData());
            }
            if ((tokenRefreshRequest = (TokenRefreshRequest)this.refreshRequestWeakReference.get()) != null) {
                staticContext.unbindService((ServiceConnection)tokenRefreshRequest);
                tokenRefreshRequest.cleanup();
            }
        }
    }
}

