/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.LoggingBehavior;
import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Session;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Response {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final String BODY_KEY = "body";
    private static final String CODE_KEY = "code";
    private static final int INVALID_SESSION_FACEBOOK_ERROR_CODE = 190;
    public static final String NON_JSON_RESPONSE_PROPERTY = "FACEBOOK_NON_JSON_RESULT";
    private static final String RESPONSE_CACHE_TAG = "ResponseCache";
    private static final String RESPONSE_LOG_TAG = "Response";
    private static FileLruCache responseCache;
    private final HttpURLConnection connection;
    private final FacebookRequestError error;
    private final GraphObject graphObject;
    private final GraphObjectList<GraphObject> graphObjectList;
    private final boolean isFromCache;
    private final Request request;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2 = !Response.class.desiredAssertionStatus();
        $assertionsDisabled = bl2;
    }

    Response(Request request, HttpURLConnection httpURLConnection, FacebookRequestError facebookRequestError) {
        this.request = request;
        this.connection = httpURLConnection;
        this.graphObject = null;
        this.graphObjectList = null;
        this.isFromCache = false;
        this.error = facebookRequestError;
    }

    Response(Request request, HttpURLConnection httpURLConnection, GraphObject graphObject, boolean bl2) {
        this.request = request;
        this.connection = httpURLConnection;
        this.graphObject = graphObject;
        this.graphObjectList = null;
        this.isFromCache = bl2;
        this.error = null;
    }

    Response(Request request, HttpURLConnection httpURLConnection, GraphObjectList<GraphObject> graphObjectList, boolean bl2) {
        this.request = request;
        this.connection = httpURLConnection;
        this.graphObject = null;
        this.graphObjectList = graphObjectList;
        this.isFromCache = bl2;
        this.error = null;
    }

    static List<Response> constructErrorResponses(List<Request> list, HttpURLConnection httpURLConnection, FacebookException facebookException) {
        int n2 = list.size();
        ArrayList<Response> arrayList = new ArrayList<Response>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(new Response(list.get(i2), httpURLConnection, new FacebookRequestError(httpURLConnection, facebookException)));
        }
        return arrayList;
    }

    private static Response createResponseFromObject(Request request, HttpURLConnection httpURLConnection, Object object, boolean bl2, Object object2) throws JSONException {
        if (object instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)object;
            FacebookRequestError facebookRequestError = FacebookRequestError.checkResponseAndCreateError(jSONObject, object2, httpURLConnection);
            if (facebookRequestError != null) {
                Session session;
                if (facebookRequestError.getErrorCode() == 190 && (session = request.getSession()) != null) {
                    session.closeAndClearTokenInformation();
                }
                return new Response(request, httpURLConnection, facebookRequestError);
            }
            Object object3 = Utility.getStringPropertyAsJSON(jSONObject, BODY_KEY, NON_JSON_RESPONSE_PROPERTY);
            if (object3 instanceof JSONObject) {
                return new Response(request, httpURLConnection, GraphObject.Factory.create((JSONObject)object3), bl2);
            }
            if (object3 instanceof JSONArray) {
                return new Response(request, httpURLConnection, GraphObject.Factory.createList((JSONArray)object3, GraphObject.class), bl2);
            }
            object = JSONObject.NULL;
        }
        if (object == JSONObject.NULL) {
            return new Response(request, httpURLConnection, (GraphObject)null, bl2);
        }
        throw new FacebookException("Got unexpected object type in response, class: " + object.getClass().getSimpleName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Response> createResponsesFromObject(HttpURLConnection httpURLConnection, List<Request> list, Object object, boolean bl2) throws FacebookException, JSONException {
        if (!$assertionsDisabled && httpURLConnection == null && !bl2) {
            throw new AssertionError();
        }
        int n2 = list.size();
        ArrayList<Response> arrayList = new ArrayList<Response>(n2);
        Object object2 = object;
        if (n2 == 1) {
            Request request = list.get(0);
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(BODY_KEY, object);
                int n3 = httpURLConnection != null ? httpURLConnection.getResponseCode() : 200;
                jSONObject.put(CODE_KEY, n3);
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)jSONObject);
                object = jSONArray;
            }
            catch (JSONException jSONException) {
                arrayList.add(new Response(request, httpURLConnection, new FacebookRequestError(httpURLConnection, (Exception)((Object)jSONException))));
            }
            catch (IOException iOException) {
                arrayList.add(new Response(request, httpURLConnection, new FacebookRequestError(httpURLConnection, iOException)));
            }
        }
        if (!(object instanceof JSONArray) || ((JSONArray)object).length() != n2) {
            throw new FacebookException("Unexpected number of results");
        }
        JSONArray jSONArray = (JSONArray)object;
        int n4 = 0;
        while (n4 < jSONArray.length()) {
            Request request = list.get(n4);
            try {
                arrayList.add(Response.createResponseFromObject(request, httpURLConnection, jSONArray.get(n4), bl2, object2));
            }
            catch (JSONException jSONException) {
                arrayList.add(new Response(request, httpURLConnection, new FacebookRequestError(httpURLConnection, (Exception)((Object)jSONException))));
            }
            catch (FacebookException facebookException) {
                arrayList.add(new Response(request, httpURLConnection, new FacebookRequestError(httpURLConnection, facebookException)));
            }
            ++n4;
        }
        return arrayList;
    }

    static List<Response> createResponsesFromStream(InputStream inputStream, HttpURLConnection httpURLConnection, RequestBatch requestBatch, boolean bl2) throws FacebookException, JSONException, IOException {
        String string2 = Utility.readStreamToString(inputStream);
        LoggingBehavior loggingBehavior = LoggingBehavior.INCLUDE_RAW_RESPONSES;
        Object[] objectArray = new Object[]{string2.length(), string2};
        Logger.log(loggingBehavior, RESPONSE_LOG_TAG, "Response (raw)\n  Size: %d\n  Response:\n%s\n", objectArray);
        return Response.createResponsesFromString(string2, httpURLConnection, requestBatch, bl2);
    }

    static List<Response> createResponsesFromString(String string2, HttpURLConnection httpURLConnection, RequestBatch requestBatch, boolean bl2) throws FacebookException, JSONException, IOException {
        List<Response> list = Response.createResponsesFromObject(httpURLConnection, requestBatch, new JSONTokener(string2).nextValue(), bl2);
        LoggingBehavior loggingBehavior = LoggingBehavior.REQUESTS;
        Object[] objectArray = new Object[]{requestBatch.getId(), string2.length(), list};
        Logger.log(loggingBehavior, RESPONSE_LOG_TAG, "Response\n  Id: %s\n  Size: %d\n  Responses:\n%s\n", objectArray);
        return list;
    }

    /*
     * Exception decompiling
     */
    static List<Response> fromHttpConnection(HttpURLConnection var0, RequestBatch var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 21[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static FileLruCache getResponseCache() {
        Context context;
        if (responseCache == null && (context = Session.getStaticContext()) != null) {
            responseCache = new FileLruCache(context, RESPONSE_CACHE_TAG, new FileLruCache.Limits());
        }
        return responseCache;
    }

    public final HttpURLConnection getConnection() {
        return this.connection;
    }

    public final FacebookRequestError getError() {
        return this.error;
    }

    public final GraphObject getGraphObject() {
        return this.graphObject;
    }

    public final <T extends GraphObject> T getGraphObjectAs(Class<T> clazz) {
        if (this.graphObject == null) {
            return null;
        }
        if (clazz == null) {
            throw new NullPointerException("Must pass in a valid interface that extends GraphObject");
        }
        return this.graphObject.cast(clazz);
    }

    public final GraphObjectList<GraphObject> getGraphObjectList() {
        return this.graphObjectList;
    }

    public final <T extends GraphObject> GraphObjectList<T> getGraphObjectListAs(Class<T> clazz) {
        if (this.graphObjectList == null) {
            return null;
        }
        return this.graphObjectList.castToListOf(clazz);
    }

    public final boolean getIsFromCache() {
        return this.isFromCache;
    }

    public Request getRequest() {
        return this.request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Request getRequestForPagedResults(PagingDirection pagingDirection) {
        GraphObject graphObject = this.graphObject;
        String string2 = null;
        if (graphObject != null) {
            PagingInfo pagingInfo = this.graphObject.cast(PagedResults.class).getPaging();
            string2 = null;
            if (pagingInfo != null) {
                string2 = pagingDirection == PagingDirection.NEXT ? pagingInfo.getNext() : pagingInfo.getPrevious();
            }
        }
        if (Utility.isNullOrEmpty(string2)) {
            return null;
        }
        if (string2 != null && string2.equals(this.request.getUrlForSingleRequest())) {
            return null;
        }
        try {
            return new Request(this.request.getSession(), new URL(string2));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        String string2;
        try {
            String string3;
            Object[] objectArray = new Object[1];
            int n2 = this.connection != null ? this.connection.getResponseCode() : 200;
            objectArray[0] = n2;
            string2 = string3 = String.format("%d", objectArray);
            return "{Response: " + " responseCode: " + string2 + ", graphObject: " + this.graphObject + ", error: " + this.error + ", isFromCache:" + this.isFromCache + "}";
        }
        catch (IOException iOException) {
            string2 = "unknown";
            return "{Response: " + " responseCode: " + string2 + ", graphObject: " + this.graphObject + ", error: " + this.error + ", isFromCache:" + this.isFromCache + "}";
        }
    }

    static interface PagedResults
    extends GraphObject {
        public GraphObjectList<GraphObject> getData();

        public PagingInfo getPaging();
    }

    public static final class PagingDirection
    extends Enum<PagingDirection> {
        private static final /* synthetic */ PagingDirection[] $VALUES;
        public static final /* enum */ PagingDirection NEXT = new PagingDirection();
        public static final /* enum */ PagingDirection PREVIOUS = new PagingDirection();

        static {
            PagingDirection[] pagingDirectionArray = new PagingDirection[]{NEXT, PREVIOUS};
            $VALUES = pagingDirectionArray;
        }

        public static PagingDirection valueOf(String string2) {
            return Enum.valueOf(PagingDirection.class, string2);
        }

        public static PagingDirection[] values() {
            return (PagingDirection[])$VALUES.clone();
        }
    }

    static interface PagingInfo
    extends GraphObject {
        public String getNext();

        public String getPrevious();
    }
}

