/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Handler;
import com.facebook.Request;
import com.facebook.RequestAsyncTask;
import com.facebook.Response;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestBatch
extends AbstractList<Request> {
    private static AtomicInteger idGenerator = new AtomicInteger();
    private String batchApplicationId;
    private Handler callbackHandler;
    private List<Callback> callbacks;
    private final String id;
    private List<Request> requests = new ArrayList<Request>();
    private int timeoutInMilliseconds = 0;

    public RequestBatch() {
        this.id = Integer.valueOf(idGenerator.incrementAndGet()).toString();
        this.callbacks = new ArrayList<Callback>();
        this.requests = new ArrayList<Request>();
    }

    public RequestBatch(RequestBatch requestBatch) {
        this.id = Integer.valueOf(idGenerator.incrementAndGet()).toString();
        this.callbacks = new ArrayList<Callback>();
        this.requests = new ArrayList<Request>(requestBatch);
        this.callbackHandler = requestBatch.callbackHandler;
        this.timeoutInMilliseconds = requestBatch.timeoutInMilliseconds;
        this.callbacks = new ArrayList<Callback>(requestBatch.callbacks);
    }

    public RequestBatch(Collection<Request> collection) {
        this.id = Integer.valueOf(idGenerator.incrementAndGet()).toString();
        this.callbacks = new ArrayList<Callback>();
        this.requests = new ArrayList<Request>(collection);
    }

    public RequestBatch(Request ... requestArray) {
        this.id = Integer.valueOf(idGenerator.incrementAndGet()).toString();
        this.callbacks = new ArrayList<Callback>();
        this.requests = Arrays.asList(requestArray);
    }

    @Override
    public final void add(int n2, Request request) {
        this.requests.add(n2, request);
    }

    @Override
    public final boolean add(Request request) {
        return this.requests.add(request);
    }

    public void addCallback(Callback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        }
    }

    @Override
    public final void clear() {
        this.requests.clear();
    }

    public final List<Response> executeAndWait() {
        return this.executeAndWaitImpl();
    }

    List<Response> executeAndWaitImpl() {
        return Request.executeBatchAndWait(this);
    }

    public final RequestAsyncTask executeAsync() {
        return this.executeAsyncImpl();
    }

    RequestAsyncTask executeAsyncImpl() {
        return Request.executeBatchAsync(this);
    }

    @Override
    public final Request get(int n2) {
        return this.requests.get(n2);
    }

    final String getBatchApplicationId() {
        return this.batchApplicationId;
    }

    final Handler getCallbackHandler() {
        return this.callbackHandler;
    }

    final List<Callback> getCallbacks() {
        return this.callbacks;
    }

    final String getId() {
        return this.id;
    }

    final List<Request> getRequests() {
        return this.requests;
    }

    public int getTimeout() {
        return this.timeoutInMilliseconds;
    }

    @Override
    public final Request remove(int n2) {
        return this.requests.remove(n2);
    }

    public void removeCallback(Callback callback) {
        this.callbacks.remove(callback);
    }

    @Override
    public final Request set(int n2, Request request) {
        return this.requests.set(n2, request);
    }

    final void setBatchApplicationId(String string2) {
        this.batchApplicationId = string2;
    }

    final void setCallbackHandler(Handler handler) {
        this.callbackHandler = handler;
    }

    public void setTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Argument timeoutInMilliseconds must be >= 0.");
        }
        this.timeoutInMilliseconds = n2;
    }

    @Override
    public final int size() {
        return this.requests.size();
    }

    public static interface Callback {
        public void onBatchCompleted(RequestBatch var1);
    }
}

