/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.graphics.Bitmap;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import com.facebook.FacebookException;
import com.facebook.HttpMethod;
import com.facebook.LoggingBehavior;
import com.facebook.RequestAsyncTask;
import com.facebook.RequestBatch;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.Settings;
import com.facebook.internal.Logger;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphMultiResult;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.model.GraphPlace;
import com.facebook.model.GraphUser;
import com.facebook.model.OpenGraphAction;
import com.facebook.model.OpenGraphObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Request {
    private static final String ACCESS_TOKEN_PARAM = "access_token";
    private static final String ATTACHED_FILES_PARAM = "attached_files";
    private static final String ATTACHMENT_FILENAME_PREFIX = "file";
    private static final String BATCH_APP_ID_PARAM = "batch_app_id";
    private static final String BATCH_BODY_PARAM = "body";
    private static final String BATCH_ENTRY_DEPENDS_ON_PARAM = "depends_on";
    private static final String BATCH_ENTRY_NAME_PARAM = "name";
    private static final String BATCH_ENTRY_OMIT_RESPONSE_ON_SUCCESS_PARAM = "omit_response_on_success";
    private static final String BATCH_METHOD_PARAM = "method";
    private static final String BATCH_PARAM = "batch";
    private static final String BATCH_RELATIVE_URL_PARAM = "relative_url";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String FORMAT_JSON = "json";
    private static final String FORMAT_PARAM = "format";
    private static final String ISO_8601_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final int MAXIMUM_BATCH_SIZE = 50;
    private static final String ME = "me";
    private static final String MIGRATION_BUNDLE_PARAM = "migration_bundle";
    private static final String MIME_BOUNDARY = "3i2ndDfv2rTHiSisAbouNdArYfORhtTPEefj3q2f";
    private static final String MY_ACTION_FORMAT = "me/%s";
    private static final String MY_FEED = "me/feed";
    private static final String MY_FRIENDS = "me/friends";
    private static final String MY_OBJECTS_FORMAT = "me/objects/%s";
    private static final String MY_PHOTOS = "me/photos";
    private static final String MY_STAGING_RESOURCES = "me/staging_resources";
    private static final String MY_VIDEOS = "me/videos";
    private static final String OBJECT_PARAM = "object";
    private static final String PICTURE_PARAM = "picture";
    private static final String SDK_ANDROID = "android";
    private static final String SDK_PARAM = "sdk";
    private static final String SEARCH = "search";
    private static final String STAGING_PARAM = "file";
    private static final String USER_AGENT_BASE = "FBAndroidSDK";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static String defaultBatchApplicationId;
    private static volatile String userAgent;
    private String batchEntryDependsOn;
    private String batchEntryName;
    private boolean batchEntryOmitResultOnSuccess = true;
    private Callback callback;
    private GraphObject graphObject;
    private String graphPath;
    private HttpMethod httpMethod;
    private String overriddenURL;
    private Bundle parameters;
    private String restMethod;
    private Session session;
    private Object tag;

    public Request() {
        this(null, null, null, null, null);
    }

    public Request(Session session, String string2) {
        this(session, string2, null, null, null);
    }

    public Request(Session session, String string2, Bundle bundle, HttpMethod httpMethod) {
        this(session, string2, bundle, httpMethod, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Request(Session session, String string2, Bundle bundle, HttpMethod httpMethod, Callback callback) {
        this.session = session;
        this.graphPath = string2;
        this.callback = callback;
        this.setHttpMethod(httpMethod);
        this.parameters = bundle != null ? new Bundle(bundle) : new Bundle();
        if (!this.parameters.containsKey(MIGRATION_BUNDLE_PARAM)) {
            this.parameters.putString(MIGRATION_BUNDLE_PARAM, "fbsdk:20131203");
        }
    }

    Request(Session session, URL uRL) {
        this.session = session;
        this.overriddenURL = uRL.toString();
        this.setHttpMethod(HttpMethod.GET);
        this.parameters = new Bundle();
    }

    private void addCommonParameters() {
        if (this.session != null) {
            if (!this.session.isOpened()) {
                throw new FacebookException("Session provided to a Request in un-opened state.");
            }
            if (!this.parameters.containsKey(ACCESS_TOKEN_PARAM)) {
                String string2 = this.session.getAccessToken();
                Logger.registerAccessToken(string2);
                this.parameters.putString(ACCESS_TOKEN_PARAM, string2);
            }
        }
        this.parameters.putString(SDK_PARAM, SDK_ANDROID);
        this.parameters.putString(FORMAT_PARAM, FORMAT_JSON);
    }

    private String appendParametersToBaseUrl(String string2) {
        Uri.Builder builder = new Uri.Builder().encodedPath(string2);
        for (String string3 : this.parameters.keySet()) {
            Object object = this.parameters.get(string3);
            if (object == null) {
                object = "";
            }
            if (Request.isSupportedParameterType(object)) {
                builder.appendQueryParameter(string3, Request.parameterToString(object).toString());
                continue;
            }
            if (this.httpMethod != HttpMethod.GET) continue;
            Object[] objectArray = new Object[]{object.getClass().getSimpleName()};
            throw new IllegalArgumentException(String.format("Unsupported parameter type for GET request: %s", objectArray));
        }
        return builder.toString();
    }

    static HttpURLConnection createConnection(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestProperty(USER_AGENT_HEADER, Request.getUserAgent());
        httpURLConnection.setRequestProperty(CONTENT_TYPE_HEADER, Request.getMimeContentType());
        httpURLConnection.setChunkedStreamingMode(0);
        return httpURLConnection;
    }

    public static Response executeAndWait(Request request) {
        List<Response> list = Request.executeBatchAndWait(request);
        if (list == null || list.size() != 1) {
            throw new FacebookException("invalid state: expected a single response");
        }
        return list.get(0);
    }

    public static List<Response> executeBatchAndWait(RequestBatch requestBatch) {
        HttpURLConnection httpURLConnection;
        Validate.notEmptyAndContainsNoNulls(requestBatch, "requests");
        try {
            httpURLConnection = Request.toHttpConnection(requestBatch);
        }
        catch (Exception exception) {
            List<Response> list = Response.constructErrorResponses(requestBatch.getRequests(), null, new FacebookException(exception));
            Request.runCallbacks(requestBatch, list);
            return list;
        }
        return Request.executeConnectionAndWait(httpURLConnection, requestBatch);
    }

    public static List<Response> executeBatchAndWait(Collection<Request> collection) {
        return Request.executeBatchAndWait(new RequestBatch(collection));
    }

    public static List<Response> executeBatchAndWait(Request ... requestArray) {
        Validate.notNull(requestArray, "requests");
        return Request.executeBatchAndWait(Arrays.asList(requestArray));
    }

    public static RequestAsyncTask executeBatchAsync(RequestBatch requestBatch) {
        Validate.notEmptyAndContainsNoNulls(requestBatch, "requests");
        RequestAsyncTask requestAsyncTask = new RequestAsyncTask(requestBatch);
        requestAsyncTask.executeOnSettingsExecutor();
        return requestAsyncTask;
    }

    public static RequestAsyncTask executeBatchAsync(Collection<Request> collection) {
        return Request.executeBatchAsync(new RequestBatch(collection));
    }

    public static RequestAsyncTask executeBatchAsync(Request ... requestArray) {
        Validate.notNull(requestArray, "requests");
        return Request.executeBatchAsync(Arrays.asList(requestArray));
    }

    public static List<Response> executeConnectionAndWait(HttpURLConnection httpURLConnection, RequestBatch requestBatch) {
        List<Response> list = Response.fromHttpConnection(httpURLConnection, requestBatch);
        Utility.disconnectQuietly(httpURLConnection);
        int n2 = requestBatch.size();
        if (n2 != list.size()) {
            Object[] objectArray = new Object[]{list.size(), n2};
            throw new FacebookException(String.format("Received %d responses while expecting %d", objectArray));
        }
        Request.runCallbacks(requestBatch, list);
        HashSet<Session> hashSet = new HashSet<Session>();
        for (Request request : requestBatch) {
            if (request.session == null) continue;
            hashSet.add(request.session);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((Session)iterator.next()).extendAccessTokenIfNeeded();
        }
        return list;
    }

    public static List<Response> executeConnectionAndWait(HttpURLConnection httpURLConnection, Collection<Request> collection) {
        return Request.executeConnectionAndWait(httpURLConnection, new RequestBatch(collection));
    }

    public static RequestAsyncTask executeConnectionAsync(Handler handler, HttpURLConnection httpURLConnection, RequestBatch requestBatch) {
        Validate.notNull(httpURLConnection, "connection");
        RequestAsyncTask requestAsyncTask = new RequestAsyncTask(httpURLConnection, requestBatch);
        requestBatch.setCallbackHandler(handler);
        requestAsyncTask.executeOnSettingsExecutor();
        return requestAsyncTask;
    }

    public static RequestAsyncTask executeConnectionAsync(HttpURLConnection httpURLConnection, RequestBatch requestBatch) {
        return Request.executeConnectionAsync(null, httpURLConnection, requestBatch);
    }

    @Deprecated
    public static RequestAsyncTask executeGraphPathRequestAsync(Session session, String string2, Callback callback) {
        return Request.newGraphPathRequest(session, string2, callback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executeMeRequestAsync(Session session, GraphUserCallback graphUserCallback) {
        return Request.newMeRequest(session, graphUserCallback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executeMyFriendsRequestAsync(Session session, GraphUserListCallback graphUserListCallback) {
        return Request.newMyFriendsRequest(session, graphUserListCallback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executePlacesSearchRequestAsync(Session session, Location location, int n2, int n3, String string2, GraphPlaceListCallback graphPlaceListCallback) {
        return Request.newPlacesSearchRequest(session, location, n2, n3, string2, graphPlaceListCallback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executePostRequestAsync(Session session, String string2, GraphObject graphObject, Callback callback) {
        return Request.newPostRequest(session, string2, graphObject, callback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executeRestRequestAsync(Session session, String string2, Bundle bundle, HttpMethod httpMethod) {
        return Request.newRestRequest(session, string2, bundle, httpMethod).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executeStatusUpdateRequestAsync(Session session, String string2, Callback callback) {
        return Request.newStatusUpdateRequest(session, string2, callback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executeUploadPhotoRequestAsync(Session session, Bitmap bitmap, Callback callback) {
        return Request.newUploadPhotoRequest(session, bitmap, callback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executeUploadPhotoRequestAsync(Session session, File file, Callback callback) throws FileNotFoundException {
        return Request.newUploadPhotoRequest(session, file, callback).executeAsync();
    }

    private static String getBatchAppId(RequestBatch requestBatch) {
        if (!Utility.isNullOrEmpty(requestBatch.getBatchApplicationId())) {
            return requestBatch.getBatchApplicationId();
        }
        Iterator iterator = requestBatch.iterator();
        while (iterator.hasNext()) {
            Session session = ((Request)iterator.next()).session;
            if (session == null) continue;
            return session.getApplicationId();
        }
        return defaultBatchApplicationId;
    }

    public static final String getDefaultBatchApplicationId() {
        return defaultBatchApplicationId;
    }

    private static String getMimeContentType() {
        return String.format("multipart/form-data; boundary=%s", MIME_BOUNDARY);
    }

    private static String getUserAgent() {
        if (userAgent == null) {
            userAgent = String.format("%s.%s", USER_AGENT_BASE, "3.6.0");
        }
        return userAgent;
    }

    private static boolean isSupportedAttachmentType(Object object) {
        return object instanceof Bitmap || object instanceof byte[] || object instanceof ParcelFileDescriptor || object instanceof ParcelFileDescriptorWithMimeType;
    }

    private static boolean isSupportedParameterType(Object object) {
        return object instanceof String || object instanceof Boolean || object instanceof Number || object instanceof Date;
    }

    public static Request newCustomAudienceThirdPartyIdRequest(Session session, Context context, Callback callback) {
        return Request.newCustomAudienceThirdPartyIdRequest(session, context, null, callback);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Request newCustomAudienceThirdPartyIdRequest(Session session, Context context, String string2, Callback callback) {
        String string3;
        if (session == null) {
            session = Session.getActiveSession();
        }
        if (session != null && !session.isOpened()) {
            session = null;
        }
        if (string2 == null) {
            string2 = session != null ? session.getApplicationId() : Utility.getMetadataApplicationId(context);
        }
        if (string2 == null) {
            throw new FacebookException("Facebook App ID cannot be determined");
        }
        String string4 = string2 + "/custom_audience_third_party_id";
        Bundle bundle = new Bundle();
        if (session == null && (string3 = Settings.getAttributionId(context.getContentResolver())) != null) {
            bundle.putString("udid", string3);
        }
        if (Settings.getLimitEventAndDataUsage(context)) {
            bundle.putString("limit_event_usage", "1");
        }
        HttpMethod httpMethod = HttpMethod.GET;
        return new Request(session, string4, bundle, httpMethod, callback);
    }

    public static Request newDeleteObjectRequest(Session session, String string2, Callback callback) {
        return new Request(session, string2, null, HttpMethod.DELETE, callback);
    }

    public static Request newGraphPathRequest(Session session, String string2, Callback callback) {
        return new Request(session, string2, null, null, callback);
    }

    public static Request newMeRequest(Session session, final GraphUserCallback graphUserCallback) {
        return new Request(session, ME, null, null, new Callback(){

            @Override
            public void onCompleted(Response response) {
                if (graphUserCallback != null) {
                    graphUserCallback.onCompleted(response.getGraphObjectAs(GraphUser.class), response);
                }
            }
        });
    }

    public static Request newMyFriendsRequest(Session session, final GraphUserListCallback graphUserListCallback) {
        return new Request(session, MY_FRIENDS, null, null, new Callback(){

            @Override
            public void onCompleted(Response response) {
                if (graphUserListCallback != null) {
                    graphUserListCallback.onCompleted(Request.typedListFromResponse(response, GraphUser.class), response);
                }
            }
        });
    }

    public static Request newPlacesSearchRequest(Session session, Location location, int n2, int n3, String string2, final GraphPlaceListCallback graphPlaceListCallback) {
        if (location == null && Utility.isNullOrEmpty(string2)) {
            throw new FacebookException("Either location or searchText must be specified.");
        }
        Bundle bundle = new Bundle(5);
        bundle.putString("type", "place");
        bundle.putInt("limit", n3);
        if (location != null) {
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{location.getLatitude(), location.getLongitude()};
            bundle.putString("center", String.format(locale, "%f,%f", objectArray));
            bundle.putInt("distance", n2);
        }
        if (!Utility.isNullOrEmpty(string2)) {
            bundle.putString("q", string2);
        }
        Callback callback = new Callback(){

            @Override
            public void onCompleted(Response response) {
                if (graphPlaceListCallback != null) {
                    graphPlaceListCallback.onCompleted(Request.typedListFromResponse(response, GraphPlace.class), response);
                }
            }
        };
        return new Request(session, SEARCH, bundle, HttpMethod.GET, callback);
    }

    public static Request newPostOpenGraphActionRequest(Session session, OpenGraphAction openGraphAction, Callback callback) {
        if (openGraphAction == null) {
            throw new FacebookException("openGraphAction cannot be null");
        }
        if (Utility.isNullOrEmpty(openGraphAction.getType())) {
            throw new FacebookException("openGraphAction must have non-null 'type' property");
        }
        Object[] objectArray = new Object[]{openGraphAction.getType()};
        return Request.newPostRequest(session, String.format(MY_ACTION_FORMAT, objectArray), openGraphAction, callback);
    }

    public static Request newPostOpenGraphObjectRequest(Session session, OpenGraphObject openGraphObject, Callback callback) {
        if (openGraphObject == null) {
            throw new FacebookException("openGraphObject cannot be null");
        }
        if (Utility.isNullOrEmpty(openGraphObject.getType())) {
            throw new FacebookException("openGraphObject must have non-null 'type' property");
        }
        if (Utility.isNullOrEmpty(openGraphObject.getTitle())) {
            throw new FacebookException("openGraphObject must have non-null 'title' property");
        }
        Object[] objectArray = new Object[]{openGraphObject.getType()};
        String string2 = String.format(MY_OBJECTS_FORMAT, objectArray);
        Bundle bundle = new Bundle();
        bundle.putString(OBJECT_PARAM, openGraphObject.getInnerJSONObject().toString());
        return new Request(session, string2, bundle, HttpMethod.POST, callback);
    }

    public static Request newPostOpenGraphObjectRequest(Session session, String string2, String string3, String string4, String string5, String string6, GraphObject graphObject, Callback callback) {
        OpenGraphObject openGraphObject = OpenGraphObject.Factory.createForPost(OpenGraphObject.class, string2, string3, string4, string5, string6);
        if (graphObject != null) {
            openGraphObject.setData(graphObject);
        }
        return Request.newPostOpenGraphObjectRequest(session, openGraphObject, callback);
    }

    public static Request newPostRequest(Session session, String string2, GraphObject graphObject, Callback callback) {
        Request request = new Request(session, string2, null, HttpMethod.POST, callback);
        request.setGraphObject(graphObject);
        return request;
    }

    public static Request newRestRequest(Session session, String string2, Bundle bundle, HttpMethod httpMethod) {
        Request request = new Request(session, null, bundle, httpMethod);
        request.setRestMethod(string2);
        return request;
    }

    public static Request newStatusUpdateRequest(Session session, String string2, Callback callback) {
        return Request.newStatusUpdateRequest(session, string2, (String)null, null, callback);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Request newStatusUpdateRequest(Session session, String string2, GraphPlace graphPlace, List<GraphUser> list, Callback callback) {
        String string3;
        ArrayList<String> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<String>(list.size());
            Iterator<GraphUser> iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().getId());
            }
        }
        if (graphPlace == null) {
            string3 = null;
            return Request.newStatusUpdateRequest(session, string2, string3, arrayList, callback);
        }
        string3 = graphPlace.getId();
        return Request.newStatusUpdateRequest(session, string2, string3, arrayList, callback);
    }

    private static Request newStatusUpdateRequest(Session session, String string2, String string3, List<String> list, Callback callback) {
        Bundle bundle = new Bundle();
        bundle.putString("message", string2);
        if (string3 != null) {
            bundle.putString("place", string3);
        }
        if (list != null && list.size() > 0) {
            bundle.putString("tags", TextUtils.join((CharSequence)",", list));
        }
        return new Request(session, MY_FEED, bundle, HttpMethod.POST, callback);
    }

    public static Request newUpdateOpenGraphObjectRequest(Session session, OpenGraphObject openGraphObject, Callback callback) {
        if (openGraphObject == null) {
            throw new FacebookException("openGraphObject cannot be null");
        }
        String string2 = openGraphObject.getId();
        if (string2 == null) {
            throw new FacebookException("openGraphObject must have an id");
        }
        Bundle bundle = new Bundle();
        bundle.putString(OBJECT_PARAM, openGraphObject.getInnerJSONObject().toString());
        return new Request(session, string2, bundle, HttpMethod.POST, callback);
    }

    public static Request newUpdateOpenGraphObjectRequest(Session session, String string2, String string3, String string4, String string5, String string6, GraphObject graphObject, Callback callback) {
        OpenGraphObject openGraphObject = OpenGraphObject.Factory.createForPost(OpenGraphObject.class, null, string3, string4, string5, string6);
        openGraphObject.setId(string2);
        openGraphObject.setData(graphObject);
        return Request.newUpdateOpenGraphObjectRequest(session, openGraphObject, callback);
    }

    public static Request newUploadPhotoRequest(Session session, Bitmap bitmap, Callback callback) {
        Bundle bundle = new Bundle(1);
        bundle.putParcelable(PICTURE_PARAM, (Parcelable)bitmap);
        return new Request(session, MY_PHOTOS, bundle, HttpMethod.POST, callback);
    }

    public static Request newUploadPhotoRequest(Session session, File file, Callback callback) throws FileNotFoundException {
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        Bundle bundle = new Bundle(1);
        bundle.putParcelable(PICTURE_PARAM, (Parcelable)parcelFileDescriptor);
        return new Request(session, MY_PHOTOS, bundle, HttpMethod.POST, callback);
    }

    public static Request newUploadStagingResourceWithImageRequest(Session session, Bitmap bitmap, Callback callback) {
        Bundle bundle = new Bundle(1);
        bundle.putParcelable("file", (Parcelable)bitmap);
        return new Request(session, MY_STAGING_RESOURCES, bundle, HttpMethod.POST, callback);
    }

    public static Request newUploadStagingResourceWithImageRequest(Session session, File file, Callback callback) throws FileNotFoundException {
        ParcelFileDescriptorWithMimeType parcelFileDescriptorWithMimeType = new ParcelFileDescriptorWithMimeType(ParcelFileDescriptor.open((File)file, (int)0x10000000), "image/png");
        Bundle bundle = new Bundle(1);
        bundle.putParcelable("file", (Parcelable)parcelFileDescriptorWithMimeType);
        return new Request(session, MY_STAGING_RESOURCES, bundle, HttpMethod.POST, callback);
    }

    public static Request newUploadVideoRequest(Session session, File file, Callback callback) throws FileNotFoundException {
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        Bundle bundle = new Bundle(1);
        bundle.putParcelable(file.getName(), (Parcelable)parcelFileDescriptor);
        return new Request(session, MY_VIDEOS, bundle, HttpMethod.POST, callback);
    }

    private static String parameterToString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Boolean || object instanceof Number) {
            return object.toString();
        }
        if (object instanceof Date) {
            return new SimpleDateFormat(ISO_8601_FORMAT_STRING, Locale.US).format(object);
        }
        throw new IllegalArgumentException("Unsupported parameter type.");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void processGraphObject(GraphObject graphObject, String string2, KeyValueSerializer keyValueSerializer) throws IOException {
        boolean bl2;
        block6: {
            block5: {
                if (string2.startsWith("me/")) break block5;
                boolean bl3 = string2.startsWith("/me/");
                bl2 = false;
                if (!bl3) break block6;
            }
            int n2 = string2.indexOf(":");
            int n3 = string2.indexOf("?");
            bl2 = n2 > 3 && (n3 == -1 || n2 < n3);
        }
        Iterator<Map.Entry<String, Object>> iterator = graphObject.asMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            boolean bl4 = bl2 && entry.getKey().equalsIgnoreCase("image");
            Request.processGraphObjectProperty(entry.getKey(), entry.getValue(), keyValueSerializer, bl4);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void processGraphObjectProperty(String string2, Object object, KeyValueSerializer keyValueSerializer, boolean bl2) throws IOException {
        Class<?> clazz = object.getClass();
        if (GraphObject.class.isAssignableFrom(clazz)) {
            object = ((GraphObject)object).getInnerJSONObject();
            clazz = object.getClass();
        } else if (GraphObjectList.class.isAssignableFrom(clazz)) {
            object = ((GraphObjectList)object).getInnerJSONArray();
            clazz = object.getClass();
        }
        if (JSONObject.class.isAssignableFrom(clazz)) {
            JSONObject jSONObject = (JSONObject)object;
            if (bl2) {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    Request.processGraphObjectProperty(String.format("%s[%s]", string2, string3), jSONObject.opt(string3), keyValueSerializer, bl2);
                }
                return;
            }
            if (jSONObject.has("id")) {
                Request.processGraphObjectProperty(string2, jSONObject.optString("id"), keyValueSerializer, bl2);
                return;
            } else {
                if (!jSONObject.has("url")) return;
                Request.processGraphObjectProperty(string2, jSONObject.optString("url"), keyValueSerializer, bl2);
                return;
            }
        }
        if (JSONArray.class.isAssignableFrom(clazz)) {
            JSONArray jSONArray = (JSONArray)object;
            int n2 = jSONArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object[] objectArray = new Object[]{string2, i2};
                Request.processGraphObjectProperty(String.format("%s[%d]", objectArray), jSONArray.opt(i2), keyValueSerializer, bl2);
            }
            return;
        } else {
            if (String.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
                keyValueSerializer.writeString(string2, object.toString());
                return;
            }
            if (!Date.class.isAssignableFrom(clazz)) return;
            Date date = (Date)object;
            keyValueSerializer.writeString(string2, new SimpleDateFormat(ISO_8601_FORMAT_STRING, Locale.US).format(date));
            return;
        }
    }

    static void runCallbacks(final RequestBatch requestBatch, List<Response> list) {
        Handler handler;
        Runnable runnable;
        block4: {
            block3: {
                int n2 = requestBatch.size();
                final ArrayList<Pair> arrayList = new ArrayList<Pair>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Request request = requestBatch.get(i2);
                    if (request.callback == null) continue;
                    arrayList.add(new Pair((Object)request.callback, (Object)list.get(i2)));
                }
                if (arrayList.size() <= 0) break block3;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (Pair pair : arrayList) {
                            ((Callback)pair.first).onCompleted((Response)pair.second);
                        }
                        Iterator<RequestBatch.Callback> iterator = requestBatch.getCallbacks().iterator();
                        while (iterator.hasNext()) {
                            iterator.next().onBatchCompleted(requestBatch);
                        }
                    }
                };
                handler = requestBatch.getCallbackHandler();
                if (handler != null) break block4;
                runnable.run();
            }
            return;
        }
        handler.post(runnable);
    }

    private static void serializeAttachments(Bundle bundle, Serializer serializer) throws IOException {
        for (String string2 : bundle.keySet()) {
            Object object = bundle.get(string2);
            if (!Request.isSupportedAttachmentType(object)) continue;
            serializer.writeObject(string2, object);
        }
    }

    private static void serializeParameters(Bundle bundle, Serializer serializer) throws IOException {
        for (String string2 : bundle.keySet()) {
            Object object = bundle.get(string2);
            if (!Request.isSupportedParameterType(object)) continue;
            serializer.writeObject(string2, object);
        }
    }

    private static void serializeRequestsAsJSON(Serializer serializer, Collection<Request> collection, Bundle bundle) throws JSONException, IOException {
        JSONArray jSONArray = new JSONArray();
        Iterator<Request> iterator = collection.iterator();
        while (iterator.hasNext()) {
            iterator.next().serializeToBatch(jSONArray, bundle);
        }
        serializer.writeString(BATCH_PARAM, jSONArray.toString());
    }

    private void serializeToBatch(JSONArray jSONArray, Bundle bundle) throws JSONException, IOException {
        JSONObject jSONObject = new JSONObject();
        if (this.batchEntryName != null) {
            jSONObject.put(BATCH_ENTRY_NAME_PARAM, (Object)this.batchEntryName);
            jSONObject.put(BATCH_ENTRY_OMIT_RESPONSE_ON_SUCCESS_PARAM, this.batchEntryOmitResultOnSuccess);
        }
        if (this.batchEntryDependsOn != null) {
            jSONObject.put(BATCH_ENTRY_DEPENDS_ON_PARAM, (Object)this.batchEntryDependsOn);
        }
        String string2 = this.getUrlForBatchedRequest();
        jSONObject.put(BATCH_RELATIVE_URL_PARAM, (Object)string2);
        jSONObject.put(BATCH_METHOD_PARAM, (Object)this.httpMethod);
        if (this.session != null) {
            Logger.registerAccessToken(this.session.getAccessToken());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : this.parameters.keySet()) {
            Object object = this.parameters.get(string3);
            if (!Request.isSupportedAttachmentType(object)) continue;
            Object[] objectArray = new Object[]{"file", bundle.size()};
            String string4 = String.format("%s%d", objectArray);
            arrayList.add(string4);
            Utility.putObjectInBundle(bundle, string4, object);
        }
        if (!arrayList.isEmpty()) {
            jSONObject.put(ATTACHED_FILES_PARAM, (Object)TextUtils.join((CharSequence)",", arrayList));
        }
        if (this.graphObject != null) {
            final ArrayList arrayList2 = new ArrayList();
            Request.processGraphObject(this.graphObject, string2, new KeyValueSerializer(){

                @Override
                public void writeString(String string2, String string3) throws IOException {
                    ArrayList arrayList = arrayList2;
                    Object[] objectArray = new Object[]{string2, URLEncoder.encode(string3, "UTF-8")};
                    arrayList.add(String.format("%s=%s", objectArray));
                }
            });
            jSONObject.put(BATCH_BODY_PARAM, (Object)TextUtils.join((CharSequence)"&", arrayList2));
        }
        jSONArray.put((Object)jSONObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final void serializeToUrlConnection(RequestBatch requestBatch, HttpURLConnection httpURLConnection) throws IOException, JSONException {
        Logger logger = new Logger(LoggingBehavior.REQUESTS, "Request");
        int n2 = requestBatch.size();
        HttpMethod httpMethod = n2 == 1 ? requestBatch.get((int)0).httpMethod : HttpMethod.POST;
        httpURLConnection.setRequestMethod(httpMethod.name());
        URL uRL = httpURLConnection.getURL();
        logger.append("Request:\n");
        logger.appendKeyValue("Id", requestBatch.getId());
        logger.appendKeyValue("URL", uRL);
        logger.appendKeyValue("Method", httpURLConnection.getRequestMethod());
        logger.appendKeyValue(USER_AGENT_HEADER, httpURLConnection.getRequestProperty(USER_AGENT_HEADER));
        logger.appendKeyValue(CONTENT_TYPE_HEADER, httpURLConnection.getRequestProperty(CONTENT_TYPE_HEADER));
        httpURLConnection.setConnectTimeout(requestBatch.getTimeout());
        httpURLConnection.setReadTimeout(requestBatch.getTimeout());
        HttpMethod httpMethod2 = HttpMethod.POST;
        boolean bl2 = false;
        if (httpMethod == httpMethod2) {
            bl2 = true;
        }
        if (!bl2) {
            logger.log();
            return;
        }
        httpURLConnection.setDoOutput(true);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
        try {
            Serializer serializer = new Serializer(bufferedOutputStream, logger);
            if (n2 == 1) {
                Request request = requestBatch.get(0);
                logger.append("  Parameters:\n");
                Request.serializeParameters(request.parameters, serializer);
                logger.append("  Attachments:\n");
                Request.serializeAttachments(request.parameters, serializer);
                if (request.graphObject != null) {
                    Request.processGraphObject(request.graphObject, uRL.getPath(), serializer);
                }
            } else {
                String string2 = Request.getBatchAppId(requestBatch);
                if (Utility.isNullOrEmpty(string2)) {
                    throw new FacebookException("At least one request in a batch must have an open Session, or a default app ID must be specified.");
                }
                serializer.writeString(BATCH_APP_ID_PARAM, string2);
                Bundle bundle = new Bundle();
                Request.serializeRequestsAsJSON(serializer, requestBatch, bundle);
                logger.append("  Attachments:\n");
                Request.serializeAttachments(bundle, serializer);
            }
            logger.log();
            return;
        }
        finally {
            bufferedOutputStream.close();
        }
    }

    public static final void setDefaultBatchApplicationId(String string2) {
        defaultBatchApplicationId = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpURLConnection toHttpConnection(RequestBatch requestBatch) {
        URL uRL;
        Iterator iterator = requestBatch.iterator();
        while (iterator.hasNext()) {
            ((Request)iterator.next()).validate();
        }
        try {
            if (requestBatch.size() != 1) {
                uRL = new URL(ServerProtocol.getGraphUrlBase());
            }
            uRL = new URL(requestBatch.get(0).getUrlForSingleRequest());
        }
        catch (MalformedURLException malformedURLException) {
            throw new FacebookException("could not construct URL for request", malformedURLException);
        }
        try {
            HttpURLConnection httpURLConnection = Request.createConnection(uRL);
            Request.serializeToUrlConnection(requestBatch, httpURLConnection);
            return httpURLConnection;
        }
        catch (IOException iOException) {
            throw new FacebookException("could not construct request body", iOException);
        }
        catch (JSONException jSONException) {
            throw new FacebookException("could not construct request body", jSONException);
        }
    }

    public static HttpURLConnection toHttpConnection(Collection<Request> collection) {
        Validate.notEmptyAndContainsNoNulls(collection, "requests");
        return Request.toHttpConnection(new RequestBatch(collection));
    }

    public static HttpURLConnection toHttpConnection(Request ... requestArray) {
        return Request.toHttpConnection(Arrays.asList(requestArray));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static <T extends GraphObject> List<T> typedListFromResponse(Response response, Class<T> clazz) {
        GraphObjectList<GraphObject> graphObjectList;
        GraphMultiResult graphMultiResult = response.getGraphObjectAs(GraphMultiResult.class);
        if (graphMultiResult == null || (graphObjectList = graphMultiResult.getData()) == null) {
            return null;
        }
        return graphObjectList.castToListOf(clazz);
    }

    private void validate() {
        if (this.graphPath != null && this.restMethod != null) {
            throw new IllegalArgumentException("Only one of a graph path or REST method may be specified per request.");
        }
    }

    public final Response executeAndWait() {
        return Request.executeAndWait(this);
    }

    public final RequestAsyncTask executeAsync() {
        return Request.executeBatchAsync(this);
    }

    public final String getBatchEntryDependsOn() {
        return this.batchEntryDependsOn;
    }

    public final String getBatchEntryName() {
        return this.batchEntryName;
    }

    public final boolean getBatchEntryOmitResultOnSuccess() {
        return this.batchEntryOmitResultOnSuccess;
    }

    public final Callback getCallback() {
        return this.callback;
    }

    public final GraphObject getGraphObject() {
        return this.graphObject;
    }

    public final String getGraphPath() {
        return this.graphPath;
    }

    public final HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public final Bundle getParameters() {
        return this.parameters;
    }

    public final String getRestMethod() {
        return this.restMethod;
    }

    public final Session getSession() {
        return this.session;
    }

    public final Object getTag() {
        return this.tag;
    }

    /*
     * Enabled aggressive block sorting
     */
    final String getUrlForBatchedRequest() {
        if (this.overriddenURL != null) {
            throw new FacebookException("Can't override URL for a batch request");
        }
        String string2 = this.restMethod != null ? "method/" + this.restMethod : this.graphPath;
        this.addCommonParameters();
        return this.appendParametersToBaseUrl(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    final String getUrlForSingleRequest() {
        String string2;
        if (this.overriddenURL != null) {
            return this.overriddenURL.toString();
        }
        if (this.restMethod != null) {
            Object[] objectArray = new Object[]{ServerProtocol.getRestUrlBase(), this.restMethod};
            string2 = String.format("%s/%s", objectArray);
        } else {
            Object[] objectArray = new Object[]{ServerProtocol.getGraphUrlBase(), this.graphPath};
            string2 = String.format("%s/%s", objectArray);
        }
        this.addCommonParameters();
        return this.appendParametersToBaseUrl(string2);
    }

    public final void setBatchEntryDependsOn(String string2) {
        this.batchEntryDependsOn = string2;
    }

    public final void setBatchEntryName(String string2) {
        this.batchEntryName = string2;
    }

    public final void setBatchEntryOmitResultOnSuccess(boolean bl2) {
        this.batchEntryOmitResultOnSuccess = bl2;
    }

    public final void setCallback(Callback callback) {
        this.callback = callback;
    }

    public final void setGraphObject(GraphObject graphObject) {
        this.graphObject = graphObject;
    }

    public final void setGraphPath(String string2) {
        this.graphPath = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setHttpMethod(HttpMethod httpMethod) {
        if (this.overriddenURL != null && httpMethod != HttpMethod.GET) {
            throw new FacebookException("Can't change HTTP method on request with overridden URL.");
        }
        if (httpMethod == null) {
            httpMethod = HttpMethod.GET;
        }
        this.httpMethod = httpMethod;
    }

    public final void setParameters(Bundle bundle) {
        this.parameters = bundle;
    }

    public final void setRestMethod(String string2) {
        this.restMethod = string2;
    }

    public final void setSession(Session session) {
        this.session = session;
    }

    public final void setTag(Object object) {
        this.tag = object;
    }

    public String toString() {
        return "{Request: " + " session: " + this.session + ", graphPath: " + this.graphPath + ", graphObject: " + this.graphObject + ", restMethod: " + this.restMethod + ", httpMethod: " + (Object)((Object)this.httpMethod) + ", parameters: " + this.parameters + "}";
    }

    public static interface Callback {
        public void onCompleted(Response var1);
    }

    public static interface GraphPlaceListCallback {
        public void onCompleted(List<GraphPlace> var1, Response var2);
    }

    public static interface GraphUserCallback {
        public void onCompleted(GraphUser var1, Response var2);
    }

    public static interface GraphUserListCallback {
        public void onCompleted(List<GraphUser> var1, Response var2);
    }

    private static interface KeyValueSerializer {
        public void writeString(String var1, String var2) throws IOException;
    }

    private static class ParcelFileDescriptorWithMimeType
    implements Parcelable {
        public static final Parcelable.Creator<ParcelFileDescriptorWithMimeType> CREATOR = new Parcelable.Creator<ParcelFileDescriptorWithMimeType>(){

            public ParcelFileDescriptorWithMimeType createFromParcel(Parcel parcel) {
                return new ParcelFileDescriptorWithMimeType(parcel);
            }

            public ParcelFileDescriptorWithMimeType[] newArray(int n2) {
                return new ParcelFileDescriptorWithMimeType[n2];
            }
        };
        private final ParcelFileDescriptor fileDescriptor;
        private final String mimeType;

        private ParcelFileDescriptorWithMimeType(Parcel parcel) {
            this.mimeType = parcel.readString();
            this.fileDescriptor = parcel.readFileDescriptor();
        }

        public ParcelFileDescriptorWithMimeType(ParcelFileDescriptor parcelFileDescriptor, String string2) {
            this.mimeType = string2;
            this.fileDescriptor = parcelFileDescriptor;
        }

        public int describeContents() {
            return 1;
        }

        public ParcelFileDescriptor getFileDescriptor() {
            return this.fileDescriptor;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeString(this.mimeType);
            parcel.writeFileDescriptor(this.fileDescriptor.getFileDescriptor());
        }
    }

    private static class Serializer
    implements KeyValueSerializer {
        private boolean firstWrite = true;
        private final Logger logger;
        private final BufferedOutputStream outputStream;

        public Serializer(BufferedOutputStream bufferedOutputStream, Logger logger) {
            this.outputStream = bufferedOutputStream;
            this.logger = logger;
        }

        public void write(String string2, Object ... objectArray) throws IOException {
            if (this.firstWrite) {
                this.outputStream.write("--".getBytes());
                this.outputStream.write(Request.MIME_BOUNDARY.getBytes());
                this.outputStream.write("\r\n".getBytes());
                this.firstWrite = false;
            }
            this.outputStream.write(String.format(string2, objectArray).getBytes());
        }

        public void writeBitmap(String string2, Bitmap bitmap) throws IOException {
            this.writeContentDisposition(string2, string2, "image/png");
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)this.outputStream);
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            this.logger.appendKeyValue("    " + string2, "<Image>");
        }

        public void writeBytes(String string2, byte[] byArray) throws IOException {
            this.writeContentDisposition(string2, string2, "content/unknown");
            this.outputStream.write(byArray);
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            Logger logger = this.logger;
            String string3 = "    " + string2;
            Object[] objectArray = new Object[]{byArray.length};
            logger.appendKeyValue(string3, String.format("<Data: %d>", objectArray));
        }

        public void writeContentDisposition(String string2, String string3, String string4) throws IOException {
            this.write("Content-Disposition: form-data; name=\"%s\"", string2);
            if (string3 != null) {
                this.write("; filename=\"%s\"", string3);
            }
            this.writeLine("", new Object[0]);
            if (string4 != null) {
                this.writeLine("%s: %s", Request.CONTENT_TYPE_HEADER, string4);
            }
            this.writeLine("", new Object[0]);
        }

        /*
         * Unable to fully structure code
         */
        public void writeFile(String var1_1, ParcelFileDescriptor var2_2, String var3_3) throws IOException {
            if (var3_3 == null) {
                var3_3 = "content/unknown";
            }
            this.writeContentDisposition(var1_1, var1_1, var3_3);
            var4_4 = null;
            var5_5 = null;
            var6_6 = 0;
            var7_7 = new ParcelFileDescriptor.AutoCloseInputStream(var2_2);
            var8_8 = new BufferedInputStream((InputStream)var7_7);
            try {
                var10_9 = new byte[8192];
                ** while ((var11_10 = var8_8.read((byte[])var10_9)) != -1)
            }
            catch (Throwable var9_17) {
                var5_5 = var8_8;
                var4_4 = var7_7;
                ** continue;
            }
lbl-1000:
            // 1 sources

            {
                this.outputStream.write(var10_9, 0, var11_10);
                var6_6 += var11_10;
                continue;
            }
lbl18:
            // 1 sources

            if (var8_8 != null) {
                var8_8.close();
            }
            if (var7_7 != null) {
                var7_7.close();
            }
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            var12_11 = this.logger;
            var13_12 = "    " + var1_1;
            var14_13 = new Object[]{var6_6};
            var12_11.appendKeyValue(var13_12, String.format("<Data: %d>", var14_13));
            return;
            catch (Throwable var9_14) lbl-1000:
            // 3 sources

            {
                while (true) {
                    if (var5_5 != null) {
                        var5_5.close();
                    }
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    throw var9_15;
                }
            }
            catch (Throwable var9_16) {
                var4_4 = var7_7;
                var5_5 = null;
                ** GOTO lbl-1000
            }
        }

        public void writeFile(String string2, ParcelFileDescriptorWithMimeType parcelFileDescriptorWithMimeType) throws IOException {
            this.writeFile(string2, parcelFileDescriptorWithMimeType.getFileDescriptor(), parcelFileDescriptorWithMimeType.getMimeType());
        }

        public void writeLine(String string2, Object ... objectArray) throws IOException {
            this.write(string2, objectArray);
            this.write("\r\n", new Object[0]);
        }

        public void writeObject(String string2, Object object) throws IOException {
            if (Request.isSupportedParameterType(object)) {
                this.writeString(string2, Request.parameterToString(object));
                return;
            }
            if (object instanceof Bitmap) {
                this.writeBitmap(string2, (Bitmap)object);
                return;
            }
            if (object instanceof byte[]) {
                this.writeBytes(string2, (byte[])object);
                return;
            }
            if (object instanceof ParcelFileDescriptor) {
                this.writeFile(string2, (ParcelFileDescriptor)object, null);
                return;
            }
            if (object instanceof ParcelFileDescriptorWithMimeType) {
                this.writeFile(string2, (ParcelFileDescriptorWithMimeType)object);
                return;
            }
            throw new IllegalArgumentException("value is not a supported type: String, Bitmap, byte[]");
        }

        public void writeRecordBoundary() throws IOException {
            this.writeLine("--%s", Request.MIME_BOUNDARY);
        }

        @Override
        public void writeString(String string2, String string3) throws IOException {
            this.writeContentDisposition(string2, null, null);
            this.writeLine("%s", string3);
            this.writeRecordBoundary();
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + string2, string3);
            }
        }
    }
}

