/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.facebook.FacebookException;
import com.facebook.NativeAppCallContentProvider;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public final class NativeAppCallAttachmentStore
implements NativeAppCallContentProvider.AttachmentDataSource {
    static final String ATTACHMENTS_DIR_NAME = "com.facebook.NativeAppCallAttachmentStore.files";
    private static final String TAG = NativeAppCallAttachmentStore.class.getName();
    private static File attachmentsDirectory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> void addAttachments(Context context, UUID uUID, Map<String, T> map, ProcessAttachment<T> processAttachment) {
        if (map.size() == 0) return;
        if (attachmentsDirectory == null) {
            this.cleanupAllAttachments(context);
        }
        this.ensureAttachmentsDirectoryExists(context);
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            for (Map.Entry<String, T> entry : map.entrySet()) {
                String string2 = entry.getKey();
                T t2 = entry.getValue();
                File file = this.getAttachmentFile(uUID, string2, true);
                arrayList.add(file);
                processAttachment.processAttachment(t2, file);
            }
            return;
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)("Got unexpected exception:" + iOException));
            Iterator iterator = arrayList.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw new FacebookException(iOException);
                }
                File file = (File)iterator.next();
                try {
                    file.delete();
                }
                catch (Exception exception) {
                }
            }
        }
    }

    static File getAttachmentsDirectory(Context context) {
        synchronized (NativeAppCallAttachmentStore.class) {
            if (attachmentsDirectory == null) {
                attachmentsDirectory = new File(context.getCacheDir(), ATTACHMENTS_DIR_NAME);
            }
            File file = attachmentsDirectory;
            return file;
        }
    }

    public void addAttachmentFilesForCall(Context context, UUID uUID, Map<String, File> map) {
        Validate.notNull(context, "context");
        Validate.notNull(uUID, "callId");
        Validate.containsNoNulls(map.values(), "imageAttachmentFiles");
        Validate.containsNoNullOrEmpty(map.keySet(), "imageAttachmentFiles");
        this.addAttachments(context, uUID, map, new ProcessAttachment<File>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void processAttachment(File var1_1, File var2_2) throws IOException {
                var3_3 = new FileOutputStream(var2_2);
                var4_4 = new FileInputStream(var1_1);
                var7_5 = new byte[1024];
                ** while ((var8_6 = var4_4.read((byte[])var7_5)) > 0)
                {
                    catch (Throwable var5_7) {
                        var6_10 = var4_4;
lbl9:
                        // 2 sources

                        while (true) {
                            Utility.closeQuietly(var3_3);
                            Utility.closeQuietly(var6_10);
                            throw var5_8;
                        }
                    }
lbl14:
                    // 2 sources

                    var3_3.write(var7_5, 0, var8_6);
                    continue;
                }
lbl16:
                // 1 sources

                Utility.closeQuietly(var3_3);
                Utility.closeQuietly(var4_4);
                return;
                catch (Throwable var5_9) {
                    var6_10 = null;
                    ** continue;
                }
            }
        });
    }

    public void addAttachmentsForCall(Context context, UUID uUID, Map<String, Bitmap> map) {
        Validate.notNull(context, "context");
        Validate.notNull(uUID, "callId");
        Validate.containsNoNulls(map.values(), "imageAttachments");
        Validate.containsNoNullOrEmpty(map.keySet(), "imageAttachments");
        this.addAttachments(context, uUID, map, new ProcessAttachment<Bitmap>(){

            @Override
            public void processAttachment(Bitmap bitmap, File file) throws IOException {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
                    return;
                }
                finally {
                    Utility.closeQuietly(fileOutputStream);
                }
            }
        });
    }

    void cleanupAllAttachments(Context context) {
        Utility.deleteDirectory(NativeAppCallAttachmentStore.getAttachmentsDirectory(context));
    }

    public void cleanupAttachmentsForCall(Context context, UUID uUID) {
        Utility.deleteDirectory(this.getAttachmentsDirectoryForCall(uUID, false));
    }

    File ensureAttachmentsDirectoryExists(Context context) {
        File file = NativeAppCallAttachmentStore.getAttachmentsDirectory(context);
        file.mkdirs();
        return file;
    }

    File getAttachmentFile(UUID uUID, String string2, boolean bl2) throws IOException {
        File file = this.getAttachmentsDirectoryForCall(uUID, bl2);
        if (file == null) {
            return null;
        }
        try {
            File file2 = new File(file, URLEncoder.encode(string2, "UTF-8"));
            return file2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    File getAttachmentsDirectoryForCall(UUID uUID, boolean bl2) {
        if (attachmentsDirectory == null) {
            return null;
        }
        File file = new File(attachmentsDirectory, uUID.toString());
        if (!bl2) return file;
        if (file.exists()) return file;
        file.mkdirs();
        return file;
    }

    @Override
    public File openAttachment(UUID uUID, String string2) throws FileNotFoundException {
        if (Utility.isNullOrEmpty(string2) || uUID == null) {
            throw new FileNotFoundException();
        }
        try {
            File file = this.getAttachmentFile(uUID, string2, false);
            return file;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException();
        }
    }

    static interface ProcessAttachment<T> {
        public void processAttachment(T var1, File var2) throws IOException;
    }
}

