/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.facebook.AuthorizationClient;
import com.facebook.android.R;
import java.io.Serializable;

public class LoginActivity
extends Activity {
    private static final String EXTRA_REQUEST = "request";
    private static final String NULL_CALLING_PKG_ERROR_MSG = "Cannot call LoginActivity with a null calling package. This can occur if the launchMode of the caller is singleInstance.";
    static final String RESULT_KEY = "com.facebook.LoginActivity:Result";
    private static final String SAVED_AUTH_CLIENT = "authorizationClient";
    private static final String SAVED_CALLING_PKG_KEY = "callingPackage";
    private static final String TAG = LoginActivity.class.getName();
    private AuthorizationClient authorizationClient;
    private String callingPackage;
    private AuthorizationClient.AuthorizationRequest request;

    /*
     * Enabled aggressive block sorting
     */
    private void onAuthClientCompleted(AuthorizationClient.Result result) {
        this.request = null;
        int n2 = result.code == AuthorizationClient.Result.Code.CANCEL ? 0 : -1;
        Bundle bundle = new Bundle();
        bundle.putSerializable(RESULT_KEY, (Serializable)result);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        this.setResult(n2, intent);
        this.finish();
    }

    static Bundle populateIntentExtras(AuthorizationClient.AuthorizationRequest authorizationRequest) {
        Bundle bundle = new Bundle();
        bundle.putSerializable(EXTRA_REQUEST, (Serializable)authorizationRequest);
        return bundle;
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        this.authorizationClient.onActivityResult(n2, n3, intent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.com_facebook_login_activity_layout);
        if (bundle != null) {
            this.callingPackage = bundle.getString(SAVED_CALLING_PKG_KEY);
            this.authorizationClient = (AuthorizationClient)bundle.getSerializable(SAVED_AUTH_CLIENT);
        } else {
            this.callingPackage = this.getCallingPackage();
            this.authorizationClient = new AuthorizationClient();
            this.request = (AuthorizationClient.AuthorizationRequest)this.getIntent().getSerializableExtra(EXTRA_REQUEST);
        }
        this.authorizationClient.setContext(this);
        this.authorizationClient.setOnCompletedListener(new AuthorizationClient.OnCompletedListener(){

            @Override
            public void onCompleted(AuthorizationClient.Result result) {
                LoginActivity.this.onAuthClientCompleted(result);
            }
        });
        this.authorizationClient.setBackgroundProcessingListener(new AuthorizationClient.BackgroundProcessingListener(){

            @Override
            public void onBackgroundProcessingStarted() {
                LoginActivity.this.findViewById(R.id.com_facebook_login_activity_progress_bar).setVisibility(0);
            }

            @Override
            public void onBackgroundProcessingStopped() {
                LoginActivity.this.findViewById(R.id.com_facebook_login_activity_progress_bar).setVisibility(8);
            }
        });
    }

    public void onPause() {
        super.onPause();
        this.authorizationClient.cancelCurrentHandler();
        this.findViewById(R.id.com_facebook_login_activity_progress_bar).setVisibility(8);
    }

    public void onResume() {
        super.onResume();
        if (this.callingPackage == null) {
            Log.e((String)TAG, (String)NULL_CALLING_PKG_ERROR_MSG);
            this.finish();
            return;
        }
        this.authorizationClient.startOrContinueAuth(this.request);
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putString(SAVED_CALLING_PKG_KEY, this.callingPackage);
        bundle.putSerializable(SAVED_AUTH_CLIENT, (Serializable)this.authorizationClient);
    }
}

