/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import com.facebook.FacebookException;
import com.facebook.FacebookServiceException;
import com.facebook.android.R;
import com.facebook.internal.Utility;
import java.net.HttpURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public final class FacebookRequestError {
    private static final String BODY_KEY = "body";
    private static final String CODE_KEY = "code";
    private static final int EC_APP_NOT_INSTALLED = 458;
    private static final int EC_APP_TOO_MANY_CALLS = 4;
    private static final int EC_EXPIRED = 463;
    private static final int EC_INVALID_SESSION = 102;
    private static final int EC_INVALID_TOKEN = 190;
    private static final int EC_PASSWORD_CHANGED = 460;
    private static final int EC_PERMISSION_DENIED = 10;
    private static final Range EC_RANGE_PERMISSION = new Range(200, 299);
    private static final int EC_SERVICE_UNAVAILABLE = 2;
    private static final int EC_UNCONFIRMED_USER = 464;
    private static final int EC_UNKNOWN_ERROR = 1;
    private static final int EC_USER_CHECKPOINTED = 459;
    private static final int EC_USER_TOO_MANY_CALLS = 17;
    private static final String ERROR_CODE_FIELD_KEY = "code";
    private static final String ERROR_CODE_KEY = "error_code";
    private static final String ERROR_KEY = "error";
    private static final String ERROR_MESSAGE_FIELD_KEY = "message";
    private static final String ERROR_MSG_KEY = "error_msg";
    private static final String ERROR_REASON_KEY = "error_reason";
    private static final String ERROR_SUB_CODE_KEY = "error_subcode";
    private static final String ERROR_TYPE_FIELD_KEY = "type";
    private static final Range HTTP_RANGE_CLIENT_ERROR;
    private static final Range HTTP_RANGE_SERVER_ERROR;
    private static final Range HTTP_RANGE_SUCCESS;
    public static final int INVALID_ERROR_CODE = -1;
    public static final int INVALID_HTTP_STATUS_CODE = -1;
    private static final int INVALID_MESSAGE_ID;
    private final Object batchRequestResult;
    private final Category category;
    private final HttpURLConnection connection;
    private final int errorCode;
    private final String errorMessage;
    private final String errorType;
    private final FacebookException exception;
    private final JSONObject requestResult;
    private final JSONObject requestResultBody;
    private final int requestStatusCode;
    private final boolean shouldNotifyUser;
    private final int subErrorCode;
    private final int userActionMessageId;

    static {
        HTTP_RANGE_SUCCESS = new Range(200, 299);
        HTTP_RANGE_CLIENT_ERROR = new Range(400, 499);
        HTTP_RANGE_SERVER_ERROR = new Range(500, 599);
    }

    private FacebookRequestError(int n2, int n3, int n4, String string2, String string3, JSONObject jSONObject, JSONObject jSONObject2, Object object, HttpURLConnection httpURLConnection) {
        this(n2, n3, n4, string2, string3, jSONObject, jSONObject2, object, httpURLConnection, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private FacebookRequestError(int n2, int n3, int n4, String string2, String string3, JSONObject jSONObject, JSONObject jSONObject2, Object object, HttpURLConnection httpURLConnection, FacebookException facebookException) {
        Category category;
        boolean bl2;
        int n5;
        block13: {
            block15: {
                block18: {
                    block17: {
                        block16: {
                            block14: {
                                block12: {
                                    boolean bl3;
                                    this.requestStatusCode = n2;
                                    this.errorCode = n3;
                                    this.subErrorCode = n4;
                                    this.errorType = string2;
                                    this.errorMessage = string3;
                                    this.requestResultBody = jSONObject;
                                    this.requestResult = jSONObject2;
                                    this.batchRequestResult = object;
                                    this.connection = httpURLConnection;
                                    if (facebookException != null) {
                                        this.exception = facebookException;
                                        bl3 = true;
                                    } else {
                                        this.exception = new FacebookServiceException(this, string3);
                                        bl3 = false;
                                    }
                                    n5 = 0;
                                    bl2 = false;
                                    if (!bl3) break block12;
                                    category = Category.CLIENT;
                                    n5 = 0;
                                    break block13;
                                }
                                if (n3 != 1 && n3 != 2) break block14;
                                category = Category.SERVER;
                                break block15;
                            }
                            if (n3 != 4 && n3 != 17) break block16;
                            category = Category.THROTTLING;
                            n5 = 0;
                            bl2 = false;
                            break block15;
                        }
                        if (n3 != 10 && !EC_RANGE_PERMISSION.contains(n3)) break block17;
                        category = Category.PERMISSION;
                        n5 = R.string.com_facebook_requesterror_permissions;
                        bl2 = false;
                        break block15;
                    }
                    if (n3 == 102) break block18;
                    category = null;
                    n5 = 0;
                    bl2 = false;
                    if (n3 != 190) break block15;
                }
                if (n4 == 459 || n4 == 464) {
                    category = Category.AUTHENTICATION_RETRY;
                    n5 = R.string.com_facebook_requesterror_web_login;
                    bl2 = true;
                } else {
                    category = Category.AUTHENTICATION_REOPEN_SESSION;
                    if (n4 == 458 || n4 == 463) {
                        n5 = R.string.com_facebook_requesterror_relogin;
                        bl2 = false;
                    } else if (n4 == 460) {
                        n5 = R.string.com_facebook_requesterror_password_changed;
                        bl2 = false;
                    } else {
                        n5 = R.string.com_facebook_requesterror_reconnect;
                        bl2 = true;
                    }
                }
            }
            if (category == null) {
                category = HTTP_RANGE_CLIENT_ERROR.contains(n2) ? Category.BAD_REQUEST : (HTTP_RANGE_SERVER_ERROR.contains(n2) ? Category.SERVER : Category.OTHER);
            }
        }
        this.category = category;
        this.userActionMessageId = n5;
        this.shouldNotifyUser = bl2;
    }

    public FacebookRequestError(int n2, String string2, String string3) {
        this(-1, n2, -1, string2, string3, null, null, null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    FacebookRequestError(HttpURLConnection httpURLConnection, Exception exception) {
        FacebookException facebookException = exception instanceof FacebookException ? (FacebookException)exception : new FacebookException(exception);
        this(-1, -1, -1, null, null, null, null, null, httpURLConnection, facebookException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static FacebookRequestError checkResponseAndCreateError(JSONObject jSONObject, Object object, HttpURLConnection httpURLConnection) {
        try {
            int n2;
            block6: {
                boolean bl2;
                String string2;
                String string3;
                int n3;
                int n4;
                JSONObject jSONObject2;
                block8: {
                    block9: {
                        block7: {
                            if (!jSONObject.has("code")) return null;
                            n2 = jSONObject.getInt("code");
                            Object object2 = Utility.getStringPropertyAsJSON(jSONObject, BODY_KEY, "FACEBOOK_NON_JSON_RESULT");
                            if (object2 == null || !(object2 instanceof JSONObject)) break block6;
                            jSONObject2 = (JSONObject)object2;
                            n4 = -1;
                            n3 = -1;
                            if (!jSONObject2.has(ERROR_KEY)) break block7;
                            JSONObject jSONObject3 = (JSONObject)Utility.getStringPropertyAsJSON(jSONObject2, ERROR_KEY, null);
                            string3 = jSONObject3.optString(ERROR_TYPE_FIELD_KEY, null);
                            string2 = jSONObject3.optString(ERROR_MESSAGE_FIELD_KEY, null);
                            n4 = jSONObject3.optInt("code", -1);
                            n3 = jSONObject3.optInt(ERROR_SUB_CODE_KEY, -1);
                            bl2 = true;
                            break block8;
                        }
                        if (jSONObject2.has(ERROR_CODE_KEY) || jSONObject2.has(ERROR_MSG_KEY)) break block9;
                        boolean bl3 = jSONObject2.has(ERROR_REASON_KEY);
                        string3 = null;
                        string2 = null;
                        bl2 = false;
                        if (!bl3) break block8;
                    }
                    string3 = jSONObject2.optString(ERROR_REASON_KEY, null);
                    string2 = jSONObject2.optString(ERROR_MSG_KEY, null);
                    n4 = jSONObject2.optInt(ERROR_CODE_KEY, -1);
                    n3 = jSONObject2.optInt(ERROR_SUB_CODE_KEY, -1);
                    bl2 = true;
                }
                if (bl2) {
                    return new FacebookRequestError(n2, n4, n3, string3, string2, jSONObject2, jSONObject, object, httpURLConnection);
                }
            }
            if (HTTP_RANGE_SUCCESS.contains(n2)) return null;
            JSONObject jSONObject4 = jSONObject.has(BODY_KEY) ? (JSONObject)Utility.getStringPropertyAsJSON(jSONObject, BODY_KEY, "FACEBOOK_NON_JSON_RESULT") : null;
            return new FacebookRequestError(n2, -1, -1, null, null, jSONObject4, jSONObject, object, httpURLConnection);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    public Object getBatchRequestResult() {
        return this.batchRequestResult;
    }

    public Category getCategory() {
        return this.category;
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        return this.exception.getLocalizedMessage();
    }

    public String getErrorType() {
        return this.errorType;
    }

    public FacebookException getException() {
        return this.exception;
    }

    public JSONObject getRequestResult() {
        return this.requestResult;
    }

    public JSONObject getRequestResultBody() {
        return this.requestResultBody;
    }

    public int getRequestStatusCode() {
        return this.requestStatusCode;
    }

    public int getSubErrorCode() {
        return this.subErrorCode;
    }

    public int getUserActionMessageId() {
        return this.userActionMessageId;
    }

    public boolean shouldNotifyUser() {
        return this.shouldNotifyUser;
    }

    public String toString() {
        return "{HttpStatus: " + this.requestStatusCode + ", errorCode: " + this.errorCode + ", errorType: " + this.errorType + ", errorMessage: " + this.getErrorMessage() + "}";
    }

    public static final class Category
    extends Enum<Category> {
        private static final /* synthetic */ Category[] $VALUES;
        public static final /* enum */ Category AUTHENTICATION_REOPEN_SESSION;
        public static final /* enum */ Category AUTHENTICATION_RETRY;
        public static final /* enum */ Category BAD_REQUEST;
        public static final /* enum */ Category CLIENT;
        public static final /* enum */ Category OTHER;
        public static final /* enum */ Category PERMISSION;
        public static final /* enum */ Category SERVER;
        public static final /* enum */ Category THROTTLING;

        static {
            AUTHENTICATION_RETRY = new Category();
            AUTHENTICATION_REOPEN_SESSION = new Category();
            PERMISSION = new Category();
            SERVER = new Category();
            THROTTLING = new Category();
            OTHER = new Category();
            BAD_REQUEST = new Category();
            CLIENT = new Category();
            Category[] categoryArray = new Category[]{AUTHENTICATION_RETRY, AUTHENTICATION_REOPEN_SESSION, PERMISSION, SERVER, THROTTLING, OTHER, BAD_REQUEST, CLIENT};
            $VALUES = categoryArray;
        }

        public static Category valueOf(String string2) {
            return Enum.valueOf(Category.class, string2);
        }

        public static Category[] values() {
            return (Category[])$VALUES.clone();
        }
    }

    private static class Range {
        private final int end;
        private final int start;

        private Range(int n2, int n3) {
            this.start = n2;
            this.end = n3;
        }

        boolean contains(int n2) {
            return this.start <= n2 && n2 <= this.end;
        }
    }
}

