/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.CookieSyncManager;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.AppEventsLogger;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookServiceException;
import com.facebook.GetTokenClient;
import com.facebook.HttpMethod;
import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Response;
import com.facebook.SessionDefaultAudience;
import com.facebook.SessionLoginBehavior;
import com.facebook.android.R;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.PlatformServiceClient;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.model.GraphMultiResult;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.model.GraphUser;
import com.facebook.widget.WebDialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class AuthorizationClient
implements Serializable {
    static final String EVENT_EXTRAS_APP_CALL_ID = "call_id";
    static final String EVENT_EXTRAS_DEFAULT_AUDIENCE = "default_audience";
    static final String EVENT_EXTRAS_IS_LEGACY = "is_legacy";
    static final String EVENT_EXTRAS_LOGIN_BEHAVIOR = "login_behavior";
    static final String EVENT_EXTRAS_MISSING_INTERNET_PERMISSION = "no_internet_permission";
    static final String EVENT_EXTRAS_NEW_PERMISSIONS = "new_permissions";
    static final String EVENT_EXTRAS_NOT_TRIED = "not_tried";
    static final String EVENT_EXTRAS_PERMISSIONS = "permissions";
    static final String EVENT_EXTRAS_PROTOCOL_VERSION = "protocol_version";
    static final String EVENT_EXTRAS_REQUEST_CODE = "request_code";
    static final String EVENT_EXTRAS_SERVICE_DISABLED = "service_disabled";
    static final String EVENT_EXTRAS_TRY_LEGACY = "try_legacy";
    static final String EVENT_EXTRAS_TRY_LOGIN_ACTIVITY = "try_login_activity";
    static final String EVENT_EXTRAS_WRITE_PRIVACY = "write_privacy";
    static final String EVENT_NAME_LOGIN_COMPLETE = "fb_mobile_login_complete";
    private static final String EVENT_NAME_LOGIN_METHOD_COMPLETE = "fb_mobile_login_method_complete";
    private static final String EVENT_NAME_LOGIN_METHOD_START = "fb_mobile_login_method_start";
    static final String EVENT_NAME_LOGIN_START = "fb_mobile_login_start";
    static final String EVENT_PARAM_AUTH_LOGGER_ID = "0_auth_logger_id";
    static final String EVENT_PARAM_ERROR_CODE = "4_error_code";
    static final String EVENT_PARAM_ERROR_MESSAGE = "5_error_message";
    static final String EVENT_PARAM_EXTRAS = "6_extras";
    static final String EVENT_PARAM_LOGIN_RESULT = "2_result";
    static final String EVENT_PARAM_METHOD = "3_method";
    private static final String EVENT_PARAM_METHOD_RESULT_SKIPPED = "skipped";
    static final String EVENT_PARAM_TIMESTAMP = "1_timestamp_ms";
    private static final String TAG = "Facebook-AuthorizationClient";
    private static final String WEB_VIEW_AUTH_HANDLER_STORE = "com.facebook.AuthorizationClient.WebViewAuthHandler.TOKEN_STORE_KEY";
    private static final String WEB_VIEW_AUTH_HANDLER_TOKEN_KEY = "TOKEN";
    private static final long serialVersionUID = 1L;
    private transient AppEventsLogger appEventsLogger;
    transient BackgroundProcessingListener backgroundProcessingListener;
    transient boolean checkedInternetPermission;
    transient Context context;
    AuthHandler currentHandler;
    List<AuthHandler> handlersToTry;
    Map<String, String> loggingExtras;
    transient OnCompletedListener onCompletedListener;
    AuthorizationRequest pendingRequest;
    transient StartActivityDelegate startActivityDelegate;

    AuthorizationClient() {
    }

    private void addLoggingExtra(String string2, String string3, boolean bl2) {
        if (this.loggingExtras == null) {
            this.loggingExtras = new HashMap<String, String>();
        }
        if (this.loggingExtras.containsKey(string2) && bl2) {
            string3 = this.loggingExtras.get(string2) + "," + string3;
        }
        this.loggingExtras.put(string2, string3);
    }

    private void completeWithFailure() {
        this.complete(Result.createErrorResult(this.pendingRequest, "Login attempt failed.", null));
    }

    private AppEventsLogger getAppEventsLogger() {
        if (this.appEventsLogger == null || this.appEventsLogger.getApplicationId() != this.pendingRequest.getApplicationId()) {
            this.appEventsLogger = AppEventsLogger.newLogger(this.context, this.pendingRequest.getApplicationId());
        }
        return this.appEventsLogger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getE2E() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("init", System.currentTimeMillis());
        }
        catch (JSONException jSONException) {
            return jSONObject.toString();
        }
        return jSONObject.toString();
    }

    private List<AuthHandler> getHandlerTypes(AuthorizationRequest authorizationRequest) {
        ArrayList<AuthHandler> arrayList = new ArrayList<AuthHandler>();
        SessionLoginBehavior sessionLoginBehavior = authorizationRequest.getLoginBehavior();
        if (sessionLoginBehavior.allowsKatanaAuth()) {
            if (!authorizationRequest.isLegacy()) {
                arrayList.add(new GetTokenAuthHandler());
                arrayList.add(new KatanaLoginDialogAuthHandler());
            }
            arrayList.add(new KatanaProxyAuthHandler());
        }
        if (sessionLoginBehavior.allowsWebViewAuth()) {
            arrayList.add(new WebViewAuthHandler());
        }
        return arrayList;
    }

    private void logAuthorizationMethodComplete(String string2, Result result, Map<String, String> map) {
        this.logAuthorizationMethodComplete(string2, result.code.getLoggingValue(), result.errorMessage, result.errorCode, map);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void logAuthorizationMethodComplete(String string2, String string3, String string4, String string5, Map<String, String> map) {
        Bundle bundle;
        if (this.pendingRequest == null) {
            bundle = AuthorizationClient.newAuthorizationLoggingBundle("");
            bundle.putString(EVENT_PARAM_LOGIN_RESULT, Result.Code.ERROR.getLoggingValue());
            bundle.putString(EVENT_PARAM_ERROR_MESSAGE, "Unexpected call to logAuthorizationMethodComplete with null pendingRequest.");
        } else {
            bundle = AuthorizationClient.newAuthorizationLoggingBundle(this.pendingRequest.getAuthId());
            if (string3 != null) {
                bundle.putString(EVENT_PARAM_LOGIN_RESULT, string3);
            }
            if (string4 != null) {
                bundle.putString(EVENT_PARAM_ERROR_MESSAGE, string4);
            }
            if (string5 != null) {
                bundle.putString(EVENT_PARAM_ERROR_CODE, string5);
            }
            if (map != null && !map.isEmpty()) {
                bundle.putString(EVENT_PARAM_EXTRAS, new JSONObject(map).toString());
            }
        }
        bundle.putString(EVENT_PARAM_METHOD, string2);
        bundle.putLong(EVENT_PARAM_TIMESTAMP, System.currentTimeMillis());
        this.getAppEventsLogger().logSdkEvent(EVENT_NAME_LOGIN_METHOD_COMPLETE, null, bundle);
    }

    private void logAuthorizationMethodStart(String string2) {
        Bundle bundle = AuthorizationClient.newAuthorizationLoggingBundle(this.pendingRequest.getAuthId());
        bundle.putLong(EVENT_PARAM_TIMESTAMP, System.currentTimeMillis());
        bundle.putString(EVENT_PARAM_METHOD, string2);
        this.getAppEventsLogger().logSdkEvent(EVENT_NAME_LOGIN_METHOD_START, null, bundle);
    }

    private void logWebLoginCompleted(String string2, String string3) {
        AppEventsLogger appEventsLogger = AppEventsLogger.newLogger(this.context, string2);
        Bundle bundle = new Bundle();
        bundle.putString("fb_web_login_e2e", string3);
        bundle.putLong("fb_web_login_switchback_time", System.currentTimeMillis());
        bundle.putString("app_id", string2);
        appEventsLogger.logSdkEvent("fb_dialogs_web_login_dialog_complete", null, bundle);
    }

    static Bundle newAuthorizationLoggingBundle(String string2) {
        Bundle bundle = new Bundle();
        bundle.putLong(EVENT_PARAM_TIMESTAMP, System.currentTimeMillis());
        bundle.putString(EVENT_PARAM_AUTH_LOGGER_ID, string2);
        bundle.putString(EVENT_PARAM_METHOD, "");
        bundle.putString(EVENT_PARAM_LOGIN_RESULT, "");
        bundle.putString(EVENT_PARAM_ERROR_MESSAGE, "");
        bundle.putString(EVENT_PARAM_ERROR_CODE, "");
        bundle.putString(EVENT_PARAM_EXTRAS, "");
        return bundle;
    }

    private void notifyBackgroundProcessingStart() {
        if (this.backgroundProcessingListener != null) {
            this.backgroundProcessingListener.onBackgroundProcessingStarted();
        }
    }

    private void notifyBackgroundProcessingStop() {
        if (this.backgroundProcessingListener != null) {
            this.backgroundProcessingListener.onBackgroundProcessingStopped();
        }
    }

    private void notifyOnCompleteListener(Result result) {
        if (this.onCompletedListener != null) {
            this.onCompletedListener.onCompleted(result);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void authorize(AuthorizationRequest authorizationRequest) {
        block5: {
            block4: {
                if (authorizationRequest == null) break block4;
                if (this.pendingRequest != null) {
                    throw new FacebookException("Attempted to authorize while a request is pending.");
                }
                if (!authorizationRequest.needsNewTokenValidation() || this.checkInternetPermission()) break block5;
            }
            return;
        }
        this.pendingRequest = authorizationRequest;
        this.handlersToTry = this.getHandlerTypes(authorizationRequest);
        this.tryNextHandler();
    }

    void cancelCurrentHandler() {
        if (this.currentHandler != null) {
            this.currentHandler.cancel();
        }
    }

    boolean checkInternetPermission() {
        if (this.checkedInternetPermission) {
            return true;
        }
        if (this.checkPermission("android.permission.INTERNET") != 0) {
            String string2 = this.context.getString(R.string.com_facebook_internet_permission_error_title);
            String string3 = this.context.getString(R.string.com_facebook_internet_permission_error_message);
            this.complete(Result.createErrorResult(this.pendingRequest, string2, string3));
            return false;
        }
        this.checkedInternetPermission = true;
        return true;
    }

    int checkPermission(String string2) {
        return this.context.checkCallingOrSelfPermission(string2);
    }

    void complete(Result result) {
        if (this.currentHandler != null) {
            this.logAuthorizationMethodComplete(this.currentHandler.getNameForLogging(), result, this.currentHandler.methodLoggingExtras);
        }
        if (this.loggingExtras != null) {
            result.loggingExtras = this.loggingExtras;
        }
        this.handlersToTry = null;
        this.currentHandler = null;
        this.pendingRequest = null;
        this.loggingExtras = null;
        this.notifyOnCompleteListener(result);
    }

    void completeAndValidate(Result result) {
        if (result.token != null && this.pendingRequest.needsNewTokenValidation()) {
            this.validateSameFbidAndFinish(result);
            return;
        }
        this.complete(result);
    }

    void continueAuth() {
        if (this.pendingRequest == null || this.currentHandler == null) {
            throw new FacebookException("Attempted to continue authorization without a pending request.");
        }
        if (this.currentHandler.needsRestart()) {
            this.currentHandler.cancel();
            this.tryCurrentHandler();
        }
    }

    Request createGetPermissionsRequest(String string2) {
        Bundle bundle = new Bundle();
        bundle.putString("fields", "id");
        bundle.putString("access_token", string2);
        return new Request(null, "me/permissions", bundle, HttpMethod.GET, null);
    }

    Request createGetProfileIdRequest(String string2) {
        Bundle bundle = new Bundle();
        bundle.putString("fields", "id");
        bundle.putString("access_token", string2);
        return new Request(null, "me", bundle, HttpMethod.GET, null);
    }

    RequestBatch createReauthValidationBatch(final Result result) {
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        String string2 = result.token.getToken();
        Request.Callback callback = new Request.Callback(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void onCompleted(Response response) {
                GraphUser graphUser;
                try {
                    graphUser = response.getGraphObjectAs(GraphUser.class);
                    if (graphUser == null) return;
                }
                catch (Exception exception) {
                    return;
                }
                arrayList.add(graphUser.getId());
            }
        };
        String string3 = this.pendingRequest.getPreviousAccessToken();
        Request request = this.createGetProfileIdRequest(string3);
        request.setCallback(callback);
        Request request2 = this.createGetProfileIdRequest(string2);
        request2.setCallback(callback);
        Request request3 = this.createGetPermissionsRequest(string3);
        request3.setCallback(new Request.Callback(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void onCompleted(Response response) {
                GraphMultiResult graphMultiResult;
                try {
                    graphMultiResult = response.getGraphObjectAs(GraphMultiResult.class);
                    if (graphMultiResult == null) return;
                }
                catch (Exception exception) {
                    return;
                }
                GraphObjectList<GraphObject> graphObjectList = graphMultiResult.getData();
                if (graphObjectList == null) return;
                if (graphObjectList.size() != 1) return;
                GraphObject graphObject = (GraphObject)graphObjectList.get(0);
                arrayList2.addAll(graphObject.asMap().keySet());
            }
        });
        RequestBatch requestBatch = new RequestBatch(request, request2, request3);
        requestBatch.setBatchApplicationId(this.pendingRequest.getApplicationId());
        requestBatch.addCallback(new RequestBatch.Callback(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onBatchCompleted(RequestBatch requestBatch) {
                Result result3;
                block7: {
                    try {
                        Result result2;
                        if (arrayList.size() == 2 && arrayList.get(0) != null && arrayList.get(1) != null && ((String)arrayList.get(0)).equals(arrayList.get(1))) {
                            AccessToken accessToken = AccessToken.createFromTokenWithRefreshedPermissions(result.token, arrayList2);
                            result3 = Result.createTokenResult(AuthorizationClient.this.pendingRequest, accessToken);
                            break block7;
                        }
                        result3 = result2 = Result.createErrorResult(AuthorizationClient.this.pendingRequest, "User logged in as different Facebook user.", null);
                    }
                    catch (Exception exception) {
                        AuthorizationClient.this.complete(Result.createErrorResult(AuthorizationClient.this.pendingRequest, "Caught exception", exception.getMessage()));
                        return;
                    }
                }
                AuthorizationClient.this.complete(result3);
                return;
                finally {
                    AuthorizationClient.this.notifyBackgroundProcessingStop();
                }
            }
        });
        return requestBatch;
    }

    BackgroundProcessingListener getBackgroundProcessingListener() {
        return this.backgroundProcessingListener;
    }

    boolean getInProgress() {
        return this.pendingRequest != null && this.currentHandler != null;
    }

    OnCompletedListener getOnCompletedListener() {
        return this.onCompletedListener;
    }

    StartActivityDelegate getStartActivityDelegate() {
        if (this.startActivityDelegate != null) {
            return this.startActivityDelegate;
        }
        if (this.pendingRequest != null) {
            return new StartActivityDelegate(){

                @Override
                public Activity getActivityContext() {
                    return AuthorizationClient.this.pendingRequest.getStartActivityDelegate().getActivityContext();
                }

                @Override
                public void startActivityForResult(Intent intent, int n2) {
                    AuthorizationClient.this.pendingRequest.getStartActivityDelegate().startActivityForResult(intent, n2);
                }
            };
        }
        return null;
    }

    boolean onActivityResult(int n2, int n3, Intent intent) {
        if (n2 == this.pendingRequest.getRequestCode()) {
            return this.currentHandler.onActivityResult(n2, n3, intent);
        }
        return false;
    }

    void setBackgroundProcessingListener(BackgroundProcessingListener backgroundProcessingListener) {
        this.backgroundProcessingListener = backgroundProcessingListener;
    }

    void setContext(final Activity activity) {
        this.context = activity;
        this.startActivityDelegate = new StartActivityDelegate(){

            @Override
            public Activity getActivityContext() {
                return activity;
            }

            @Override
            public void startActivityForResult(Intent intent, int n2) {
                activity.startActivityForResult(intent, n2);
            }
        };
    }

    void setContext(Context context) {
        this.context = context;
        this.startActivityDelegate = null;
    }

    void setOnCompletedListener(OnCompletedListener onCompletedListener) {
        this.onCompletedListener = onCompletedListener;
    }

    void startOrContinueAuth(AuthorizationRequest authorizationRequest) {
        if (this.getInProgress()) {
            this.continueAuth();
            return;
        }
        this.authorize(authorizationRequest);
    }

    boolean tryCurrentHandler() {
        if (this.currentHandler.needsInternetPermission() && !this.checkInternetPermission()) {
            this.addLoggingExtra(EVENT_EXTRAS_MISSING_INTERNET_PERMISSION, "1", false);
            return false;
        }
        boolean bl2 = this.currentHandler.tryAuthorize(this.pendingRequest);
        if (bl2) {
            this.logAuthorizationMethodStart(this.currentHandler.getNameForLogging());
            return bl2;
        }
        this.addLoggingExtra(EVENT_EXTRAS_NOT_TRIED, this.currentHandler.getNameForLogging(), true);
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    void tryNextHandler() {
        if (this.currentHandler != null) {
            this.logAuthorizationMethodComplete(this.currentHandler.getNameForLogging(), EVENT_PARAM_METHOD_RESULT_SKIPPED, null, null, this.currentHandler.methodLoggingExtras);
        }
        while (this.handlersToTry != null && !this.handlersToTry.isEmpty()) {
            this.currentHandler = this.handlersToTry.remove(0);
            if (!this.tryCurrentHandler()) continue;
            return;
        }
        if (this.pendingRequest == null) {
            return;
        }
        this.completeWithFailure();
    }

    void validateSameFbidAndFinish(Result result) {
        if (result.token == null) {
            throw new FacebookException("Can't validate without a token");
        }
        RequestBatch requestBatch = this.createReauthValidationBatch(result);
        this.notifyBackgroundProcessingStart();
        requestBatch.executeAsync();
    }

    static class AuthDialogBuilder
    extends WebDialog.Builder {
        private static final String OAUTH_DIALOG = "oauth";
        static final String REDIRECT_URI = "fbconnect://success";
        private String e2e;

        public AuthDialogBuilder(Context context, String string2, Bundle bundle) {
            super(context, string2, OAUTH_DIALOG, bundle);
        }

        @Override
        public WebDialog build() {
            Bundle bundle = this.getParameters();
            bundle.putString("redirect_uri", REDIRECT_URI);
            bundle.putString("client_id", this.getApplicationId());
            bundle.putString("e2e", this.e2e);
            return new WebDialog(this.getContext(), OAUTH_DIALOG, bundle, this.getTheme(), this.getListener());
        }

        public AuthDialogBuilder setE2E(String string2) {
            this.e2e = string2;
            return this;
        }
    }

    abstract class AuthHandler
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Map<String, String> methodLoggingExtras;

        AuthHandler() {
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void addLoggingExtra(String string2, Object object) {
            if (this.methodLoggingExtras == null) {
                this.methodLoggingExtras = new HashMap<String, String>();
            }
            Map<String, String> map = this.methodLoggingExtras;
            String string3 = object == null ? null : object.toString();
            map.put(string2, string3);
        }

        void cancel() {
        }

        abstract String getNameForLogging();

        boolean needsInternetPermission() {
            return false;
        }

        boolean needsRestart() {
            return false;
        }

        boolean onActivityResult(int n2, int n3, Intent intent) {
            return false;
        }

        abstract boolean tryAuthorize(AuthorizationRequest var1);
    }

    static class AuthorizationRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String applicationId;
        private final String authId;
        private final SessionDefaultAudience defaultAudience;
        private boolean isLegacy = false;
        private final SessionLoginBehavior loginBehavior;
        private List<String> permissions;
        private final String previousAccessToken;
        private final int requestCode;
        private final transient StartActivityDelegate startActivityDelegate;

        AuthorizationRequest(SessionLoginBehavior sessionLoginBehavior, int n2, boolean bl2, List<String> list, SessionDefaultAudience sessionDefaultAudience, String string2, String string3, StartActivityDelegate startActivityDelegate, String string4) {
            this.loginBehavior = sessionLoginBehavior;
            this.requestCode = n2;
            this.isLegacy = bl2;
            this.permissions = list;
            this.defaultAudience = sessionDefaultAudience;
            this.applicationId = string2;
            this.previousAccessToken = string3;
            this.startActivityDelegate = startActivityDelegate;
            this.authId = string4;
        }

        String getApplicationId() {
            return this.applicationId;
        }

        String getAuthId() {
            return this.authId;
        }

        SessionDefaultAudience getDefaultAudience() {
            return this.defaultAudience;
        }

        SessionLoginBehavior getLoginBehavior() {
            return this.loginBehavior;
        }

        List<String> getPermissions() {
            return this.permissions;
        }

        String getPreviousAccessToken() {
            return this.previousAccessToken;
        }

        int getRequestCode() {
            return this.requestCode;
        }

        StartActivityDelegate getStartActivityDelegate() {
            return this.startActivityDelegate;
        }

        boolean isLegacy() {
            return this.isLegacy;
        }

        boolean needsNewTokenValidation() {
            return this.previousAccessToken != null && !this.isLegacy;
        }

        void setIsLegacy(boolean bl2) {
            this.isLegacy = bl2;
        }

        void setPermissions(List<String> list) {
            this.permissions = list;
        }
    }

    static interface BackgroundProcessingListener {
        public void onBackgroundProcessingStarted();

        public void onBackgroundProcessingStopped();
    }

    class GetTokenAuthHandler
    extends AuthHandler {
        private static final long serialVersionUID = 1L;
        private transient GetTokenClient getTokenClient;

        GetTokenAuthHandler() {
        }

        @Override
        void cancel() {
            if (this.getTokenClient != null) {
                this.getTokenClient.cancel();
                this.getTokenClient = null;
            }
        }

        @Override
        String getNameForLogging() {
            return "get_token";
        }

        void getTokenCompleted(AuthorizationRequest authorizationRequest, Bundle bundle) {
            this.getTokenClient = null;
            AuthorizationClient.this.notifyBackgroundProcessingStop();
            if (bundle != null) {
                ArrayList arrayList = bundle.getStringArrayList("com.facebook.platform.extra.PERMISSIONS");
                List<String> list = authorizationRequest.getPermissions();
                if (arrayList != null && (list == null || arrayList.containsAll(list))) {
                    AccessToken accessToken = AccessToken.createFromNativeLogin(bundle, AccessTokenSource.FACEBOOK_APPLICATION_SERVICE);
                    Result result = Result.createTokenResult(AuthorizationClient.this.pendingRequest, accessToken);
                    AuthorizationClient.this.completeAndValidate(result);
                    return;
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (String string2 : list) {
                    if (arrayList.contains(string2)) continue;
                    arrayList2.add(string2);
                }
                if (!arrayList2.isEmpty()) {
                    this.addLoggingExtra(AuthorizationClient.EVENT_EXTRAS_NEW_PERMISSIONS, TextUtils.join((CharSequence)",", arrayList2));
                }
                authorizationRequest.setPermissions(arrayList2);
            }
            AuthorizationClient.this.tryNextHandler();
        }

        @Override
        boolean needsRestart() {
            return this.getTokenClient == null;
        }

        @Override
        boolean tryAuthorize(final AuthorizationRequest authorizationRequest) {
            this.getTokenClient = new GetTokenClient(AuthorizationClient.this.context, authorizationRequest.getApplicationId());
            if (!this.getTokenClient.start()) {
                return false;
            }
            AuthorizationClient.this.notifyBackgroundProcessingStart();
            PlatformServiceClient.CompletedListener completedListener = new PlatformServiceClient.CompletedListener(){

                @Override
                public void completed(Bundle bundle) {
                    GetTokenAuthHandler.this.getTokenCompleted(authorizationRequest, bundle);
                }
            };
            this.getTokenClient.setCompletedListener(completedListener);
            return true;
        }
    }

    abstract class KatanaAuthHandler
    extends AuthHandler {
        private static final long serialVersionUID = 1L;

        KatanaAuthHandler() {
        }

        protected boolean tryIntent(Intent intent, int n2) {
            if (intent == null) {
                return false;
            }
            try {
                AuthorizationClient.this.getStartActivityDelegate().startActivityForResult(intent, n2);
                return true;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                return false;
            }
        }
    }

    class KatanaLoginDialogAuthHandler
    extends KatanaAuthHandler {
        private static final long serialVersionUID = 1L;
        private String applicationId;
        private String callId;

        KatanaLoginDialogAuthHandler() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Result createCancelOrErrorResult(AuthorizationRequest authorizationRequest, Intent intent) {
            Bundle bundle = intent.getExtras();
            String string2 = bundle.getString("com.facebook.platform.status.ERROR_TYPE");
            if ("UserCanceled".equals(string2)) return Result.createCancelResult(authorizationRequest, intent.getStringExtra("com.facebook.platform.status.ERROR_DESCRIPTION"));
            if ("PermissionDenied".equals(string2)) {
                return Result.createCancelResult(authorizationRequest, intent.getStringExtra("com.facebook.platform.status.ERROR_DESCRIPTION"));
            }
            String string3 = bundle.getString("com.facebook.platform.status.ERROR_JSON");
            String string4 = null;
            if (string3 == null) return Result.createErrorResult(authorizationRequest, string2, intent.getStringExtra("com.facebook.platform.status.ERROR_DESCRIPTION"), string4);
            try {
                String string5;
                string4 = string5 = new JSONObject(string3).getString("error_code");
                return Result.createErrorResult(authorizationRequest, string2, intent.getStringExtra("com.facebook.platform.status.ERROR_DESCRIPTION"), string4);
            }
            catch (JSONException jSONException) {
                string4 = null;
                return Result.createErrorResult(authorizationRequest, string2, intent.getStringExtra("com.facebook.platform.status.ERROR_DESCRIPTION"), string4);
            }
        }

        private Result handleResultOk(Intent intent) {
            Bundle bundle = intent.getExtras();
            String string2 = bundle.getString("com.facebook.platform.status.ERROR_TYPE");
            if (string2 == null) {
                return Result.createTokenResult(AuthorizationClient.this.pendingRequest, AccessToken.createFromNativeLogin(bundle, AccessTokenSource.FACEBOOK_APPLICATION_NATIVE));
            }
            if ("ServiceDisabled".equals(string2)) {
                this.addLoggingExtra(AuthorizationClient.EVENT_EXTRAS_SERVICE_DISABLED, "1");
                return null;
            }
            return this.createCancelOrErrorResult(AuthorizationClient.this.pendingRequest, intent);
        }

        private void logEvent(String string2, String string3, String string4) {
            if (string4 != null) {
                AppEventsLogger appEventsLogger = AppEventsLogger.newLogger(AuthorizationClient.this.context, this.applicationId);
                Bundle bundle = new Bundle();
                bundle.putString("app_id", this.applicationId);
                bundle.putString("action_id", string4);
                bundle.putLong(string3, System.currentTimeMillis());
                appEventsLogger.logSdkEvent(string2, null, bundle);
            }
        }

        @Override
        String getNameForLogging() {
            return "katana_login_dialog";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        boolean onActivityResult(int n2, int n3, Intent intent) {
            this.logEvent("fb_dialogs_native_login_dialog_complete", "fb_native_login_dialog_complete_time", this.callId);
            Result result = intent == null ? Result.createCancelResult(AuthorizationClient.this.pendingRequest, "Operation canceled") : (NativeProtocol.isServiceDisabledResult20121101(intent) ? null : (n3 == 0 ? this.createCancelOrErrorResult(AuthorizationClient.this.pendingRequest, intent) : (n3 != -1 ? Result.createErrorResult(AuthorizationClient.this.pendingRequest, "Unexpected resultCode from authorization.", null) : this.handleResultOk(intent))));
            if (result != null) {
                AuthorizationClient.this.completeAndValidate(result);
                return true;
            }
            AuthorizationClient.this.tryNextHandler();
            return true;
        }

        @Override
        boolean tryAuthorize(AuthorizationRequest authorizationRequest) {
            this.applicationId = authorizationRequest.getApplicationId();
            Intent intent = NativeProtocol.createLoginDialog20121101Intent(AuthorizationClient.this.context, authorizationRequest.getApplicationId(), new ArrayList<String>(authorizationRequest.getPermissions()), authorizationRequest.getDefaultAudience().getNativeProtocolAudience());
            if (intent == null) {
                return false;
            }
            this.callId = intent.getStringExtra("com.facebook.platform.protocol.CALL_ID");
            this.addLoggingExtra(AuthorizationClient.EVENT_EXTRAS_APP_CALL_ID, this.callId);
            this.addLoggingExtra(AuthorizationClient.EVENT_EXTRAS_PROTOCOL_VERSION, intent.getIntExtra("com.facebook.platform.protocol.PROTOCOL_VERSION", 0));
            this.addLoggingExtra(AuthorizationClient.EVENT_EXTRAS_PERMISSIONS, TextUtils.join((CharSequence)",", (Iterable)intent.getStringArrayListExtra("com.facebook.platform.extra.PERMISSIONS")));
            this.addLoggingExtra(AuthorizationClient.EVENT_EXTRAS_WRITE_PRIVACY, intent.getStringExtra("com.facebook.platform.extra.WRITE_PRIVACY"));
            this.logEvent("fb_dialogs_native_login_dialog_start", "fb_native_login_dialog_start_time", this.callId);
            return this.tryIntent(intent, authorizationRequest.getRequestCode());
        }
    }

    class KatanaProxyAuthHandler
    extends KatanaAuthHandler {
        private static final long serialVersionUID = 1L;
        private String applicationId;

        KatanaProxyAuthHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Result handleResultOk(Intent intent) {
            String string2;
            Bundle bundle = intent.getExtras();
            String string3 = bundle.getString("error");
            if (string3 == null) {
                string3 = bundle.getString("error_type");
            }
            String string4 = bundle.getString("error_code");
            String string5 = bundle.getString("error_message");
            if (string5 == null) {
                string5 = bundle.getString("error_description");
            }
            if (!Utility.isNullOrEmpty(string2 = bundle.getString("e2e"))) {
                AuthorizationClient.this.logWebLoginCompleted(this.applicationId, string2);
            }
            if (string3 == null && string4 == null && string5 == null) {
                AccessToken accessToken = AccessToken.createFromWebBundle(AuthorizationClient.this.pendingRequest.getPermissions(), bundle, AccessTokenSource.FACEBOOK_APPLICATION_WEB);
                return Result.createTokenResult(AuthorizationClient.this.pendingRequest, accessToken);
            }
            boolean bl2 = ServerProtocol.errorsProxyAuthDisabled.contains(string3);
            Result result = null;
            if (bl2) return result;
            if (!ServerProtocol.errorsUserCanceled.contains(string3)) return Result.createErrorResult(AuthorizationClient.this.pendingRequest, string3, string5, string4);
            return Result.createCancelResult(AuthorizationClient.this.pendingRequest, null);
        }

        @Override
        String getNameForLogging() {
            return "katana_proxy_auth";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        boolean onActivityResult(int n2, int n3, Intent intent) {
            Result result = intent == null ? Result.createCancelResult(AuthorizationClient.this.pendingRequest, "Operation canceled") : (n3 == 0 ? Result.createCancelResult(AuthorizationClient.this.pendingRequest, intent.getStringExtra("error")) : (n3 != -1 ? Result.createErrorResult(AuthorizationClient.this.pendingRequest, "Unexpected resultCode from authorization.", null) : this.handleResultOk(intent)));
            if (result != null) {
                AuthorizationClient.this.completeAndValidate(result);
                return true;
            }
            AuthorizationClient.this.tryNextHandler();
            return true;
        }

        @Override
        boolean tryAuthorize(AuthorizationRequest authorizationRequest) {
            this.applicationId = authorizationRequest.getApplicationId();
            String string2 = AuthorizationClient.getE2E();
            Intent intent = NativeProtocol.createProxyAuthIntent(AuthorizationClient.this.context, authorizationRequest.getApplicationId(), authorizationRequest.getPermissions(), string2);
            this.addLoggingExtra("e2e", string2);
            return this.tryIntent(intent, authorizationRequest.getRequestCode());
        }
    }

    static interface OnCompletedListener {
        public void onCompleted(Result var1);
    }

    static class Result
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Code code;
        final String errorCode;
        final String errorMessage;
        Map<String, String> loggingExtras;
        final AuthorizationRequest request;
        final AccessToken token;

        private Result(AuthorizationRequest authorizationRequest, Code code, AccessToken accessToken, String string2, String string3) {
            this.request = authorizationRequest;
            this.token = accessToken;
            this.errorMessage = string2;
            this.code = code;
            this.errorCode = string3;
        }

        static Result createCancelResult(AuthorizationRequest authorizationRequest, String string2) {
            return new Result(authorizationRequest, Code.CANCEL, null, string2, null);
        }

        static Result createErrorResult(AuthorizationRequest authorizationRequest, String string2, String string3) {
            return Result.createErrorResult(authorizationRequest, string2, string3, null);
        }

        static Result createErrorResult(AuthorizationRequest authorizationRequest, String string2, String string3, String string4) {
            String string5 = TextUtils.join((CharSequence)": ", Utility.asListNoNulls(string2, string3));
            return new Result(authorizationRequest, Code.ERROR, null, string5, string4);
        }

        static Result createTokenResult(AuthorizationRequest authorizationRequest, AccessToken accessToken) {
            return new Result(authorizationRequest, Code.SUCCESS, accessToken, null, null);
        }

        static final class Code
        extends Enum<Code> {
            private static final /* synthetic */ Code[] $VALUES;
            public static final /* enum */ Code CANCEL;
            public static final /* enum */ Code ERROR;
            public static final /* enum */ Code SUCCESS;
            private final String loggingValue;

            static {
                SUCCESS = new Code("success");
                CANCEL = new Code("cancel");
                ERROR = new Code("error");
                Code[] codeArray = new Code[]{SUCCESS, CANCEL, ERROR};
                $VALUES = codeArray;
            }

            private Code(String string3) {
                this.loggingValue = string3;
            }

            public static Code valueOf(String string2) {
                return Enum.valueOf(Code.class, string2);
            }

            public static Code[] values() {
                return (Code[])$VALUES.clone();
            }

            String getLoggingValue() {
                return this.loggingValue;
            }
        }
    }

    static interface StartActivityDelegate {
        public Activity getActivityContext();

        public void startActivityForResult(Intent var1, int var2);
    }

    class WebViewAuthHandler
    extends AuthHandler {
        private static final long serialVersionUID = 1L;
        private String applicationId;
        private String e2e;
        private transient WebDialog loginDialog;

        WebViewAuthHandler() {
        }

        private String loadCookieToken() {
            return AuthorizationClient.this.getStartActivityDelegate().getActivityContext().getSharedPreferences(AuthorizationClient.WEB_VIEW_AUTH_HANDLER_STORE, 0).getString(AuthorizationClient.WEB_VIEW_AUTH_HANDLER_TOKEN_KEY, "");
        }

        private void saveCookieToken(String string2) {
            SharedPreferences.Editor editor = AuthorizationClient.this.getStartActivityDelegate().getActivityContext().getSharedPreferences(AuthorizationClient.WEB_VIEW_AUTH_HANDLER_STORE, 0).edit();
            editor.putString(AuthorizationClient.WEB_VIEW_AUTH_HANDLER_TOKEN_KEY, string2);
            if (!editor.commit()) {
                Utility.logd(AuthorizationClient.TAG, "Could not update saved web view auth handler token.");
            }
        }

        @Override
        void cancel() {
            if (this.loginDialog != null) {
                this.loginDialog.dismiss();
                this.loginDialog = null;
            }
        }

        @Override
        String getNameForLogging() {
            return "web_view";
        }

        @Override
        boolean needsInternetPermission() {
            return true;
        }

        @Override
        boolean needsRestart() {
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        void onWebDialogComplete(AuthorizationRequest authorizationRequest, Bundle bundle, FacebookException facebookException) {
            Result result;
            if (bundle != null) {
                if (bundle.containsKey("e2e")) {
                    this.e2e = bundle.getString("e2e");
                }
                AccessToken accessToken = AccessToken.createFromWebBundle(authorizationRequest.getPermissions(), bundle, AccessTokenSource.WEB_VIEW);
                result = Result.createTokenResult(AuthorizationClient.this.pendingRequest, accessToken);
                CookieSyncManager.createInstance((Context)AuthorizationClient.this.context).sync();
                this.saveCookieToken(accessToken.getToken());
            } else if (facebookException instanceof FacebookOperationCanceledException) {
                result = Result.createCancelResult(AuthorizationClient.this.pendingRequest, "User canceled log in.");
            } else {
                this.e2e = null;
                String string2 = facebookException.getMessage();
                boolean bl2 = facebookException instanceof FacebookServiceException;
                String string3 = null;
                if (bl2) {
                    FacebookRequestError facebookRequestError = ((FacebookServiceException)facebookException).getRequestError();
                    Object[] objectArray = new Object[]{facebookRequestError.getErrorCode()};
                    string3 = String.format("%d", objectArray);
                    string2 = facebookRequestError.toString();
                }
                result = Result.createErrorResult(AuthorizationClient.this.pendingRequest, null, string2, string3);
            }
            if (!Utility.isNullOrEmpty(this.e2e)) {
                AuthorizationClient.this.logWebLoginCompleted(this.applicationId, this.e2e);
            }
            AuthorizationClient.this.completeAndValidate(result);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        boolean tryAuthorize(final AuthorizationRequest authorizationRequest) {
            String string2;
            this.applicationId = authorizationRequest.getApplicationId();
            Bundle bundle = new Bundle();
            if (!Utility.isNullOrEmpty(authorizationRequest.getPermissions())) {
                String string3 = TextUtils.join((CharSequence)",", authorizationRequest.getPermissions());
                bundle.putString("scope", string3);
                this.addLoggingExtra("scope", string3);
            }
            if (!Utility.isNullOrEmpty(string2 = authorizationRequest.getPreviousAccessToken()) && string2.equals(this.loadCookieToken())) {
                bundle.putString("access_token", string2);
                this.addLoggingExtra("access_token", "1");
            } else {
                Utility.clearFacebookCookies(AuthorizationClient.this.context);
                this.addLoggingExtra("access_token", "0");
            }
            WebDialog.OnCompleteListener onCompleteListener = new WebDialog.OnCompleteListener(){

                @Override
                public void onComplete(Bundle bundle, FacebookException facebookException) {
                    WebViewAuthHandler.this.onWebDialogComplete(authorizationRequest, bundle, facebookException);
                }
            };
            this.e2e = AuthorizationClient.getE2E();
            this.addLoggingExtra("e2e", this.e2e);
            this.loginDialog = ((WebDialog.Builder)new AuthDialogBuilder((Context)AuthorizationClient.this.getStartActivityDelegate().getActivityContext(), this.applicationId, bundle).setE2E(this.e2e).setOnCompleteListener(onCompleteListener)).build();
            this.loginDialog.show();
            return true;
        }
    }
}

