/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.facebook.internal.PlatformServiceClient;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import org.json.JSONException;
import org.json.JSONObject;

public class AppLinkData {
    private static final String APPLINK_BRIDGE_ARGS_KEY = "bridge_args";
    private static final String APPLINK_METHOD_ARGS_KEY = "method_args";
    private static final String APPLINK_VERSION_KEY = "version";
    public static final String ARGUMENTS_TAPTIME_KEY = "com.facebook.platform.APPLINK_TAP_TIME_UTC";
    private static final String BRIDGE_ARGS_METHOD_KEY = "method";
    private static final String BUNDLE_APPLINK_ARGS_KEY = "com.facebook.platform.APPLINK_ARGS";
    private static final String METHOD_ARGS_REF_KEY = "ref";
    private static final String METHOD_ARGS_TARGET_URL_KEY = "target_url";
    private static final String TAG = AppLinkData.class.getCanonicalName();
    private JSONObject arguments;
    private String[] ref;
    private Uri targetUri;
    private String version;

    private AppLinkData() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppLinkData createFromActivity(Activity activity) {
        Validate.notNull(activity, "activity");
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        AppLinkData appLinkData = AppLinkData.createFromJson(intent.getStringExtra(BUNDLE_APPLINK_ARGS_KEY));
        if (appLinkData != null) return appLinkData;
        return AppLinkData.createFromUri(intent.getData());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AppLinkData createFromJson(String string2) {
        if (string2 == null) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            String string4 = jSONObject.getString(APPLINK_VERSION_KEY);
            if (!jSONObject.getJSONObject(APPLINK_BRIDGE_ARGS_KEY).getString(BRIDGE_ARGS_METHOD_KEY).equals("applink")) return null;
            if (!string4.equals("2")) return null;
            AppLinkData appLinkData = new AppLinkData();
            appLinkData.version = string4;
            appLinkData.arguments = jSONObject.getJSONObject(APPLINK_METHOD_ARGS_KEY);
            if (appLinkData.arguments.has(METHOD_ARGS_REF_KEY) && (string3 = appLinkData.arguments.getString(METHOD_ARGS_REF_KEY)) != null) {
                appLinkData.ref = string3.split(",");
            }
            if (!appLinkData.arguments.has(METHOD_ARGS_TARGET_URL_KEY)) return appLinkData;
            appLinkData.targetUri = Uri.parse((String)appLinkData.arguments.getString(METHOD_ARGS_TARGET_URL_KEY));
            return appLinkData;
        }
        catch (JSONException jSONException) {
            Log.d((String)TAG, (String)"Unable to parse AppLink JSON");
            return null;
        }
    }

    private static AppLinkData createFromUri(Uri uri) {
        if (uri == null) {
            // empty if block
        }
        return null;
    }

    public static void fetchDeferredAppLinkData(Context context, CompletionHandler completionHandler) {
        AppLinkData.fetchDeferredAppLinkData(context, null, completionHandler);
    }

    public static void fetchDeferredAppLinkData(Context context, String string2, final CompletionHandler completionHandler) {
        Validate.notNull(context, "context");
        Validate.notNull(completionHandler, "completionHandler");
        if (string2 == null) {
            string2 = Utility.getMetadataApplicationId(context);
        }
        Validate.notNull(string2, "applicationId");
        DeferredAppLinkDataClient deferredAppLinkDataClient = new DeferredAppLinkDataClient(context, string2);
        deferredAppLinkDataClient.setCompletedListener(new PlatformServiceClient.CompletedListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void completed(Bundle bundle) {
                AppLinkData appLinkData = null;
                if (bundle != null) {
                    String string2 = bundle.getString(AppLinkData.BUNDLE_APPLINK_ARGS_KEY);
                    long l2 = bundle.getLong(AppLinkData.ARGUMENTS_TAPTIME_KEY, -1L);
                    appLinkData = AppLinkData.createFromJson(string2);
                    if (l2 != -1L) {
                        try {
                            appLinkData.getArguments().put(AppLinkData.ARGUMENTS_TAPTIME_KEY, l2);
                        }
                        catch (JSONException jSONException) {
                            Log.d((String)TAG, (String)"Unable to put tap time in AppLinkData.arguments");
                        }
                    }
                }
                completionHandler.onDeferredAppLinkDataFetched(appLinkData);
            }
        });
        if (!deferredAppLinkDataClient.start()) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    completionHandler.onDeferredAppLinkDataFetched(null);
                }
            });
        }
    }

    public JSONObject getArguments() {
        return this.arguments;
    }

    public String[] getRef() {
        return this.ref;
    }

    public Uri getTargetUri() {
        return this.targetUri;
    }

    public static interface CompletionHandler {
        public void onDeferredAppLinkDataFetched(AppLinkData var1);
    }

    static final class DeferredAppLinkDataClient
    extends PlatformServiceClient {
        DeferredAppLinkDataClient(Context context, String string2) {
            super(context, 65540, 65541, 20130618, string2);
        }

        @Override
        protected void populateRequestBundle(Bundle bundle) {
            bundle.putString("com.facebook.platform.extra.INSTALLDATA_PACKAGE", this.getContext().getPackageName());
        }
    }
}

