/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.LoggingBehavior;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.Settings;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppEventsLogger {
    public static final String ACTION_APP_EVENTS_FLUSHED = "com.facebook.sdk.APP_EVENTS_FLUSHED";
    private static final int APP_ACTIVATE_SUPPRESSION_PERIOD_IN_SECONDS = 300;
    public static final String APP_EVENTS_EXTRA_FLUSH_RESULT = "com.facebook.sdk.APP_EVENTS_FLUSH_RESULT";
    public static final String APP_EVENTS_EXTRA_NUM_EVENTS_FLUSHED = "com.facebook.sdk.APP_EVENTS_NUM_EVENTS_FLUSHED";
    private static final int APP_SUPPORTS_ATTRIBUTION_ID_RECHECK_PERIOD_IN_SECONDS = 86400;
    private static final int FLUSH_PERIOD_IN_SECONDS = 60;
    private static final int NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER = 100;
    private static final String TAG = AppEventsLogger.class.getCanonicalName();
    private static Context applicationContext;
    private static FlushBehavior flushBehavior;
    private static Timer flushTimer;
    private static String hashedDeviceAndAppId;
    private static Map<String, EventSuppression> mapEventNameToSuppress;
    private static Map<String, Date> mapEventsToSuppressionTime;
    private static boolean requestInFlight;
    private static Map<AccessTokenAppIdPair, SessionEventsState> stateMap;
    private static Object staticLock;
    private static Timer supportsAttributionRecheckTimer;
    private final AccessTokenAppIdPair accessTokenAppId;
    private final Context context;

    static {
        stateMap = new ConcurrentHashMap<AccessTokenAppIdPair, SessionEventsState>();
        flushBehavior = FlushBehavior.AUTO;
        staticLock = new Object();
        mapEventsToSuppressionTime = new HashMap<String, Date>();
        mapEventNameToSuppress = new HashMap<String, EventSuppression>(){
            {
                this.put("fb_mobile_activate_app", new EventSuppression(300, SuppressionTimeoutBehavior.RESET_TIMEOUT_WHEN_LOG_ATTEMPTED));
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AppEventsLogger(Context context, String string2, Session session) {
        Validate.notNull(context, "context");
        this.context = context;
        if (session == null) {
            session = Session.getActiveSession();
        }
        if (session != null) {
            this.accessTokenAppId = new AccessTokenAppIdPair(session);
        } else {
            if (string2 == null) {
                string2 = Utility.getMetadataApplicationId(context);
            }
            this.accessTokenAppId = new AccessTokenAppIdPair(null, string2);
        }
        Object object = staticLock;
        synchronized (object) {
            if (hashedDeviceAndAppId == null) {
                hashedDeviceAndAppId = Utility.getHashedDeviceAndAppID(context, string2);
            }
            if (applicationContext == null) {
                applicationContext = context.getApplicationContext();
            }
        }
        AppEventsLogger.initializeTimersIfNeeded();
    }

    static /* synthetic */ String access$800() {
        return TAG;
    }

    private static int accumulatePersistedEvents() {
        PersistedEvents persistedEvents = PersistedEvents.readAndClearStore(applicationContext);
        int n2 = 0;
        for (AccessTokenAppIdPair accessTokenAppIdPair : persistedEvents.keySet()) {
            SessionEventsState sessionEventsState = AppEventsLogger.getSessionEventsState(applicationContext, accessTokenAppIdPair);
            List<AppEvent> list = persistedEvents.getEvents(accessTokenAppIdPair);
            sessionEventsState.accumulatePersistedEvents(list);
            n2 += list.size();
        }
        return n2;
    }

    public static void activateApp(Context context) {
        AppEventsLogger.activateApp(context, Utility.getMetadataApplicationId(context));
    }

    public static void activateApp(Context context, String string2) {
        if (context == null || string2 == null) {
            throw new IllegalArgumentException("Both context and applicationId must be non-null");
        }
        Settings.publishInstallAsync(context, string2);
        new AppEventsLogger(context, string2, null).logEvent("fb_mobile_activate_app");
    }

    private static FlushStatistics buildAndExecuteRequests(FlushReason flushReason, Set<AccessTokenAppIdPair> set) {
        FlushStatistics flushStatistics = new FlushStatistics();
        boolean bl2 = Settings.getLimitEventAndDataUsage(applicationContext);
        ArrayList<Request> arrayList = new ArrayList<Request>();
        for (AccessTokenAppIdPair accessTokenAppIdPair : set) {
            Request request;
            SessionEventsState sessionEventsState = AppEventsLogger.getSessionEventsState(accessTokenAppIdPair);
            if (sessionEventsState == null || (request = AppEventsLogger.buildRequestForSession(accessTokenAppIdPair, sessionEventsState, bl2, flushStatistics)) == null) continue;
            arrayList.add(request);
        }
        if (arrayList.size() > 0) {
            LoggingBehavior loggingBehavior = LoggingBehavior.APP_EVENTS;
            String string2 = TAG;
            Object[] objectArray = new Object[]{flushStatistics.numEvents, flushReason.toString()};
            Logger.log(loggingBehavior, string2, "Flushing %d events due to %s.", objectArray);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((Request)iterator.next()).executeAndWait();
            }
        } else {
            flushStatistics = null;
        }
        return flushStatistics;
    }

    private static Request buildRequestForSession(final AccessTokenAppIdPair accessTokenAppIdPair, final SessionEventsState sessionEventsState, boolean bl2, final FlushStatistics flushStatistics) {
        String string2 = accessTokenAppIdPair.getApplicationId();
        Utility.FetchedAppSettings fetchedAppSettings = Utility.queryAppSettings(string2, false);
        final Request request = Request.newPostRequest(null, String.format("%s/activities", string2), null, null);
        Bundle bundle = request.getParameters();
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("access_token", accessTokenAppIdPair.getAccessToken());
        request.setParameters(bundle);
        int n2 = sessionEventsState.populateRequest(request, fetchedAppSettings.supportsImplicitLogging(), fetchedAppSettings.supportsAttribution(), bl2);
        if (n2 == 0) {
            return null;
        }
        flushStatistics.numEvents = n2 + flushStatistics.numEvents;
        request.setCallback(new Request.Callback(){

            @Override
            public void onCompleted(Response response) {
                AppEventsLogger.handleResponse(accessTokenAppIdPair, request, response, sessionEventsState, flushStatistics);
            }
        });
        return request;
    }

    static void eagerFlush() {
        if (AppEventsLogger.getFlushBehavior() != FlushBehavior.EXPLICIT_ONLY) {
            AppEventsLogger.flush(FlushReason.EAGER_FLUSHING_EVENT);
        }
    }

    private static void flush(final FlushReason flushReason) {
        Settings.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AppEventsLogger.flushAndWait(flushReason);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void flushAndWait(FlushReason flushReason) {
        FlushStatistics flushStatistics;
        Object object = staticLock;
        // MONITORENTER : object
        if (requestInFlight) {
            // MONITOREXIT : object
            return;
        }
        requestInFlight = true;
        HashSet<AccessTokenAppIdPair> hashSet = new HashSet<AccessTokenAppIdPair>(stateMap.keySet());
        // MONITOREXIT : object
        AppEventsLogger.accumulatePersistedEvents();
        try {
            FlushStatistics flushStatistics2;
            flushStatistics = flushStatistics2 = AppEventsLogger.buildAndExecuteRequests(flushReason, hashSet);
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)("Caught unexpected exception while flushing: " + exception.toString()));
            flushStatistics = null;
        }
        Object object2 = staticLock;
        // MONITORENTER : object2
        requestInFlight = false;
        // MONITOREXIT : object2
        if (flushStatistics == null) return;
        Intent intent = new Intent(ACTION_APP_EVENTS_FLUSHED);
        intent.putExtra(APP_EVENTS_EXTRA_NUM_EVENTS_FLUSHED, flushStatistics.numEvents);
        intent.putExtra(APP_EVENTS_EXTRA_FLUSH_RESULT, (Serializable)((Object)flushStatistics.result));
        LocalBroadcastManager.getInstance(applicationContext).sendBroadcast(intent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void flushIfNecessary() {
        Object object = staticLock;
        synchronized (object) {
            if (AppEventsLogger.getFlushBehavior() != FlushBehavior.EXPLICIT_ONLY && AppEventsLogger.getAccumulatedEventCount() > 100) {
                AppEventsLogger.flush(FlushReason.EVENT_THRESHOLD);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getAccumulatedEventCount() {
        Object object = staticLock;
        synchronized (object) {
            int n2 = 0;
            Iterator<SessionEventsState> iterator = stateMap.values().iterator();
            while (iterator.hasNext()) {
                n2 += iterator.next().getAccumulatedEventCount();
            }
            return n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FlushBehavior getFlushBehavior() {
        Object object = staticLock;
        synchronized (object) {
            return flushBehavior;
        }
    }

    @Deprecated
    public static boolean getLimitEventUsage(Context context) {
        return Settings.getLimitEventAndDataUsage(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SessionEventsState getSessionEventsState(Context context, AccessTokenAppIdPair accessTokenAppIdPair) {
        Object object = staticLock;
        synchronized (object) {
            SessionEventsState sessionEventsState = stateMap.get(accessTokenAppIdPair);
            if (sessionEventsState == null) {
                sessionEventsState = new SessionEventsState(Settings.getAttributionId(context.getContentResolver()), context.getPackageName(), hashedDeviceAndAppId);
                stateMap.put(accessTokenAppIdPair, sessionEventsState);
            }
            return sessionEventsState;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SessionEventsState getSessionEventsState(AccessTokenAppIdPair accessTokenAppIdPair) {
        Object object = staticLock;
        synchronized (object) {
            return stateMap.get(accessTokenAppIdPair);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void handleResponse(AccessTokenAppIdPair accessTokenAppIdPair, Request request, Response response, SessionEventsState sessionEventsState, FlushStatistics flushStatistics) {
        FacebookRequestError facebookRequestError = response.getError();
        String string2 = "Success";
        FlushResult flushResult = FlushResult.SUCCESS;
        if (facebookRequestError != null) {
            if (facebookRequestError.getErrorCode() == -1) {
                string2 = "Failed: No Connectivity";
                flushResult = FlushResult.NO_CONNECTIVITY;
            } else {
                Object[] objectArray = new Object[]{response.toString(), facebookRequestError.toString()};
                string2 = String.format("Failed:\n  Response: %s\n  Error %s", objectArray);
                flushResult = FlushResult.SERVER_ERROR;
            }
        }
        if (Settings.isLoggingBehaviorEnabled(LoggingBehavior.APP_EVENTS)) {
            String string3;
            String string4 = (String)request.getTag();
            try {
                String string5;
                string3 = string5 = new JSONArray(string4).toString(2);
            }
            catch (JSONException jSONException) {
                string3 = "<Can't encode events for debug logging>";
            }
            LoggingBehavior loggingBehavior = LoggingBehavior.APP_EVENTS;
            String string6 = TAG;
            Object[] objectArray = new Object[]{request.getGraphObject().toString(), string2, string3};
            Logger.log(loggingBehavior, string6, "Flush completed\nParams: %s\n  Result: %s\n  Events JSON: %s", objectArray);
        }
        boolean bl2 = facebookRequestError != null;
        sessionEventsState.clearInFlightAndStats(bl2);
        if (flushResult == FlushResult.NO_CONNECTIVITY) {
            PersistedEvents.persistEvents(applicationContext, accessTokenAppIdPair, sessionEventsState);
        }
        if (flushResult != FlushResult.SUCCESS && flushStatistics.result != FlushResult.NO_CONNECTIVITY) {
            flushStatistics.result = flushResult;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initializeTimersIfNeeded() {
        Object object = staticLock;
        synchronized (object) {
            if (flushTimer != null) {
                return;
            }
            flushTimer = new Timer();
            supportsAttributionRecheckTimer = new Timer();
        }
        flushTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (AppEventsLogger.getFlushBehavior() != FlushBehavior.EXPLICIT_ONLY) {
                    AppEventsLogger.flushAndWait(FlushReason.TIMER);
                }
            }
        }, 0L, 60000L);
        supportsAttributionRecheckTimer.schedule(new TimerTask(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                HashSet<String> hashSet = new HashSet<String>();
                Object object = staticLock;
                synchronized (object) {
                    Iterator iterator = stateMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        hashSet.add(((AccessTokenAppIdPair)iterator.next()).getApplicationId());
                    }
                }
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    Utility.queryAppSettings((String)iterator.next(), true);
                }
                return;
            }
        }, 0L, 86400000L);
    }

    private static void logEvent(Context context, AppEvent appEvent, AccessTokenAppIdPair accessTokenAppIdPair) {
        if (AppEventsLogger.shouldSuppressEvent(appEvent)) {
            return;
        }
        AppEventsLogger.getSessionEventsState(context, accessTokenAppIdPair).addEvent(appEvent);
        AppEventsLogger.flushIfNecessary();
    }

    private void logEvent(String string2, Double d2, Bundle bundle, boolean bl2) {
        AppEvent appEvent = new AppEvent(string2, d2, bundle, bl2);
        AppEventsLogger.logEvent(this.context, appEvent, this.accessTokenAppId);
    }

    public static AppEventsLogger newLogger(Context context) {
        return new AppEventsLogger(context, null, null);
    }

    public static AppEventsLogger newLogger(Context context, Session session) {
        return new AppEventsLogger(context, null, session);
    }

    public static AppEventsLogger newLogger(Context context, String string2) {
        return new AppEventsLogger(context, string2, null);
    }

    public static AppEventsLogger newLogger(Context context, String string2, Session session) {
        return new AppEventsLogger(context, string2, session);
    }

    private static void notifyDeveloperError(String string2) {
        Logger.log(LoggingBehavior.DEVELOPER_ERRORS, "AppEvents", string2);
    }

    public static void onContextStop() {
        PersistedEvents.persistEvents(applicationContext, stateMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setFlushBehavior(FlushBehavior flushBehavior) {
        Object object = staticLock;
        synchronized (object) {
            AppEventsLogger.flushBehavior = flushBehavior;
            return;
        }
    }

    @Deprecated
    public static void setLimitEventUsage(Context context, boolean bl2) {
        Settings.setLimitEventAndDataUsage(context, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean shouldSuppressEvent(AppEvent appEvent) {
        boolean bl2;
        block7: {
            block6: {
                EventSuppression eventSuppression = mapEventNameToSuppress.get(appEvent.getName());
                bl2 = false;
                if (eventSuppression == null) break block6;
                Date date = mapEventsToSuppressionTime.get(appEvent.getName());
                if (date == null) {
                    bl2 = false;
                } else {
                    long l2 = new Date().getTime() - date.getTime() - (long)(1000 * eventSuppression.getTimeoutPeriod());
                    long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    bl2 = false;
                    if (l3 < 0) {
                        bl2 = true;
                    }
                }
                if (!bl2 || eventSuppression.getBehavior() == SuppressionTimeoutBehavior.RESET_TIMEOUT_WHEN_LOG_ATTEMPTED) break block7;
            }
            return bl2;
        }
        mapEventsToSuppressionTime.put(appEvent.getName(), new Date());
        return bl2;
    }

    public void flush() {
        AppEventsLogger.flush(FlushReason.EXPLICIT);
    }

    public String getApplicationId() {
        return this.accessTokenAppId.getApplicationId();
    }

    boolean isValidForSession(Session session) {
        AccessTokenAppIdPair accessTokenAppIdPair = new AccessTokenAppIdPair(session);
        return this.accessTokenAppId.equals(accessTokenAppIdPair);
    }

    public void logEvent(String string2) {
        this.logEvent(string2, null);
    }

    public void logEvent(String string2, double d2) {
        this.logEvent(string2, d2, null);
    }

    public void logEvent(String string2, double d2, Bundle bundle) {
        this.logEvent(string2, d2, bundle, false);
    }

    public void logEvent(String string2, Bundle bundle) {
        this.logEvent(string2, null, bundle, false);
    }

    public void logPurchase(BigDecimal bigDecimal, Currency currency) {
        this.logPurchase(bigDecimal, currency, null);
    }

    public void logPurchase(BigDecimal bigDecimal, Currency currency, Bundle bundle) {
        if (bigDecimal == null) {
            AppEventsLogger.notifyDeveloperError("purchaseAmount cannot be null");
            return;
        }
        if (currency == null) {
            AppEventsLogger.notifyDeveloperError("currency cannot be null");
            return;
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("fb_currency", currency.getCurrencyCode());
        this.logEvent("fb_mobile_purchase", bigDecimal.doubleValue(), bundle);
        AppEventsLogger.eagerFlush();
    }

    public void logSdkEvent(String string2, Double d2, Bundle bundle) {
        this.logEvent(string2, d2, bundle, true);
    }

    private static class AccessTokenAppIdPair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String accessToken;
        private final String applicationId;

        AccessTokenAppIdPair(Session session) {
            this(session.getAccessToken(), session.getApplicationId());
        }

        AccessTokenAppIdPair(String string2, String string3) {
            if (Utility.isNullOrEmpty(string2)) {
                string2 = null;
            }
            this.accessToken = string2;
            this.applicationId = string3;
        }

        private Object writeReplace() {
            return new SerializationProxyV1(this.accessToken, this.applicationId);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (!(object instanceof AccessTokenAppIdPair)) break block2;
                    AccessTokenAppIdPair accessTokenAppIdPair = (AccessTokenAppIdPair)object;
                    if (Utility.areObjectsEqual(accessTokenAppIdPair.accessToken, this.accessToken) && Utility.areObjectsEqual(accessTokenAppIdPair.applicationId, this.applicationId)) break block3;
                }
                return false;
            }
            return true;
        }

        String getAccessToken() {
            return this.accessToken;
        }

        String getApplicationId() {
            return this.applicationId;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int hashCode() {
            int n2 = this.accessToken == null ? 0 : this.accessToken.hashCode();
            String string2 = this.applicationId;
            int n3 = 0;
            if (string2 == null) {
                return n2 ^ n3;
            }
            n3 = this.applicationId.hashCode();
            return n2 ^ n3;
        }

        private static class SerializationProxyV1
        implements Serializable {
            private static final long serialVersionUID = -2488473066578201069L;
            private final String accessToken;
            private final String appId;

            private SerializationProxyV1(String string2, String string3) {
                this.accessToken = string2;
                this.appId = string3;
            }

            private Object readResolve() {
                return new AccessTokenAppIdPair(this.accessToken, this.appId);
            }
        }
    }

    static class AppEvent
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final HashSet<String> validatedIdentifiers = new HashSet();
        private boolean isImplicit;
        private JSONObject jsonObject;
        private String name;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public AppEvent(String string2, Double d2, Bundle bundle, boolean bl2) {
            this.validateIdentifier(string2);
            this.name = string2;
            this.isImplicit = bl2;
            this.jsonObject = new JSONObject();
            try {
                String string3;
                this.jsonObject.put("_eventName", (Object)string2);
                this.jsonObject.put("_logTime", System.currentTimeMillis() / 1000L);
                if (d2 != null) {
                    this.jsonObject.put("_valueToSum", d2.doubleValue());
                }
                if (this.isImplicit) {
                    this.jsonObject.put("_implicitlyLogged", (Object)"1");
                }
                if ((string3 = Settings.getAppVersion()) != null) {
                    this.jsonObject.put("_appVersion", (Object)string3);
                }
                if (bundle != null) {
                    for (String string4 : bundle.keySet()) {
                        this.validateIdentifier(string4);
                        Object object = bundle.get(string4);
                        if (!(object instanceof String) && !(object instanceof Number)) {
                            throw new FacebookException(String.format("Parameter value '%s' for key '%s' should be a string or a numeric type.", object, string4));
                        }
                        this.jsonObject.put(string4, (Object)object.toString());
                    }
                }
                if (this.isImplicit) return;
                LoggingBehavior loggingBehavior = LoggingBehavior.APP_EVENTS;
                Object[] objectArray = new Object[]{this.jsonObject.toString()};
                Logger.log(loggingBehavior, "AppEvents", "Created app event '%s'", objectArray);
                return;
            }
            catch (JSONException jSONException) {
                LoggingBehavior loggingBehavior = LoggingBehavior.APP_EVENTS;
                Object[] objectArray = new Object[]{jSONException.toString()};
                Logger.log(loggingBehavior, "AppEvents", "JSON encoding for app event failed: '%s'", objectArray);
                this.jsonObject = null;
                return;
            }
        }

        private AppEvent(String string2, boolean bl2) throws JSONException {
            this.jsonObject = new JSONObject(string2);
            this.isImplicit = bl2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void validateIdentifier(String string2) {
            if (string2 == null || string2.length() == 0 || string2.length() > 40) {
                if (string2 == null) {
                    string2 = "<None Provided>";
                }
                Object[] objectArray = new Object[]{string2, 40};
                throw new FacebookException(String.format("Identifier '%s' must be less than %d characters", objectArray));
            }
            HashSet<String> hashSet = validatedIdentifiers;
            // MONITORENTER : hashSet
            boolean bl2 = validatedIdentifiers.contains(string2);
            // MONITOREXIT : hashSet
            if (bl2) return;
            if (!string2.matches("^[0-9a-zA-Z_]+[0-9a-zA-Z _-]*$")) throw new FacebookException(String.format("Skipping event named '%s' due to illegal name - must be under 40 chars and alphanumeric, _, - or space, and not start with a space or hyphen.", string2));
            HashSet<String> hashSet2 = validatedIdentifiers;
            // MONITORENTER : hashSet2
            validatedIdentifiers.add(string2);
            // MONITOREXIT : hashSet2
        }

        private Object writeReplace() {
            return new SerializationProxyV1(this.jsonObject.toString(), this.isImplicit);
        }

        public boolean getIsImplicit() {
            return this.isImplicit;
        }

        public JSONObject getJSONObject() {
            return this.jsonObject;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            Object[] objectArray = new Object[]{this.jsonObject.optString("_eventName"), this.isImplicit, this.jsonObject.toString()};
            return String.format("\"%s\", implicit: %b, json: %s", objectArray);
        }

        private static class SerializationProxyV1
        implements Serializable {
            private static final long serialVersionUID = -2488473066578201069L;
            private final boolean isImplicit;
            private final String jsonString;

            private SerializationProxyV1(String string2, boolean bl2) {
                this.jsonString = string2;
                this.isImplicit = bl2;
            }

            private Object readResolve() throws JSONException {
                return new AppEvent(this.jsonString, this.isImplicit);
            }
        }
    }

    private static class EventSuppression {
        private SuppressionTimeoutBehavior behavior;
        private int timeoutPeriod;

        EventSuppression(int n2, SuppressionTimeoutBehavior suppressionTimeoutBehavior) {
            this.timeoutPeriod = n2;
            this.behavior = suppressionTimeoutBehavior;
        }

        SuppressionTimeoutBehavior getBehavior() {
            return this.behavior;
        }

        int getTimeoutPeriod() {
            return this.timeoutPeriod;
        }
    }

    public static final class FlushBehavior
    extends Enum<FlushBehavior> {
        private static final /* synthetic */ FlushBehavior[] $VALUES;
        public static final /* enum */ FlushBehavior AUTO = new FlushBehavior();
        public static final /* enum */ FlushBehavior EXPLICIT_ONLY = new FlushBehavior();

        static {
            FlushBehavior[] flushBehaviorArray = new FlushBehavior[]{AUTO, EXPLICIT_ONLY};
            $VALUES = flushBehaviorArray;
        }

        public static FlushBehavior valueOf(String string2) {
            return Enum.valueOf(FlushBehavior.class, string2);
        }

        public static FlushBehavior[] values() {
            return (FlushBehavior[])$VALUES.clone();
        }
    }

    private static final class FlushReason
    extends Enum<FlushReason> {
        private static final /* synthetic */ FlushReason[] $VALUES;
        public static final /* enum */ FlushReason EAGER_FLUSHING_EVENT;
        public static final /* enum */ FlushReason EVENT_THRESHOLD;
        public static final /* enum */ FlushReason EXPLICIT;
        public static final /* enum */ FlushReason PERSISTED_EVENTS;
        public static final /* enum */ FlushReason SESSION_CHANGE;
        public static final /* enum */ FlushReason TIMER;

        static {
            EXPLICIT = new FlushReason();
            TIMER = new FlushReason();
            SESSION_CHANGE = new FlushReason();
            PERSISTED_EVENTS = new FlushReason();
            EVENT_THRESHOLD = new FlushReason();
            EAGER_FLUSHING_EVENT = new FlushReason();
            FlushReason[] flushReasonArray = new FlushReason[]{EXPLICIT, TIMER, SESSION_CHANGE, PERSISTED_EVENTS, EVENT_THRESHOLD, EAGER_FLUSHING_EVENT};
            $VALUES = flushReasonArray;
        }

        public static FlushReason valueOf(String string2) {
            return Enum.valueOf(FlushReason.class, string2);
        }

        public static FlushReason[] values() {
            return (FlushReason[])$VALUES.clone();
        }
    }

    private static final class FlushResult
    extends Enum<FlushResult> {
        private static final /* synthetic */ FlushResult[] $VALUES;
        public static final /* enum */ FlushResult NO_CONNECTIVITY;
        public static final /* enum */ FlushResult SERVER_ERROR;
        public static final /* enum */ FlushResult SUCCESS;
        public static final /* enum */ FlushResult UNKNOWN_ERROR;

        static {
            SUCCESS = new FlushResult();
            SERVER_ERROR = new FlushResult();
            NO_CONNECTIVITY = new FlushResult();
            UNKNOWN_ERROR = new FlushResult();
            FlushResult[] flushResultArray = new FlushResult[]{SUCCESS, SERVER_ERROR, NO_CONNECTIVITY, UNKNOWN_ERROR};
            $VALUES = flushResultArray;
        }

        public static FlushResult valueOf(String string2) {
            return Enum.valueOf(FlushResult.class, string2);
        }

        public static FlushResult[] values() {
            return (FlushResult[])$VALUES.clone();
        }
    }

    private static class FlushStatistics {
        public int numEvents = 0;
        public FlushResult result = FlushResult.SUCCESS;

        private FlushStatistics() {
        }
    }

    static class PersistedEvents {
        static final String PERSISTED_EVENTS_FILENAME = "AppEventsLogger.persistedevents";
        private static Object staticLock = new Object();
        private Context context;
        private HashMap<AccessTokenAppIdPair, List<AppEvent>> persistedEvents = new HashMap();

        private PersistedEvents(Context context) {
            this.context = context;
        }

        public static void persistEvents(Context context, AccessTokenAppIdPair accessTokenAppIdPair, SessionEventsState sessionEventsState) {
            HashMap<AccessTokenAppIdPair, SessionEventsState> hashMap = new HashMap<AccessTokenAppIdPair, SessionEventsState>();
            hashMap.put(accessTokenAppIdPair, sessionEventsState);
            PersistedEvents.persistEvents(context, hashMap);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static void persistEvents(Context context, Map<AccessTokenAppIdPair, SessionEventsState> map) {
            Object object = staticLock;
            synchronized (object) {
                PersistedEvents persistedEvents = PersistedEvents.readAndClearStore(context);
                Iterator<Map.Entry<AccessTokenAppIdPair, SessionEventsState>> iterator = map.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        persistedEvents.write();
                        return;
                    }
                    Map.Entry<AccessTokenAppIdPair, SessionEventsState> entry = iterator.next();
                    List<AppEvent> list = entry.getValue().getEventsToPersist();
                    if (list.size() == 0) continue;
                    persistedEvents.addEvents(entry.getKey(), list);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static PersistedEvents readAndClearStore(Context context) {
            Object object = staticLock;
            synchronized (object) {
                PersistedEvents persistedEvents = new PersistedEvents(context);
                persistedEvents.readAndClearStore();
                return persistedEvents;
            }
        }

        /*
         * Unable to fully structure code
         */
        private void readAndClearStore() {
            var1_1 = null;
            var2_2 = new ObjectInputStream(new BufferedInputStream(this.context.openFileInput("AppEventsLogger.persistedevents")));
            try {
                var7_3 = (HashMap)var2_2.readObject();
                this.context.getFileStreamPath("AppEventsLogger.persistedevents").delete();
                this.persistedEvents = var7_3;
            }
            catch (Throwable var5_10) {
                var1_1 = var2_2;
                ** continue;
            }
            catch (Exception var4_7) {
                var1_1 = var2_2;
                ** continue;
            }
            catch (FileNotFoundException var3_11) {
                var1_1 = var2_2;
                ** continue;
            }
            Utility.closeQuietly(var2_2);
            return;
            catch (FileNotFoundException var9_4) lbl-1000:
            // 2 sources

            {
                while (true) {
                    Utility.closeQuietly(var1_1);
                    return;
                }
            }
            catch (Exception var4_5) lbl-1000:
            // 2 sources

            {
                while (true) {
                    try {
                        Log.d((String)AppEventsLogger.access$800(), (String)("Got unexpected exception: " + var4_6.toString()));
                    }
                    catch (Throwable var5_8) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            Utility.closeQuietly(var1_1);
                            throw var5_9;
                        }
                    }
                    Utility.closeQuietly(var1_1);
                    return;
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void write() {
            var1_1 = null;
            var2_2 = new ObjectOutputStream(new BufferedOutputStream(this.context.openFileOutput("AppEventsLogger.persistedevents", 0)));
            try {
                var2_2.writeObject(this.persistedEvents);
            }
            catch (Throwable var4_8) {
                var1_1 = var2_2;
                ** continue;
            }
            catch (Exception var3_5) {
                var1_1 = var2_2;
                ** continue;
            }
            Utility.closeQuietly(var2_2);
            return;
            catch (Exception var3_3) lbl-1000:
            // 2 sources

            {
                while (true) {
                    try {
                        Log.d((String)AppEventsLogger.access$800(), (String)("Got unexpected exception: " + var3_4.toString()));
                    }
                    catch (Throwable var4_6) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            Utility.closeQuietly(var1_1);
                            throw var4_7;
                        }
                    }
                    Utility.closeQuietly(var1_1);
                    return;
                }
            }
        }

        public void addEvents(AccessTokenAppIdPair accessTokenAppIdPair, List<AppEvent> list) {
            if (!this.persistedEvents.containsKey(accessTokenAppIdPair)) {
                this.persistedEvents.put(accessTokenAppIdPair, new ArrayList());
            }
            this.persistedEvents.get(accessTokenAppIdPair).addAll(list);
        }

        public List<AppEvent> getEvents(AccessTokenAppIdPair accessTokenAppIdPair) {
            return this.persistedEvents.get(accessTokenAppIdPair);
        }

        public Set<AccessTokenAppIdPair> keySet() {
            return this.persistedEvents.keySet();
        }
    }

    static class SessionEventsState {
        public static final String ENCODED_EVENTS_KEY = "encoded_events";
        public static final String EVENT_COUNT_KEY = "event_count";
        public static final String NUM_SKIPPED_KEY = "num_skipped";
        private final int MAX_ACCUMULATED_LOG_EVENTS;
        private List<AppEvent> accumulatedEvents = new ArrayList<AppEvent>();
        private String attributionId;
        private String hashedDeviceAndAppId;
        private List<AppEvent> inFlightEvents = new ArrayList<AppEvent>();
        private int numSkippedEventsDueToFullBuffer;
        private String packageName;

        public SessionEventsState(String string2, String string3, String string4) {
            this.MAX_ACCUMULATED_LOG_EVENTS = 1000;
            this.attributionId = string2;
            this.packageName = string3;
            this.hashedDeviceAndAppId = string4;
        }

        private byte[] getStringAsByteArray(String string2) {
            try {
                byte[] byArray = string2.getBytes("UTF-8");
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Utility.logd("Encoding exception: ", unsupportedEncodingException);
                return null;
            }
        }

        private void populateRequest(Request request, int n2, JSONArray jSONArray, boolean bl2, boolean bl3) {
            String string2;
            GraphObject graphObject = GraphObject.Factory.create();
            graphObject.setProperty("event", "CUSTOM_APP_EVENTS");
            if (this.numSkippedEventsDueToFullBuffer > 0) {
                graphObject.setProperty("num_skipped_events", n2);
            }
            if (bl2) {
                Utility.setAppEventAttributionParameters(graphObject, this.attributionId, this.hashedDeviceAndAppId, bl3);
            }
            graphObject.setProperty("application_package_name", this.packageName);
            request.setGraphObject(graphObject);
            Bundle bundle = request.getParameters();
            if (bundle == null) {
                bundle = new Bundle();
            }
            if ((string2 = jSONArray.toString()) != null) {
                bundle.putByteArray("custom_events_file", this.getStringAsByteArray(string2));
                request.setTag(string2);
            }
            request.setParameters(bundle);
        }

        public void accumulatePersistedEvents(List<AppEvent> list) {
            synchronized (this) {
                this.accumulatedEvents.addAll(list);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void addEvent(AppEvent appEvent) {
            synchronized (this) {
                if (this.accumulatedEvents.size() + this.inFlightEvents.size() >= 1000) {
                    this.numSkippedEventsDueToFullBuffer = 1 + this.numSkippedEventsDueToFullBuffer;
                } else {
                    this.accumulatedEvents.add(appEvent);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void clearInFlightAndStats(boolean bl2) {
            synchronized (this) {
                if (bl2) {
                    this.accumulatedEvents.addAll(this.inFlightEvents);
                }
                this.inFlightEvents.clear();
                this.numSkippedEventsDueToFullBuffer = 0;
                return;
            }
        }

        public int getAccumulatedEventCount() {
            synchronized (this) {
                int n2 = this.accumulatedEvents.size();
                return n2;
            }
        }

        public List<AppEvent> getEventsToPersist() {
            synchronized (this) {
                List<AppEvent> list = this.accumulatedEvents;
                this.accumulatedEvents = new ArrayList<AppEvent>();
                return list;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int populateRequest(Request request, boolean bl2, boolean bl3, boolean bl4) {
            JSONArray jSONArray;
            int n2;
            synchronized (this) {
                n2 = this.numSkippedEventsDueToFullBuffer;
                this.inFlightEvents.addAll(this.accumulatedEvents);
                this.accumulatedEvents.clear();
                jSONArray = new JSONArray();
                for (AppEvent appEvent : this.inFlightEvents) {
                    if (!bl2 && appEvent.getIsImplicit()) continue;
                    jSONArray.put((Object)appEvent.getJSONObject());
                }
                if (jSONArray.length() == 0) {
                    return 0;
                }
            }
            this.populateRequest(request, n2, jSONArray, bl3, bl4);
            return jSONArray.length();
        }
    }

    private static final class SuppressionTimeoutBehavior
    extends Enum<SuppressionTimeoutBehavior> {
        private static final /* synthetic */ SuppressionTimeoutBehavior[] $VALUES;
        public static final /* enum */ SuppressionTimeoutBehavior RESET_TIMEOUT_WHEN_LOG_ATTEMPTED;
        public static final /* enum */ SuppressionTimeoutBehavior RESET_TIMEOUT_WHEN_LOG_SUCCESSFUL;

        static {
            RESET_TIMEOUT_WHEN_LOG_SUCCESSFUL = new SuppressionTimeoutBehavior();
            RESET_TIMEOUT_WHEN_LOG_ATTEMPTED = new SuppressionTimeoutBehavior();
            SuppressionTimeoutBehavior[] suppressionTimeoutBehaviorArray = new SuppressionTimeoutBehavior[]{RESET_TIMEOUT_WHEN_LOG_SUCCESSFUL, RESET_TIMEOUT_WHEN_LOG_ATTEMPTED};
            $VALUES = suppressionTimeoutBehaviorArray;
        }

        public static SuppressionTimeoutBehavior valueOf(String string2) {
            return Enum.valueOf(SuppressionTimeoutBehavior.class, string2);
        }

        public static SuppressionTimeoutBehavior[] values() {
            return (SuppressionTimeoutBehavior[])$VALUES.clone();
        }
    }
}

