/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.facebook.AccessTokenSource;
import com.facebook.LoggingBehavior;
import com.facebook.Settings;
import com.facebook.TokenCachingStrategy;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class AccessToken
implements Serializable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    static final String ACCESS_TOKEN_KEY = "access_token";
    private static final Date ALREADY_EXPIRED_EXPIRATION_TIME;
    private static final AccessTokenSource DEFAULT_ACCESS_TOKEN_SOURCE;
    private static final Date DEFAULT_EXPIRATION_TIME;
    private static final Date DEFAULT_LAST_REFRESH_TIME;
    static final String EXPIRES_IN_KEY = "expires_in";
    private static final Date MAX_DATE;
    private static final Date MIN_DATE;
    private static final long serialVersionUID = 1L;
    private final Date expires;
    private final Date lastRefresh;
    private final List<String> permissions;
    private final AccessTokenSource source;
    private final String token;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2 = !AccessToken.class.desiredAssertionStatus();
        $assertionsDisabled = bl2;
        MIN_DATE = new Date(Long.MIN_VALUE);
        DEFAULT_EXPIRATION_TIME = MAX_DATE = new Date(Long.MAX_VALUE);
        DEFAULT_LAST_REFRESH_TIME = new Date();
        DEFAULT_ACCESS_TOKEN_SOURCE = AccessTokenSource.FACEBOOK_APPLICATION_WEB;
        ALREADY_EXPIRED_EXPIRATION_TIME = MIN_DATE;
    }

    AccessToken(String string2, Date date, List<String> list, AccessTokenSource accessTokenSource, Date date2) {
        if (list == null) {
            list = Collections.emptyList();
        }
        this.expires = date;
        this.permissions = Collections.unmodifiableList(list);
        this.token = string2;
        this.source = accessTokenSource;
        this.lastRefresh = date2;
    }

    private void appendPermissions(StringBuilder stringBuilder) {
        stringBuilder.append(" permissions:");
        if (this.permissions == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append("[");
        stringBuilder.append(TextUtils.join((CharSequence)", ", this.permissions));
        stringBuilder.append("]");
    }

    static AccessToken createEmptyToken(List<String> list) {
        return new AccessToken("", ALREADY_EXPIRED_EXPIRATION_TIME, list, AccessTokenSource.NONE, DEFAULT_LAST_REFRESH_TIME);
    }

    private static AccessToken createFromBundle(List<String> list, Bundle bundle, AccessTokenSource accessTokenSource, Date date) {
        String string2 = bundle.getString(ACCESS_TOKEN_KEY);
        Date date2 = AccessToken.getBundleLongAsDate(bundle, EXPIRES_IN_KEY, date);
        if (Utility.isNullOrEmpty(string2) || date2 == null) {
            return null;
        }
        return new AccessToken(string2, date2, list, accessTokenSource, new Date());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static AccessToken createFromCache(Bundle bundle) {
        List<String> list;
        ArrayList arrayList = bundle.getStringArrayList("com.facebook.TokenCachingStrategy.Permissions");
        if (arrayList == null) {
            list = Collections.emptyList();
            return new AccessToken(bundle.getString("com.facebook.TokenCachingStrategy.Token"), TokenCachingStrategy.getDate(bundle, "com.facebook.TokenCachingStrategy.ExpirationDate"), list, TokenCachingStrategy.getSource(bundle), TokenCachingStrategy.getDate(bundle, "com.facebook.TokenCachingStrategy.LastRefreshDate"));
        }
        list = Collections.unmodifiableList(new ArrayList(arrayList));
        return new AccessToken(bundle.getString("com.facebook.TokenCachingStrategy.Token"), TokenCachingStrategy.getDate(bundle, "com.facebook.TokenCachingStrategy.ExpirationDate"), list, TokenCachingStrategy.getSource(bundle), TokenCachingStrategy.getDate(bundle, "com.facebook.TokenCachingStrategy.LastRefreshDate"));
    }

    public static AccessToken createFromExistingAccessToken(String string2, Date date, Date date2, AccessTokenSource accessTokenSource, List<String> list) {
        if (date == null) {
            date = DEFAULT_EXPIRATION_TIME;
        }
        if (date2 == null) {
            date2 = DEFAULT_LAST_REFRESH_TIME;
        }
        if (accessTokenSource == null) {
            accessTokenSource = DEFAULT_ACCESS_TOKEN_SOURCE;
        }
        return new AccessToken(string2, date, list, accessTokenSource, date2);
    }

    public static AccessToken createFromNativeLinkingIntent(Intent intent) {
        Validate.notNull(intent, "intent");
        if (intent.getExtras() == null) {
            return null;
        }
        return AccessToken.createFromBundle(null, intent.getExtras(), AccessTokenSource.FACEBOOK_APPLICATION_WEB, new Date());
    }

    static AccessToken createFromNativeLogin(Bundle bundle, AccessTokenSource accessTokenSource) {
        Date date = AccessToken.getBundleLongAsDate(bundle, "com.facebook.platform.extra.EXPIRES_SECONDS_SINCE_EPOCH", new Date(0L));
        return AccessToken.createNew(bundle.getStringArrayList("com.facebook.platform.extra.PERMISSIONS"), bundle.getString("com.facebook.platform.extra.ACCESS_TOKEN"), date, accessTokenSource);
    }

    @SuppressLint(value={"FieldGetter"})
    static AccessToken createFromRefresh(AccessToken accessToken, Bundle bundle) {
        if (!$assertionsDisabled && accessToken.source != AccessTokenSource.FACEBOOK_APPLICATION_WEB && accessToken.source != AccessTokenSource.FACEBOOK_APPLICATION_NATIVE && accessToken.source != AccessTokenSource.FACEBOOK_APPLICATION_SERVICE) {
            throw new AssertionError();
        }
        Date date = AccessToken.getBundleLongAsDate(bundle, EXPIRES_IN_KEY, new Date(0L));
        String string2 = bundle.getString(ACCESS_TOKEN_KEY);
        return AccessToken.createNew(accessToken.getPermissions(), string2, date, accessToken.source);
    }

    static AccessToken createFromString(String string2, List<String> list, AccessTokenSource accessTokenSource) {
        return new AccessToken(string2, DEFAULT_EXPIRATION_TIME, list, accessTokenSource, DEFAULT_LAST_REFRESH_TIME);
    }

    static AccessToken createFromTokenWithRefreshedPermissions(AccessToken accessToken, List<String> list) {
        return new AccessToken(accessToken.token, accessToken.expires, list, accessToken.source, accessToken.lastRefresh);
    }

    static AccessToken createFromWebBundle(List<String> list, Bundle bundle, AccessTokenSource accessTokenSource) {
        Date date = AccessToken.getBundleLongAsDate(bundle, EXPIRES_IN_KEY, new Date());
        return AccessToken.createNew(list, bundle.getString(ACCESS_TOKEN_KEY), date, accessTokenSource);
    }

    private static AccessToken createNew(List<String> list, String string2, Date date, AccessTokenSource accessTokenSource) {
        if (Utility.isNullOrEmpty(string2) || date == null) {
            return AccessToken.createEmptyToken(list);
        }
        return new AccessToken(string2, date, list, accessTokenSource, new Date());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Date getBundleLongAsDate(Bundle bundle, String string2, Date date) {
        long l2;
        block8: {
            Object object;
            block9: {
                block6: {
                    block7: {
                        if (bundle == null) break block6;
                        object = bundle.get(string2);
                        if (!(object instanceof Long)) break block7;
                        l2 = (Long)object;
                        break block8;
                    }
                    if (object instanceof String) break block9;
                }
                return null;
            }
            try {
                long l3;
                l2 = l3 = Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (l2 == 0L) {
            return new Date(Long.MAX_VALUE);
        }
        return new Date(date.getTime() + 1000L * l2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Cannot readObject, serialization proxy required");
    }

    private String tokenToString() {
        if (this.token == null) {
            return "null";
        }
        if (Settings.isLoggingBehaviorEnabled(LoggingBehavior.INCLUDE_ACCESS_TOKENS)) {
            return this.token;
        }
        return "ACCESS_TOKEN_REMOVED";
    }

    private Object writeReplace() {
        return new SerializationProxyV1(this.token, this.expires, this.permissions, this.source, this.lastRefresh);
    }

    public Date getExpires() {
        return this.expires;
    }

    public Date getLastRefresh() {
        return this.lastRefresh;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public AccessTokenSource getSource() {
        return this.source;
    }

    public String getToken() {
        return this.token;
    }

    boolean isInvalid() {
        return Utility.isNullOrEmpty(this.token) || new Date().after(this.expires);
    }

    Bundle toCacheBundle() {
        Bundle bundle = new Bundle();
        bundle.putString("com.facebook.TokenCachingStrategy.Token", this.token);
        TokenCachingStrategy.putDate(bundle, "com.facebook.TokenCachingStrategy.ExpirationDate", this.expires);
        bundle.putStringArrayList("com.facebook.TokenCachingStrategy.Permissions", new ArrayList<String>(this.permissions));
        bundle.putSerializable("com.facebook.TokenCachingStrategy.AccessTokenSource", (Serializable)((Object)this.source));
        TokenCachingStrategy.putDate(bundle, "com.facebook.TokenCachingStrategy.LastRefreshDate", this.lastRefresh);
        return bundle;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{AccessToken");
        stringBuilder.append(" token:").append(this.tokenToString());
        this.appendPermissions(stringBuilder);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static class SerializationProxyV1
    implements Serializable {
        private static final long serialVersionUID = -2488473066578201069L;
        private final Date expires;
        private final Date lastRefresh;
        private final List<String> permissions;
        private final AccessTokenSource source;
        private final String token;

        private SerializationProxyV1(String string2, Date date, List<String> list, AccessTokenSource accessTokenSource, Date date2) {
            this.expires = date;
            this.permissions = list;
            this.token = string2;
            this.source = accessTokenSource;
            this.lastRefresh = date2;
        }

        private Object readResolve() {
            return new AccessToken(this.token, this.expires, this.permissions, this.source, this.lastRefresh);
        }
    }
}

