/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.merge;

import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.SectionIndexer;
import com.commonsware.cwac.sacklist.SackOfViewsAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MergeAdapter
extends BaseAdapter
implements SectionIndexer {
    protected PieceStateRoster pieces = new PieceStateRoster();

    public void addAdapter(ListAdapter listAdapter) {
        this.pieces.add(listAdapter);
        listAdapter.registerDataSetObserver((DataSetObserver)new CascadeDataSetObserver());
    }

    public void addView(View view) {
        this.addView(view, false);
    }

    public void addView(View view, boolean bl2) {
        ArrayList<View> arrayList = new ArrayList<View>(1);
        arrayList.add(view);
        this.addViews(arrayList, bl2);
    }

    public void addViews(List<View> list) {
        this.addViews(list, false);
    }

    public void addViews(List<View> list, boolean bl2) {
        if (bl2) {
            this.addAdapter((ListAdapter)new EnabledSackAdapter(list));
            return;
        }
        this.addAdapter((ListAdapter)new SackOfViewsAdapter(list));
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ListAdapter getAdapter(int n2) {
        Iterator<ListAdapter> iterator = this.getPieces().iterator();
        while (iterator.hasNext()) {
            ListAdapter listAdapter = iterator.next();
            int n3 = listAdapter.getCount();
            if (n2 < n3) return listAdapter;
            n2 -= n3;
        }
        return null;
    }

    public int getCount() {
        int n2 = 0;
        Iterator<ListAdapter> iterator = this.getPieces().iterator();
        while (iterator.hasNext()) {
            n2 += iterator.next().getCount();
        }
        return n2;
    }

    public Object getItem(int n2) {
        Iterator<ListAdapter> iterator = this.getPieces().iterator();
        while (iterator.hasNext()) {
            ListAdapter listAdapter = iterator.next();
            int n3 = listAdapter.getCount();
            if (n2 < n3) {
                return listAdapter.getItem(n2);
            }
            n2 -= n3;
        }
        return null;
    }

    public long getItemId(int n2) {
        Iterator<ListAdapter> iterator = this.getPieces().iterator();
        while (iterator.hasNext()) {
            ListAdapter listAdapter = iterator.next();
            int n3 = listAdapter.getCount();
            if (n2 < n3) {
                return listAdapter.getItemId(n2);
            }
            n2 -= n3;
        }
        return -1L;
    }

    public int getItemViewType(int n2) {
        int n3 = 0;
        Iterator<PieceState> iterator = this.pieces.getRawPieces().iterator();
        while (iterator.hasNext()) {
            PieceState pieceState = iterator.next();
            if (pieceState.isActive) {
                int n4 = pieceState.adapter.getCount();
                if (n2 < n4) {
                    return n3 + pieceState.adapter.getItemViewType(n2);
                }
                n2 -= n4;
            }
            n3 += pieceState.adapter.getViewTypeCount();
        }
        return -1;
    }

    protected List<ListAdapter> getPieces() {
        return this.pieces.getPieces();
    }

    public int getPositionForSection(int n2) {
        int n3 = 0;
        Iterator<ListAdapter> iterator = this.getPieces().iterator();
        while (iterator.hasNext()) {
            ListAdapter listAdapter = iterator.next();
            if (listAdapter instanceof SectionIndexer) {
                Object[] objectArray = ((SectionIndexer)listAdapter).getSections();
                int n4 = 0;
                if (objectArray != null) {
                    n4 = objectArray.length;
                }
                if (n2 < n4) {
                    return n3 + ((SectionIndexer)listAdapter).getPositionForSection(n2);
                }
                if (objectArray != null) {
                    n2 -= n4;
                }
            }
            n3 += listAdapter.getCount();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getSectionForPosition(int n2) {
        int n3 = 0;
        Iterator<ListAdapter> iterator = this.getPieces().iterator();
        while (true) {
            Object[] objectArray;
            int n4;
            ListAdapter listAdapter;
            block6: {
                block7: {
                    block5: {
                        if (!iterator.hasNext()) break block5;
                        listAdapter = iterator.next();
                        n4 = listAdapter.getCount();
                        if (n2 >= n4) break block6;
                        if (listAdapter instanceof SectionIndexer) break block7;
                    }
                    return 0;
                }
                return n3 + ((SectionIndexer)listAdapter).getSectionForPosition(n2);
            }
            if (listAdapter instanceof SectionIndexer && (objectArray = ((SectionIndexer)listAdapter).getSections()) != null) {
                n3 += objectArray.length;
            }
            n2 -= n4;
        }
    }

    public Object[] getSections() {
        ArrayList arrayList = new ArrayList();
        Iterator<ListAdapter> iterator = this.getPieces().iterator();
        while (true) {
            Object[] objectArray;
            if (!iterator.hasNext()) {
                if (arrayList.size() != 0) break;
                return new String[0];
            }
            ListAdapter listAdapter = iterator.next();
            if (!(listAdapter instanceof SectionIndexer) || (objectArray = ((SectionIndexer)listAdapter).getSections()) == null) continue;
            Collections.addAll(arrayList, objectArray);
        }
        return arrayList.toArray(new Object[0]);
    }

    public View getView(int n2, View view, ViewGroup viewGroup) {
        Iterator<ListAdapter> iterator = this.getPieces().iterator();
        while (iterator.hasNext()) {
            ListAdapter listAdapter = iterator.next();
            int n3 = listAdapter.getCount();
            if (n2 < n3) {
                return listAdapter.getView(n2, view, viewGroup);
            }
            n2 -= n3;
        }
        return null;
    }

    public int getViewTypeCount() {
        int n2 = 0;
        Iterator<PieceState> iterator = this.pieces.getRawPieces().iterator();
        while (iterator.hasNext()) {
            n2 += iterator.next().adapter.getViewTypeCount();
        }
        return Math.max(n2, 1);
    }

    public boolean isEnabled(int n2) {
        Iterator<ListAdapter> iterator = this.getPieces().iterator();
        while (iterator.hasNext()) {
            ListAdapter listAdapter = iterator.next();
            int n3 = listAdapter.getCount();
            if (n2 < n3) {
                return listAdapter.isEnabled(n2);
            }
            n2 -= n3;
        }
        return false;
    }

    public void setActive(View view, boolean bl2) {
        this.pieces.setActive(view, bl2);
        this.notifyDataSetChanged();
    }

    public void setActive(ListAdapter listAdapter, boolean bl2) {
        this.pieces.setActive(listAdapter, bl2);
        this.notifyDataSetChanged();
    }

    private class CascadeDataSetObserver
    extends DataSetObserver {
        private CascadeDataSetObserver() {
        }

        public void onChanged() {
            MergeAdapter.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            MergeAdapter.this.notifyDataSetInvalidated();
        }
    }

    private static class EnabledSackAdapter
    extends SackOfViewsAdapter {
        public EnabledSackAdapter(List<View> list) {
            super(list);
        }

        @Override
        public boolean areAllItemsEnabled() {
            return true;
        }

        @Override
        public boolean isEnabled(int n2) {
            return true;
        }
    }

    private static class PieceState {
        ListAdapter adapter;
        boolean isActive = true;

        PieceState(ListAdapter listAdapter, boolean bl2) {
            this.adapter = listAdapter;
            this.isActive = bl2;
        }
    }

    private static class PieceStateRoster {
        protected ArrayList<ListAdapter> active = null;
        protected ArrayList<PieceState> pieces = new ArrayList();

        private PieceStateRoster() {
        }

        void add(ListAdapter listAdapter) {
            this.pieces.add(new PieceState(listAdapter, true));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        List<ListAdapter> getPieces() {
            if (this.active != null) return this.active;
            this.active = new ArrayList();
            Iterator<PieceState> iterator = this.pieces.iterator();
            while (iterator.hasNext()) {
                PieceState pieceState = iterator.next();
                if (!pieceState.isActive) continue;
                this.active.add(pieceState.adapter);
            }
            return this.active;
        }

        List<PieceState> getRawPieces() {
            return this.pieces;
        }

        void setActive(View view, boolean bl2) {
            PieceState pieceState;
            Iterator<PieceState> iterator = this.pieces.iterator();
            do {
                if (!iterator.hasNext()) {
                    return;
                }
                pieceState = iterator.next();
            } while (!(pieceState.adapter instanceof SackOfViewsAdapter) || !((SackOfViewsAdapter)pieceState.adapter).hasView(view));
            pieceState.isActive = bl2;
            this.active = null;
        }

        void setActive(ListAdapter listAdapter, boolean bl2) {
            PieceState pieceState;
            Iterator<PieceState> iterator = this.pieces.iterator();
            do {
                if (!iterator.hasNext()) {
                    return;
                }
                pieceState = iterator.next();
            } while (pieceState.adapter != listAdapter);
            pieceState.isActive = bl2;
            this.active = null;
        }
    }
}

