/*
 * Decompiled with CFR 0.152.
 */
package com.codebutler.android_websockets;

import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.codebutler.android_websockets.HybiParser;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.LineParser;

public class WebSocketClient {
    private static final String TAG = "WebSocketClient";
    private static TrustManager[] sTrustManagers;
    private boolean mConnected;
    private List<BasicNameValuePair> mExtraHeaders;
    private Handler mHandler;
    private HandlerThread mHandlerThread;
    private Listener mListener;
    private HybiParser mParser;
    private final Object mSendLock = new Object();
    private Socket mSocket;
    private Thread mThread;
    private URI mURI;

    public WebSocketClient(URI uRI, Listener listener, List<BasicNameValuePair> list) {
        this.mURI = uRI;
        this.mListener = listener;
        this.mExtraHeaders = list;
        this.mConnected = false;
        this.mParser = new HybiParser(this);
        this.mHandlerThread = new HandlerThread("websocket-thread");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
    }

    static /* synthetic */ Socket access$202(WebSocketClient webSocketClient, Socket socket) {
        webSocketClient.mSocket = socket;
        return socket;
    }

    static /* synthetic */ boolean access$902(WebSocketClient webSocketClient, boolean bl2) {
        webSocketClient.mConnected = bl2;
        return bl2;
    }

    private String createSecret() {
        byte[] byArray = new byte[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            byArray[i2] = (byte)(256.0 * Math.random());
        }
        return Base64.encodeToString((byte[])byArray, (int)0).trim();
    }

    private SSLSocketFactory getSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, sTrustManagers, null);
        return sSLContext.getSocketFactory();
    }

    private Header parseHeader(String string2) {
        return BasicLineParser.parseHeader((String)string2, (LineParser)new BasicLineParser());
    }

    private StatusLine parseStatusLine(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        return BasicLineParser.parseStatusLine((String)string2, (LineParser)new BasicLineParser());
    }

    private String readLine(HybiParser.HappyDataInputStream happyDataInputStream) throws IOException {
        int n2 = happyDataInputStream.read();
        if (n2 == -1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("");
        while (n2 != 10) {
            if (n2 != 13) {
                stringBuilder.append((char)n2);
            }
            if ((n2 = happyDataInputStream.read()) != -1) continue;
            return null;
        }
        return stringBuilder.toString();
    }

    public static void setTrustManagers(TrustManager[] trustManagerArray) {
        sTrustManagers = trustManagerArray;
    }

    public void connect() {
        if (this.mThread != null && this.mThread.isAlive()) {
            return;
        }
        this.mThread = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                HybiParser.HappyDataInputStream happyDataInputStream;
                block13: {
                    int n2 = WebSocketClient.this.mURI.getPort() != -1 ? WebSocketClient.this.mURI.getPort() : (WebSocketClient.this.mURI.getScheme().equals("wss") || WebSocketClient.this.mURI.getScheme().equals("https") ? 443 : 80);
                    String string2 = TextUtils.isEmpty((CharSequence)WebSocketClient.this.mURI.getPath()) ? "/" : WebSocketClient.this.mURI.getPath();
                    if (!TextUtils.isEmpty((CharSequence)WebSocketClient.this.mURI.getQuery())) {
                        string2 = string2 + "?" + WebSocketClient.this.mURI.getQuery();
                    }
                    String string3 = WebSocketClient.this.mURI.getScheme().equals("wss") ? "https" : "http";
                    URI uRI = new URI(string3, "//" + WebSocketClient.this.mURI.getHost(), null);
                    SocketFactory socketFactory = WebSocketClient.this.mURI.getScheme().equals("wss") || WebSocketClient.this.mURI.getScheme().equals("https") ? WebSocketClient.this.getSSLSocketFactory() : SocketFactory.getDefault();
                    WebSocketClient.access$202(WebSocketClient.this, socketFactory.createSocket(WebSocketClient.this.mURI.getHost(), n2));
                    PrintWriter printWriter = new PrintWriter(WebSocketClient.this.mSocket.getOutputStream());
                    printWriter.print("GET " + string2 + " HTTP/1.1\r\n");
                    printWriter.print("Upgrade: websocket\r\n");
                    printWriter.print("Connection: Upgrade\r\n");
                    printWriter.print("Host: " + WebSocketClient.this.mURI.getHost() + ":" + WebSocketClient.this.mURI.getPort() + "\r\n");
                    printWriter.print("Origin: " + uRI.toString() + "\r\n");
                    printWriter.print("Sec-WebSocket-Key: " + WebSocketClient.this.createSecret() + "\r\n");
                    printWriter.print("Sec-WebSocket-Version: 13\r\n");
                    if (WebSocketClient.this.mExtraHeaders != null) {
                        for (NameValuePair nameValuePair : WebSocketClient.this.mExtraHeaders) {
                            Object[] objectArray = new Object[]{nameValuePair.getName(), nameValuePair.getValue()};
                            printWriter.print(String.format("%s: %s\r\n", objectArray));
                        }
                    }
                    printWriter.print("\r\n");
                    printWriter.flush();
                    happyDataInputStream = new HybiParser.HappyDataInputStream(WebSocketClient.this.mSocket.getInputStream());
                    StatusLine statusLine = WebSocketClient.this.parseStatusLine(WebSocketClient.this.readLine(happyDataInputStream));
                    if (statusLine == null) {
                        throw new HttpException("Received no reply from server.");
                    }
                    if (statusLine.getStatusCode() == 101) break block13;
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                }
                try {
                    while (true) {
                        String string4;
                        if (TextUtils.isEmpty((CharSequence)(string4 = WebSocketClient.this.readLine(happyDataInputStream)))) {
                            WebSocketClient.this.mListener.onConnect();
                            WebSocketClient.access$902(WebSocketClient.this, true);
                            WebSocketClient.this.mParser.start(happyDataInputStream);
                            return;
                        }
                        if (!WebSocketClient.this.parseHeader(string4).getName().equals("Sec-WebSocket-Accept")) continue;
                    }
                }
                catch (EOFException eOFException) {
                    Log.d((String)WebSocketClient.TAG, (String)"WebSocket EOF!", (Throwable)eOFException);
                    WebSocketClient.this.mListener.onDisconnect(0, "EOF");
                    WebSocketClient.access$902(WebSocketClient.this, false);
                    return;
                }
                catch (SSLException sSLException) {
                    Log.d((String)WebSocketClient.TAG, (String)"Websocket SSL error!", (Throwable)sSLException);
                    WebSocketClient.this.mListener.onDisconnect(0, "SSL");
                    WebSocketClient.access$902(WebSocketClient.this, false);
                    return;
                }
                catch (Exception exception) {
                    WebSocketClient.this.mListener.onError(exception);
                    return;
                }
            }
        });
        this.mThread.start();
    }

    public void disconnect() {
        if (this.mSocket != null) {
            this.mHandler.post(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    if (WebSocketClient.this.mSocket != null) {
                        try {
                            WebSocketClient.this.mSocket.close();
                        }
                        catch (IOException iOException) {
                            Log.d((String)WebSocketClient.TAG, (String)"Error while disconnecting", (Throwable)iOException);
                            WebSocketClient.this.mListener.onError(iOException);
                        }
                        WebSocketClient.access$202(WebSocketClient.this, null);
                    }
                    WebSocketClient.access$902(WebSocketClient.this, false);
                }
            });
        }
    }

    public Listener getListener() {
        return this.mListener;
    }

    public boolean isConnected() {
        return this.mConnected;
    }

    public void send(String string2) {
        this.sendFrame(this.mParser.frame(string2));
    }

    public void send(byte[] byArray) {
        this.sendFrame(this.mParser.frame(byArray));
    }

    void sendFrame(final byte[] byArray) {
        this.mHandler.post(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    Object object = WebSocketClient.this.mSendLock;
                    synchronized (object) {
                    }
                }
                catch (IOException iOException) {
                    WebSocketClient.this.mListener.onError(iOException);
                    return;
                }
                {
                    OutputStream outputStream = WebSocketClient.this.mSocket.getOutputStream();
                    outputStream.write(byArray);
                    outputStream.flush();
                    return;
                }
            }
        });
    }

    public static interface Listener {
        public void onConnect();

        public void onDisconnect(int var1, String var2);

        public void onError(Exception var1);

        public void onMessage(String var1);

        public void onMessage(byte[] var1);
    }
}

