/*
 * Decompiled with CFR 0.152.
 */
package com.codebutler.android_websockets;

import android.util.Log;
import com.codebutler.android_websockets.WebSocketClient;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;

public class HybiParser {
    private static final int BYTE = 255;
    private static final int FIN = 128;
    private static final List<Integer> FRAGMENTED_OPCODES;
    private static final int LENGTH = 127;
    private static final int MASK = 128;
    private static final int MODE_BINARY = 2;
    private static final int MODE_TEXT = 1;
    private static final int OPCODE = 15;
    private static final List<Integer> OPCODES;
    private static final int OP_BINARY = 2;
    private static final int OP_CLOSE = 8;
    private static final int OP_CONTINUATION = 0;
    private static final int OP_PING = 9;
    private static final int OP_PONG = 10;
    private static final int OP_TEXT = 1;
    private static final int RSV1 = 64;
    private static final int RSV2 = 32;
    private static final int RSV3 = 16;
    private static final String TAG = "HybiParser";
    private ByteArrayOutputStream mBuffer;
    private WebSocketClient mClient;
    private boolean mClosed = false;
    private boolean mFinal;
    private int mLength;
    private int mLengthSize;
    private byte[] mMask = new byte[0];
    private boolean mMasked;
    private boolean mMasking = true;
    private int mMode;
    private int mOpcode;
    private byte[] mPayload = new byte[0];
    private int mStage;

    static {
        Integer[] integerArray = new Integer[]{0, 1, 2, 8, 9, 10};
        OPCODES = Arrays.asList(integerArray);
        Integer[] integerArray2 = new Integer[]{0, 1, 2};
        FRAGMENTED_OPCODES = Arrays.asList(integerArray2);
    }

    public HybiParser(WebSocketClient webSocketClient) {
        this.mBuffer = new ByteArrayOutputStream();
        this.mClient = webSocketClient;
    }

    private static long byteArrayToLong(byte[] byArray, int n2, int n3) {
        if (byArray.length < n3) {
            throw new IllegalArgumentException("length must be less than or equal to b.length");
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = 8 * (n3 - 1 - i2);
            l2 += (long)((0xFF & byArray[i2 + n2]) << n4);
        }
        return l2;
    }

    private static byte[] copyOfRange(byte[] byArray, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
        int n4 = byArray.length;
        if (n2 < 0 || n2 > n4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n5 = n3 - n2;
        int n6 = Math.min(n5, n4 - n2);
        byte[] byArray2 = new byte[n5];
        System.arraycopy(byArray, n2, byArray2, 0, n6);
        return byArray2;
    }

    private byte[] decode(String string2) {
        try {
            byte[] byArray = string2.getBytes("UTF-8");
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void emitFrame() throws IOException {
        byte[] byArray = HybiParser.mask(this.mPayload, this.mMask, 0);
        int n2 = this.mOpcode;
        if (n2 == 0) {
            if (this.mMode == 0) {
                throw new ProtocolError("Mode was not set.");
            }
            this.mBuffer.write(byArray);
            if (!this.mFinal) return;
            byte[] byArray2 = this.mBuffer.toByteArray();
            if (this.mMode == 1) {
                this.mClient.getListener().onMessage(this.encode(byArray2));
            } else {
                this.mClient.getListener().onMessage(byArray2);
            }
            this.reset();
            return;
        }
        if (n2 == 1) {
            if (this.mFinal) {
                String string2 = this.encode(byArray);
                this.mClient.getListener().onMessage(string2);
                return;
            }
            this.mMode = 1;
            this.mBuffer.write(byArray);
            return;
        }
        if (n2 == 2) {
            if (this.mFinal) {
                this.mClient.getListener().onMessage(byArray);
                return;
            }
            this.mMode = 2;
            this.mBuffer.write(byArray);
            return;
        }
        if (n2 == 8) {
            int n3 = byArray.length;
            int n4 = 0;
            if (n3 >= 2) {
                n4 = 256 * byArray[0] + byArray[1];
            }
            String string3 = byArray.length > 2 ? this.encode(this.slice(byArray, 2)) : null;
            Log.d((String)TAG, (String)("Got close op! " + n4 + " " + string3));
            this.mClient.getListener().onDisconnect(n4, string3);
            return;
        }
        if (n2 == 9) {
            if (byArray.length > 125) {
                throw new ProtocolError("Ping payload too large");
            }
            Log.d((String)TAG, (String)"Sending pong!!");
            this.mClient.sendFrame(this.frame(byArray, 10, -1));
            return;
        }
        if (n2 != 10) return;
        String string4 = this.encode(byArray);
        Log.d((String)TAG, (String)("Got pong! " + string4));
    }

    private String encode(byte[] byArray) {
        try {
            String string2 = new String(byArray, "UTF-8");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private byte[] frame(Object object, int n2, int n3) {
        if (this.mClosed) {
            return null;
        }
        Log.d((String)TAG, (String)("Creating frame for: " + object + " op: " + n2 + " err: " + n3));
        byte[] byArray = object instanceof String ? this.decode((String)object) : (byte[])object;
        int n4 = n3 > 0 ? 2 : 0;
        int n5 = n4 + byArray.length;
        int n6 = n5 <= 125 ? 2 : (n5 <= 65535 ? 4 : 10);
        int n7 = this.mMasking ? 4 : 0;
        int n8 = n6 + n7;
        int n9 = this.mMasking ? 128 : 0;
        byte[] byArray2 = new byte[n5 + n8];
        byArray2[0] = (byte)(0xFFFFFF80 | (byte)n2);
        if (n5 <= 125) {
            byArray2[1] = (byte)(n9 | n5);
        } else if (n5 <= 65535) {
            byArray2[1] = (byte)(n9 | 0x7E);
            byArray2[2] = (byte)Math.floor(n5 / 256);
            byArray2[3] = (byte)(n5 & 0xFF);
        } else {
            byArray2[1] = (byte)(n9 | 0x7F);
            byArray2[2] = (byte)(0xFF & (int)Math.floor((double)n5 / Math.pow(2.0, 56.0)));
            byArray2[3] = (byte)(0xFF & (int)Math.floor((double)n5 / Math.pow(2.0, 48.0)));
            byArray2[4] = (byte)(0xFF & (int)Math.floor((double)n5 / Math.pow(2.0, 40.0)));
            byArray2[5] = (byte)(0xFF & (int)Math.floor((double)n5 / Math.pow(2.0, 32.0)));
            byArray2[6] = (byte)(0xFF & (int)Math.floor((double)n5 / Math.pow(2.0, 24.0)));
            byArray2[7] = (byte)(0xFF & (int)Math.floor((double)n5 / Math.pow(2.0, 16.0)));
            byArray2[8] = (byte)(0xFF & (int)Math.floor((double)n5 / Math.pow(2.0, 8.0)));
            byArray2[9] = (byte)(n5 & 0xFF);
        }
        if (n3 > 0) {
            byArray2[n8] = (byte)(0xFF & (int)Math.floor(n3 / 256));
            byArray2[n8 + 1] = (byte)(n3 & 0xFF);
        }
        System.arraycopy(byArray, 0, byArray2, n8 + n4, byArray.length);
        if (!this.mMasking) return byArray2;
        byte[] byArray3 = new byte[]{(byte)Math.floor(256.0 * Math.random()), (byte)Math.floor(256.0 * Math.random()), (byte)Math.floor(256.0 * Math.random()), (byte)Math.floor(256.0 * Math.random())};
        System.arraycopy(byArray3, 0, byArray2, n6, byArray3.length);
        HybiParser.mask(byArray2, byArray3, n8);
        return byArray2;
    }

    private byte[] frame(String string2, int n2, int n3) {
        return this.frame((Object)string2, n2, n3);
    }

    private byte[] frame(byte[] byArray, int n2, int n3) {
        return this.frame((Object)byArray, n2, n3);
    }

    private int getInteger(byte[] byArray) throws ProtocolError {
        long l2 = HybiParser.byteArrayToLong(byArray, 0, byArray.length);
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new ProtocolError("Bad integer: " + l2);
        }
        return (int)l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] mask(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray2.length != 0) {
            for (int i2 = 0; i2 < byArray.length - n2; ++i2) {
                byArray[n2 + i2] = (byte)(byArray[n2 + i2] ^ byArray2[i2 % 4]);
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseExtendedLength(byte[] byArray) throws ProtocolError {
        this.mLength = this.getInteger(byArray);
        int n2 = this.mMasked ? 3 : 4;
        this.mStage = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseLength(byte by2) {
        boolean bl2 = (by2 & 0x80) == 128;
        this.mMasked = bl2;
        this.mLength = by2 & 0x7F;
        if (this.mLength >= 0 && this.mLength <= 125) {
            int n2 = this.mMasked ? 3 : 4;
            this.mStage = n2;
            return;
        }
        int n3 = this.mLength == 126 ? 2 : 8;
        this.mLengthSize = n3;
        this.mStage = 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseOpcode(byte by2) throws ProtocolError {
        boolean bl2 = (by2 & 0x40) == 64;
        boolean bl3 = (by2 & 0x20) == 32;
        boolean bl4 = (by2 & 0x10) == 16;
        if (bl2 || bl3 || bl4) {
            throw new ProtocolError("RSV not zero");
        }
        boolean bl5 = (by2 & 0x80) == 128;
        this.mFinal = bl5;
        this.mOpcode = by2 & 0xF;
        this.mMask = new byte[0];
        this.mPayload = new byte[0];
        if (!OPCODES.contains(this.mOpcode)) {
            throw new ProtocolError("Bad opcode");
        }
        if (!FRAGMENTED_OPCODES.contains(this.mOpcode) && !this.mFinal) {
            throw new ProtocolError("Expected non-final packet");
        }
        this.mStage = 1;
    }

    private void reset() {
        this.mMode = 0;
        this.mBuffer.reset();
    }

    private byte[] slice(byte[] byArray, int n2) {
        return HybiParser.copyOfRange(byArray, n2, byArray.length);
    }

    public void close(int n2, String string2) {
        if (this.mClosed) {
            return;
        }
        this.mClient.send(this.frame(string2, 8, n2));
        this.mClosed = true;
    }

    public byte[] frame(String string2) {
        return this.frame(string2, 1, -1);
    }

    public byte[] frame(byte[] byArray) {
        return this.frame(byArray, 2, -1);
    }

    public void ping(String string2) {
        this.mClient.send(this.frame(string2, 9, -1));
    }

    public void start(HappyDataInputStream happyDataInputStream) throws IOException {
        block7: while (true) {
            if (happyDataInputStream.available() == -1) {
                this.mClient.getListener().onDisconnect(0, "EOF");
                return;
            }
            switch (this.mStage) {
                default: {
                    continue block7;
                }
                case 0: {
                    this.parseOpcode(happyDataInputStream.readByte());
                    continue block7;
                }
                case 1: {
                    this.parseLength(happyDataInputStream.readByte());
                    continue block7;
                }
                case 2: {
                    this.parseExtendedLength(happyDataInputStream.readBytes(this.mLengthSize));
                    continue block7;
                }
                case 3: {
                    this.mMask = happyDataInputStream.readBytes(4);
                    this.mStage = 4;
                    continue block7;
                }
                case 4: 
            }
            this.mPayload = happyDataInputStream.readBytes(this.mLength);
            this.emitFrame();
            this.mStage = 0;
        }
    }

    public static class HappyDataInputStream
    extends DataInputStream {
        public HappyDataInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public byte[] readBytes(int n2) throws IOException {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 >= n2 || (n4 = this.read(byArray, n3, n2 - n3)) == -1) {
                    if (n3 == n2) break;
                    Object[] objectArray = new Object[]{n3, n2};
                    throw new IOException(String.format("Read wrong number of bytes. Got: %s, Expected: %s.", objectArray));
                }
                n3 += n4;
            }
            return byArray;
        }
    }

    public static class ProtocolError
    extends IOException {
        public ProtocolError(String string2) {
            super(string2);
        }
    }
}

