/*
 * Decompiled with CFR 0.152.
 */
package com.astuetz.viewpager.extensions;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.astuetz.viewpager.extensions.R;
import java.util.Locale;

public class PagerSlidingTabStrip
extends HorizontalScrollView {
    private static final int[] ATTRS = new int[]{16842901, 16842904};
    private boolean checkedTabWidths = false;
    private int currentPosition = 0;
    private float currentPositionOffset = 0.0f;
    private LinearLayout.LayoutParams defaultTabLayoutParams;
    public ViewPager.OnPageChangeListener delegatePageListener;
    private int dividerColor = 0x1A000000;
    private int dividerPadding = 12;
    private Paint dividerPaint;
    private int dividerWidth = 1;
    private LinearLayout.LayoutParams expandedTabLayoutParams;
    private int indicatorColor = -10066330;
    private int indicatorHeight = 8;
    private int lastScrollX = 0;
    private Locale locale;
    private final PageListener pageListener = new PageListener();
    private ViewPager pager;
    private Paint rectPaint;
    private int scrollOffset = 52;
    private boolean shouldExpand = false;
    private int tabBackgroundResId = R.drawable.background_tab;
    private int tabCount;
    private int tabPadding = 24;
    private int tabTextColor = -10066330;
    private int tabTextSize = 12;
    private Typeface tabTypeface = null;
    private int tabTypefaceStyle = 1;
    private LinearLayout tabsContainer;
    private boolean textAllCaps = true;
    private int underlineColor = 0x1A000000;
    private int underlineHeight = 2;

    public PagerSlidingTabStrip(Context context) {
        this(context, null);
    }

    public PagerSlidingTabStrip(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public PagerSlidingTabStrip(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.setFillViewport(true);
        this.setWillNotDraw(false);
        this.tabsContainer = new LinearLayout(context);
        this.tabsContainer.setOrientation(0);
        this.tabsContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.tabsContainer);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.scrollOffset = (int)TypedValue.applyDimension((int)1, (float)this.scrollOffset, (DisplayMetrics)displayMetrics);
        this.indicatorHeight = (int)TypedValue.applyDimension((int)1, (float)this.indicatorHeight, (DisplayMetrics)displayMetrics);
        this.underlineHeight = (int)TypedValue.applyDimension((int)1, (float)this.underlineHeight, (DisplayMetrics)displayMetrics);
        this.dividerPadding = (int)TypedValue.applyDimension((int)1, (float)this.dividerPadding, (DisplayMetrics)displayMetrics);
        this.tabPadding = (int)TypedValue.applyDimension((int)1, (float)this.tabPadding, (DisplayMetrics)displayMetrics);
        this.dividerWidth = (int)TypedValue.applyDimension((int)1, (float)this.dividerWidth, (DisplayMetrics)displayMetrics);
        this.tabTextSize = (int)TypedValue.applyDimension((int)2, (float)this.tabTextSize, (DisplayMetrics)displayMetrics);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, ATTRS);
        this.tabTextSize = typedArray.getDimensionPixelSize(0, this.tabTextSize);
        this.tabTextColor = typedArray.getColor(1, this.tabTextColor);
        typedArray.recycle();
        TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, R.styleable.PagerSlidingTabStrip);
        this.indicatorColor = typedArray2.getColor(0, this.indicatorColor);
        this.underlineColor = typedArray2.getColor(1, this.underlineColor);
        this.dividerColor = typedArray2.getColor(2, this.dividerColor);
        this.indicatorHeight = typedArray2.getDimensionPixelSize(3, this.indicatorHeight);
        this.underlineHeight = typedArray2.getDimensionPixelSize(4, this.underlineHeight);
        this.dividerPadding = typedArray2.getDimensionPixelSize(5, this.dividerPadding);
        this.tabPadding = typedArray2.getDimensionPixelSize(6, this.tabPadding);
        this.tabBackgroundResId = typedArray2.getResourceId(8, this.tabBackgroundResId);
        this.shouldExpand = typedArray2.getBoolean(9, this.shouldExpand);
        this.scrollOffset = typedArray2.getDimensionPixelSize(7, this.scrollOffset);
        this.textAllCaps = typedArray2.getBoolean(10, this.textAllCaps);
        typedArray2.recycle();
        this.rectPaint = new Paint();
        this.rectPaint.setAntiAlias(true);
        this.rectPaint.setStyle(Paint.Style.FILL);
        this.dividerPaint = new Paint();
        this.dividerPaint.setAntiAlias(true);
        this.dividerPaint.setStrokeWidth((float)this.dividerWidth);
        this.defaultTabLayoutParams = new LinearLayout.LayoutParams(-2, -1);
        this.expandedTabLayoutParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
        if (this.locale == null) {
            this.locale = this.getResources().getConfiguration().locale;
        }
    }

    static /* synthetic */ int access$102(PagerSlidingTabStrip pagerSlidingTabStrip, int n2) {
        pagerSlidingTabStrip.currentPosition = n2;
        return n2;
    }

    static /* synthetic */ float access$402(PagerSlidingTabStrip pagerSlidingTabStrip, float f2) {
        pagerSlidingTabStrip.currentPositionOffset = f2;
        return f2;
    }

    private void addIconTab(final int n2, int n3) {
        ImageButton imageButton = new ImageButton(this.getContext());
        imageButton.setFocusable(true);
        imageButton.setImageResource(n3);
        imageButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PagerSlidingTabStrip.this.pager.setCurrentItem(n2);
            }
        });
        this.tabsContainer.addView((View)imageButton);
    }

    private void addTextTab(final int n2, String string2) {
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)string2);
        textView.setFocusable(true);
        textView.setGravity(17);
        textView.setSingleLine();
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PagerSlidingTabStrip.this.pager.setCurrentItem(n2);
            }
        });
        this.tabsContainer.addView((View)textView);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scrollToChild(int n2, int n3) {
        int n4;
        block5: {
            block4: {
                if (this.tabCount == 0) break block4;
                n4 = n3 + this.tabsContainer.getChildAt(n2).getLeft();
                if (n2 > 0 || n3 > 0) {
                    n4 -= this.scrollOffset;
                }
                if (n4 != this.lastScrollX) break block5;
            }
            return;
        }
        this.lastScrollX = n4;
        this.scrollTo(n4, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateTabStyles() {
        int n2 = 0;
        while (n2 < this.tabCount) {
            View view = this.tabsContainer.getChildAt(n2);
            view.setLayoutParams((ViewGroup.LayoutParams)this.defaultTabLayoutParams);
            view.setBackgroundResource(this.tabBackgroundResId);
            if (this.shouldExpand) {
                view.setPadding(0, 0, 0, 0);
            } else {
                view.setPadding(this.tabPadding, 0, this.tabPadding, 0);
            }
            if (view instanceof TextView) {
                TextView textView = (TextView)view;
                textView.setTextSize(0, (float)this.tabTextSize);
                textView.setTypeface(this.tabTypeface, this.tabTypefaceStyle);
                textView.setTextColor(this.tabTextColor);
                if (this.textAllCaps) {
                    if (Build.VERSION.SDK_INT >= 14) {
                        textView.setAllCaps(true);
                    } else {
                        textView.setText((CharSequence)textView.getText().toString().toUpperCase(this.locale));
                    }
                }
            }
            ++n2;
        }
        return;
    }

    public int getDividerColor() {
        return this.dividerColor;
    }

    public int getDividerPadding() {
        return this.dividerPadding;
    }

    public int getIndicatorColor() {
        return this.indicatorColor;
    }

    public int getIndicatorHeight() {
        return this.indicatorHeight;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public boolean getShouldExpand() {
        return this.shouldExpand;
    }

    public int getTabBackground() {
        return this.tabBackgroundResId;
    }

    public int getTabPaddingLeftRight() {
        return this.tabPadding;
    }

    public int getTextColor() {
        return this.tabTextColor;
    }

    public int getTextSize() {
        return this.tabTextSize;
    }

    public int getUnderlineColor() {
        return this.underlineColor;
    }

    public int getUnderlineHeight() {
        return this.underlineHeight;
    }

    public boolean isTextAllCaps() {
        return this.textAllCaps;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notifyDataSetChanged() {
        this.tabsContainer.removeAllViews();
        this.tabCount = this.pager.getAdapter().getCount();
        int n2 = 0;
        while (true) {
            if (n2 >= this.tabCount) {
                this.updateTabStyles();
                this.checkedTabWidths = false;
                this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    @SuppressLint(value={"NewApi"})
                    public void onGlobalLayout() {
                        if (Build.VERSION.SDK_INT < 16) {
                            PagerSlidingTabStrip.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            PagerSlidingTabStrip.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                        PagerSlidingTabStrip.access$102(PagerSlidingTabStrip.this, PagerSlidingTabStrip.this.pager.getCurrentItem());
                        PagerSlidingTabStrip.this.scrollToChild(PagerSlidingTabStrip.this.currentPosition, 0);
                    }
                });
                return;
            }
            if (this.pager.getAdapter() instanceof IconTabProvider) {
                this.addIconTab(n2, ((IconTabProvider)((Object)this.pager.getAdapter())).getPageIconResId(n2));
            } else {
                this.addTextTab(n2, this.pager.getAdapter().getPageTitle(n2).toString());
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isInEditMode() && this.tabCount != 0) {
            int n2 = this.getHeight();
            this.rectPaint.setColor(this.indicatorColor);
            View view = this.tabsContainer.getChildAt(this.currentPosition);
            float f2 = view.getLeft();
            float f3 = view.getRight();
            if (this.currentPositionOffset > 0.0f && this.currentPosition < -1 + this.tabCount) {
                View view2 = this.tabsContainer.getChildAt(1 + this.currentPosition);
                float f4 = view2.getLeft();
                float f5 = view2.getRight();
                f2 = f4 * this.currentPositionOffset + f2 * (1.0f - this.currentPositionOffset);
                f3 = f5 * this.currentPositionOffset + f3 * (1.0f - this.currentPositionOffset);
            }
            canvas.drawRect(f2, (float)(n2 - this.indicatorHeight), f3, (float)n2, this.rectPaint);
            this.rectPaint.setColor(this.underlineColor);
            canvas.drawRect(0.0f, (float)(n2 - this.underlineHeight), (float)this.tabsContainer.getWidth(), (float)n2, this.rectPaint);
            this.dividerPaint.setColor(this.dividerColor);
            for (int i2 = 0; i2 < -1 + this.tabCount; ++i2) {
                View view3 = this.tabsContainer.getChildAt(i2);
                canvas.drawLine((float)view3.getRight(), (float)this.dividerPadding, (float)view3.getRight(), (float)(n2 - this.dividerPadding), this.dividerPaint);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        int n4;
        int n5;
        block7: {
            block6: {
                super.onMeasure(n2, n3);
                if (!this.shouldExpand || View.MeasureSpec.getMode((int)n2) == 0) break block6;
                n5 = this.getMeasuredWidth();
                n4 = 0;
                for (int i2 = 0; i2 < this.tabCount; n4 += this.tabsContainer.getChildAt(i2).getMeasuredWidth(), ++i2) {
                }
                if (!this.checkedTabWidths && n4 > 0 && n5 > 0) break block7;
            }
            return;
        }
        if (n4 <= n5) {
            for (int i3 = 0; i3 < this.tabCount; ++i3) {
                this.tabsContainer.getChildAt(i3).setLayoutParams((ViewGroup.LayoutParams)this.expandedTabLayoutParams);
            }
        }
        this.checkedTabWidths = true;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.currentPosition = savedState.currentPosition;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.currentPosition = this.currentPosition;
        return savedState;
    }

    public void setAllCaps(boolean bl2) {
        this.textAllCaps = bl2;
    }

    public void setDividerColor(int n2) {
        this.dividerColor = n2;
        this.invalidate();
    }

    public void setDividerColorResource(int n2) {
        this.dividerColor = this.getResources().getColor(n2);
        this.invalidate();
    }

    public void setDividerPadding(int n2) {
        this.dividerPadding = n2;
        this.invalidate();
    }

    public void setIndicatorColor(int n2) {
        this.indicatorColor = n2;
        this.invalidate();
    }

    public void setIndicatorColorResource(int n2) {
        this.indicatorColor = this.getResources().getColor(n2);
        this.invalidate();
    }

    public void setIndicatorHeight(int n2) {
        this.indicatorHeight = n2;
        this.invalidate();
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        this.delegatePageListener = onPageChangeListener;
    }

    public void setScrollOffset(int n2) {
        this.scrollOffset = n2;
        this.invalidate();
    }

    public void setShouldExpand(boolean bl2) {
        this.shouldExpand = bl2;
        this.requestLayout();
    }

    public void setTabBackground(int n2) {
        this.tabBackgroundResId = n2;
    }

    public void setTabPaddingLeftRight(int n2) {
        this.tabPadding = n2;
        this.updateTabStyles();
    }

    public void setTextColor(int n2) {
        this.tabTextColor = n2;
        this.updateTabStyles();
    }

    public void setTextColorResource(int n2) {
        this.tabTextColor = this.getResources().getColor(n2);
        this.updateTabStyles();
    }

    public void setTextSize(int n2) {
        this.tabTextSize = n2;
        this.updateTabStyles();
    }

    public void setTypeface(Typeface typeface, int n2) {
        this.tabTypeface = typeface;
        this.tabTypefaceStyle = n2;
        this.updateTabStyles();
    }

    public void setUnderlineColor(int n2) {
        this.underlineColor = n2;
        this.invalidate();
    }

    public void setUnderlineColorResource(int n2) {
        this.underlineColor = this.getResources().getColor(n2);
        this.invalidate();
    }

    public void setUnderlineHeight(int n2) {
        this.underlineHeight = n2;
        this.invalidate();
    }

    public void setViewPager(ViewPager viewPager) {
        this.pager = viewPager;
        if (viewPager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        viewPager.setOnPageChangeListener(this.pageListener);
        this.notifyDataSetChanged();
    }

    public static interface IconTabProvider {
        public int getPageIconResId(int var1);
    }

    private class PageListener
    implements ViewPager.OnPageChangeListener {
        private PageListener() {
        }

        @Override
        public void onPageScrollStateChanged(int n2) {
            if (n2 == 0) {
                PagerSlidingTabStrip.this.scrollToChild(PagerSlidingTabStrip.this.pager.getCurrentItem(), 0);
            }
            if (PagerSlidingTabStrip.this.delegatePageListener != null) {
                PagerSlidingTabStrip.this.delegatePageListener.onPageScrollStateChanged(n2);
            }
        }

        @Override
        public void onPageScrolled(int n2, float f2, int n3) {
            PagerSlidingTabStrip.access$102(PagerSlidingTabStrip.this, n2);
            PagerSlidingTabStrip.access$402(PagerSlidingTabStrip.this, f2);
            PagerSlidingTabStrip.this.scrollToChild(n2, (int)(f2 * (float)PagerSlidingTabStrip.this.tabsContainer.getChildAt(n2).getWidth()));
            PagerSlidingTabStrip.this.invalidate();
            if (PagerSlidingTabStrip.this.delegatePageListener != null) {
                PagerSlidingTabStrip.this.delegatePageListener.onPageScrolled(n2, f2, n3);
            }
        }

        @Override
        public void onPageSelected(int n2) {
            if (PagerSlidingTabStrip.this.delegatePageListener != null) {
                PagerSlidingTabStrip.this.delegatePageListener.onPageSelected(n2);
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        int currentPosition;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.currentPosition = parcel.readInt();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeInt(this.currentPosition);
        }
    }
}

