/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.webservices;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.webservices.json.CreateUserJson;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.octo.android.robospice.request.googlehttpclient.GoogleHttpClientSpiceRequest;
import java.util.HashMap;
import java.util.Locale;

public class UpdateUserRequest
extends GoogleHttpClientSpiceRequest<CreateUserJson> {
    String baseUrl = "http://webservices.aptoide.com/webservices/createUser";
    private Context context;
    private String name = "";

    public UpdateUserRequest(Context context) {
        super(CreateUserJson.class);
        this.context = context;
    }

    @Override
    public CreateUserJson loadDataFromNetwork() throws Exception {
        GenericUrl genericUrl = new GenericUrl(this.baseUrl);
        AccountManager accountManager = AccountManager.get((Context)this.context);
        Account account = accountManager.getAccountsByType("cm.aptoide.pt")[0];
        String string2 = account.name.toLowerCase(Locale.ENGLISH);
        String string3 = accountManager.getPassword(account);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string4 = AptoideUtils.Algorithms.computeSHA1sum(string3);
        hashMap.put("mode", "json");
        hashMap.put("email", string2);
        hashMap.put("name", this.name);
        hashMap.put("update", "true");
        hashMap.put("passhash", string4);
        hashMap.put("hmac", AptoideUtils.Algorithms.computeHmacSha1(string2 + string4 + this.name + "true", "bazaar_hmac"));
        UrlEncodedContent urlEncodedContent = new UrlEncodedContent(hashMap);
        HttpRequest httpRequest = this.getHttpRequestFactory().buildPostRequest(genericUrl, urlEncodedContent);
        httpRequest.setParser(new JacksonFactory().createJsonObjectParser());
        return (CreateUserJson)httpRequest.execute().parseAs(this.getResultType());
    }

    public void setName(String string2) {
        this.name = string2;
    }
}

