/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.webservices;

import android.content.Context;
import android.util.Log;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.webservices.json.RelatedApkJson;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.octo.android.robospice.request.googlehttpclient.GoogleHttpClientSpiceRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ListRelatedApkRequest
extends GoogleHttpClientSpiceRequest<RelatedApkJson> {
    String baseUrl = "http://webservices.aptoide.com/webservices/2/listRelatedApks";
    private Context context;
    private int limit;
    private String mode;
    private String packageName;
    private String repos;
    private int vercode;

    public ListRelatedApkRequest(Context context) {
        super(RelatedApkJson.class);
        this.context = context;
    }

    @Override
    public RelatedApkJson loadDataFromNetwork() throws Exception {
        ArrayList<WebserviceOptions> arrayList = new ArrayList<WebserviceOptions>();
        GenericUrl genericUrl = new GenericUrl(this.baseUrl);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("mode", "json");
        hashMap.put("apkid", this.packageName);
        if (this.repos != null) {
            arrayList.add(new WebserviceOptions("repo", this.repos));
        }
        if (this.mode != null) {
            arrayList.add(new WebserviceOptions("type", this.mode));
        }
        arrayList.add(new WebserviceOptions("limit", String.valueOf(this.limit)));
        arrayList.add(new WebserviceOptions("vercode", String.valueOf(this.vercode)));
        arrayList.add(new WebserviceOptions("q", AptoideUtils.filters(this.context)));
        arrayList.add(new WebserviceOptions("lang", AptoideUtils.getMyCountryCode(this.context)));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append((WebserviceOptions)iterator.next());
            stringBuilder.append(";");
        }
        stringBuilder.append(")");
        hashMap.put("options", stringBuilder.toString());
        UrlEncodedContent urlEncodedContent = new UrlEncodedContent(hashMap);
        HttpRequest httpRequest = this.getHttpRequestFactory().buildPostRequest(genericUrl, urlEncodedContent);
        Log.d((String)"Aptoide-ApkRelated", (String)genericUrl.toString());
        httpRequest.setParser(new JacksonFactory().createJsonObjectParser());
        return (RelatedApkJson)httpRequest.execute().parseAs(this.getResultType());
    }

    public void setLimit(int n2) {
        this.limit = n2;
    }

    public void setMode(String string2) {
        this.mode = string2;
    }

    public void setPackageName(String string2) {
        this.packageName = string2;
    }

    public void setRepos(String string2) {
        this.repos = string2;
    }

    public void setVercode(int n2) {
        this.vercode = n2;
    }

    public class WebserviceOptions {
        String key;
        String value;

        private WebserviceOptions(String string2, String string3) {
            this.value = string3;
            this.key = string2;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

