/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.webservices;

import android.content.Context;
import android.util.Log;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.webservices.json.GetApkInfoJson;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.octo.android.robospice.request.googlehttpclient.GoogleHttpClientSpiceRequest;
import java.util.ArrayList;
import java.util.Iterator;

public class GetApkInfoRequestFromMd5
extends GoogleHttpClientSpiceRequest<GetApkInfoJson> {
    private Context context;
    private String md5Sum;
    private String packageName;
    private String repoName;
    private String token;
    private String versionName;

    public GetApkInfoRequestFromMd5(Context context) {
        super(GetApkInfoJson.class);
        this.context = context;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public String getToken() {
        return this.token;
    }

    public String getVersionName() {
        return this.versionName;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public GetApkInfoJson loadDataFromNetwork() throws Exception {
        ArrayList<WebserviceOptions> arrayList = new ArrayList<WebserviceOptions>();
        if (this.token != null) {
            arrayList.add(new WebserviceOptions("token", this.token));
        }
        arrayList.add(new WebserviceOptions("cmtlimit", "5"));
        arrayList.add(new WebserviceOptions("payinfo", "true"));
        arrayList.add(new WebserviceOptions("q", AptoideUtils.filters(this.context)));
        arrayList.add(new WebserviceOptions("lang", AptoideUtils.getMyCountryCode(this.context)));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append((WebserviceOptions)iterator.next());
            stringBuilder.append(";");
        }
        stringBuilder.append(")");
        String string2 = this.repoName != null ? "http://webservices.aptoide.com/webservices/2/getApkInfo/" + this.repoName + "/md5sum:" + this.md5Sum + "/options=" + stringBuilder.toString() + "/json" : "http://webservices.aptoide.com/webservices/2/getApkInfo/md5sum:" + this.md5Sum + "/options=" + stringBuilder.toString() + "/json";
        GenericUrl genericUrl = new GenericUrl(string2);
        Log.e((String)"Aptoide-Request", (String)string2);
        HttpRequest httpRequest = this.getHttpRequestFactory().buildGetRequest(genericUrl);
        httpRequest.setParser(new JacksonFactory().createJsonObjectParser());
        return (GetApkInfoJson)httpRequest.execute().parseAs(this.getResultType());
    }

    public void setMd5Sum(String string2) {
        this.md5Sum = string2;
    }

    public void setPackageName(String string2) {
        this.packageName = string2;
    }

    public void setRepoName(String string2) {
        this.repoName = string2;
    }

    public void setToken(String string2) {
        this.token = string2;
    }

    public void setVersionName(String string2) {
        this.versionName = string2;
    }

    public class WebserviceOptions {
        String key;
        String value;

        private WebserviceOptions(String string2, String string3) {
            this.value = string3;
            this.key = string2;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

