/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.webservices;

import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.webservices.json.CreateUserJson;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.octo.android.robospice.request.googlehttpclient.GoogleHttpClientSpiceRequest;
import java.util.HashMap;

public class CreateUserRequest
extends GoogleHttpClientSpiceRequest<CreateUserJson> {
    String baseUrl = "https://webservices.aptoide.com/webservices/createUser";
    private String email;
    private String name = "";
    private String pass;

    public CreateUserRequest() {
        super(CreateUserJson.class);
    }

    @Override
    public CreateUserJson loadDataFromNetwork() throws Exception {
        GenericUrl genericUrl = new GenericUrl(this.baseUrl);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = AptoideUtils.Algorithms.computeSHA1sum(this.pass);
        hashMap.put("mode", "json");
        hashMap.put("email", this.email);
        hashMap.put("passhash", string2);
        hashMap.put("hmac", AptoideUtils.Algorithms.computeHmacSha1(this.email + string2 + this.name, "bazaar_hmac"));
        UrlEncodedContent urlEncodedContent = new UrlEncodedContent(hashMap);
        HttpRequest httpRequest = this.getHttpRequestFactory().buildPostRequest(genericUrl, urlEncodedContent);
        httpRequest.setParser(new JacksonFactory().createJsonObjectParser());
        return (CreateUserJson)httpRequest.execute().parseAs(this.getResultType());
    }

    public void setEmail(String string2) {
        this.email = string2;
    }

    public void setName(String string2) {
        this.name = string2;
    }

    public void setPass(String string2) {
        this.pass = string2;
    }
}

