/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.views;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.TabWidget;
import android.widget.TextView;

public class BadgeView
extends TextView {
    private static final int DEFAULT_BADGE_COLOR = 0;
    private static final int DEFAULT_CORNER_RADIUS_DIP = 8;
    private static final int DEFAULT_LR_PADDING_DIP = 5;
    private static final int DEFAULT_MARGIN_DIP = 5;
    private static final int DEFAULT_POSITION = 2;
    private static final int DEFAULT_TEXT_COLOR = -1;
    public static final int POSITION_BOTTOM_LEFT = 3;
    public static final int POSITION_BOTTOM_RIGHT = 4;
    public static final int POSITION_CENTER = 5;
    public static final int POSITION_TOP_LEFT = 1;
    public static final int POSITION_TOP_RIGHT = 2;
    private static Animation fadeIn;
    private static Animation fadeOut;
    private ShapeDrawable badgeBg;
    private int badgeColor;
    private int badgeMarginH;
    private int badgeMarginV;
    private int badgePosition;
    private Context context;
    private boolean isShown;
    private View target;
    private int targetTabIndex;

    static {
        DEFAULT_BADGE_COLOR = Color.parseColor((String)"#CCFF0000");
    }

    public BadgeView(Context context) {
        this(context, (AttributeSet)null, 16842884);
    }

    public BadgeView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842884);
    }

    public BadgeView(Context context, AttributeSet attributeSet, int n2) {
        this(context, attributeSet, n2, null, 0);
    }

    public BadgeView(Context context, AttributeSet attributeSet, int n2, View view, int n3) {
        super(context, attributeSet, n2);
        this.init(context, view, n3);
    }

    public BadgeView(Context context, View view) {
        this(context, null, 16842884, view, 0);
    }

    public BadgeView(Context context, TabWidget tabWidget, int n2) {
        this(context, null, 16842884, (View)tabWidget, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyLayoutParams() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        switch (this.badgePosition) {
            case 1: {
                layoutParams.gravity = 51;
                layoutParams.setMargins(this.badgeMarginH, this.badgeMarginV, 0, 0);
                break;
            }
            case 2: {
                layoutParams.gravity = 53;
                layoutParams.setMargins(0, this.badgeMarginV, this.badgeMarginH, 0);
                break;
            }
            case 3: {
                layoutParams.gravity = 83;
                layoutParams.setMargins(this.badgeMarginH, 0, 0, this.badgeMarginV);
                break;
            }
            case 4: {
                layoutParams.gravity = 85;
                layoutParams.setMargins(0, 0, this.badgeMarginH, this.badgeMarginV);
                break;
            }
            case 5: {
                layoutParams.gravity = 17;
                layoutParams.setMargins(0, 0, 0, 0);
                break;
            }
        }
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void applyTo(View view) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        ViewParent viewParent = view.getParent();
        FrameLayout frameLayout = new FrameLayout(this.context);
        if (view instanceof TabWidget) {
            View view2;
            this.target = view2 = ((TabWidget)view).getChildTabViewAt(this.targetTabIndex);
            ((ViewGroup)view2).addView((View)frameLayout, new ViewGroup.LayoutParams(-1, -1));
            this.setVisibility(8);
            frameLayout.addView((View)this);
            return;
        }
        ViewGroup viewGroup = (ViewGroup)viewParent;
        int n2 = viewGroup.indexOfChild(view);
        viewGroup.removeView(view);
        viewGroup.addView((View)frameLayout, n2, layoutParams);
        frameLayout.addView(view);
        this.setVisibility(8);
        frameLayout.addView((View)this);
        viewGroup.invalidate();
    }

    private int dipToPixels(int n2) {
        Resources resources = this.getResources();
        return (int)TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)resources.getDisplayMetrics());
    }

    private ShapeDrawable getDefaultBackground() {
        int n2 = this.dipToPixels(8);
        float[] fArray = new float[]{n2, n2, n2, n2, n2, n2, n2, n2};
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new RoundRectShape(fArray, null, null));
        shapeDrawable.getPaint().setColor(this.badgeColor);
        return shapeDrawable;
    }

    private void hide(boolean bl2, Animation animation) {
        this.setVisibility(8);
        if (bl2) {
            this.startAnimation(animation);
        }
        this.isShown = false;
    }

    private void init(Context context, View view, int n2) {
        this.context = context;
        this.target = view;
        this.targetTabIndex = n2;
        this.badgePosition = 2;
        this.badgeMarginV = this.badgeMarginH = this.dipToPixels(5);
        this.badgeColor = DEFAULT_BADGE_COLOR;
        this.setTypeface(Typeface.DEFAULT_BOLD);
        int n3 = this.dipToPixels(5);
        this.setPadding(n3, 0, n3, 0);
        this.setTextColor(-1);
        fadeIn = new AlphaAnimation(0.0f, 1.0f);
        fadeIn.setInterpolator((Interpolator)new DecelerateInterpolator());
        fadeIn.setDuration(200L);
        fadeOut = new AlphaAnimation(1.0f, 0.0f);
        fadeOut.setInterpolator((Interpolator)new AccelerateInterpolator());
        fadeOut.setDuration(200L);
        this.isShown = false;
        if (this.target != null) {
            this.applyTo(this.target);
            return;
        }
        this.show();
    }

    private void show(boolean bl2, Animation animation) {
        if (this.getBackground() == null) {
            if (this.badgeBg == null) {
                this.badgeBg = this.getDefaultBackground();
            }
            this.setBackgroundDrawable((Drawable)this.badgeBg);
        }
        this.applyLayoutParams();
        if (bl2) {
            this.startAnimation(animation);
        }
        this.setVisibility(0);
        this.isShown = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void toggle(boolean bl2, Animation animation, Animation animation2) {
        boolean bl3 = true;
        if (this.isShown) {
            if (!bl2 || animation2 == null) {
                bl3 = false;
            }
            this.hide(bl3, animation2);
            return;
        }
        if (!bl2 || animation == null) {
            bl3 = false;
        }
        this.show(bl3, animation);
    }

    public int decrement(int n2) {
        return this.increment(-n2);
    }

    public int getBadgeBackgroundColor() {
        return this.badgeColor;
    }

    public int getBadgePosition() {
        return this.badgePosition;
    }

    public int getHorizontalBadgeMargin() {
        return this.badgeMarginH;
    }

    public View getTarget() {
        return this.target;
    }

    public int getVerticalBadgeMargin() {
        return this.badgeMarginV;
    }

    public void hide() {
        this.hide(false, null);
    }

    public void hide(Animation animation) {
        this.hide(true, animation);
    }

    public void hide(boolean bl2) {
        this.hide(bl2, fadeOut);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int increment(int n2) {
        int n3;
        CharSequence charSequence = this.getText();
        if (charSequence != null) {
            try {
                int n4;
                n3 = n4 = Integer.parseInt(charSequence.toString());
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 0;
            }
        } else {
            n3 = 0;
        }
        int n5 = n3 + n2;
        this.setText(String.valueOf(n5));
        return n5;
    }

    public boolean isShown() {
        return this.isShown;
    }

    public void setBadgeBackgroundColor(int n2) {
        this.badgeColor = n2;
        this.badgeBg = this.getDefaultBackground();
    }

    public void setBadgeMargin(int n2) {
        this.badgeMarginH = n2;
        this.badgeMarginV = n2;
    }

    public void setBadgeMargin(int n2, int n3) {
        this.badgeMarginH = n2;
        this.badgeMarginV = n3;
    }

    public void setBadgePosition(int n2) {
        this.badgePosition = n2;
    }

    public void show() {
        this.show(false, null);
    }

    public void show(Animation animation) {
        this.show(true, animation);
    }

    public void show(boolean bl2) {
        this.show(bl2, fadeIn);
    }

    public void toggle() {
        this.toggle(false, null, null);
    }

    public void toggle(Animation animation, Animation animation2) {
        this.toggle(true, animation, animation2);
    }

    public void toggle(boolean bl2) {
        this.toggle(bl2, fadeIn, fadeOut);
    }
}

