/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.utils;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.text.format.DateUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.WindowManager;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.InstalledAppsHelper;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.model.Apk;
import cm.aptoide.ptdev.model.IconDownloadPermissions;
import cm.aptoide.ptdev.preferences.EnumPreferences;
import cm.aptoide.ptdev.utils.Base64;
import cm.aptoide.ptdev.utils.Filters;
import cm.aptoide.ptdev.utils.IconSizes;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.Seconds;
import org.json.JSONException;
import org.json.JSONObject;

public class AptoideUtils {
    private static final String cpu;
    private static final String cpu2;
    private static final String cpu3;
    private static final String gles;
    private static final int screen;
    private static final String screenSpec;
    private static final int sdk;

    /*
     * Enabled aggressive block sorting
     */
    static {
        sdk = HWSpecifications.getSdkVer();
        gles = HWSpecifications.getGlEsVer(Aptoide.getContext());
        screen = HWSpecifications.getScreenSize(Aptoide.getContext());
        screenSpec = HWSpecifications.getNumericScreenSize(Aptoide.getContext()) + "/" + HWSpecifications.getDensityDpi(Aptoide.getContext());
        cpu = HWSpecifications.getCpuAbi();
        cpu2 = HWSpecifications.getCpuAbi2();
        String string2 = cpu2.equals("armeabi-v7a") ? "armeabi" : "";
        cpu3 = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CopyStream(InputStream inputStream, OutputStream outputStream) {
        try {
            byte[] byArray = new byte[1024];
            while (true) {
                int n2;
                if ((n2 = inputStream.read(byArray, 0, 1024)) == -1) {
                    return;
                }
                outputStream.write(byArray, 0, n2);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private static boolean checkCpuCompatibility(String string2) {
        for (String string3 : new ArrayList<String>(Arrays.asList(string2.split(",")))) {
            if (!string3.equals(cpu) && (cpu2.length() <= 0 || !string3.equals(cpu2)) && (cpu3.length() <= 0 || !string3.equals(cpu3))) continue;
            return true;
        }
        return false;
    }

    public static String checkStoreUrl(String string2) {
        String string3;
        String string4 = string2.trim();
        if (!string4.contains(".")) {
            string4 = string4.concat(".store.aptoide.com");
        }
        if ((string3 = RepoUtils.formatRepoUri(string4)).contains("bazaarandroid.com")) {
            string3 = string3.replaceAll("bazaarandroid\\.com", "store.aptoide.com");
        }
        return string3;
    }

    public static String filters(Context context) {
        int n2 = HWSpecifications.getSdkVer();
        String string2 = Filters.Screen.values()[HWSpecifications.getScreenSize(context)].name().toLowerCase(Locale.ENGLISH);
        String string3 = HWSpecifications.getGlEsVer(context);
        int n3 = HWSpecifications.getDensityDpi(context);
        String string4 = HWSpecifications.getCpuAbi();
        if (HWSpecifications.getCpuAbi2().length() > 0) {
            string4 = string4 + "," + HWSpecifications.getCpuAbi2();
        }
        return Base64.encodeToString(("maxSdk=" + n2 + "&maxScreen=" + string2 + "&maxGles=" + string3 + "&myCPU=" + string4 + "&myDensity=" + n3).getBytes(), 0).replace("=", "").replace("/", "*").replace("+", "_").replace("\n", "");
    }

    public static String formatBits(long l2) {
        if (l2 < (long)1024) {
            return l2 + " B";
        }
        int n2 = (int)(Math.log(l2) / Math.log(1024));
        String string2 = "KMGTPE".charAt(n2 - 1) + "";
        Locale locale = Locale.ENGLISH;
        Object[] objectArray = new Object[]{(double)l2 / Math.pow(1024, n2), string2};
        return String.format(locale, "%.1f %sb", objectArray);
    }

    public static String formatBytes(long l2) {
        if (l2 < (long)1024) {
            return l2 + " B";
        }
        int n2 = (int)(Math.log(l2) / Math.log(1024));
        String string2 = "KMGTPE".charAt(n2 - 1) + "";
        Locale locale = Locale.ENGLISH;
        Object[] objectArray = new Object[]{(double)l2 / Math.pow(1024, n2), string2};
        return String.format(locale, "%.1f %sB", objectArray);
    }

    public static String getMyCountry(Context context) {
        return context.getResources().getConfiguration().locale.getLanguage();
    }

    public static String getMyCountryCode(Context context) {
        return context.getResources().getConfiguration().locale.getLanguage() + "_" + context.getResources().getConfiguration().locale.getCountry();
    }

    public static int getPixels(Context context, int n2) {
        Resources resources = context.getResources();
        int n3 = (int)TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)resources.getDisplayMetrics());
        Log.d((String)"getPixels", (String)("" + n3));
        return n3;
    }

    public static SharedPreferences getSharedPreferences() {
        return PreferenceManager.getDefaultSharedPreferences((Context)Aptoide.getContext());
    }

    public static boolean isAppInstalled(Context context, String string2) {
        PackageManager packageManager = context.getPackageManager();
        try {
            packageManager.getPackageInfo(string2, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public static boolean isCompatible(Apk apk) {
        return !(apk.getMinSdk() > sdk || apk.getMinScreen().ordinal() > screen || !(Float.parseFloat(apk.getMinGlEs()) <= Float.parseFloat(gles)) || apk.getScreenCompat() != null && !apk.getScreenCompat().contains(screenSpec) || apk.getCpuAbi() != null && !AptoideUtils.checkCpuCompatibility(apk.getCpuAbi()));
    }

    public static String screenshotToThumb(Context context, String string2, String string3) {
        if (string2.contains("_screen")) {
            String string4 = IconSizes.generateSizeStringScreenshots(context, string3);
            String[] stringArray = string2.split("\\.(?=[^\\.]+$)");
            return stringArray[0] + "_" + string4 + "." + stringArray[1];
        }
        String[] stringArray = string2.split("/");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 != -1 + stringArray.length; ++i2) {
            stringBuilder.append(stringArray[i2]);
            stringBuilder.append("/");
        }
        stringBuilder.append("thumbs/mobile/");
        stringBuilder.append(stringArray[-1 + stringArray.length]);
        return stringBuilder.toString();
    }

    public static void syncInstalledApps(Context context, SQLiteDatabase sQLiteDatabase) {
        Log.d((String)"Aptoide-InstalledSync", (String)"Syncing");
        long l2 = System.currentTimeMillis();
        InstalledAppsHelper.sync(sQLiteDatabase, context);
        Log.d((String)"Aptoide-InstalledSync", (String)("Sync complete in " + (System.currentTimeMillis() - l2) + "ms"));
    }

    public static String withSuffix(String string2) {
        long l2 = Long.parseLong(string2);
        if (l2 < 1000L) {
            return "" + l2;
        }
        int n2 = (int)(Math.log(l2) / Math.log(1000.0));
        Object[] objectArray = new Object[]{(double)l2 / Math.pow(1000.0, n2), Character.valueOf("kMGTPE".charAt(n2 - 1))};
        return String.format("%.1f %c", objectArray);
    }

    public static class Algorithms {
        public static String computeHmacSha1(String string2, String string3) throws InvalidKeyException, IllegalStateException, UnsupportedEncodingException, NoSuchAlgorithmException {
            System.out.println(string2);
            System.out.println(string3);
            SecretKeySpec secretKeySpec = new SecretKeySpec(string3.getBytes("UTF-8"), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKeySpec);
            return Algorithms.convToHex(mac.doFinal(string2.getBytes("UTF-8")));
        }

        public static String computeSHA1sum(String string2) throws NoSuchAlgorithmException, UnsupportedEncodingException {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] cfr_ignored_0 = new byte[40];
            messageDigest.update(string2.getBytes("iso-8859-1"), 0, string2.length());
            return Algorithms.convToHex(messageDigest.digest());
        }

        public static String computeSHA1sumFromBytes(byte[] byArray) throws NoSuchAlgorithmException, UnsupportedEncodingException {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(byArray, 0, byArray.length);
            return Algorithms.convToHex(messageDigest.digest());
        }

        /*
         * Enabled aggressive block sorting
         */
        private static String convToHex(byte[] byArray) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            block0: while (n2 < byArray.length) {
                int n3 = 0xF & byArray[n2] >>> 4;
                int n4 = 0;
                while (true) {
                    if (n3 >= 0 && n3 <= 9) {
                        stringBuilder.append((char)(n3 + 48));
                    } else {
                        stringBuilder.append((char)(97 + (n3 - 10)));
                    }
                    n3 = 0xF & byArray[n2];
                    int n5 = n4 + 1;
                    if (n4 >= 1) {
                        ++n2;
                        continue block0;
                    }
                    n4 = n5;
                }
                break;
            }
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static String md5Calc(File file) {
            int n2;
            String string2;
            String string3;
            FileInputStream fileInputStream;
            MessageDigest messageDigest;
            byte[] byArray = new byte[1024];
            try {
                int n3;
                messageDigest = MessageDigest.getInstance("MD5");
                fileInputStream = new FileInputStream(file);
                while ((n3 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    messageDigest.update(byArray, 0, n3);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            {
                string3 = new BigInteger(1, messageDigest.digest()).toString(16);
                ((InputStream)fileInputStream).close();
                if (string3.length() == 33) return string3;
                string2 = "";
                n2 = 1;
            }
            while (n2 < 33 - string3.length()) {
                string2 = string2.concat("0");
                ++n2;
            }
            return string2.concat(string3);
        }
    }

    public static class DateDiffUtils {
        static final int DAYS = 1;
        static final int HOURS = 2;
        static final int MINUTES = 3;
        static final int MONTHS = 0;
        static final int SECONDS = 4;

        public static String getDiffDate(Context context, Date date) {
            DateTime dateTime = new DateTime(date);
            DateTime dateTime2 = DateTime.now();
            int n2 = Months.monthsBetween(dateTime, dateTime2).getMonths();
            int n3 = 0;
            if (n2 == 0) {
                n3 = 1;
                n2 = Days.daysBetween(dateTime, dateTime2).getDays();
            }
            if (n2 == 0) {
                n3 = 2;
                n2 = Hours.hoursBetween(dateTime, dateTime2).getHours();
            }
            if (n2 == 0) {
                n3 = 3;
                n2 = Minutes.minutesBetween(dateTime, dateTime2).getMinutes();
            }
            if (n2 == 0) {
                n3 = 4;
                n2 = Seconds.secondsBetween(dateTime, dateTime2).getSeconds();
            }
            if (n2 == 1) {
                return DateDiffUtils.getSingleUnitStringBasedOnType(context, n3);
            }
            return DateDiffUtils.getStringBasedOnType(context, n3, n2);
        }

        private static String getSingleUnitStringBasedOnType(Context context, int n2) {
            switch (n2) {
                default: {
                    return null;
                }
                case 0: {
                    int n3 = R.string.timestamp_month;
                    Object[] objectArray = new Object[]{1};
                    return context.getString(n3, objectArray);
                }
                case 1: {
                    int n4 = R.string.timestamp_day;
                    Object[] objectArray = new Object[]{1};
                    return context.getString(n4, objectArray);
                }
                case 2: {
                    int n5 = R.string.WidgetProvider_timestamp_hour_ago;
                    Object[] objectArray = new Object[]{1};
                    return context.getString(n5, objectArray);
                }
                case 3: {
                    return context.getString(R.string.WidgetProvider_timestamp_just_now);
                }
                case 4: 
            }
            return context.getString(R.string.WidgetProvider_timestamp_just_now);
        }

        private static String getStringBasedOnType(Context context, int n2, int n3) {
            switch (n2) {
                default: {
                    return null;
                }
                case 0: {
                    int n4 = R.string.timestamp_months;
                    Object[] objectArray = new Object[]{n3};
                    return context.getString(n4, objectArray);
                }
                case 1: {
                    int n5 = R.string.timestamp_days;
                    Object[] objectArray = new Object[]{n3};
                    return context.getString(n5, objectArray);
                }
                case 2: {
                    int n6 = R.string.WidgetProvider_timestamp_hours_ago;
                    Object[] objectArray = new Object[]{n3};
                    return context.getString(n6, objectArray);
                }
                case 3: {
                    int n7 = R.string.WidgetProvider_timestamp_minutes_ago;
                    Object[] objectArray = new Object[]{n3};
                    return context.getString(n7, objectArray);
                }
                case 4: 
            }
            return context.getString(R.string.WidgetProvider_timestamp_just_now);
        }
    }

    public static class DateTimeUtils
    extends DateUtils {
        private static DateTimeUtils instance;
        private static Context mCtx;
        private static String mTimestampLabelHourAgo;
        private static String mTimestampLabelHoursAgo;
        private static String mTimestampLabelJustNow;
        private static String mTimestampLabelMinutesAgo;
        private static String mTimestampLabelToday;
        private static String mTimestampLabelYesterday;
        public static final long millisInADay = 86400000L;
        public static String[] weekdays;

        static {
            weekdays = new DateFormatSymbols().getWeekdays();
        }

        public static DateTimeUtils getInstance(Context context) {
            mCtx = context;
            if (instance == null) {
                instance = new DateTimeUtils();
                mTimestampLabelYesterday = context.getResources().getString(R.string.WidgetProvider_timestamp_yesterday);
                mTimestampLabelToday = context.getResources().getString(R.string.WidgetProvider_timestamp_today);
                mTimestampLabelJustNow = context.getResources().getString(R.string.WidgetProvider_timestamp_just_now);
                mTimestampLabelMinutesAgo = context.getResources().getString(R.string.WidgetProvider_timestamp_minutes_ago);
                mTimestampLabelHoursAgo = context.getResources().getString(R.string.WidgetProvider_timestamp_hours_ago);
                mTimestampLabelHourAgo = context.getResources().getString(R.string.WidgetProvider_timestamp_hour_ago);
            }
            return instance;
        }

        public static boolean isYesterday(long l2) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l2);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(5, -1);
            return calendar2.get(1) == calendar.get(1) && calendar2.get(6) == calendar.get(6);
        }

        public String getTimeDiffString(long l2) {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTimeInMillis(l2);
            long l3 = calendar.getTimeInMillis() - calendar2.getTimeInMillis();
            long l4 = l3 / 3600000L;
            long l5 = l3 / 60000L - 60L * l4;
            long cfr_ignored_0 = l3 / 1000L;
            boolean bl2 = DateTimeUtils.isToday((long)l2);
            boolean bl3 = DateTimeUtils.isYesterday(l2);
            if (l4 > 0L && l4 < 12L) {
                if (l4 == 1L) {
                    String string2 = mTimestampLabelHourAgo;
                    Object[] objectArray = new Object[]{l4};
                    return String.format(string2, objectArray);
                }
                String string3 = mTimestampLabelHoursAgo;
                Object[] objectArray = new Object[]{l4};
                return String.format(string3, objectArray);
            }
            if (l4 <= 0L) {
                if (l5 > 0L) {
                    String string4 = mTimestampLabelMinutesAgo;
                    Object[] objectArray = new Object[]{l5};
                    return String.format(string4, objectArray);
                }
                return mTimestampLabelJustNow;
            }
            if (bl2) {
                return mTimestampLabelToday;
            }
            if (bl3) {
                return mTimestampLabelYesterday;
            }
            if (calendar.getTimeInMillis() - l2 < 518400000L) {
                return weekdays[calendar2.get(7)];
            }
            return DateTimeUtils.formatDateTime((Context)mCtx, (long)l2, (int)131072);
        }
    }

    public static class HWSpecifications {
        public static final String TERMINAL_INFO = HWSpecifications.getModel() + "(" + HWSpecifications.getProduct() + ")" + ";v" + HWSpecifications.getRelease() + ";" + System.getProperty("os.arch");
        private static String cpuAbi2;

        public static String getCpuAbi() {
            return Build.CPU_ABI;
        }

        public static String getCpuAbi2() {
            if (HWSpecifications.getSdkVer() >= 8 && !Build.CPU_ABI2.equals("unknown")) {
                return Build.CPU_ABI2;
            }
            return "";
        }

        public static int getDensityDpi(Context context) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            int n2 = displayMetrics.densityDpi;
            if (n2 <= 120) {
                return 120;
            }
            if (n2 <= 160) {
                return 160;
            }
            if (n2 <= 213) {
                return 213;
            }
            if (n2 <= 240) {
                return 240;
            }
            if (n2 <= 320) {
                return 320;
            }
            return 480;
        }

        public static String getDeviceId(Context context) {
            return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }

        public static String getGlEsVer(Context context) {
            return ((ActivityManager)context.getSystemService("activity")).getDeviceConfigurationInfo().getGlEsVersion();
        }

        public static String getModel() {
            return Build.MODEL.replaceAll(";", " ");
        }

        public static int getNumericScreenSize(Context context) {
            return 100 * (1 + (0xF & context.getResources().getConfiguration().screenLayout));
        }

        public static String getProduct() {
            return Build.PRODUCT.replace(";", " ");
        }

        public static String getRelease() {
            return Build.VERSION.RELEASE.replaceAll(";", " ");
        }

        public static int getScreenSize(Context context) {
            return 0xF & context.getResources().getConfiguration().screenLayout;
        }

        public static int getSdkVer() {
            return Build.VERSION.SDK_INT;
        }
    }

    public static class NetworkUtils {
        private static int TIME_OUT = 15000;

        public static int checkServerConnection(String string2, String string3, String string4) throws Exception {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string2 + "info.xml").openConnection();
            if (string3 != null && string4 != null) {
                httpURLConnection.setRequestProperty("Authorization", "Basic " + new String(Base64.encode((string3 + ":" + string4).getBytes(), 2)));
            }
            httpURLConnection.setRequestMethod("HEAD");
            httpURLConnection.setConnectTimeout(TIME_OUT);
            httpURLConnection.setReadTimeout(TIME_OUT);
            String string5 = httpURLConnection.getContentType();
            int n2 = httpURLConnection.getResponseCode();
            httpURLConnection.disconnect();
            if (Aptoide.DEBUG_MODE) {
                Log.i((String)"Aptoide-NetworkUtils-checkServerConnection", (String)("Checking on: " + httpURLConnection.getURL().toString()));
            }
            if (string5.equals("application/xml")) {
                n2 = 0;
            }
            return n2;
        }

        static void getIconSize(Context context) {
        }

        public static long getLastModified(URL uRL) throws IOException {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(TIME_OUT);
            httpURLConnection.setReadTimeout(TIME_OUT);
            long l2 = httpURLConnection.getLastModified();
            httpURLConnection.disconnect();
            return l2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static String getUserAgentString(Context context) {
            String string2;
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            String string3 = sharedPreferences.getString(EnumPreferences.APTOIDE_CLIENT_UUID.name(), "NoInfo");
            String string4 = sharedPreferences.getInt(EnumPreferences.SCREEN_WIDTH.name(), 0) + "x" + sharedPreferences.getInt(EnumPreferences.SCREEN_HEIGHT.name(), 0);
            try {
                string2 = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
                return "aptoide-" + string2 + ";" + HWSpecifications.TERMINAL_INFO + ";" + string4 + ";id:" + string3 + ";" + sharedPreferences.getString("usernameLogin", "") + ";" + "";
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
                string2 = null;
                return "aptoide-" + string2 + ";" + HWSpecifications.TERMINAL_INFO + ";" + string4 + ";id:" + string3 + ";" + sharedPreferences.getString("usernameLogin", "") + ";" + "";
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static boolean isConnectionAvailable(Context context) {
            boolean bl2;
            block18: {
                block17: {
                    ConnectivityManager connectivityManager;
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                                            bl2 = false;
                                            try {
                                                bl2 = connectivityManager.getNetworkInfo(0).getState() == NetworkInfo.State.CONNECTED;
                                                Log.d((String)"ManagerDownloads", (String)("isConnectionAvailable mobile: " + bl2));
                                            }
                                            catch (Exception exception) {}
                                            if (!bl2) {
                                                try {
                                                    if (connectivityManager.getNetworkInfo(1).getState() == NetworkInfo.State.CONNECTED) break block11;
                                                    bl2 = false;
                                                    break block12;
                                                }
                                                catch (Exception exception) {
                                                    break block13;
                                                }
                                            }
                                        }
                                        bl2 = true;
                                    }
                                    Log.d((String)"ManagerDownloads", (String)("isConnectionAvailable wifi: " + bl2));
                                }
                                if (!bl2) {
                                    try {
                                        if (connectivityManager.getNetworkInfo(6).getState() == NetworkInfo.State.CONNECTED) break block14;
                                        bl2 = false;
                                        break block15;
                                    }
                                    catch (Exception exception) {
                                        break block16;
                                    }
                                }
                            }
                            bl2 = true;
                        }
                        Log.d((String)"ManagerDownloads", (String)("isConnectionAvailable wimax: " + bl2));
                    }
                    if (!bl2) {
                        try {
                            if (connectivityManager.getNetworkInfo(9).getState() == NetworkInfo.State.CONNECTED) break block17;
                            bl2 = false;
                            break block18;
                        }
                        catch (Exception exception) {
                            return bl2;
                        }
                    }
                }
                bl2 = true;
            }
            Log.d((String)"ManagerDownloads", (String)("isConnectionAvailable ethernet: " + bl2));
            return bl2;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static boolean isPermittedConnectionAvailable(Context context, IconDownloadPermissions iconDownloadPermissions) {
            boolean bl2;
            ConnectivityManager connectivityManager;
            block16: {
                block15: {
                    connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    boolean bl3 = iconDownloadPermissions.isWiFi();
                    bl2 = false;
                    if (bl3) {
                        try {
                            NetworkInfo.State state = connectivityManager.getNetworkInfo(1).getState();
                            NetworkInfo.State state2 = NetworkInfo.State.CONNECTED;
                            bl2 = state == state2;
                        }
                        catch (Exception exception) {
                            bl2 = false;
                        }
                    }
                    if (iconDownloadPermissions.isWiMax()) {
                        block13: {
                            if (!bl2) {
                                NetworkInfo.State state = connectivityManager.getNetworkInfo(6).getState();
                                NetworkInfo.State state3 = NetworkInfo.State.CONNECTED;
                                if (state != state3) break block13;
                            }
                            bl2 = true;
                            break block15;
                        }
                        bl2 = false;
                        break block15;
                        catch (Exception exception) {}
                    }
                }
                if (iconDownloadPermissions.isMobile()) {
                    block14: {
                        if (!bl2) {
                            NetworkInfo.State state = connectivityManager.getNetworkInfo(0).getState();
                            NetworkInfo.State state4 = NetworkInfo.State.CONNECTED;
                            if (state != state4) break block14;
                        }
                        bl2 = true;
                        break block16;
                    }
                    bl2 = false;
                    break block16;
                    catch (Exception exception) {}
                }
            }
            if (!iconDownloadPermissions.isEthernet()) return bl2;
            if (bl2) return true;
            try {
                NetworkInfo.State state = connectivityManager.getNetworkInfo(9).getState();
                NetworkInfo.State state5 = NetworkInfo.State.CONNECTED;
                if (state != state5) return false;
            }
            catch (Exception exception) {
                return bl2;
            }
            return true;
        }

        public static void setTimeout(int n2) {
            TIME_OUT = n2;
        }

        public BufferedInputStream getInputStream(String string2, Context context) throws IOException {
            return this.getInputStream(string2, null, null, context);
        }

        public BufferedInputStream getInputStream(String string2, String string3, String string4, Context context) throws IOException {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string2).openConnection();
            if (string3 != null && string4 != null) {
                httpURLConnection.setRequestProperty("Authorization", "Basic " + new String(Base64.encode((string3 + ":" + string4).getBytes(), 2)));
            }
            httpURLConnection.setConnectTimeout(TIME_OUT);
            httpURLConnection.setReadTimeout(TIME_OUT);
            httpURLConnection.setRequestProperty("User-Agent", NetworkUtils.getUserAgentString(context));
            return new BufferedInputStream(httpURLConnection.getInputStream(), 8192);
        }

        public JSONObject getJsonObject(String string2, Context context) throws IOException, JSONException {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getInputStream(string2, null, null, context)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string3 + '\n');
            }
            bufferedReader.close();
            return new JSONObject(stringBuilder.toString());
        }
    }

    public static class RepoUtils {
        public static String formatRepoUri(String string2) {
            if (string2.contains("http//")) {
                string2 = string2.replaceFirst("http//", "http://");
            }
            if (string2.length() != 0 && string2.charAt(-1 + string2.length()) != '/') {
                string2 = string2 + '/';
                Log.d((String)"Aptoide-ManageRepo", (String)("repo uri: " + string2));
            }
            if (!string2.startsWith("http://")) {
                string2 = "http://" + string2;
                Log.d((String)"Aptoide-ManageRepo", (String)("repo uri: " + string2));
            }
            return string2;
        }

        public static String split(String string2) {
            Log.d((String)"Aptoide-RepoUtils", (String)("Splitting " + string2));
            return RepoUtils.formatRepoUri(string2).split("http://")[1].split("\\.store")[0].split("\\.bazaarandroid.com")[0];
        }
    }
}

