/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.services;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Service;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.util.Log;
import cm.aptoide.ptdev.AppViewActivity;
import cm.aptoide.ptdev.utils.AptoideUtils;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ConsumerCancelledException;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelN;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class RabbitMqService
extends Service {
    private ChannelN channel;
    private AMQConnection connection;
    private QueueingConsumer consumer;
    private boolean isRunning = true;
    private ExecutorService thread_pool;
    private final IBinder wBinder = new RabbitMqBinder();

    static /* synthetic */ AMQConnection access$002(RabbitMqService rabbitMqService, AMQConnection aMQConnection) {
        rabbitMqService.connection = aMQConnection;
        return aMQConnection;
    }

    static /* synthetic */ boolean access$102(RabbitMqService rabbitMqService, boolean bl2) {
        rabbitMqService.isRunning = bl2;
        return bl2;
    }

    public void newChannel(String string2, AMQHandler aMQHandler) throws IOException {
        this.channel = (ChannelN)this.connection.createChannel();
        this.channel.basicQos(0);
        this.consumer = new QueueingConsumer(this.channel);
        this.channel.basicConsume(string2, false, this.consumer);
        aMQHandler.setConsumer(this.consumer);
        this.thread_pool.execute(aMQHandler);
    }

    public IBinder onBind(Intent intent) {
        return this.wBinder;
    }

    public void onCreate() {
        super.onCreate();
        Log.d((String)"Aptoide-RabbitMqService", (String)"RabbitMqService created!");
        this.thread_pool = Executors.newCachedThreadPool();
        AccountManager accountManager = AccountManager.get((Context)this.getApplicationContext());
        if (accountManager.getAccountsByType("cm.aptoide.pt").length > 0) {
            Account account = accountManager.getAccountsByType("cm.aptoide.pt")[0];
            if (Build.VERSION.SDK_INT >= 8) {
                ContentResolver.removePeriodicSync((Account)account, (String)"cm.aptoide.pt.StubProvider", (Bundle)new Bundle());
            }
            ContentResolver.setSyncAutomatically((Account)account, (String)"cm.aptoide.pt.StubProvider", (boolean)false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onDestroy() {
        super.onDestroy();
        Log.d((String)"Aptoide-RabbitMqService", (String)"RabbitMqService Destroyed!");
        try {
            this.isRunning = false;
            if (this.connection != null && this.connection.isOpen()) {
                if (this.channel != null) {
                    this.channel.close();
                }
                this.connection.disconnectChannel(this.channel);
                this.connection.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ShutdownSignalException shutdownSignalException) {
            shutdownSignalException.printStackTrace();
        }
        if (AccountManager.get((Context)this.getApplicationContext()).getAccountsByType("cm.aptoide.pt").length > 0) {
            Account account = AccountManager.get((Context)this.getApplicationContext()).getAccountsByType("cm.aptoide.pt")[0];
            ContentResolver.setIsSyncable((Account)account, (String)"cm.aptoide.pt.StubProvider", (int)1);
            ContentResolver.setSyncAutomatically((Account)account, (String)"cm.aptoide.pt.StubProvider", (boolean)true);
            if (Build.VERSION.SDK_INT >= 8) {
                ContentResolver.addPeriodicSync((Account)account, (String)"cm.aptoide.pt.StubProvider", (Bundle)new Bundle(), (long)360L);
            }
        }
    }

    public void onStart(Intent intent, int n2) {
        super.onStart(intent, n2);
        this.onStartCommand(intent, 0, n2);
    }

    public int onStartCommand(Intent intent, int n2, int n3) {
        new Thread(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (AccountManager.get((Context)RabbitMqService.this.getApplicationContext()).getAccountsByType("cm.aptoide.pt").length <= 0) return;
                final Account account = AccountManager.get((Context)RabbitMqService.this.getApplicationContext()).getAccountsByType("cm.aptoide.pt")[0];
                String string2 = PreferenceManager.getDefaultSharedPreferences((Context)RabbitMqService.this.getApplicationContext()).getString("queueName", null);
                try {
                    ConnectionFactory connectionFactory = new ConnectionFactory();
                    connectionFactory.setHost("amqp.webservices.aptoide.com");
                    connectionFactory.setUsername("public");
                    connectionFactory.setPassword("public");
                    connectionFactory.setConnectionTimeout(20000);
                    connectionFactory.setVirtualHost("webinstall");
                    RabbitMqService.access$002(RabbitMqService.this, (AMQConnection)connectionFactory.newConnection());
                    RabbitMqService.this.newChannel(string2, new AMQHandler(){

                        @Override
                        void handleMessage(String string2) {
                            try {
                                JSONObject jSONObject = new JSONObject(string2);
                                Intent intent = new Intent(RabbitMqService.this.getApplicationContext(), AppViewActivity.class);
                                String string3 = ((Bundle)AccountManager.get((Context)RabbitMqService.this.getApplicationContext()).getAuthToken(account, "Full access", null, null, null, null).getResult()).getString("authtoken");
                                String string4 = jSONObject.getString("repo");
                                long l2 = jSONObject.getLong("id");
                                String string5 = jSONObject.getString("md5sum");
                                intent.putExtra("fromMyapp", true);
                                intent.putExtra("repoName", string4);
                                intent.putExtra("id", l2);
                                intent.putExtra("md5sum", string5);
                                String string6 = Settings.Secure.getString((ContentResolver)RabbitMqService.this.getApplicationContext().getContentResolver(), (String)"android_id");
                                intent.setFlags(0x10000000);
                                String string7 = jSONObject.getString("hmac");
                                String string8 = AptoideUtils.Algorithms.computeHmacSha1(string4 + l2 + string5, string3 + string6);
                                if (string7.equals(string8)) {
                                    RabbitMqService.this.getApplicationContext().startActivity(intent);
                                    return;
                                }
                                Log.d((String)"Aptoide-WebInstall", (String)("Error validating message: received: " + string7 + " calculated:" + string8));
                                return;
                            }
                            catch (JSONException jSONException) {
                                jSONException.printStackTrace();
                                return;
                            }
                            catch (AuthenticatorException authenticatorException) {
                                authenticatorException.printStackTrace();
                                return;
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                unsupportedEncodingException.printStackTrace();
                                return;
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                return;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                noSuchAlgorithmException.printStackTrace();
                                return;
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                operationCanceledException.printStackTrace();
                                return;
                            }
                            catch (InvalidKeyException invalidKeyException) {
                                invalidKeyException.printStackTrace();
                                return;
                            }
                        }
                    });
                    return;
                }
                catch (IOException iOException) {
                    PreferenceManager.getDefaultSharedPreferences((Context)RabbitMqService.this.getApplicationContext()).edit().putBoolean("wiQueueExcluded", true).commit();
                    iOException.printStackTrace();
                    return;
                }
            }
        }).start();
        return 1;
    }

    public abstract class AMQHandler
    implements Runnable {
        private QueueingConsumer consumer;

        abstract void handleMessage(String var1);

        @Override
        public void run() {
            while (RabbitMqService.this.isRunning) {
                try {
                    QueueingConsumer.Delivery delivery = this.consumer.nextDelivery();
                    String string2 = new String(delivery.getBody(), "UTF-8");
                    Log.d((String)"Aptoide-RabbitMqService", (String)("MESSAGE: " + string2));
                    this.handleMessage(string2);
                    RabbitMqService.this.channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (IOException iOException) {
                    RabbitMqService.access$102(RabbitMqService.this, false);
                    iOException.printStackTrace();
                }
                catch (ShutdownSignalException shutdownSignalException) {
                    RabbitMqService.access$102(RabbitMqService.this, false);
                    Log.d((String)"Aptoide-WebInstall", (String)("Connection closed with reason " + shutdownSignalException.getReason().toString()));
                }
                catch (ConsumerCancelledException consumerCancelledException) {
                    RabbitMqService.access$102(RabbitMqService.this, false);
                    Log.d((String)"Aptoide-WebInstall", (String)"Connection was canceled");
                }
            }
            try {
                if (RabbitMqService.this.channel != null && RabbitMqService.this.channel.isOpen()) {
                    RabbitMqService.this.channel.close();
                    RabbitMqService.this.connection.disconnectChannel(RabbitMqService.this.channel);
                    RabbitMqService.this.connection.close();
                }
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        public void setConsumer(QueueingConsumer queueingConsumer) {
            this.consumer = queueingConsumer;
        }
    }

    public class RabbitMqBinder
    extends Binder {
        public RabbitMqService getService() {
            return RabbitMqService.this;
        }
    }
}

