/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.services;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.preference.PreferenceManager;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.util.SparseArray;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.events.BusProvider;
import cm.aptoide.ptdev.events.RepoAddedEvent;
import cm.aptoide.ptdev.events.RepoErrorEvent;
import cm.aptoide.ptdev.fragments.callbacks.RepoCompleteEvent;
import cm.aptoide.ptdev.model.Login;
import cm.aptoide.ptdev.model.Store;
import cm.aptoide.ptdev.parser.Parser;
import cm.aptoide.ptdev.parser.callbacks.CompleteCallback;
import cm.aptoide.ptdev.parser.callbacks.ErrorCallback;
import cm.aptoide.ptdev.parser.callbacks.PoolEndedCallback;
import cm.aptoide.ptdev.parser.events.StopParseEvent;
import cm.aptoide.ptdev.parser.handlers.HandlerEditorsChoiceXml;
import cm.aptoide.ptdev.parser.handlers.HandlerFeaturedTop;
import cm.aptoide.ptdev.parser.handlers.HandlerInfoXml;
import cm.aptoide.ptdev.parser.handlers.HandlerLatestXml;
import cm.aptoide.ptdev.parser.handlers.HandlerTopXml;
import cm.aptoide.ptdev.services.ParserHttp;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.utils.IconSizes;
import cm.aptoide.ptdev.webservices.GetRepositoryInfoRequest;
import cm.aptoide.ptdev.webservices.json.RepositoryInfoJson;
import com.octo.android.robospice.Jackson2GoogleHttpClientSpiceService;
import com.octo.android.robospice.SpiceManager;
import com.squareup.otto.Subscribe;
import java.io.IOException;
import java.net.URL;

public class ParserService
extends Service
implements ErrorCallback,
CompleteCallback {
    ErrorCallback editorsErrorCallback;
    SparseArray<HandlerBundle> handlerBundleSparseArray;
    private Object lock;
    Parser parser;
    private boolean showNotification = true;
    private SpiceManager spiceManager = new SpiceManager(ParserHttp.class);
    ErrorCallback topErrorCallback;

    public ParserService() {
        this.lock = new Object();
        this.handlerBundleSparseArray = new SparseArray();
        this.editorsErrorCallback = new ErrorCallback(){

            @Override
            public void onError(Exception exception, long l2) {
                PreferenceManager.getDefaultSharedPreferences((Context)ParserService.this.getApplicationContext()).edit().remove("editorschoiceTimestamp").commit();
                BusProvider.getInstance().post(new RepoErrorEvent(exception, l2));
            }
        };
        this.topErrorCallback = new ErrorCallback(){

            @Override
            public void onError(Exception exception, long l2) {
                PreferenceManager.getDefaultSharedPreferences((Context)ParserService.this.getApplicationContext()).edit().remove("topappsTimestamp").commit();
                BusProvider.getInstance().post(new RepoErrorEvent(exception, l2));
            }
        };
    }

    static /* synthetic */ boolean access$002(ParserService parserService, boolean bl2) {
        parserService.showNotification = bl2;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void beginParse(Database database, Store store, long l2) {
        Log.d((String)"Aptoide-Parser", (String)"Creating Objects");
        if (this.handlerBundleSparseArray.get((int)store.getId()) != null) {
            return;
        }
        database.updateStore(store);
        BusProvider.getInstance().post(this.produceRepoAddedEvent());
        HandlerLatestXml handlerLatestXml = new HandlerLatestXml(database, l2);
        HandlerTopXml handlerTopXml = new HandlerTopXml(database, l2);
        HandlerInfoXml handlerInfoXml = new HandlerInfoXml(database, l2);
        HandlerBundle handlerBundle = new HandlerBundle(handlerInfoXml, handlerTopXml, handlerLatestXml);
        this.handlerBundleSparseArray.append((int)l2, (Object)handlerBundle);
        Log.d((String)"Aptoide-Parser", (String)"Checking timestamps");
        long l3 = 0L;
        try {
            long l4;
            l3 = l4 = AptoideUtils.NetworkUtils.getLastModified(new URL(store.getLatestXmlUrl()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        long l5 = 0L;
        try {
            long l6;
            l5 = l6 = AptoideUtils.NetworkUtils.getLastModified(new URL(store.getTopXmlUrl()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Log.d((String)"Aptoide-Parser", (String)"Delete");
        if (l3 > store.getLatestTimestamp()) {
            this.parser.parse(store.getLatestXmlUrl(), store.getLogin(), 4, handlerLatestXml, new LatestPreParseRunnable(handlerLatestXml, l3, database, l2));
        }
        if (l5 > store.getTopTimestamp()) {
            this.parser.parse(store.getTopXmlUrl(), store.getLogin(), 4, handlerTopXml, new TopPreParseRunnable(handlerTopXml, l5, database, l2));
        }
        Log.d((String)"Aptoide-Parser", (String)"Parse");
        Parser parser = this.parser;
        String string2 = store.getInfoXmlUrl();
        Login login = store.getLogin();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        parser.parse(string2, login, 10, handlerInfoXml, this, this, runnable);
    }

    private long insertStoreDatabase(Database database, Store store) {
        return database.insertStore(store);
    }

    private void showUpdatesNotification() {
        Cursor cursor = new Database(Aptoide.getDb()).getUpdates();
        int n2 = 0;
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            if (cursor.getInt(cursor.getColumnIndex("is_update")) == 1) {
                ++n2;
            }
            cursor.moveToNext();
        }
        cursor.close();
        if (n2 > 0) {
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            int n3 = 17301634;
            if (Aptoide.getConfiguration().getMarketName().equals("Aptoide")) {
                n3 = R.drawable.ic_stat_aptoide_notification;
            }
            int n4 = R.string.has_updates;
            Object[] objectArray = new Object[]{Aptoide.getConfiguration().getMarketName()};
            String string2 = this.getString(n4, objectArray);
            System.currentTimeMillis();
            Context context = this.getApplicationContext();
            String string3 = Aptoide.getConfiguration().getMarketName();
            int n5 = R.string.new_updates;
            Object[] objectArray2 = new Object[]{n2};
            String string4 = this.getString(n5, objectArray2);
            if (n2 == 1) {
                int n6 = R.string.one_new_update;
                Object[] objectArray3 = new Object[]{n2};
                string4 = this.getString(n6, objectArray3);
            }
            Intent intent = new Intent();
            intent.setClassName(this.getPackageName(), "cm.aptoide.ptdev.Start");
            intent.setFlags(0x10400000);
            intent.setAction("");
            intent.putExtra("new_updates", true);
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
            notificationManager.notify(1, new NotificationCompat.Builder((Context)this).setSmallIcon(n3).setContentTitle(string3).setContentText(string4).setContentIntent(pendingIntent).setTicker(string2).build());
        }
    }

    public boolean anyRepoParser() {
        return this.handlerBundleSparseArray.size() != 0;
    }

    @Subscribe
    public void cancelRepo(StopParseEvent stopParseEvent) {
        HandlerBundle handlerBundle = (HandlerBundle)this.handlerBundleSparseArray.get((int)stopParseEvent.getRepoId());
        if (handlerBundle != null) {
            handlerBundle.cancel();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Notification createDefaultNotification() {
        Notification notification = new Notification();
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT <= 15) {
            notification.icon = this.getApplicationInfo().icon;
            notification.setLatestEventInfo((Context)this, (CharSequence)"", (CharSequence)"", PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)new Intent(), (int)0));
        } else {
            notification.icon = 0;
        }
        notification.tickerText = null;
        notification.when = System.currentTimeMillis();
        if (Build.VERSION.SDK_INT >= 16) {
            notification.priority = -2;
        }
        return notification;
    }

    public Parser getParser() {
        return this.parser;
    }

    public IBinder onBind(Intent intent) {
        this.parser = new Parser(this.spiceManager);
        this.parser.setPoolEndCallback(new PoolEndedCallback(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onEnd() {
                synchronized (this) {
                    Log.d((String)"Aptoide-", (String)"onEnd");
                    try {
                        if (ParserService.this.showNotification) {
                            ParserService.access$002(ParserService.this, false);
                            if (PreferenceManager.getDefaultSharedPreferences((Context)ParserService.this.getApplicationContext()).getBoolean("showUpdatesNotification", true)) {
                                ParserService.this.showUpdatesNotification();
                            }
                        }
                        if (ParserService.this.spiceManager.isStarted()) {
                            ParserService.this.spiceManager.shouldStopAndJoin(60000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    ParserService.this.stopForeground(true);
                    ParserService.this.stopSelf();
                    return;
                }
            }
        });
        return new MainServiceBinder();
    }

    @Override
    public void onComplete(long l2) {
        this.handlerBundleSparseArray.remove((int)l2);
        BusProvider.getInstance().post(new RepoCompleteEvent(l2));
    }

    public void onCreate() {
        super.onCreate();
        BusProvider.getInstance().register(this);
        Log.d((String)"Aptoide-ParserService", (String)"onStart");
    }

    public void onDestroy() {
        super.onDestroy();
        BusProvider.getInstance().unregister(this);
        Log.d((String)"Aptoide-ParserService", (String)"onDestroy");
    }

    @Override
    public void onError(Exception exception, long l2) {
        this.handlerBundleSparseArray.remove((int)l2);
        BusProvider.getInstance().post(new RepoErrorEvent(exception, l2));
    }

    @SuppressLint(value={"NewApi"})
    public void onTaskRemoved(Intent intent) {
        super.onTaskRemoved(intent);
    }

    public void parseEditorsChoice(final Database database, String string2) throws IOException {
        SharedPreferences sharedPreferences;
        long l2 = AptoideUtils.NetworkUtils.getLastModified(new URL(string2));
        if (l2 > (sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.getApplicationContext())).getLong("editorschoiceTimestamp", 0L)) {
            sharedPreferences.edit().putLong("editorschoiceTimestamp", l2).commit();
            if (!this.spiceManager.isStarted()) {
                Log.d((String)"Aptoide-Parser", (String)"Starting spice");
                this.spiceManager.start(this.getApplicationContext());
            }
            this.startService(new Intent(this.getApplicationContext(), ParserService.class));
            this.startForeground(45, this.createDefaultNotification());
            this.parser.parse(string2, null, 1, new HandlerEditorsChoiceXml(database, 0L), this.editorsErrorCallback, this, new Runnable(){

                @Override
                public void run() {
                    database.deleteFeatured(510);
                    BusProvider.getInstance().post(new RepoCompleteEvent(-2L));
                }
            });
        }
    }

    public void parseTopApps(final Database database, String string2) throws IOException {
        SharedPreferences sharedPreferences;
        long l2 = AptoideUtils.NetworkUtils.getLastModified(new URL(string2));
        if (l2 > (sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.getApplicationContext())).getLong("topappsTimestamp", 0L)) {
            sharedPreferences.edit().putLong("topappsTimestamp", l2).commit();
            if (!this.spiceManager.isStarted()) {
                Log.d((String)"Aptoide-Parser", (String)"Starting spice");
                this.spiceManager.start(this.getApplicationContext());
            }
            this.startService(new Intent(this.getApplicationContext(), ParserService.class));
            this.startForeground(45, this.createDefaultNotification());
            this.parser.parse(string2, null, 2, new HandlerFeaturedTop(database), this.topErrorCallback, this, new Runnable(){

                @Override
                public void run() {
                    database.deleteFeatured(511);
                    BusProvider.getInstance().post(new RepoCompleteEvent(-1L));
                }
            });
        }
    }

    public RepoAddedEvent produceRepoAddedEvent() {
        return new RepoAddedEvent();
    }

    public boolean repoIsParsing(long l2) {
        return this.handlerBundleSparseArray.get((int)l2) != null;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public void setShowNotification(boolean bl2) {
        this.showNotification = bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startParse(final Database database, final Store store, boolean bl2) {
        synchronized (this) {
            RepositoryInfoJson repositoryInfoJson;
            long l2;
            Object object = this.handlerBundleSparseArray.get((int)store.getId());
            if (object != null) return;
            this.startService(new Intent(this.getApplicationContext(), ParserService.class));
            this.startForeground(45, this.createDefaultNotification());
            if (bl2) {
                if (database.existsServer(store.getBaseUrl())) return;
                l2 = this.insertStoreDatabase(database, store);
                store.setId(l2);
                BusProvider.getInstance().post(this.produceRepoAddedEvent());
            } else {
                l2 = store.getId();
            }
            if (store.getBaseUrl().contains("store.aptoide.com")) {
                store.setName(AptoideUtils.RepoUtils.split(store.getBaseUrl()));
            }
            GetRepositoryInfoRequest getRepositoryInfoRequest = new GetRepositoryInfoRequest(store.getName());
            if (!this.spiceManager.isStarted()) {
                Log.d((String)"Aptoide-Parser", (String)"Starting spice");
                this.spiceManager.start(this.getApplicationContext());
            }
            getRepositoryInfoRequest.setHttpRequestFactory(Jackson2GoogleHttpClientSpiceService.createRequestFactory());
            try {
                RepositoryInfoJson repositoryInfoJson2;
                repositoryInfoJson = repositoryInfoJson2 = getRepositoryInfoRequest.loadDataFromNetwork();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            if (repositoryInfoJson == null) return;
            Log.i((String)"Aptoide-", (String)"success");
            if (!"FAIL".equals(repositoryInfoJson.getStatus())) {
                store.setName(repositoryInfoJson.getListing().getName());
                store.setDownloads(repositoryInfoJson.getListing().getDownloads());
                if (repositoryInfoJson.getListing().getAvatar_hd() != null) {
                    String string2 = IconSizes.generateSizeStringAvatar(this.getApplicationContext());
                    String[] stringArray = repositoryInfoJson.getListing().getAvatar_hd().split("\\.(?=[^\\.]+$)");
                    store.setAvatar(stringArray[0] + "_" + string2 + "." + stringArray[1]);
                } else {
                    store.setAvatar(repositoryInfoJson.getListing().getAvatar());
                }
                store.setDescription(repositoryInfoJson.getListing().getDescription());
                store.setTheme(repositoryInfoJson.getListing().getTheme());
                store.setView(repositoryInfoJson.getListing().getView());
                store.setItems(repositoryInfoJson.getListing().getItems());
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ParserService.this.beginParse(database, store, l2);
                    }
                }).start();
            }
            return;
        }
    }

    private static class HandlerBundle {
        private final HandlerInfoXml handlerInfoXml;
        private final HandlerLatestXml handlerLatestXml;
        private final HandlerTopXml handlerTopXml;

        public HandlerBundle(HandlerInfoXml handlerInfoXml, HandlerTopXml handlerTopXml, HandlerLatestXml handlerLatestXml) {
            this.handlerInfoXml = handlerInfoXml;
            this.handlerTopXml = handlerTopXml;
            this.handlerLatestXml = handlerLatestXml;
        }

        public void cancel() {
            this.handlerInfoXml.stopParse();
            this.handlerTopXml.stopParse();
            this.handlerLatestXml.stopParse();
        }
    }

    public class LatestPreParseRunnable
    implements Runnable {
        private long currentLatestTimestamp;
        private Database db;
        private HandlerLatestXml handlerLatestXml;
        private long id;

        public LatestPreParseRunnable(HandlerLatestXml handlerLatestXml, long l2, Database database, long l3) {
            this.handlerLatestXml = handlerLatestXml;
            this.currentLatestTimestamp = l2;
            this.db = database;
            this.id = l3;
        }

        @Override
        public void run() {
            this.handlerLatestXml.setTimestamp(this.currentLatestTimestamp);
            this.db.deleteLatest(this.id);
        }
    }

    public class MainServiceBinder
    extends Binder {
        public ParserService getService() {
            return ParserService.this;
        }
    }

    public class TopPreParseRunnable
    implements Runnable {
        private long currentTopTimestamp;
        private Database db;
        private HandlerTopXml handlerTopXml;
        private long id;

        public TopPreParseRunnable(HandlerTopXml handlerTopXml, long l2, Database database, long l3) {
            this.handlerTopXml = handlerTopXml;
            this.currentTopTimestamp = l2;
            this.db = database;
            this.id = l3;
        }

        @Override
        public void run() {
            this.handlerTopXml.setTimestamp(this.currentTopTimestamp);
            this.db.deleteTop(this.id);
        }
    }
}

