/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.services;

import android.app.Application;
import android.util.Log;
import com.google.api.client.extensions.android.http.AndroidHttp;
import com.google.api.client.http.HttpRequestFactory;
import com.octo.android.robospice.SpiceService;
import com.octo.android.robospice.persistence.CacheManager;
import com.octo.android.robospice.persistence.binary.InFileBigInputStreamObjectPersister;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.request.CachedSpiceRequest;
import com.octo.android.robospice.request.googlehttpclient.GoogleHttpClientSpiceRequest;
import com.octo.android.robospice.request.listener.RequestListener;
import java.util.Set;

public class ParserHttp
extends SpiceService {
    protected HttpRequestFactory httpRequestFactory;

    public static HttpRequestFactory createRequestFactory() {
        return AndroidHttp.newCompatibleTransport().createRequestFactory();
    }

    @Override
    public void addRequest(CachedSpiceRequest<?> cachedSpiceRequest, Set<RequestListener<?>> set) {
        if (cachedSpiceRequest.getSpiceRequest() instanceof GoogleHttpClientSpiceRequest) {
            ((GoogleHttpClientSpiceRequest)cachedSpiceRequest.getSpiceRequest()).setHttpRequestFactory(this.httpRequestFactory);
        }
        super.addRequest(cachedSpiceRequest, set);
    }

    @Override
    public CacheManager createCacheManager(Application application) throws CacheCreationException {
        CacheManager cacheManager = new CacheManager();
        cacheManager.addPersister(new InFileBigInputStreamObjectPersister(application));
        return cacheManager;
    }

    @Override
    public int getThreadCount() {
        return 4;
    }

    @Override
    public int getThreadPriority() {
        return 1;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.httpRequestFactory = ParserHttp.createRequestFactory();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        Log.d((String)"Aptoide-ParserHttp", (String)"onDestroy");
    }
}

