/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.services;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Binder;
import android.os.Environment;
import android.os.IBinder;
import android.support.v4.app.NotificationCompat;
import android.support.v4.util.LongSparseArray;
import android.util.Log;
import android.widget.Toast;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.downloadmanager.DownloadExecutorImpl;
import cm.aptoide.ptdev.downloadmanager.DownloadInfo;
import cm.aptoide.ptdev.downloadmanager.DownloadManager;
import cm.aptoide.ptdev.downloadmanager.DownloadModel;
import cm.aptoide.ptdev.downloadmanager.FinishedApk;
import cm.aptoide.ptdev.model.Download;
import cm.aptoide.ptdev.model.Error;
import cm.aptoide.ptdev.services.HttpClientSpiceService;
import cm.aptoide.ptdev.utils.IconSizes;
import cm.aptoide.ptdev.webservices.GetApkInfoRequestFromMd5;
import cm.aptoide.ptdev.webservices.json.GetApkInfoJson;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.RequestListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class DownloadService
extends Service {
    private static final String OBB_DESTINATION = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/obb/";
    private LongSparseArray<DownloadInfo> downloads;
    private boolean isStopped = true;
    private NotificationCompat.Builder mBuilder;
    private DownloadManager manager = new DownloadManager();
    private Timer timer;

    public DownloadService() {
        this.downloads = new LongSparseArray();
    }

    static /* synthetic */ boolean access$002(DownloadService downloadService, boolean bl2) {
        downloadService.isStopped = bl2;
        return bl2;
    }

    private int getOngoingDownloadsPercentage() {
        ArrayList<DownloadInfo> arrayList = this.getOngoingDownloads();
        arrayList.addAll(this.manager.getmCompletedList());
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            n2 += ((DownloadInfo)iterator.next()).getPercentDownloaded();
        }
        if (!arrayList.isEmpty()) {
            return n2 / arrayList.size();
        }
        return 0;
    }

    private TimerTask getTask() {
        return new TimerTask(){

            @Override
            public void run() {
                DownloadService.this.updateDownload();
                Log.d((String)"Aptoide-DownloadService", (String)"Updating progress bar");
            }
        };
    }

    private NotificationCompat.Builder setNotification() {
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this);
        Intent intent = new Intent();
        intent.setClassName(this.getPackageName(), "cm.aptoide.ptdev.Start");
        intent.setFlags(0x10400000);
        intent.setAction("android.intent.action.VIEW");
        intent.putExtra("fromDownloadNotification", true);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)intent, (int)0x8000000);
        builder.setOngoing(true);
        int n2 = R.string.aptoide_downloading;
        Object[] objectArray = new Object[]{Aptoide.getConfiguration().getMarketName()};
        builder.setContentTitle(this.getString(n2, objectArray)).setSmallIcon(0x1080081).setProgress(0, 0, true).setContentIntent(pendingIntent);
        this.updateProgress(builder, this.getOngoingDownloads());
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateProgress(NotificationCompat.Builder builder, ArrayList<DownloadInfo> arrayList) {
        int n2 = this.getOngoingDownloadsPercentage();
        boolean bl2 = n2 == 0;
        builder.setProgress(100, n2, bl2);
        int n3 = R.string.x_app;
        Object[] objectArray = new Object[]{arrayList.size()};
        builder.setContentText(this.getString(n3, objectArray));
        ((NotificationManager)this.getSystemService("notification")).notify(-3, builder.build());
    }

    public ArrayList<Download> getAllActiveDownloads() {
        ArrayList<DownloadInfo> arrayList = this.getOngoingDownloads();
        ArrayList<Download> arrayList2 = new ArrayList<Download>();
        Iterator<DownloadInfo> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(iterator.next().getDownload());
        }
        return arrayList2;
    }

    public ArrayList<Download> getAllNotActiveDownloads() {
        ArrayList<DownloadInfo> arrayList = new ArrayList<DownloadInfo>();
        arrayList.addAll(this.manager.getmErrorList());
        arrayList.addAll(this.manager.getmCompletedList());
        ArrayList<Download> arrayList2 = new ArrayList<Download>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(((DownloadInfo)iterator.next()).getDownload());
        }
        return arrayList2;
    }

    public DownloadInfo getDownload(long l2) {
        if (this.downloads.get(l2) != null) {
            return this.downloads.get(l2);
        }
        return new DownloadInfo(this.manager, l2);
    }

    public ArrayList<DownloadInfo> getOngoingDownloads() {
        ArrayList<DownloadInfo> arrayList = new ArrayList<DownloadInfo>();
        arrayList.addAll(this.manager.getmActiveList());
        arrayList.addAll(this.manager.getmPendingList());
        return arrayList;
    }

    public IBinder onBind(Intent intent) {
        return new LocalBinder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onCreate() {
        super.onCreate();
        String string2 = this.getCacheDir().getAbsolutePath();
        File file = new File(string2 + "/downloadManager");
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.manager = (DownloadManager)objectInputStream.readObject();
            objectInputStream.close();
            for (DownloadInfo downloadInfo : this.manager.getmErrorList()) {
                this.downloads.put(downloadInfo.getId(), downloadInfo);
            }
            for (DownloadInfo downloadInfo : this.manager.getmActiveList()) {
                this.downloads.put(downloadInfo.getId(), downloadInfo);
            }
            for (DownloadInfo downloadInfo : this.manager.getmCompletedList()) {
                this.downloads.put(downloadInfo.getId(), downloadInfo);
            }
            for (DownloadInfo downloadInfo : this.manager.getmInactiveList()) {
                this.downloads.put(downloadInfo.getId(), downloadInfo);
            }
            for (DownloadInfo downloadInfo : this.manager.getmPendingList()) {
                this.downloads.put(downloadInfo.getId(), downloadInfo);
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        try {
            String string2 = this.getCacheDir().getAbsolutePath();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string2 + "/downloadManager"));
            objectOutputStream.writeObject(this.manager);
            objectOutputStream.flush();
            objectOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public void removeNonActiveDownloads() {
        ArrayList<DownloadInfo> arrayList = new ArrayList<DownloadInfo>();
        arrayList.addAll(this.manager.getmErrorList());
        arrayList.addAll(this.manager.getmCompletedList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((DownloadInfo)iterator.next()).remove();
        }
    }

    public void resumeDownload(int n2) {
        this.startService(new Intent(this.getApplicationContext(), DownloadService.class));
        this.mBuilder = this.setNotification();
        this.startForeground(-3, this.mBuilder.build());
        this.getDownload(n2).download();
        if (this.isStopped) {
            this.isStopped = false;
            this.timer = new Timer();
            this.timer.schedule(this.getTask(), 0L, 1000L);
        }
    }

    public void startDownloadFromAppId(final long l2) {
        this.startService(new Intent(this.getApplicationContext(), DownloadService.class));
        this.mBuilder = this.setNotification();
        this.startForeground(-3, this.mBuilder.build());
        SpiceManager spiceManager = new SpiceManager(HttpClientSpiceService.class);
        if (!spiceManager.isStarted()) {
            spiceManager.start(this.getApplicationContext());
        }
        new Thread(new Runnable(IconSizes.generateSizeString(this.getApplicationContext()), spiceManager){
            final /* synthetic */ SpiceManager val$manager;
            final /* synthetic */ String val$sizeString;
            {
                this.val$sizeString = string2;
                this.val$manager = spiceManager;
            }

            @Override
            public void run() {
                Cursor cursor = new Database(Aptoide.getDb()).getApkInfo(l2);
                if (cursor.moveToFirst()) {
                    String string2 = cursor.getString(cursor.getColumnIndex("reponame"));
                    String string3 = cursor.getString(cursor.getColumnIndex("name"));
                    String string4 = cursor.getString(cursor.getColumnIndex("package_name"));
                    String string5 = cursor.getString(cursor.getColumnIndex("version_name"));
                    String string6 = cursor.getString(cursor.getColumnIndex("md5"));
                    String string7 = cursor.getString(cursor.getColumnIndex("icon"));
                    String string8 = cursor.getString(cursor.getColumnIndex("iconpath"));
                    GetApkInfoRequestFromMd5 getApkInfoRequestFromMd5 = new GetApkInfoRequestFromMd5(DownloadService.this.getApplicationContext());
                    getApkInfoRequestFromMd5.setRepoName(string2);
                    getApkInfoRequestFromMd5.setMd5Sum(string6);
                    Download download = new Download();
                    download.setId(l2);
                    download.setName(string3);
                    download.setPackageName(string4);
                    download.setVersion(string5);
                    if (string7.contains("_icon")) {
                        String[] stringArray = string7.split("\\.(?=[^\\.]+$)");
                        string7 = stringArray[0] + "_" + this.val$sizeString + "." + stringArray[1];
                    }
                    download.setIcon(string8 + string7);
                    this.val$manager.getFromCacheAndLoadFromNetworkIfExpired(getApkInfoRequestFromMd5, string2 + string6, 3600000L, new DownloadRequest(l2, download));
                    cursor.close();
                }
            }
        }).start();
    }

    public void startDownloadFromJson(GetApkInfoJson getApkInfoJson, long l2, Download download) {
        ArrayList<DownloadModel> arrayList = new ArrayList<DownloadModel>();
        if (getApkInfoJson.getObb() != null) {
            arrayList.add(new DownloadModel(getApkInfoJson.getObb().getMain().getPath(), OBB_DESTINATION + download.getPackageName() + "/" + getApkInfoJson.getObb().getMain().getFilename(), getApkInfoJson.getObb().getMain().getMd5sum(), getApkInfoJson.getObb().getMain().getFilesize().longValue()));
            if (getApkInfoJson.getObb().getPatch() != null) {
                arrayList.add(new DownloadModel(getApkInfoJson.getObb().getPatch().getPath(), OBB_DESTINATION + download.getPackageName() + "/" + getApkInfoJson.getObb().getPatch().getFilename(), getApkInfoJson.getObb().getPatch().getMd5sum(), getApkInfoJson.getObb().getPatch().getFilesize().longValue()));
            }
        }
        String string2 = Aptoide.getConfiguration().getPathCacheApks();
        DownloadModel downloadModel = new DownloadModel(getApkInfoJson.getApk().getPath(), string2 + getApkInfoJson.getApk().getMd5sum() + ".apk", getApkInfoJson.getApk().getMd5sum(), getApkInfoJson.getApk().getSize().longValue());
        downloadModel.setAutoExecute(true);
        arrayList.add(downloadModel);
        DownloadInfo downloadInfo = this.getDownload(l2);
        DownloadExecutorImpl downloadExecutorImpl = new DownloadExecutorImpl(new FinishedApk(download.getName(), download.getPackageName(), download.getVersion(), l2, download.getIcon(), string2 + getApkInfoJson.getApk().getMd5sum() + ".apk", new ArrayList<String>(getApkInfoJson.getApk().getPermissions())));
        downloadInfo.setDownloadExecutor(downloadExecutorImpl);
        downloadInfo.setDownload(download);
        downloadInfo.setFilesToDownload(arrayList);
        this.downloads.put(downloadInfo.getId(), downloadInfo);
        downloadInfo.download();
        this.startService(new Intent(this.getApplicationContext(), DownloadService.class));
        this.mBuilder = this.setNotification();
        this.startForeground(-3, this.mBuilder.build());
        if (this.isStopped) {
            this.isStopped = false;
            this.timer = new Timer();
            this.timer.schedule(this.getTask(), 0L, 1000L);
        }
    }

    public void startDownloadFromUrl(String string2, String string3, long l2, Download download) {
        ArrayList<DownloadModel> arrayList = new ArrayList<DownloadModel>();
        String string4 = Aptoide.getConfiguration().getPathCacheApks();
        DownloadModel downloadModel = new DownloadModel(string2, string4 + string3 + ".apk", string3, 0L);
        downloadModel.setAutoExecute(true);
        arrayList.add(downloadModel);
        DownloadInfo downloadInfo = this.getDownload(l2);
        DownloadExecutorImpl downloadExecutorImpl = new DownloadExecutorImpl(new FinishedApk(download.getName(), download.getPackageName(), download.getVersion(), l2, download.getIcon(), string4 + string3 + ".apk", new ArrayList<String>()));
        downloadInfo.setDownloadExecutor(downloadExecutorImpl);
        downloadInfo.setDownload(download);
        downloadInfo.setFilesToDownload(arrayList);
        this.downloads.put(downloadInfo.getId(), downloadInfo);
        downloadInfo.download();
        this.startService(new Intent(this.getApplicationContext(), DownloadService.class));
        this.mBuilder = this.setNotification();
        this.startForeground(-3, this.mBuilder.build());
        if (this.isStopped) {
            this.isStopped = false;
            this.timer = new Timer();
            this.timer.schedule(this.getTask(), 0L, 1000L);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startExistingDownload(long l2) {
        this.startService(new Intent(this.getApplicationContext(), DownloadService.class));
        this.mBuilder = this.setNotification();
        this.startForeground(-3, this.mBuilder.build());
        if (this.isStopped) {
            this.isStopped = false;
            this.timer = new Timer();
            this.timer.schedule(this.getTask(), 0L, 1000L);
        }
        Log.d((String)"Aptoide-DownloadManager", (String)("Starting existing download " + l2));
        for (DownloadInfo downloadInfo : this.manager.getmCompletedList()) {
            if (downloadInfo.getId() != l2) continue;
            downloadInfo.download();
            return;
        }
        for (DownloadInfo downloadInfo : this.manager.getmErrorList()) {
            if (downloadInfo.getId() != l2) continue;
            downloadInfo.download();
            return;
        }
    }

    public void stopDownload(long l2) {
        this.getDownload(l2).remove();
    }

    public void updateDownload() {
        ArrayList<DownloadInfo> arrayList = this.getOngoingDownloads();
        if (!arrayList.isEmpty()) {
            this.updateProgress(this.mBuilder, arrayList);
            return;
        }
        this.timer.cancel();
        this.timer.purge();
        this.stopSelf();
        this.stopForeground(true);
        this.isStopped = true;
    }

    public class DownloadRequest
    implements RequestListener<GetApkInfoJson> {
        private final Download download;
        private final long id;

        public DownloadRequest(long l2, Download download) {
            this.id = l2;
            this.download = download;
        }

        @Override
        public void onRequestFailure(SpiceException spiceException) {
            DownloadService.this.stopSelf();
            DownloadService.this.stopForeground(true);
            DownloadService.access$002(DownloadService.this, true);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onRequestSuccess(GetApkInfoJson getApkInfoJson) {
            if (getApkInfoJson == null) return;
            if (getApkInfoJson.getStatus().equals("OK")) {
                DownloadService.this.startDownloadFromJson(getApkInfoJson, this.id, this.download);
                return;
            } else {
                for (Error error : getApkInfoJson.getErrors()) {
                    Toast.makeText((Context)DownloadService.this.getApplicationContext(), (CharSequence)error.getMsg(), (int)1).show();
                }
            }
        }
    }

    public class LocalBinder
    extends Binder {
        public DownloadService getService() {
            return DownloadService.this;
        }
    }
}

