/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.preferences;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.model.IconDownloadPermissions;
import cm.aptoide.ptdev.preferences.EnumPreferences;
import java.util.UUID;

public class ManagerPreferences {
    private SharedPreferences getPreferences;
    private SharedPreferences.Editor setPreferences;

    public ManagerPreferences(Context context) {
        this.getPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.setPreferences = this.getPreferences.edit();
        if (this.getAptoideClientUUID() == null) {
            this.createLauncherShortcut(context);
            this.setAptoideClientUUID(UUID.randomUUID().toString());
        }
    }

    private void removeLauncherShortcut(Context context) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setComponent(new ComponentName(context.getPackageName(), "cm.aptoide.ptdev.Start"));
        Intent intent2 = new Intent();
        intent2.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)intent);
        intent2.putExtra("android.intent.extra.shortcut.NAME", Aptoide.getConfiguration().getMarketName());
        intent.setComponent(new ComponentName(context.getPackageName(), "cm.aptoide.ptdev.Start"));
        intent2.setAction("com.android.launcher.action.UNINSTALL_SHORTCUT");
        context.sendBroadcast(intent2, null);
    }

    public void createLauncherShortcut(Context context) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        Intent intent2 = new Intent();
        intent2.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)intent);
        intent2.putExtra("android.intent.extra.shortcut.NAME", Aptoide.getConfiguration().getMarketName());
        intent2.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)Intent.ShortcutIconResource.fromContext((Context)context, (int)R.drawable.icon_brand_aptoide));
        intent2.putExtra("duplicate", false);
        intent2.setAction("com.android.launcher.action.INSTALL_SHORTCUT");
        context.sendBroadcast(intent2);
    }

    public String getAptoideClientUUID() {
        return this.getPreferences.getString(EnumPreferences.APTOIDE_CLIENT_UUID.name(), null);
    }

    public IconDownloadPermissions getIconDownloadPermissions() {
        return new IconDownloadPermissions(this.getPreferences.getBoolean("wifi", true), this.getPreferences.getBoolean("ethernet", true), this.getPreferences.getBoolean("4g", true), this.getPreferences.getBoolean("3g", true));
    }

    public SharedPreferences getPreferences() {
        return this.getPreferences;
    }

    public void setAptoideClientUUID(String string2) {
        this.setPreferences.putString(EnumPreferences.APTOIDE_CLIENT_UUID.name(), string2);
        this.setPreferences.commit();
    }

    public SharedPreferences.Editor setPreferences() {
        return this.setPreferences;
    }
}

