/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.parser.handlers;

import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.model.Apk;
import cm.aptoide.ptdev.model.ApkLatestXml;
import cm.aptoide.ptdev.model.Server;
import cm.aptoide.ptdev.parser.handlers.AbstractHandler;
import cm.aptoide.ptdev.utils.Configs;
import java.text.ParseException;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HandlerTopXml
extends AbstractHandler {
    private static final int TOPAPPS_ID = 500;
    boolean insidePackage;
    private long timestamp;

    public HandlerTopXml(Database database, long l2) {
        super(database, l2);
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.getDb().updateServer(this.server, this.getRepoId());
        this.getDb().setTopTimestamp(this.getRepoId(), this.timestamp);
    }

    @Override
    protected Apk getApk() {
        return new ApkLatestXml();
    }

    @Override
    protected Server getServer() {
        return new Server();
    }

    @Override
    protected void loadSpecificElements() {
        this.elements.put("package", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                HandlerTopXml.this.apk.databaseInsert(HandlerTopXml.this.statements, HandlerTopXml.this.categoriesIds);
                HandlerTopXml.this.insidePackage = false;
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
                HandlerTopXml.this.apk = HandlerTopXml.this.getApk();
                HandlerTopXml.this.apk.setRepoId(HandlerTopXml.this.repoId);
                HandlerTopXml.this.apk.addCategoryId(500);
                HandlerTopXml.this.insidePackage = true;
            }
        });
        this.elements.put("timestamp", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                try {
                    HandlerTopXml.this.apk.setDate(Configs.TIME_STAMP_FORMAT.parse(AbstractHandler.sb.toString()));
                    return;
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                    HandlerTopXml.this.apk.setDate(new Date(0L));
                    return;
                }
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
    }

    public void setTimestamp(long l2) {
        this.timestamp = l2;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.getDb().insertCategory("Top Apps", 0, 500, 0, this.getRepoId());
    }
}

