/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.parser.handlers;

import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.model.Apk;
import cm.aptoide.ptdev.model.ApkLatestXml;
import cm.aptoide.ptdev.model.Server;
import cm.aptoide.ptdev.parser.handlers.AbstractHandler;
import cm.aptoide.ptdev.utils.Configs;
import java.text.ParseException;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HandlerLatestXml
extends AbstractHandler {
    private static final int LATESTAPPS_ID = 501;
    private long timestamp;

    public HandlerLatestXml(Database database, long l2) {
        super(database, l2);
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.getDb().updateServer(this.server, this.getRepoId());
        this.getDb().setLatestTimestamp(this.getRepoId(), this.timestamp);
    }

    @Override
    protected Apk getApk() {
        return new ApkLatestXml();
    }

    @Override
    protected Server getServer() {
        return new Server();
    }

    @Override
    protected void loadSpecificElements() {
        this.elements.put("package", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                HandlerLatestXml.this.apk.databaseInsert(HandlerLatestXml.this.statements, HandlerLatestXml.this.categoriesIds);
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
                HandlerLatestXml.this.apk = HandlerLatestXml.this.getApk();
                ((ApkLatestXml)HandlerLatestXml.this.apk).setRepoId(HandlerLatestXml.this.repoId);
                HandlerLatestXml.this.apk.addCategoryId(501);
            }
        });
        this.elements.put("timestamp", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                try {
                    HandlerLatestXml.this.apk.setDate(Configs.TIME_STAMP_FORMAT.parse(AbstractHandler.sb.toString()));
                    return;
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                    HandlerLatestXml.this.apk.setDate(new Date(0L));
                    return;
                }
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
    }

    public void setTimestamp(long l2) {
        this.timestamp = l2;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.getDb().insertCategory("Latest Apps", 0, 501, 0, this.getRepoId());
    }
}

