/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.parser.handlers;

import android.util.Log;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.model.Apk;
import cm.aptoide.ptdev.model.ApkInfoXML;
import cm.aptoide.ptdev.model.Server;
import cm.aptoide.ptdev.parser.exceptions.InvalidVersionException;
import cm.aptoide.ptdev.parser.handlers.AbstractHandler;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.utils.Configs;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HandlerInfoXml
extends AbstractHandler {
    private String countriesPermitted;
    private File file;
    private boolean insideCat;
    private boolean isDelta;
    private boolean isRemove;

    public HandlerInfoXml(Database database, long l2) {
        super(database, l2);
    }

    static /* synthetic */ boolean access$002(HandlerInfoXml handlerInfoXml, boolean bl2) {
        handlerInfoXml.isRemove = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$102(HandlerInfoXml handlerInfoXml, boolean bl2) {
        handlerInfoXml.isDelta = bl2;
        return bl2;
    }

    static /* synthetic */ String access$202(HandlerInfoXml handlerInfoXml, String string2) {
        handlerInfoXml.countriesPermitted = string2;
        return string2;
    }

    static /* synthetic */ boolean access$302(HandlerInfoXml handlerInfoXml, boolean bl2) {
        handlerInfoXml.insideCat = bl2;
        return bl2;
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.getDb().updateAppsCount(this.repoId);
        if (!this.isDelta) {
            Log.d((String)"Aptoide-Parser", (String)"Calculating md5");
            String string2 = AptoideUtils.Algorithms.md5Calc(this.file);
            Log.d((String)"Aptoide-Parser", (String)("md5 is " + string2));
            this.server.setHash(string2);
        }
        this.getDb().updateServer(this.server, this.getRepoId());
    }

    @Override
    protected Apk getApk() {
        return new ApkInfoXML();
    }

    public String getCountriesPermitted() {
        return this.countriesPermitted;
    }

    @Override
    protected Server getServer() {
        return new Server();
    }

    public boolean isDelta() {
        return this.isDelta;
    }

    @Override
    protected void loadSpecificElements() {
        this.elements.put("package", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                block6: {
                    block5: {
                        if (!HandlerInfoXml.this.isRunning()) break block5;
                        if (!HandlerInfoXml.this.isRemove) break block6;
                        HandlerInfoXml.this.apk.databaseDelete(HandlerInfoXml.this.getDb());
                        HandlerInfoXml.access$002(HandlerInfoXml.this, false);
                    }
                    return;
                }
                if (HandlerInfoXml.this.apk.getChildren() != null) {
                    for (Apk apk : HandlerInfoXml.this.apk.getChildren()) {
                        Log.d((String)"Aptoide-Multiple-Apk", (String)"Inserting multipleApk");
                        apk.databaseInsert(HandlerInfoXml.this.statements, HandlerInfoXml.this.categoriesIds);
                    }
                    HandlerInfoXml.this.apk.setChildren(null);
                    return;
                }
                HandlerInfoXml.this.apk.databaseInsert(HandlerInfoXml.this.statements, HandlerInfoXml.this.categoriesIds);
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
                HandlerInfoXml.this.apk = HandlerInfoXml.this.getApk();
                HandlerInfoXml.this.apk.setRepoId(HandlerInfoXml.this.repoId);
            }
        });
        this.elements.put("delta", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                String string2 = AbstractHandler.sb.toString();
                if (string2.length() > 0) {
                    HandlerInfoXml.this.server.setHash(string2);
                }
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
                HandlerInfoXml.access$102(HandlerInfoXml.this, true);
            }
        });
        this.elements.put("version", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                if (Integer.parseInt(AbstractHandler.sb.toString()) < 7) {
                    Log.d((String)"Aptoide-Parser", (String)"Throwing exception");
                    throw new InvalidVersionException();
                }
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("date", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                try {
                    HandlerInfoXml.this.apk.setDate(Configs.TIME_STAMP_FORMAT_INFO_XML.parse(AbstractHandler.sb.toString()));
                    return;
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                    HandlerInfoXml.this.apk.setDate(new Date(0L));
                    return;
                }
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("localize", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                HandlerInfoXml.access$202(HandlerInfoXml.this, AbstractHandler.sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("repository", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                HandlerInfoXml.this.getDb().updateServer(HandlerInfoXml.this.server, HandlerInfoXml.this.getRepoId());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("apk", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                if (HandlerInfoXml.this.multipleApk) {
                    HandlerInfoXml.this.apk.getChildren().add(HandlerInfoXml.this.apk);
                }
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("del", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
                HandlerInfoXml.access$002(HandlerInfoXml.this, true);
            }
        });
        this.elements.put("categories", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
                if (!HandlerInfoXml.this.isDelta) {
                    HandlerInfoXml.this.getDb().clearStore(HandlerInfoXml.this.getRepoId());
                }
                HandlerInfoXml.this.getDb().clearCategories(HandlerInfoXml.this.getRepoId());
            }
        });
        this.elements.put("cat", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                HandlerInfoXml.this.getDb().insertCategory(HandlerInfoXml.this.category.name, HandlerInfoXml.this.category.parent, HandlerInfoXml.this.category.real_id, HandlerInfoXml.this.category.order, HandlerInfoXml.this.getRepoId());
                HandlerInfoXml.access$302(HandlerInfoXml.this, false);
                Log.d((String)"Aptoide-", (String)"Inserting category");
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
                HandlerInfoXml.this.category = new AbstractHandler.Category();
                HandlerInfoXml.access$302(HandlerInfoXml.this, true);
            }
        });
        this.elements.put("catids", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                for (String string2 : AbstractHandler.sb.toString().split(",")) {
                    HandlerInfoXml.this.apk.addCategoryId(Integer.parseInt(string2));
                }
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("name", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                if (HandlerInfoXml.this.insideCat) {
                    HandlerInfoXml.this.category.name = AbstractHandler.sb.toString();
                    return;
                }
                HandlerInfoXml.this.apk.setName(AbstractHandler.sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("parent", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                try {
                    HandlerInfoXml.this.category.parent = Integer.parseInt(AbstractHandler.sb.toString());
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    HandlerInfoXml.this.category.parent = 0;
                    return;
                }
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("order", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                HandlerInfoXml.this.category.order = Integer.parseInt(AbstractHandler.sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("id", new AbstractHandler.ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                HandlerInfoXml.this.category.real_id = Integer.parseInt(AbstractHandler.sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
    }

    public void setFile(File file) {
        this.file = file;
    }
}

