/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.parser.handlers;

import android.database.sqlite.SQLiteStatement;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.model.Apk;
import cm.aptoide.ptdev.model.Server;
import cm.aptoide.ptdev.parser.exceptions.ParseStoppedException;
import cm.aptoide.ptdev.utils.Filters;
import com.squareup.otto.Subscribe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public abstract class AbstractHandler
extends DefaultHandler2 {
    static StringBuilder sb = new StringBuilder();
    Apk apk;
    protected final HashMap<Integer, Integer> categoriesIds = new HashMap();
    Category category;
    private final Database db;
    HashMap<String, ElementHandler> elements;
    private int i;
    private boolean isRunning = true;
    protected boolean multipleApk;
    protected long repoId;
    Server server;
    ArrayList<SQLiteStatement> statements;

    public AbstractHandler(Database database, long l2) {
        this.apk = this.getApk();
        this.server = this.getServer();
        this.elements = new HashMap();
        this.db = database;
        this.repoId = l2;
        this.loadCommonElements();
        this.loadSpecificElements();
        this.statements = new ArrayList<SQLiteStatement>(database.compileStatements(this.apk.getStatements()));
    }

    static /* synthetic */ int access$008(AbstractHandler abstractHandler) {
        int n2 = abstractHandler.i;
        abstractHandler.i = n2 + 1;
        return n2;
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        super.characters(cArray, n2, n3);
        sb.append(cArray, n2, n3);
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        super.endElement(string2, string3, string4);
        if (!this.isRunning()) {
            throw new ParseStoppedException();
        }
        if (this.elements.get(string3) != null) {
            this.elements.get(string3).endElement();
        }
    }

    protected abstract Apk getApk();

    public Database getDb() {
        return this.db;
    }

    public long getRepoId() {
        return this.repoId;
    }

    protected abstract Server getServer();

    public boolean isRunning() {
        return this.isRunning;
    }

    void loadCommonElements() {
        this.elements.put("apklst", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("signature", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setSignature(sb.toString());
                if (AbstractHandler.this.apk.getChildren() != null) {
                    Iterator<Apk> iterator = AbstractHandler.this.apk.getChildren().iterator();
                    while (iterator.hasNext()) {
                        iterator.next().setSignature(sb.toString());
                    }
                }
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("multipleapk", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.multipleApk = false;
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
                AbstractHandler.this.multipleApk = true;
                AbstractHandler.this.apk.setChildren(new ArrayList<Apk>());
            }
        });
        this.elements.put("localize", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("cpu", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setCpuAbi(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("path", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setPath(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("screenCompat", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setScreenCompat(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("basepath", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.server.setBasepath(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("appscount", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("iconspath", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.server.setIconspath(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("screenspath", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.server.setScreenspath(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("webservicespath", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.server.setWebservicespath(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("apkpath", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.server.setApkpath(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("name", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setName(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("ver", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setVersionName(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("vercode", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setVersionCode(Integer.parseInt(sb.toString()));
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("apkid", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setPackageName(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
                AbstractHandler.access$008(AbstractHandler.this);
            }
        });
        this.elements.put("icon", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                if (AbstractHandler.this.apk.getIconPath() == null) {
                    AbstractHandler.this.apk.setIconPath(sb.toString());
                }
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("icon_hd", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setIconPath(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("dwn", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setDownloads(Integer.parseInt(sb.toString()));
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("rat", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setRating(Double.parseDouble(sb.toString()));
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("catg", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setCategory1(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("catg2", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setCategory2(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("age", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setAge(Filters.Age.lookup(sb.toString()));
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("minSdk", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setMinSdk(Integer.parseInt(sb.toString()));
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("minScreen", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setMinScreen(Filters.Screen.valueOf(sb.toString()));
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("minGles", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setMinGlEs(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("price", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setPrice(Double.parseDouble(sb.toString()));
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
        this.elements.put("md5h", new ElementHandler(){

            @Override
            public void endElement() throws SAXException {
                AbstractHandler.this.apk.setMd5h(sb.toString());
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }
        });
    }

    protected abstract void loadSpecificElements();

    public void setRunning(boolean bl2) {
        this.isRunning = bl2;
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        super.startElement(string2, string3, string4, attributes);
        sb.setLength(0);
        if (this.elements.get(string3) != null) {
            this.elements.get(string3).startElement(attributes);
        }
    }

    @Subscribe
    public void stopParse() {
        this.setRunning(false);
        this.statements.clear();
    }

    protected static class Category {
        String name;
        int order;
        int parent;
        int real_id;

        protected Category() {
        }
    }

    static interface ElementHandler {
        public void endElement() throws SAXException;

        public void startElement(Attributes var1) throws SAXException;
    }
}

