/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.parser;

import android.content.Context;
import android.database.sqlite.SQLiteStatement;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.model.Apk;
import cm.aptoide.ptdev.model.ApkInfoXML;
import cm.aptoide.ptdev.utils.AptoideUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class RepoLocaleUpdater {
    final Apk apk;
    private Context context;
    private final Database database;
    private HashMap<String, EndElement> elementHashMap = new HashMap();
    private long repoid;
    private final StringBuilder sb;
    private String serverName;
    private SQLiteStatement statement;

    public RepoLocaleUpdater(long l2, String string2, Context context, final Database database) {
        this.apk = new ApkInfoXML();
        this.sb = new StringBuilder();
        this.repoid = l2;
        this.serverName = string2;
        this.context = context;
        this.database = database;
        this.statement = database.getDatabaseInstance().compileStatement("UPDATE apk SET name=? WHERE package_name=? and id_repo = ?");
        this.elementHashMap.put("name", new EndElement(){

            @Override
            public void endElement() {
                RepoLocaleUpdater.this.apk.setName(RepoLocaleUpdater.this.sb.toString());
            }
        });
        this.elementHashMap.put("apkid", new EndElement(){

            @Override
            public void endElement() {
                RepoLocaleUpdater.this.apk.setPackageName(RepoLocaleUpdater.this.sb.toString());
            }
        });
        this.elementHashMap.put("entry", new EndElement(){

            @Override
            public void endElement() {
                database.updateApkName(RepoLocaleUpdater.this.apk, RepoLocaleUpdater.this.statement);
            }
        });
    }

    public void parse() {
        try {
            BufferedInputStream bufferedInputStream = new AptoideUtils.NetworkUtils().getInputStream(Aptoide.getConfiguration().getWebServicesUri() + "webservices/listRepositoryLocalApkNames/" + this.serverName + "/" + AptoideUtils.getMyCountryCode(this.context) + "/xml", this.context);
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            this.apk.setRepoId(this.repoid);
            sAXParser.parse((InputStream)bufferedInputStream, (DefaultHandler)new DefaultHandler2(){

                @Override
                public void characters(char[] cArray, int n2, int n3) throws SAXException {
                    super.characters(cArray, n2, n3);
                    RepoLocaleUpdater.this.sb.append(cArray, n2, n3);
                }

                @Override
                public void endElement(String string2, String string3, String string4) throws SAXException {
                    super.endElement(string2, string3, string4);
                    if (RepoLocaleUpdater.this.elementHashMap.get(string3) != null) {
                        ((EndElement)RepoLocaleUpdater.this.elementHashMap.get(string3)).endElement();
                    }
                }

                @Override
                public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
                    super.startElement(string2, string3, string4, attributes);
                    RepoLocaleUpdater.this.sb.setLength(0);
                }
            });
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return;
        }
    }

    static interface EndElement {
        public void endElement();
    }
}

