/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.parser;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.database.schema.Schema;
import cm.aptoide.ptdev.model.Login;
import cm.aptoide.ptdev.parser.RepoLocaleUpdater;
import cm.aptoide.ptdev.parser.RunnableWithPriority;
import cm.aptoide.ptdev.parser.callbacks.CompleteCallback;
import cm.aptoide.ptdev.parser.callbacks.ErrorCallback;
import cm.aptoide.ptdev.parser.callbacks.PoolEndedCallback;
import cm.aptoide.ptdev.parser.handlers.AbstractHandler;
import cm.aptoide.ptdev.parser.handlers.HandlerInfoXml;
import cm.aptoide.ptdev.services.FileRequest;
import cm.aptoide.ptdev.utils.AptoideUtils;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.RequestListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser {
    private int a;
    private int i;
    PoolEndedCallback poolEndedCallback;
    PriorityBlockingQueue<Runnable> pq = new PriorityBlockingQueue(10, new ComparePriority());
    ExecutorService service = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.pq, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setPriority(3);
            return thread;
        }
    });
    private SpiceManager spiceManager;
    private int totalNumberOfTasks;

    public Parser(SpiceManager spiceManager) {
        this.spiceManager = spiceManager;
        Log.d((String)"Aptoide-Parser", (String)"newParser");
    }

    static /* synthetic */ int access$110(Parser parser) {
        int n2 = parser.i;
        parser.i = n2 - 1;
        return n2;
    }

    private boolean threadPoolIsIdle() {
        return this.i == 0;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Log.d((String)"Aptoide-Parser", (String)"GC on Parser");
    }

    public ExecutorService getExecutor() {
        return this.service;
    }

    public void parse(final String string2, Login login, final int n2, final AbstractHandler abstractHandler, final ErrorCallback errorCallback, final CompleteCallback completeCallback, final Runnable runnable) {
        Log.d((String)"Aptoide-Parser", (String)("Starting parse: " + string2));
        int n3 = string2.hashCode();
        String string3 = Aptoide.getConfiguration().getPathCache();
        final File file = new File(string3 + n3 + ".xml");
        this.i = 1 + this.i;
        final long l2 = abstractHandler.getRepoId();
        Log.d((String)"Aptoide-Parser", (String)("Starting request: " + string2));
        if (!this.spiceManager.isStarted()) {
            this.spiceManager.start(Aptoide.getContext());
        }
        SpiceManager spiceManager = this.spiceManager;
        FileRequest fileRequest = new FileRequest(string2, file, login);
        spiceManager.execute(fileRequest, new RequestListener<InputStream>(){

            @Override
            public void onRequestFailure(SpiceException spiceException) {
                Log.d((String)"Aptoide-Parser", (String)"onRequestFailure");
                Parser.access$110(Parser.this);
                if (Parser.this.threadPoolIsIdle() && Parser.this.poolEndedCallback != null) {
                    Parser.this.poolEndedCallback.onEnd();
                }
                if (abstractHandler instanceof HandlerInfoXml) {
                    new Database(Aptoide.getDb()).setFailedRepo(l2);
                }
                if (errorCallback != null) {
                    errorCallback.onError(spiceException, l2);
                }
            }

            @Override
            public void onRequestSuccess(final InputStream inputStream) {
                Log.d((String)"Aptoide-Parser", (String)("onRequestSuccess " + string2));
                Parser.this.service.execute(new RunnableWithPriority(n2){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        Log.d((String)"Aptoide-Parser", (String)("Starting parse " + string2));
                        long l2 = System.currentTimeMillis();
                        Aptoide.getDb().beginTransaction();
                        try {
                            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                            Log.d((String)"Aptoide-Parser", (String)"New SaxParser");
                            if (runnable != null) {
                                runnable.run();
                            }
                            if (abstractHandler instanceof HandlerInfoXml) {
                                ((HandlerInfoXml)abstractHandler).setFile(file);
                                ContentValues contentValues = new ContentValues();
                                contentValues.putNull("is_failed");
                                SQLiteDatabase sQLiteDatabase = Aptoide.getDb();
                                String string2 = Schema.Repo.getName();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                sQLiteDatabase.update(string2, contentValues, "id_repo = ?", stringArray);
                            }
                            sAXParser.parse(inputStream, (DefaultHandler)abstractHandler);
                            Log.d((String)"Aptoide-Parser", (String)"Parse ended");
                            if (abstractHandler instanceof HandlerInfoXml && !((HandlerInfoXml)abstractHandler).isDelta() && ((HandlerInfoXml)abstractHandler).getCountriesPermitted() != null && ((HandlerInfoXml)abstractHandler).getCountriesPermitted().contains(AptoideUtils.getMyCountry(Aptoide.getContext()))) {
                                new RepoLocaleUpdater(abstractHandler.getRepoId(), AptoideUtils.RepoUtils.split(string2), Aptoide.getContext(), abstractHandler.getDb()).parse();
                            }
                            Aptoide.getDb().setTransactionSuccessful();
                            if (completeCallback != null) {
                                completeCallback.onComplete(l2);
                            }
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                            parserConfigurationException.printStackTrace();
                            if (errorCallback != null) {
                                errorCallback.onError(parserConfigurationException, l2);
                            }
                            Log.d((String)"Aptoide-Parser", (String)"Error");
                        }
                        catch (SAXException sAXException) {
                            sAXException.printStackTrace();
                            if (errorCallback != null) {
                                errorCallback.onError(sAXException, l2);
                            }
                            Log.d((String)"Aptoide-Parser", (String)"Error");
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            if (errorCallback != null) {
                                errorCallback.onError(iOException, l2);
                            }
                            Log.d((String)"Aptoide-Parser", (String)"Error");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            if (errorCallback != null) {
                                errorCallback.onError(exception, l2);
                            }
                            Log.d((String)"Aptoide-Parser", (String)"Error");
                        }
                        Aptoide.getDb().endTransaction();
                        Log.d((String)"Aptoide-Parser", (String)"Deleting file");
                        file.delete();
                        Parser.access$110(Parser.this);
                        Log.d((String)"Aptoide-Parser", (String)(string2 + " Took : " + (System.currentTimeMillis() - l2) + " ms" + " i=" + Parser.this.i));
                        if (Parser.this.threadPoolIsIdle() && Parser.this.poolEndedCallback != null) {
                            Parser.this.poolEndedCallback.onEnd();
                        }
                    }
                });
            }
        });
    }

    public void parse(String string2, Login login, int n2, AbstractHandler abstractHandler, Runnable runnable) {
        this.parse(string2, login, n2, abstractHandler, null, null, runnable);
    }

    public void setPoolEndCallback(PoolEndedCallback poolEndedCallback) {
        this.poolEndedCallback = poolEndedCallback;
    }

    private class ComparePriority<T extends RunnableWithPriority>
    implements Comparator<T> {
        private ComparePriority() {
        }

        @Override
        public int compare(T t2, T t3) {
            return ((RunnableWithPriority)t2).getPriority().compareTo(((RunnableWithPriority)t3).getPriority());
        }
    }
}

